/** @file   nfc.h
 *  @brief  Header file for NFC communication driver
 *  @author LR
 *  @date   Feb 2011
 *  @note   History:
 *          Date        Author      Comment
 *          02/2011     LR          File created and added to GIT
 *  Built with IAR Embedded Workbench Version: 5.20
 *
 */
/* --COPYRIGHT--,BSD
 * Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//
// Include files
//
#include "RFID_hardware.h"

//
// Macro definitionss
//
/*! Timeout sent in ATR_RES */
#define TIMEOUT_TARGET  14
/*! Collision check retries */
#define COLLISION_RF_ATTEMPTS   50

/*! Return value when function is OK */
#define RET_OK  1
/*! Return value when there's an error */
#define RET_ERR -1

//
// Definition of NFC requests and responses
//
#define SENSF_REQ 0x00FF
#define SENSF_RES 0x01FF

#define ATR_REQ 0xD400
#define ATR_RES 0xD501
#define WUP_REQ 0xD402
#define WUP_RES 0xD503
#define PSL_REQ 0xD404
#define PSL_RES 0xD505
#define DEP_REQ 0xD406
#define DEP_RES 0xD507
#define DSL_REQ 0xD408
#define DSL_RES 0xD509
#define RLS_REQ 0xD40A
#define RLS_RES 0xD50B

#define CONNECT	0x04
#define CC		0x06
#define SYMM    0x00
#define I		0x0C
#define DM		0x07
#define DISC	0x05
#define RR		0x0D

//
// Type definitionss
//
/*! Possible states of NFC State machine */
typedef enum
{
    POWER_OFF_STATE= 0,     /* Default state after reset */
    SENSE_STATE,            /* Target is waiting for Initiator */
    PRESELECTED_STATE,      /* Target received SDD and waiting for ATR_REQ */
    SELECTED_STATE,         /* Target is ready to transfer data */
    SENDING_ACK_STATE      /* Target is sending acknowledge (ATR_RES) */
}NFC_state_t;

#define RX_PACKET_ONGOING 0x00
#define DATA_RECEIVED 0x01
#define RX_ERROR_RECOVERABLE 0x02
#define RX_ERROR_REINIT 0x03
#define RX_ERROR_FATAL 0x04
#define PI_DATA_RECEIVED 0x05
//
// Function prototypes
//
void NFC_IRQ_RF(void);
void NFC_IRQ_SDD(void);
void  NFC_IRQ_RX(uint8_t Fifo_Int);
void  NFC_IRQ_TX(void);
void NFC_IRQ_CRITICAL_ERR(void);
void NFC_IRQ_PROTOCOL_ERR(void);
void NFC_Init(void);
int8_t NFCTarget_statemachine(void);
void NFC_ProcessAppData(uint8_t *length, uint8_t *buf);
void NFCTarget_ChangeFreq(uint8_t Freq);
void ResetDecoders(void);
void NFC_IRQ_COLL_AVOID_FINISH(void);
