/*
 * main.c
 */
#include <stdint.h>
#include "msp430.h"
#include "HAL_AppUart.h"
#include "NFC/RFID_hardware.h"
#include "NFC/nfc.h"
#include "NFC/rfid_hal.h"
#include "NFC/Android_P2P.h"

uint8_t messageDirection = 0;

void setMessage(char* text);
void rxMenu(void);
void txMenu(void);
unsigned int i;
//void Init_UART(void);
void main(void)
{

	// Stop WDT
	WDTCTL = WDTPW + WDTHOLD;


	BCSCTL1 = CALBC1_16MHZ;                   // Set range
	DCOCTL = CALDCO_16MHZ;                    // Set DCO step + modulation*/



	// Globally enable interrupts
	__enable_interrupt();




	// Initialize Radio
	TRF_DISABLE();
	TRF_ENABLESET();
	TRF_ENABLE();
	//DELAY_MS(10);

	// Configure IRQ pin
	IRQ_PIN_SET();

	// Setup SPI to communicate with TRF7970A
	USCISPIset();                     // Set the USCI - SPI Mode for TRF communication */

	// Initialize Radio settings
	Radio_InitialSettings();

	// Initialize TRF7970A for NFC communications
	NFC_Init();
	//Init_UART();
	AppUart_init();
	message[0] = 0;
	// We will only receive
	messageDirection = RECEIVING;
	//Start with TX or RX?

//	while(!buttonsPressed);
//	if(buttonsPressed & BUTTON_S2)
//	{
//		txMenu();
//		// TX stuff
//	}
//	else
//	{
//		rxMenu();
//		// RX Stuff
//	}



	// Main loop

	while (1)
	{
		messageStatus = 0;
		NFCTarget_statemachine(); //Run the state machine for NFC P2P communication
		//	buttonsPressed = 0;
		if(messageStatus == MESSAGE_RECEIVED)
		{
			//show what we received

			message[message[0] + 1] = 0; //indicates end of string for LCD display
			  for (i = 0; i < message[0] + 1; i++)
			             AppUart_putChar(message[i]);
			// SNET IT OUT TO UART
		}
//		else if(messageStatus == MESSAGE_SENT)
//		{
//			//in case something was sent
//		}
	}
}




// after setMessage, change messageDirection to SENDING to send
// messageDirection = SENDING;

void setMessage(char* text)
{
	//Store the message to send. Message[0] stores the message length.
	uint8_t i = 0;
	do
	{
		message[i+1] = text[i];
		i++;
	}
	while(text[i] != 0);
	message[i+1] = 0; //end line character
	message[0] = i; //store the length

}
