#include <demo_vdec_vdis.h>
#include <osa_mutex.h>
#include <demo_vcap_venc_vdis.h>


void VdecVmosaicVenc_start()
{
    
    int i;
    Int32 res = -1;
    VSYS_PARAMS_S vsysParams;
    VDEC_PARAMS_S vdecParams;
    VENC_PARAMS_S vencParams;
    
    gDemo_info.maxVcapChannels = 0;
    gDemo_info.maxVdisChannels = 0;
    gDemo_info.maxVencChannels = 8;
    gDemo_info.maxVdecChannels = 8;

    res = VdecVdis_bitsRdInit();
    if (res != 0)
       printf("Error in file read init!!!\n");
    
	
    Vsys_params_init(&vsysParams);
    vsysParams.systemUseCase = VSYS_USECASE_MULTICHN_VDEC_VMOSAIC_VENC;
    vsysParams.enableCapture = FALSE;
    vsysParams.enableNsf     = TRUE;
    vsysParams.enableEncode  = TRUE;
    vsysParams.enableDecode  = TRUE;
    vsysParams.enableNullSrc = FALSE;
    vsysParams.enableAVsync  = TRUE;
    vsysParams.numDeis       = 0;
    vsysParams.numSwMs       = 8;
    vsysParams.numDisplays   = 0;
	
    Vdec_params_init(&vdecParams);
	vdecParams.numChn = 8;
    vdecParams.forceUseDecChannelParams = TRUE;
	for (i=0; i < vdecParams.numChn; i++) 
	{
		vdecParams.decChannelParams[i].dynamicParam.frameRate = 30; // NOT USED
		vdecParams.decChannelParams[i].dynamicParam.targetBitRate = 2 * 1000 * 1000; // NOT USED
		if (gVdecVdis_config.fileInfo[i].width != 0 && gVdecVdis_config.fileInfo[i].height != 0)
		{
			vdecParams.decChannelParams[i].maxVideoWidth = gVdecVdis_config.fileInfo[i].width;
			vdecParams.decChannelParams[i].maxVideoHeight = gVdecVdis_config.fileInfo[i].height;
		}
		else
		{
			printf(" ERROR: Invalid Decoder width x height !!!\n");
			OSA_assert(0);
		}

		/*If the codec type is missing, by default choose h264*/
		if(strlen(gVdecVdis_config.fileInfo[i].codec) == 0)
			strcpy(gVdecVdis_config.fileInfo[i].codec,"h264");
		
		if(strcmp(gVdecVdis_config.fileInfo[i].codec,"h264") == 0)
		{
			vdecParams.decChannelParams[i].isCodec = VDEC_CHN_H264;
			printf("ch[%d], h264\n",i);
		}	
		vdecParams.decChannelParams[i].displayDelay = gVdecVdis_config.fileInfo[i].displaydelay;
		vdecParams.decChannelParams[i].numBufPerCh = gVdecVdis_config.fileInfo[i].numbuf;
    }
	
    Venc_params_init(&vencParams);
    vencParams.numPrimaryChn = 8;
	
    Vsys_init(&vsysParams);
    Venc_init(&vencParams);
    Vdec_init(&vdecParams);

    res = VcapVenc_bitsWriteCreate();
    if (res != 0)
       printf("Error in file write init!!!\n");
    /* Create Link instances and connects component blocks */
    Vsys_create();
    
    /* Start components in reverse order */
    Venc_start();
    Vdec_start();
    Vdis_start();
    Vcap_start();
	
    VdecVdis_bitsRdStart();
}

void VdecVmosaicVenc_stop()
{
	VdecVdis_bitsRdStop();
	Vcap_stop();
	Vdec_stop();
	Venc_stop();
    Vdis_stop();
	VcapVenc_bitsWriteDelete();
	
	Vsys_delete();
	Vdec_exit();
    Venc_exit();
    Vsys_exit();

}

