#include "mcfw/src_linux/mcfw_api/usecases/multich_common.h"
#include "mcfw/src_linux/mcfw_api/usecases/multich_ipcbits.h"
#include "mcfw/interfaces/link_api/avsync_hlos.h"
#include "mcfw/interfaces/link_api/system_tiler.h"

#define     NUM_SWMS_LINK                        (8)

#define     NUM_BUFS_PER_CH_DEC                  (4)
#define     NUM_BUFS_PER_CH_SWMS                 (4)
#define     NUM_BUFS_PER_CH_ENC                  (4)
#define     NUM_BUFS_PER_CH_NSF                  (4)
#define     NUM_BUFS_PER_CH_MERGE                (4)
#define     NUM_BUFS_PER_CH_BITSOUT              (6)
#define     MAX_BUFFERING_QUEUE_LEN_PER_CH       (50)

static SystemVideo_Ivahd2ChMap_Tbl systemVid_encDecIvaChMapTbl =
{
    .isPopulated = 1,
    .ivaMap[0] =
    {
        .EncNumCh  = 8,
        .EncChList = {0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 0, 0, 0 , 0, 0},

        .DecNumCh  = 8,
        .DecChList = {0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 0, 0, 0 , 0, 0},
    },
    .ivaMap[1] =  {  .EncNumCh  = 0,  .DecNumCh  = 0,  },
    .ivaMap[2] =  {  .EncNumCh  = 0,  .DecNumCh  = 0,  },
};

typedef struct {

    UInt32 swmsId[NUM_SWMS_LINK];
    UInt32 mergeId;
	UInt32 nsfId;
	UInt32 dupId;

    /* encode, deccode, ipc ID's are in gVxxxModuleContext */
} MultiCh_VdecVmosaicVencVObj;

MultiCh_VdecVmosaicVencVObj gMultiCh_VdecVmosaicVencVObj;

/*Set Link IDs*/
void Multich_SetLinkIds()
{
	gVdecModuleContext.ipcBitsOutHLOSId      = SYSTEM_HOST_LINK_ID_IPC_BITS_OUT_0;
    gVdecModuleContext.ipcBitsInRTOSId       = SYSTEM_VIDEO_LINK_ID_IPC_BITS_IN_0;
	gVdecModuleContext.ipcM3InId             = SYSTEM_VPSS_LINK_ID_IPC_IN_M3_0;
	gVdecModuleContext.ipcM3OutId            = SYSTEM_VIDEO_LINK_ID_IPC_OUT_M3_0;
    gVdecModuleContext.decId                 = SYSTEM_LINK_ID_VDEC_0;
	
	gVencModuleContext.ipcBitsOutRTOSId      = SYSTEM_VIDEO_LINK_ID_IPC_BITS_OUT_0;
	gVencModuleContext.ipcBitsInHLOSId       = SYSTEM_HOST_LINK_ID_IPC_BITS_IN_0;
	gVencModuleContext.ipcM3InId             = SYSTEM_VIDEO_LINK_ID_IPC_IN_M3_0;
	gVencModuleContext.ipcM3OutId            = SYSTEM_VPSS_LINK_ID_IPC_OUT_M3_0;
	gVencModuleContext.encId                 = SYSTEM_LINK_ID_VENC_0;

    gMultiCh_VdecVmosaicVencVObj.dupId       = SYSTEM_VPSS_LINK_ID_DUP_0;
    gMultiCh_VdecVmosaicVencVObj.mergeId     = SYSTEM_VPSS_LINK_ID_MERGE_0;
	gMultiCh_VdecVmosaicVencVObj.nsfId       = SYSTEM_LINK_ID_NSF_0;
	gVcapModuleContext.nsfId[0] = gMultiCh_VdecVmosaicVencVObj.nsfId;
	
	gMultiCh_VdecVmosaicVencVObj.swmsId[0]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_0;
	gVdisModuleContext.swMsId[0] = gMultiCh_VdecVmosaicVencVObj.swmsId[0];
	gMultiCh_VdecVmosaicVencVObj.swmsId[1]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_1;
	gVdisModuleContext.swMsId[1] = gMultiCh_VdecVmosaicVencVObj.swmsId[1];
	gMultiCh_VdecVmosaicVencVObj.swmsId[2]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_2;
	gVdisModuleContext.swMsId[2] = gMultiCh_VdecVmosaicVencVObj.swmsId[2];
	gMultiCh_VdecVmosaicVencVObj.swmsId[3]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_3;
	gVdisModuleContext.swMsId[3] = gMultiCh_VdecVmosaicVencVObj.swmsId[3];
	gMultiCh_VdecVmosaicVencVObj.swmsId[4]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_4;
	gMultiCh_VdecVmosaicVencVObj.swmsId[5]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_5;
	gMultiCh_VdecVmosaicVencVObj.swmsId[6]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_6;
	gMultiCh_VdecVmosaicVencVObj.swmsId[7]   = SYSTEM_LINK_ID_SW_MS_MULTI_INST_7;
}

/*Set Encoder Params*/
static Void Multich_SetEncParams(EncLink_CreateParams *encPrm)
{
    Uint32 i;
    EncLink_ChCreateParams *pLinkChPrm;
    EncLink_ChDynamicParams *pLinkDynPrm;
    VENC_CHN_DYNAMIC_PARAM_S *pDynPrm;
    VENC_CHN_PARAMS_S *pChPrm;
    
    encPrm->numBufPerCh[0] = NUM_BUFS_PER_CH_ENC;
    for (i=0; i < gVencModuleContext.vencConfig.numPrimaryChn; i++)
    {
        pLinkChPrm  = &encPrm->chCreateParams[i];
        pLinkDynPrm = &pLinkChPrm->defaultDynamicParams;

        pChPrm      = &gVencModuleContext.vencConfig.encChannelParams[i];
        pDynPrm     = &pChPrm->dynamicParam;

        pLinkChPrm->format                  = IVIDEO_H264HP;
        pLinkChPrm->profile                 = gVencModuleContext.vencConfig.h264Profile[i];
        pLinkChPrm->dataLayout              = IVIDEO_FIELD_SEPARATED;
        pLinkChPrm->fieldMergeEncodeEnable  = FALSE;
        pLinkChPrm->enableAnalyticinfo      = pChPrm->enableAnalyticinfo;
        pLinkChPrm->maxBitRate              = pChPrm->maxBitRate;
        pLinkChPrm->encodingPreset          = pChPrm->encodingPreset;
        pLinkChPrm->rateControlPreset       = pChPrm->rcType;
        pLinkChPrm->enableHighSpeed         = FALSE;
        pLinkChPrm->numTemporalLayer        = pChPrm->numTemporalLayer;
        pLinkChPrm->enableSVCExtensionFlag  = pChPrm->enableSVCExtensionFlag;

        pLinkDynPrm->intraFrameInterval     = pDynPrm->intraFrameInterval;
        pLinkDynPrm->targetBitRate          = pDynPrm->targetBitRate;
        pLinkDynPrm->interFrameInterval     = 1;
        pLinkDynPrm->mvAccuracy             = IVIDENC2_MOTIONVECTOR_QUARTERPEL;
        pLinkDynPrm->inputFrameRate         = pDynPrm->inputFrameRate;
        pLinkDynPrm->rcAlg                  = pDynPrm->rcAlg;
        pLinkDynPrm->qpMin                  = pDynPrm->qpMin;
        pLinkDynPrm->qpMax                  = pDynPrm->qpMax;
        pLinkDynPrm->qpInit                 = pDynPrm->qpInit;
        pLinkDynPrm->vbrDuration            = pDynPrm->vbrDuration;
        pLinkDynPrm->vbrSensitivity         = pDynPrm->vbrSensitivity;
    }
}


/*Set Mosaic Params*/
static Void MultiCh_setSwMsParams(SwMsLink_CreateParams *swMsPrm, int i)
{
    SwMsLink_LayoutPrm *layoutInfo;
    SwMsLink_LayoutWinInfo *winInfo;
    UInt32 outWidth, outHeight, row, col, winId, widthAlign, heightAlign;
    outWidth  = 1280;
    outHeight = 720;
	
    widthAlign = 8;
    heightAlign = 1;

    layoutInfo = &swMsPrm->layoutPrm;
    /* init to known default */
    memset(layoutInfo, 0, sizeof(*layoutInfo));
	
	layoutInfo->onlyCh2WinMapChanged = FALSE;
	layoutInfo->outputFPS = 30;
	layoutInfo->numWin = 8;
	
	for(row=0; row<2; row++)
	{
	  for(col=0; col<2; col++)
	  {
		  winId = row*2+col;
		  winInfo = &layoutInfo->winInfo[winId];
		  winInfo->width  = SystemUtils_floor((outWidth*2)/5, widthAlign);
		  winInfo->height = SystemUtils_floor(outHeight/2, heightAlign);
		  winInfo->startX = winInfo->width*col;
		  winInfo->startY = winInfo->height*row;
		  winInfo->bypass = FALSE;
		  winInfo->channelNum = winId;
	  }
	}

	for(row=0; row<4; row++)
	{
	  winId = 4 + row;
	  winInfo = &layoutInfo->winInfo[winId];
	  winInfo->width  = layoutInfo->winInfo[0].width/2;
	  winInfo->height = layoutInfo->winInfo[0].height/2;
	  winInfo->startX = layoutInfo->winInfo[0].width*2;
	  winInfo->startY = winInfo->height*row;
	  winInfo->bypass = FALSE;
	  winInfo->channelNum = winId;
	}
}

/*Set Noisefilter Params*/
static Void Multich_SetNsfParams(NsfLink_CreateParams *nsfPrm)
{
    nsfPrm->bypassNsf                        = TRUE;
    nsfPrm->tilerEnable                      = FALSE;
    nsfPrm->numOutQue                        = 1;
    nsfPrm->numBufsPerCh                     = NUM_BUFS_PER_CH_NSF;
}

SwMsLink_CreateParams           swMsPrm[NUM_SWMS_LINK];
MergeLink_CreateParams          mergePrm;
DupLink_CreateParams            dupPrm;
NsfLink_CreateParams            nsfPrm;
IpcLink_CreateParams            ipcOutVpssPrm;
IpcLink_CreateParams            ipcInVideoPrm;
IpcLink_CreateParams            ipcOutVideoPrm;
IpcLink_CreateParams            ipcInVpssPrm;
EncLink_CreateParams            encPrm;
DecLink_CreateParams            decPrm;
IpcBitsOutLinkRTOS_CreateParams ipcBitsOutVideoPrm;
IpcBitsInLinkRTOS_CreateParams  ipcBitsInVideoPrm;
IpcBitsOutLinkHLOS_CreateParams ipcBitsOutHostPrm;
IpcBitsInLinkHLOS_CreateParams  ipcBitsInHostPrm;

/*Create usecase*/
void MultiCh_createVdecVmosaicVenc()
{
    printf("Enter the usecase file!!!\n");
    //Define Link Params
	
	UInt32 i;
	//Set Link ID
	Multich_SetLinkIds();
	//Init Link Params
	for(i=0; i<NUM_SWMS_LINK; i++)
	    MULTICH_INIT_STRUCT(SwMsLink_CreateParams, swMsPrm[i]);
	//MULTICH_INIT_STRUCT(MergeLink_CreateParams, mergePrm);
	//MULTICH_INIT_STRUCT(DupLink_CreateParams, dupPrm);
	MULTICH_INIT_STRUCT(NsfLink_CreateParams, nsfPrm);
	MULTICH_INIT_STRUCT(IpcLink_CreateParams, ipcOutVpssPrm);
	MULTICH_INIT_STRUCT(IpcLink_CreateParams, ipcInVideoPrm);
	MULTICH_INIT_STRUCT(IpcLink_CreateParams, ipcOutVideoPrm);
	MULTICH_INIT_STRUCT(IpcLink_CreateParams, ipcInVpssPrm);
	MULTICH_INIT_STRUCT(EncLink_CreateParams, encPrm);
	MULTICH_INIT_STRUCT(DecLink_CreateParams, decPrm);
	MULTICH_INIT_STRUCT(IpcBitsOutLinkRTOS_CreateParams, ipcBitsOutVideoPrm);
	MULTICH_INIT_STRUCT(IpcBitsInLinkRTOS_CreateParams, ipcBitsInVideoPrm);
	MULTICH_INIT_STRUCT(IpcBitsOutLinkHLOS_CreateParams, ipcBitsOutHostPrm);
	MULTICH_INIT_STRUCT(IpcBitsInLinkHLOS_CreateParams, ipcBitsInHostPrm);
	
	MultiCh_detectBoard();

    System_linkControl(
        SYSTEM_LINK_ID_M3VPSS,
        SYSTEM_M3VPSS_CMD_RESET_VIDEO_DEVICES,
        NULL,
        0,
        TRUE
        );
    /* Disable tiler allocator for this usecase
     * for that tiler memory can be reused for
     * non-tiled allocation
     */
    SystemTiler_disableAllocator();

    System_linkControl(
        SYSTEM_LINK_ID_M3VIDEO,
        SYSTEM_COMMON_CMD_SET_CH2IVAHD_MAP_TBL,
        &systemVid_encDecIvaChMapTbl,
        sizeof(SystemVideo_Ivahd2ChMap_Tbl),
        TRUE
        );

    printf("Start to config Link Params!!!\n");
    /******************************set ipcBitsOutHLOS link param *******************************/
	IpcBitsOutLinkHLOS_CreateParams_Init(&ipcBitsOutHostPrm);
    ipcBitsOutHostPrm.baseCreateParams.outQueParams[0].nextLink = gVdecModuleContext.ipcBitsInRTOSId;
    ipcBitsOutHostPrm.baseCreateParams.notifyNextLink           = TRUE;
    ipcBitsOutHostPrm.baseCreateParams.notifyPrevLink           = TRUE;
    ipcBitsOutHostPrm.baseCreateParams.noNotifyMode             = FALSE;
    ipcBitsOutHostPrm.baseCreateParams.numOutQue                = 1;
    ipcBitsOutHostPrm.inQueInfo.numCh                           = NUM_SWMS_LINK;

    for (i=0; i<ipcBitsOutHostPrm.inQueInfo.numCh; i++)
    {
    	UInt32 numBufPerCh;

        ipcBitsOutHostPrm.inQueInfo.chInfo[i].width =
            gVdecModuleContext.vdecConfig.decChannelParams[i].maxVideoWidth;

        ipcBitsOutHostPrm.inQueInfo.chInfo[i].height =
            gVdecModuleContext.vdecConfig.decChannelParams[i].maxVideoHeight;

        ipcBitsOutHostPrm.inQueInfo.chInfo[i].scanFormat =
            SYSTEM_SF_PROGRESSIVE;

        ipcBitsOutHostPrm.inQueInfo.chInfo[i].bufType        = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].codingformat   = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].dataFormat     = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].memType        = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].startX         = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].startY         = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].pitch[0]       = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].pitch[1]       = 0; // NOT USED
        ipcBitsOutHostPrm.inQueInfo.chInfo[i].pitch[2]       = 0; // NOT USED
        ipcBitsOutHostPrm.maxQueueDepth[i] =  MAX_BUFFERING_QUEUE_LEN_PER_CH;
        ipcBitsOutHostPrm.chMaxReqBufSize[i] =
        		gVdecModuleContext.vdecConfig.decChannelParams[i].maxVideoWidth * gVdecModuleContext.vdecConfig.decChannelParams[i].maxVideoHeight;
        numBufPerCh = NUM_BUFS_PER_CH_BITSOUT;
        ipcBitsOutHostPrm.totalBitStreamBufferSize[i] =
                ipcBitsOutHostPrm.chMaxReqBufSize[i] *  numBufPerCh;
    }
	/******************************set ipcBitsInRTOS link param *******************************/
	IpcBitsInLinkRTOS_CreateParams_Init(&ipcBitsInVideoPrm);
    ipcBitsInVideoPrm.baseCreateParams.inQueParams.prevLinkId    = gVdecModuleContext.ipcBitsOutHLOSId;//Arm out
    ipcBitsInVideoPrm.baseCreateParams.inQueParams.prevLinkQueId = 0;
    ipcBitsInVideoPrm.baseCreateParams.outQueParams[0].nextLink  = gVdecModuleContext.decId;
    ipcBitsInVideoPrm.baseCreateParams.noNotifyMode              = FALSE;
    ipcBitsInVideoPrm.baseCreateParams.notifyNextLink            = TRUE;
    ipcBitsInVideoPrm.baseCreateParams.notifyPrevLink            = TRUE;
    ipcBitsInVideoPrm.baseCreateParams.numOutQue                 = 1;

    printf("Config DecLink Params!!!\n");
	/******************************set dec link param *******************************/
	DecLink_CreateParams_Init(&decPrm);

	for (i=0; i<NUM_SWMS_LINK; i++)
	{
	decPrm.chCreateParams[i].format                 = IVIDEO_H264HP;
	decPrm.chCreateParams[i].profile                = IH264VDEC_PROFILE_ANY;
	decPrm.chCreateParams[i].processCallLevel       = VDEC_FRAMELEVELPROCESSCALL;
	decPrm.chCreateParams[i].dpbBufSizeInFrames     = IH264VDEC_DPB_NUMFRAMES_AUTO;
	decPrm.chCreateParams[i].targetMaxWidth         = ipcBitsOutHostPrm.inQueInfo.chInfo[i].width;
	decPrm.chCreateParams[i].targetMaxHeight        = ipcBitsOutHostPrm.inQueInfo.chInfo[i].height;
	decPrm.chCreateParams[i].numBufPerCh            = NUM_BUFS_PER_CH_DEC; 
	decPrm.chCreateParams[i].defaultDynamicParams.targetFrameRate = gVdecModuleContext.vdecConfig.decChannelParams[i].dynamicParam.frameRate;
	decPrm.chCreateParams[i].defaultDynamicParams.targetBitRate   = gVdecModuleContext.vdecConfig.decChannelParams[i].dynamicParam.targetBitRate;
	decPrm.chCreateParams[i].tilerEnable = FALSE;
	}
	decPrm.inQueParams.prevLinkId       = gVdecModuleContext.ipcBitsInRTOSId;//video in
    decPrm.inQueParams.prevLinkQueId    = 0;
    decPrm.outQueParams.nextLink        = gVdecModuleContext.ipcM3OutId;//Video out

	/******************************set ipcOutVideo link param *******************************/
	IpcLink_CreateParams_Init(&ipcOutVideoPrm);
	ipcOutVideoPrm.inQueParams.prevLinkId    = gVdecModuleContext.decId;
    ipcOutVideoPrm.inQueParams.prevLinkQueId = 0;
    ipcOutVideoPrm.outQueParams[0].nextLink  = gVdecModuleContext.ipcM3InId;//Vpss in
    ipcOutVideoPrm.notifyNextLink            = TRUE;
    ipcOutVideoPrm.notifyPrevLink            = TRUE;
	ipcOutVideoPrm.noNotifyMode              = FALSE;
    ipcOutVideoPrm.numOutQue                 = 1;
    /******************************set ipcInVpss link param *******************************/
	IpcLink_CreateParams_Init(&ipcInVpssPrm);
    ipcInVpssPrm.inQueParams.prevLinkId    = gVdecModuleContext.ipcM3OutId;
    ipcInVpssPrm.inQueParams.prevLinkQueId = 0;
    ipcInVpssPrm.notifyNextLink            = TRUE;
    ipcInVpssPrm.notifyPrevLink            = TRUE;
	ipcInVpssPrm.noNotifyMode              = FALSE;
    ipcInVpssPrm.numOutQue                 = 1;
	ipcInVpssPrm.outQueParams[0].nextLink  = gMultiCh_VdecVmosaicVencVObj.dupId;

    printf("Config DupLink Params!!!\n");
	/******************************set dup link param *******************************/
	dupPrm.inQueParams.prevLinkId         = gVdecModuleContext.ipcM3InId;;
    dupPrm.inQueParams.prevLinkQueId      = 0;
	dupPrm.numOutQue                      = NUM_SWMS_LINK;
	for(i=0; i<NUM_SWMS_LINK; i++)   
		dupPrm.outQueParams[i].nextLink   = gMultiCh_VdecVmosaicVencVObj.swmsId[i];
    dupPrm.notifyNextLink                 = TRUE;

    printf("Config SWMSLink Params!!!\n");
	/******************************set swms link param *******************************/
	for(i=0; i<NUM_SWMS_LINK; i++)
	{
	    SwMsLink_CreateParams_Init(&swMsPrm[i]);
		swMsPrm[i].numSwMsInst                  = 1;
        switch(i)
        {
            case 0:
    		    swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_VIP0_SC;//4
    		    break;
            case 1:
    		     swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_VIP0_SC;//4
     		    break;
            case 2:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_DEIHQ_SC_NO_DEI;//4
        		break;
            case 3:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_DEIHQ_SC_NO_DEI;//4
        		break;
            case 4:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_DEI_SC_NO_DEI;//5
        		break;
            case 5:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_DEI_SC_NO_DEI;//5
        		break;
            case 6:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_VIP1_SC;//5
        		break;
            case 7:
                swMsPrm[i].swMsInstId[0]                = SYSTEM_SW_MS_SC_INST_VIP1_SC;//5
        		break;
        }
 
		swMsPrm[i].maxInputQueLen               = SYSTEM_SW_MS_DEFAULT_INPUT_QUE_LEN + 4;
		swMsPrm[i].numOutBuf                    = NUM_BUFS_PER_CH_SWMS;

		swMsPrm[i].maxOutRes                    = VSYS_STD_720P_60;
		swMsPrm[i].initOutRes                   = VSYS_STD_720P_60;
		swMsPrm[i].lineSkipMode                 = FALSE;
		swMsPrm[i].enableLayoutGridDraw         = FALSE;
		MultiCh_setSwMsParams(&swMsPrm[i], i);
		swMsPrm[i].inQueParams.prevLinkId     = gMultiCh_VdecVmosaicVencVObj.dupId;
		swMsPrm[i].inQueParams.prevLinkQueId  = i;
		swMsPrm[i].outQueParams.nextLink      = gMultiCh_VdecVmosaicVencVObj.mergeId;
                
                swMsPrm[i].outputBufModified            = FALSE;
                swMsPrm[i].enableProcessTieWithDisplay  = FALSE;
	    
	}
    printf("Config MergeLink Params!!!\n");
	/******************************set merge link param *******************************/
	mergePrm.numInQue                         = NUM_SWMS_LINK;
	for(i=0; i<NUM_SWMS_LINK; i++)
	{
		mergePrm.inQueParams[i].prevLinkId    = gMultiCh_VdecVmosaicVencVObj.swmsId[i];
		mergePrm.inQueParams[i].prevLinkQueId = 0;
	}
    mergePrm.outQueParams.nextLink            = gMultiCh_VdecVmosaicVencVObj.nsfId;
    mergePrm.notifyNextLink                   = TRUE;
    
    printf("Config NfsLink Params!!!\n");
	/******************************set nsf link param *******************************/
    NsfLink_CreateParams_Init(&nsfPrm);
    Multich_SetNsfParams(&nsfPrm);
    nsfPrm.inQueParams.prevLinkId             = gMultiCh_VdecVmosaicVencVObj.mergeId;
    nsfPrm.inQueParams.prevLinkQueId          = 0;
    nsfPrm.outQueParams[0].nextLink              = gVencModuleContext.ipcM3OutId;
	/******************************set ipcOutVpssPrm link param *******************************/
	IpcLink_CreateParams_Init(&ipcOutVpssPrm);
	ipcOutVpssPrm.inQueParams.prevLinkId      = gMultiCh_VdecVmosaicVencVObj.nsfId;
    ipcOutVpssPrm.inQueParams.prevLinkQueId   = 0;
    ipcOutVpssPrm.numOutQue                   = 1;
    ipcOutVpssPrm.outQueParams[0].nextLink    = gVencModuleContext.ipcM3InId;
    ipcOutVpssPrm.notifyNextLink              = TRUE;
    ipcOutVpssPrm.notifyPrevLink              = TRUE;
    ipcOutVpssPrm.noNotifyMode                = FALSE;
	/******************************set ipcInVideoPrm link param *******************************/
    IpcLink_CreateParams_Init(&ipcInVideoPrm);
    ipcInVideoPrm.inQueParams.prevLinkId      = gVencModuleContext.ipcM3OutId;
    ipcInVideoPrm.inQueParams.prevLinkQueId   = 0;
    ipcInVideoPrm.numOutQue                   = 1;
    ipcInVideoPrm.outQueParams[0].nextLink    = gVencModuleContext.encId;
    ipcInVideoPrm.notifyNextLink              = TRUE;
    ipcInVideoPrm.notifyPrevLink              = TRUE;
    ipcInVideoPrm.noNotifyMode                = FALSE;

    printf("Config EncLink Params!!!\n");
	/******************************set enc link param *******************************/	
	EncLink_CreateParams_Init(&encPrm);
	Multich_SetEncParams(&encPrm);
	encPrm.inQueParams.prevLinkId             = gVencModuleContext.ipcM3InId;
    encPrm.inQueParams.prevLinkQueId          = 0;
    encPrm.outQueParams.nextLink              = gVencModuleContext.ipcBitsOutRTOSId;
	/******************************set IpcBitsOutLinkRTOS link param *******************************/	
    IpcBitsOutLinkRTOS_CreateParams_Init(&ipcBitsOutVideoPrm);
	ipcBitsOutVideoPrm.baseCreateParams.inQueParams.prevLinkId     = gVencModuleContext.encId;
    ipcBitsOutVideoPrm.baseCreateParams.inQueParams.prevLinkQueId      = 0;
	ipcBitsOutVideoPrm.baseCreateParams.numOutQue                  = 1;
    ipcBitsOutVideoPrm.baseCreateParams.outQueParams[0].nextLink       = gVencModuleContext.ipcBitsInHLOSId;
    ipcBitsOutVideoPrm.baseCreateParams.notifyNextLink                 = TRUE;
    ipcBitsOutVideoPrm.baseCreateParams.notifyPrevLink                 = TRUE;
    ipcBitsOutVideoPrm.baseCreateParams.noNotifyMode                   = FALSE;
 
    /******************************set IpcBitsInLinkHLOS link param *******************************/
    MultiCh_ipcBitsInitCreateParams_BitsInHLOS(&ipcBitsInHostPrm);
    ipcBitsInHostPrm.baseCreateParams.inQueParams.prevLinkId           = gVencModuleContext.ipcBitsOutRTOSId;
    ipcBitsInHostPrm.baseCreateParams.inQueParams.prevLinkQueId        = 0;
    ipcBitsInHostPrm.baseCreateParams.numOutQue                        = 1;
    ipcBitsInHostPrm.baseCreateParams.outQueParams[0].nextLink         = SYSTEM_LINK_ID_INVALID;
    ipcBitsInHostPrm.baseCreateParams.notifyNextLink                   = FALSE;
    ipcBitsInHostPrm.baseCreateParams.notifyPrevLink                   = TRUE;
    ipcBitsInHostPrm.baseCreateParams.noNotifyMode                     = FALSE;
	/******************************Create Links from src to sink *******************************/
	System_linkCreate(gVdecModuleContext.ipcBitsOutHLOSId,&ipcBitsOutHostPrm,sizeof(ipcBitsOutHostPrm));
    System_linkCreate(gVdecModuleContext.ipcBitsInRTOSId,&ipcBitsInVideoPrm,sizeof(ipcBitsInVideoPrm));
    System_linkCreate(gVdecModuleContext.decId, &decPrm, sizeof(decPrm));
	System_linkCreate(gVdecModuleContext.ipcM3OutId, &ipcOutVideoPrm, sizeof(ipcOutVideoPrm));
    System_linkCreate(gVdecModuleContext.ipcM3InId, &ipcInVpssPrm, sizeof(ipcInVpssPrm));
	
	System_linkCreate(gMultiCh_VdecVmosaicVencVObj.dupId, &dupPrm, sizeof(dupPrm));
	for(i=0; i<NUM_SWMS_LINK; i++)
        { 
	     System_linkCreate(gMultiCh_VdecVmosaicVencVObj.swmsId[i],
                               &swMsPrm[i],
                               sizeof(swMsPrm[i])
                              );
        }
	System_linkCreate(gMultiCh_VdecVmosaicVencVObj.mergeId, &mergePrm, sizeof(mergePrm));
	System_linkCreate(gMultiCh_VdecVmosaicVencVObj.nsfId, &nsfPrm, sizeof(nsfPrm));
	
	System_linkCreate(gVencModuleContext.ipcM3OutId, &ipcOutVpssPrm, sizeof(ipcOutVpssPrm));
	System_linkCreate(gVencModuleContext.ipcM3InId, &ipcInVideoPrm, sizeof(ipcInVideoPrm));
	System_linkCreate(gVencModuleContext.encId, &encPrm, sizeof(encPrm));
	System_linkCreate(gVencModuleContext.ipcBitsOutRTOSId, &ipcBitsOutVideoPrm, sizeof(ipcBitsOutVideoPrm));
	System_linkCreate(gVencModuleContext.ipcBitsInHLOSId, &ipcBitsInHostPrm, sizeof(ipcBitsInHostPrm));
	
	MultiCh_memPrintHeapStatus();

	System_linkStart(gVdecModuleContext.ipcBitsOutHLOSId);
	System_linkStart(gVdecModuleContext.ipcBitsInRTOSId);
	System_linkStart(gVdecModuleContext.decId);
	System_linkStart(gVdecModuleContext.ipcM3OutId);
	System_linkStart(gVdecModuleContext.ipcM3InId);
	for(i=0; i<NUM_SWMS_LINK; i++)
	{
	     System_linkStart(gMultiCh_VdecVmosaicVencVObj.swmsId[i]);
	}
	System_linkStart(gMultiCh_VdecVmosaicVencVObj.nsfId);

	System_linkStart(gVencModuleContext.ipcM3OutId);
	System_linkStart(gVencModuleContext.ipcM3InId);
	System_linkStart(gVencModuleContext.encId);
	System_linkStart(gVencModuleContext.ipcBitsOutRTOSId);
	System_linkStart(gVencModuleContext.ipcBitsInHLOSId);

}
//delete usecase
void MultiCh_deleteVdecVmosaicVenc()
{
    int i;
    Vdec_delete();
    Venc_delete();
	System_linkDelete(gMultiCh_VdecVmosaicVencVObj.dupId);
	for(i=0; i<NUM_SWMS_LINK; i++)
		System_linkDelete(gMultiCh_VdecVmosaicVencVObj.swmsId[i]);
	System_linkDelete(gMultiCh_VdecVmosaicVencVObj.mergeId);
	System_linkDelete(gMultiCh_VdecVmosaicVencVObj.nsfId);
	/* Print slave processor load info */
    MultiCh_prfLoadCalcEnable(FALSE, TRUE, FALSE);
}
