/* 
 * Copyright (c) 2010, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
/*
 *  ======== serverplatforms.xs ========
 *  This script builds the platforms specific to servers in this package.
 *  It is included by the package-specific _config.bld.
 */
/*
 *  Codec Engine Memory Map for TI8168
 *
 *  8000_0000 - 8AFF_FFFF  (176 MB)     External Memory
 *  ----------------------------------------------------
 *  8000_0000 - 8AFF_FFFF  ( 176 MB)     Linux (reserved)
 *  8B00_0000 - 8B7F_FFFF  (   8 MB)     DSP code (reserved)
 *  8B80_0000 - 8CBF_FFFF  (  20 MB)     CMEM (reserved)
 *  8CC0_0000 - 8CFF_FFFF  (   4 MB)     DDRALGHEAP (Codecs dynamic heap)
 *  8D00_0000 - 8DBF_FFFF  (  12 MB)     DDR3_SR1 (????)
 *  8DC0_0000 - 8DDF_FFFF  (   2 MB)     DDR3_HDVPSS (????)
 *  8DE0_0000 - 8DFF_FFFF  (   2 MB)     DDR3_V4L2 (????)
 *  8E00_0000 - 8EFF_FFFF  (  16 MB)     DDR3_SR0 (????)
 *  8F00_0000 - 8FFF_FFFF  (  16 MB)     DDR3_M3 (????)
 */
// Note reserved section in the following memory map should not be changed
var TI816X_DSP_MemoryMap = [
//EZSDK Linux and CMEM configuration for 5.03
/*["DDR3_HOST", {
    comment:    "DDR3 Memory reserved for use by the A8",
    name:       "DDR3_HOST",
    base:       0x80000000,
    len:        0x0B000000,
}],
["DDR3_CMEM", {
    comment: "DDR3 Memory reserved for use by the C674/ARM for CMEM",
    name: "DDR3_CMEM",
    base: 0x96C00000,
    len: 0x01400000       // 20MB (CMEM region defined based on application requirement) 
}],*/
["DDR3_DSP", {
     comment: "DDR3 Memory reserved for use by the C674",
     name: "DDR3_DSP",
     base: 0x99500000,
     len:  0x00c00000    /* 12 MB (Default memory reserved for c674x changed based on size of the DSP code)*/
}],
["DDRALGHEAP", {
     comment: "DDR3 Memory reserved for use by algorithms on the C674",
     name: "DDRALGHEAP",
     base: 0x98000000,
     len:  0x01400000    /* 20 MB (Region used by algs and codec engine for memory allocations)*/
}],
["DDR3_SR1", {
      comment: "DDR3 Memory reserved for use by SharedRegion 1",
      name: "DDR3_SR1",
      base: 0x99400000,
      len:  0x00100000    /* 1 MB (Reserved)*/
}],
["DDR3_SR0", {
      comment: "DDR3 Memory reserved for use by SharedRegion 0",
      name: "DDR3_SR0",
      base: 0x9F700000,
      len:  0x00200000    /* 2 MB (Reserved)*/
}],
["DDR3_REST", {
      comment: "DDR3 Memory reserved for use by the M3 core",
      name: "DDR3_REST",
      base: 0x9F900000,
      len:  0x01000000    /* 16 MB */
}],	  
];


/* platform instances used by this package */
Build.platformTable["ti.platforms.evmTI816X:DSP"] = {
    externalMemoryMap: TI816X_DSP_MemoryMap,
    /* Instantiate platform with required cache settings
       Check Datasheet for Maximum cache settings */
    l1DMode:"32k",
    l1PMode:"32k",
    l2Mode:"256k",
    codeMemory: "DDR3_DSP",
    dataMemory: "DDR3_DSP",
    stackMemory: "DDR3_DSP",
};


/*
 *  @(#) ti.sdo.ce.examples.servers.all_codecs; 1, 0, 0,207; 10-11-2010 15:13:47; /db/atree/library/trees/ce/ce-s01x/src/ xlibrary

 */

