/*
// TI File $Revision: /main/9 $
// Checkin $Date: August 28, 2007   11:23:38 $
//###########################################################################
//
// FILE:	AppBoot_lnk.cmd
//
// TITLE:	Linker Command File For F28335 Device
//
//###########################################################################
// $TI Release: DSP2833x Header Files V1.00 $
// $Release Date: September 7, 2007 $
//###########################################################################
*/

/* ======================================================
// For Code Composer Studio V2.2 and later
// ---------------------------------------
// In addition to this memory linker command file, 
// add the header linker command file directly to the project. 
// The header linker command file is required to link the
// peripheral structures to the proper locations within 
// the memory map.
//
// The header linker files are found in <base>\DSP2833x_Headers\cmd
//   
// For BIOS applications add:      DSP2833x_Headers_BIOS.cmd
// For nonBIOS applications add:   DSP2833x_Headers_nonBIOS.cmd    
========================================================= */

/* ======================================================
// For Code Composer Studio prior to V2.2
// --------------------------------------
// 1) Use one of the following -l statements to include the 
// header linker command file in the project. The header linker
// file is required to link the peripheral structures to the proper 
// locations within the memory map                                    */

/* Uncomment this line to include file only for non-BIOS applications */
/* -l DSP2833x_Headers_nonBIOS.cmd */

/* Uncomment this line to include file only for BIOS applications */
/* -l DSP2833x_Headers_BIOS.cmd */

/* 2) In your project add the path to <base>\DSP2833x_headers\cmd to the
   library search path under project->build options, linker tab, 
   library search path (-i).
/*========================================================= */

/* Define the memory block start/length for the F28335  
   PAGE 0 will be used to organize program sections
   PAGE 1 will be used to organize data sections

    Notes: 
          Memory blocks on F28335 are uniform (ie same
          physical memory) in both PAGE 0 and PAGE 1.  
          That is the same memory region should not be
          defined for both PAGE 0 and PAGE 1.
          Doing so will result in corruption of program 
          and/or data. 
          
          L0/L1/L2 and L3 memory blocks are mirrored - that is
          they can be accessed in high memory or low memory.
          For simplicity only one instance is used in this
          linker file. 
          
          Contiguous SARAM memory blocks can be combined 
          if required to create a larger memory block. 
 */

-stack 0x400

MEMORY
{
PAGE 0:    /* Program Memory */
           /* Memory (RAM/FLASH/OTP) blocks can be moved to PAGE1 for data allocation */

   //PRAML0      : origin = 0x008000, length = 0x000800     /* on-chip RAM block L0 */

   // R.Liang : RAM P
   RAMP0         : origin = 0x008000, length = 0x004000     /* on-chip RAM block L3 */

   OTP         : origin = 0x3D7800, length = 0x000400     /* on-chip OTP */
   //FLASHD      : origin = 0x3E8000, length = 0x004000     /* on-chip FLASH */
   //FLASHC      : origin = 0x3EC000, length = 0x004000     /* on-chip FLASH */
   FLASHA      : origin = 0x3F4000, length = 0x003F80     /* on-chip FLASH */
   //FLASHB      : origin = 0x3F0000, length = 0x004000     /* on-chip FLASH */    
   //FLASHH        : origin = 0x3D8000, length = 0x004000     /* on-chip FLASH */    
   
   CSM_RSVD    : origin = 0x3F7F80, length = 0x000076     /* Part of FLASHA.  Program with all 0x0000 when CSM is in use. */
   BEGIN       : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASHA.  Used for "boot to Flash" bootloader mode. */
   CSM_PWL     : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASHA.  CSM password locations in FLASHA */
   
   FPUTABLES   : origin = 0x3FD860, length = 0x0006A0	  /* FPU Tables in Boot ROM */
   IQTABLES    : origin = 0x3FDF00, length = 0x000B50     /* IQ Math Tables in Boot ROM */
   IQTABLES2   : origin = 0x3FEA50, length = 0x00008C     /* IQ Math Tables in Boot ROM */
   IQTABLES3   : origin = 0x3FEADC, length = 0x0000AA	  /* IQ Math Tables in Boot ROM */

   ROM         : origin = 0x3FF3B0, length = 0x000C10     /* Boot ROM */
   RESET       : origin = 0x3FFFC0, length = 0x000002     /* part of boot ROM  */
   VECTORS     : origin = 0x3FFFC2, length = 0x00003E     /* part of boot ROM  */

PAGE 1 :   /* Data Memory */
           /* Memory (RAM/FLASH/OTP) blocks can be moved to PAGE0 for program allocation */
           /* Registers remain on PAGE1                                                  */

   BOOT_RSVD   : origin = 0x000000, length = 0x000050     /* Part of M0, BOOT rom will use this for stack */  
   RAMM0       : origin = 0x000050, length = 0x0003B0     /* on-chip RAM block M0 */
   RAMM1       : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

   DRAML1      : origin = 0x008800, length = 0x000400     /* on-chip RAM block L1 */  

   RAML2       : origin = 0x008C00, length = 0x000400     /* on-chip RAM block L2 */
   RAML3       : origin = 0x009000, length = 0x001000	  /* on-chip RAM block L3 */
   RAML4       : origin = 0x00A000, length = 0x002000     /* on-chip RAM block L4 */

   //RAML5       : origin = 0x00C000, length = 0x002000     /* on-chip RAM block L5 */
   //RAML6       : origin = 0x00E000, length = 0x002000     /* on-chip RAM block L6 */
   //RAML7       : origin = 0x010000, length = 0x002000     /* on-chip RAM block L7 */
   //RAML8       : origin = 0x012000, length = 0x002000     /* on-chip RAM block L8 */   

   // R.Liang
   RAMP1_S	   : origin = 0x00C000, length = 0x0010     /* on-chip RAM block L3 */
   RAMP1       : origin = 0x00C010, length = 0x003ff0     /* on-chip RAM block L3 */


    
}



/* Allocate sections to memory blocks.
   Note:
         codestart user defined section in DSP28_CodeStartBranch.asm used to redirect code 
                   execution when booting to flash
         ramfuncs  user defined section to store functions that will be copied from Flash into RAM
*/ 
 
SECTIONS
{
   sys_entry		 : > 0x3F4000,           PAGE = 0 
   
   /* Allocate program areas: */
   /* The Flash API functions can be grouped together as shown below.
      The defined symbols _Flash28_API_LoadStart, _Flash28_API_LoadEnd
      and _Flash28_API_RunStart are used to copy the API functions out
      of flash memory and into SARAM */
/*
   Flash28_API:
   {
        -lFlash2806x_API_V100.lib(.econst) 
        -lFlash2806x_API_V100.lib(.text)
   }                   LOAD = FLASHH, 
                       RUN = RAMP0,  
                       LOAD_START(_Flash28_API_LoadStart),
                       LOAD_END(_Flash28_API_LoadEnd),
                       RUN_START(_Flash28_API_RunStart),
                       PAGE = 0
*/


   CRC_API:
   {        
        -lcrc_vcu.lib(.text)
   }                   LOAD = FLASHA, 
                       RUN = RAMP0,  
                       LOAD_START(_CRC_API_LoadStart),
                       LOAD_END(_CRC_API_LoadEnd),
                       RUN_START(_CRC_API_RunStart),
                       PAGE = 0 
/*
   SBD_API:
   {        
        -lbfm.lib(.text)
   }                   LOAD = FLASHA, 
                       RUN = RAMP0,  
                       LOAD_START(_SBD_API_LoadStart),
                       LOAD_END(_SBD_API_LoadEnd),
                       RUN_START(_SBD_API_RunStart),
                       PAGE = 0	
*/
   CSL_F2806x_API:
   {   
        -lcsl_F2806x.lib<F2806x_DefaultIsr.obj> (.text)
		//rts2800_fpu32.lib<args_main.obj> (.text)		

   }				   LOAD = FLASHA, 
                       RUN = RAMP0,  
                       LOAD_START(_CSL_API_LoadStart),
                       LOAD_END(_CSL_API_LoadEnd),
                       RUN_START(_CSL_API_RunStart),
                       PAGE = 0	
                       
   PROJ_ASSERT_API:
   {        
        -lproj_assert.lib(.text)
   }                   LOAD = FLASHA, 
                       RUN = RAMP0,  
                       LOAD_START(_PROJ_ASSERT_API_LoadStart),
                       LOAD_END(_PROJ_ASSERT_API_LoadEnd),
                       RUN_START(_PROJ_ASSERT_API_RunStart),
                       PAGE = 0 

   .cinit              : > FLASHA      PAGE = 0
   

                       
   .pinit              : > FLASHA,     PAGE = 0
   //boot 		  > FLASHD PAGE = 0

/*
   boot	 		: > 0x3D8010,           PAGE = 0           
   {
        rts2800_fpu32.lib<boot.obj> (.text)

   }   

*/

   .text               : > FLASHA      PAGE = 0
   codestart           : > BEGIN       PAGE = 0
   
   ramfuncs            : LOAD = FLASHA, 
                         RUN = RAMP0, 
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart),
                         PAGE = 0
   
    secureRamFuncs    :  LOAD = FLASHA,                  
                         RUN  = RAMP0,             
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_END(_secureRamFuncs_loadend),
                         RUN_START(_secureRamFuncs_runstart)
						 PAGE = 0

	phyRamFuncs    :     LOAD = FLASHA,                  
                         RUN  = RAMP0,             
                         LOAD_START(_phyRamFuncs_loadstart),
                         LOAD_END(_phyRamFuncs_loadend),
                         RUN_START(_phyRamFuncs_runstart)
						 PAGE = 0
						 
   csmpasswds          : > CSM_PWL     PAGE = 0
   csm_rsvd            : > CSM_RSVD    PAGE = 0
   
   /* Allocate uninitalized data sections: */
   .stack              : > RAMM1       PAGE = 1
   .ebss               : > RAMP1       PAGE = 1
   .esysmem            : > RAMM1       PAGE = 1
   .eshared            : > RAMP1_S     PAGE = 1

   /* Initalized sections go in Flash */
   /* For SDFlash to program these, they must be allocated to page 0 */
   //.econst             : > FLASHA      PAGE = 0
  
   .econst             : LOAD = FLASHA,  PAGE =0
                         RUN  = RAMP1,   PAGE =1          
                         LOAD_START(_econst_LoadStart),
                         LOAD_END(_econst_LoadEnd),
                         RUN_START(_econst_RunStart)
                        
   .switch             : > FLASHA      PAGE = 0      

   /* Allocate IQ math areas: */
   IQmath              : > FLASHA      PAGE = 0                  /* Math Code */
   IQmathTables     : > IQTABLES,  PAGE = 0, TYPE = NOLOAD 
   IQmathTables2    : > IQTABLES2, PAGE = 0, TYPE = NOLOAD 
   FPUmathTables    : > FPUTABLES, PAGE = 0, TYPE = NOLOAD 
         
   /* Allocate DMA-accessible RAM sections: */
//   DMARAML4         : > RAML4,     PAGE = 1
//   DMARAML5         : > RAML5,     PAGE = 1
//   DMARAML6         : > RAML6,     PAGE = 1
//   DMARAML7         : > RAML7,     PAGE = 1
   
   /* Allocate 0x400 of XINTF Zone 7 to storing data */
   //ZONE7DATA        : > ZONE7B,    PAGE = 1

   /* .reset is a standard section used by the compiler.  It contains the */ 
   /* the address of the start of _c_int00 for C Code.   /*
   /* When using the boot ROM this section and the CPU vector */
   /* table is not needed.  Thus the default type is set here to  */
   /* DSECT  */ 
   .reset              : > RESET,      PAGE = 0, TYPE = DSECT
   vectors             : > VECTORS     PAGE = 0, TYPE = DSECT
   
   /* Allocate ADC_cal function (pre-programmed by factory into TI reserved memory) */
   .adc_cal     : load = FLASHA,   PAGE = 0, TYPE = NOLOAD

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/

