/**************************************************************************************************
  Filename:       boot_api.h
  
  Description:    This file contains public APIs
  
  Copyright 2005-2007 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.

  HISTORY:
  
  12/29/2010 R.Liang           initial version 

******************************************************************************/
#ifndef _BOOT_API_H
#define _BOOT_API_H

#include <typedefs.h>
#include <proj_assert.h>

#include "DSP28x_Project.h"

/**************************************************************************************************
 * MACROS
 **************************************************************************************************/



/**************************************************************************************************
 * CONSTANTS
 **************************************************************************************************/
#ifdef F2806X
#define FIRMWARE_UPGRADE_APP_START_ADDRESS            (0x3D8000)
#else
#ifdef F28M35X
#define FIRMWARE_UPGRADE_APP_START_ADDRESS            (0x100000)
#else
#define FIRMWARE_UPGRADE_APP_START_ADDRESS            (0x300000)
#endif


#endif


#ifdef F2806X
// DFU     is in sector H: 
// AppBoot is in sector A:
// PLC start starts at sector G,F,E,D,C,and B

#define FLASH_STORED_CRC        (0x3F3FD0)
#define FLASH_STORED_IMAGE_LEN  (0x017FD0)
#define FLASH_PLC_IMAGE_START   (0x3DC000)

#define FLASH_BOOT_START_ADDR   (0x3F4000)

#else

#ifdef F28M35X

#define FLASH_STORED_CRC        (0x127FD0)
#define FLASH_STORED_IMAGE_LEN  (0x01FFD0)
#define FLASH_PLC_IMAGE_START   (0x108000)

#define FLASH_BOOT_START_ADDR   (0x13E000)

#else

#define FLASH_STORED_CRC        (0x32FFD0)
#define FLASH_STORED_IMAGE_LEN  (0x01FFD0)
#define FLASH_PLC_IMAGE_START   (0x310000)

#define FLASH_BOOT_START_ADDR   (0x338000)
#endif

#endif

/**************************************************************************************************
 *                                            TYPEDEFS
 **************************************************************************************************/



/* ------------------------------------------------------------------------------------------------
 *                                           Function Prototypes
 * ------------------------------------------------------------------------------------------------
 */


void soft_reset(void);
void Idle_Task(void);
UINT16 probe_Flash_upgrade(void);
void jump_flash_upgrade_start(int port);

void Jump_Start_BIT(void);
void Jump_Start_DFU(void);
void JUMP_Start_PLC_App(void);
UINT16 Flash_Check_Firmware_CRC32(void);
void Flash_Get_Firmware_Info(UINT32 *flash_start,UINT32 *len);
UINT32 Flash_getStoredFirmwareCRC32(void);

#endif //







