/******************************************************************************
* FILE PURPOSE: CRC32 Module definitions
*******************************************************************************
*
* FILE NAME: crc_32.h
*
* DESCRIPTION:
*  This file contains the API for the Prime CRC8 and CRC32 functions.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
*  03/02/2009  : Shu Du initial implementation for PRIME 
*  05/20/2009  : Shu Du changed the crc tables to be in flash 
*
* LIST OF FUNCTION POTOTYPES:
*
* Notes: 
*   
*  o CRC implementations are based on tables. If the tables
*    are calculated on the fly, the macro GEN_CRC_TABLES shall be defined
*    and genCRC32Tables() shall be called during 
*    initialization. If the macro is not defined, pre-calculated tables will
*    will be used. Using the latter option can put the tables to flash.
*
******************************************************************************/
#ifndef _CRC_32_H
#define _CRC_32_H

#include <typedefs.h>
#include <mp_sbfm.h>

/*****************************************************************************/
/* Definitions                                                               */
/*****************************************************************************/

//If the following macro is defined, tables need to be initialized, otherwise
//static tables are used. Static tables can be put in flash
//#define GEN_CRC_TABLES

#define INIT_CRC32 0x0
#define POLYNOMIAL32 0x04c11db7

/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/

#ifdef GEN_CRC_TABLES
void genCRC32Table();
#endif

uint32 getCRC32FromBD (uint32 input_crc32_accum, SBD_s * pbd, uint16 rxLen);
uint32 getCRC32 (uint32 input_crc32_accum, uint16 *msg, parity_t parity, uint32 rxLen);

#ifdef VCU
//#define getCRC32(input_crc_accum, msg, parity, rxLen) \
//        getCRC32_vcu_asm(input_crc_accum, msg, parity, rxLen)
uint32 getCRC32_vcu_asm(uint32 input_crc_accum, uint16 *msg, parity_t parity, uint16 rxLen);
#else

#endif

#endif // #ifndef _CRC_32_H
