/******************************************************************************
* FILE PURPOSE: CRC5 Module definitions
*******************************************************************************
*
* FILE NAME: crc_5.h
*
* DESCRIPTION:
*  This file contains the API for the Prime CRC8 and CRC32 functions.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
*  03/02/2009  : Shu Du initial implementation for PRIME 
*  05/20/2009  : Shu Du changed the crc tables to be in flash 
*
* LIST OF FUNCTION POTOTYPES:
*
* Notes: 
*   
*  o CRC implementations are based on tables. If the tables
*    are calculated on the fly, the macro GEN_CRC_TABLES shall be defined
*    and genCRC8Tables() shall be called during 
*    initialization. If the macro is not defined, pre-calculated tables will
*    will be used. Using the latter option can put the tables to flash.
*
******************************************************************************/
#ifndef _CRC_5_H
#define _CRC_5_H

#include <typedefs.h>

/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/

uint16 getCRC5(uint16 *in_p, int16 len);

#endif // #ifndef _CRC_5_H
