/******************************************************************************
* FILE PURPOSE: CRC8 Module definitions
*******************************************************************************
*
* FILE NAME: crc_8.h
*
* DESCRIPTION:
*  This file contains the API for the Prime CRC8 and CRC32 functions.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
*  03/02/2009  : Shu Du initial implementation for PRIME 
*  05/20/2009  : Shu Du changed the crc tables to be in flash 
*
* LIST OF FUNCTION POTOTYPES:
*
* Notes: 
*   
*  o CRC implementations are based on tables. If the tables
*    are calculated on the fly, the macro GEN_CRC_TABLES shall be defined
*    and genCRC8Tables() shall be called during 
*    initialization. If the macro is not defined, pre-calculated tables will
*    will be used. Using the latter option can put the tables to flash.
*
******************************************************************************/
#ifndef _CRC_8_H
#define _CRC_8_H

#include <typedefs.h>
#include <mp_sbfm.h>

/*****************************************************************************/
/* Definitions                                                               */
/*****************************************************************************/

//If the following macro is defined, tables need to be initialized, otherwise
//static tables are used. Static tables can be put in flash
//#define GEN_CRC_TABLES

#define INIT_CRC8 0x0
#define POLYNOMIAL8  0x07

/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/

#ifdef GEN_CRC_TABLES
void genCRC8Table();
#endif

uint16 getCRC8FromBD(uint16 input_crc8_accum, SBD_s * pbd, uint16 rxLen);
uint16 getCRC8(uint16 input_crc8_accum, uint16 *msg, parity_t parity, uint16 rxLen);

#ifdef VCU
//  #define getCRC8(input_crc_accum, msg, parity, rxLen) \
//        getCRC8_vcu_asm(input_crc_accum, msg, parity, rxLen)
  uint16 getCRC8_vcu_asm(uint32 input_crc_accum, uint16 *msg, parity_t parity, uint16 rxLen);
#else
  
#endif
      
#endif // #ifndef _CRC_8_H
