/******************************************************************************
* FILE PURPOSE: Public header file
*******************************************************************************
*
* FILE NAME: proj_assert.h
*
* DESCRIPTION:
*       This file contains public definitions, data structures and function 
*       prototypes for wimax assert function
*
*  Copyright (c) 2009 Texas Instruments Inc. 
*  All Rights Reserved This program is the confidential and proprietary 
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or 
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 08/16/2007 R.Liang           initial version
* 03/03/2009 R.Liang		   port to emeter project
* LIST OF FUNCTION PROTOTYPES: 
*
* 
******************************************************************************/
#ifndef PROJ_ASSERT_H
#define PROJ_ASSERT_H

#include <typedefs.h>

#if defined(_M_IX86)    // Visual Studio 2005 (Windows)

#ifndef ASSERT
#include <Crtdbg.h>
#define ASSERT        _ASSERT
#define proj_assert    _ASSERT
#endif

#elif defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio

#define SW_BREAKPOINT           asm( " .long 0x1001E000" );

//Robert Liang
// remove file name and line number to save memory
//void _proj_assert(const char *,const char *, int);

void _proj_assert(void);
#if 1
#define proj_assert(expr)  { if (!(expr)) \
      _proj_assert(); }
//      _proj_assert(#expr, __FILE__, __LINE__); }

#else
#define proj_assert(expr) 
#endif
#define PROJ_ASSERT_INT_ENAB() \
  { \
    UINT16 st1; \
    st1 = HWI_disable(); \
    HWI_restore(st1); \
    proj_assert((st1 & 1) == 0); \
  }

#endif

#define PROJ_OOPS  proj_assert(0)	

#endif // #ifndef LTE_ASSERT_H

