/*******************************************************************
 *
 *    DESCRIPTION:
 *
 *  Copyright (c) 2009 Texas Instruments Inc.
 *  All Rights Reserved This program is the confidential and proprietary
 *  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
 *  transfer of this program is strictly prohibited.
 *
 *    AUTHOR:
 *
 *    HISTORY:
 *
 *******************************************************************/
#ifndef _HW_SPINLOCK_H
#define _HW_SPINLOCK_H

/** include files **/
#include <typedefs.h>

/** local definitions **/

/** default settings **/

/** external functions **/

/** external data **/

/** internal functions **/

/** public data **/

typedef uint32 (*spinlock_DisableIntCbFunc)(void);
typedef void   (*spinlock_RestoreIntCbFunc)(uint32 saved_int);

typedef struct __spin_hdr_
{
  spinlock_DisableIntCbFunc disable;
  spinlock_RestoreIntCbFunc restore;
      
} SPIN_HND_s;

extern SPIN_HND_s spin_hnd;
/** private data **/

/** public functions **/
#if defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
uint32 spin_lock(uint16 lock_num);
void spin_unlock(uint16 lock_num,uint32 interrupt_save);

void spin_lock_init(spinlock_DisableIntCbFunc disableFunc,spinlock_RestoreIntCbFunc restoreFunc);

/** private functions **/

#endif

#endif

