//###########################################################################
//
// FILE:	F2806x_DMA.c
//
// TITLE:	F2806x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2806x/F2806x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "F2806x_Device.h"     // Headerfile Include File
#include "F2806x_Examples.h"   // Examples Include File

// This function initializes the DMA to a known state.
//



void DMACHWrapConfig(Uint16 ch_num,Uint16 srcwsize, int16 srcwstep, Uint16 deswsize, int16 deswstep)
{
	volatile struct CH_REGS *pch;
  
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);

	// Set up WRAP registers:
	pch->SRC_WRAP_SIZE = srcwsize;				// Wrap source address after N bursts
  pch->SRC_WRAP_STEP = srcwstep;			    // Step for source wrap

	pch->DST_WRAP_SIZE = deswsize;				// Wrap destination address after N bursts
	pch->DST_WRAP_STEP = deswstep;				// Step for destination wrap

	EDIS;
}


