//###########################################################################
//
// FILE:	DSP2833x_DMA.c
//
// TITLE:	DSP2833x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP2833x/DSP2823x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "DSP2833x_Device.h"     // Headerfile Include File
#include "DSP2833x_Examples.h"   // Examples Include File


void DMACHAddrConfig(Uint16 ch_num,volatile Uint16 *DMA_Dest,volatile Uint16 *DMA_Source)
{
	volatile struct CH_REGS *pch;
  
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);
  
	// Set up SOURCE address:
  pch->SRC_BEG_ADDR_SHADOW = (Uint32)DMA_Source;	// Point to beginning of source buffer
  pch->SRC_ADDR_SHADOW =     (Uint32)DMA_Source;
  
	// Set up DESTINATION address:
	pch->DST_BEG_ADDR_SHADOW = (Uint32)DMA_Dest;	    // Point to beginning of destination buffer
	pch->DST_ADDR_SHADOW =     (Uint32)DMA_Dest;


	EDIS;
}

