//###########################################################################
//
// FILE:	DSP2833x_DMA.c
//
// TITLE:	DSP2833x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP2833x/DSP2823x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "DSP2833x_Device.h"     // Headerfile Include File
#include "DSP2833x_Examples.h"   // Examples Include File



void DMACHTransferConfig(Uint16 ch_num,Uint16 tsize, int16 srctstep, int16 deststep)
{
	volatile struct CH_REGS *pch;
  
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);

	// Set up TRANSFER registers:
	pch->TRANSFER_SIZE = tsize;                  // Number of bursts per transfer, DMA interrupt will occur after completed transfer
	pch->SRC_TRANSFER_STEP = srctstep;			// TRANSFER_STEP is ignored when WRAP occurs
	pch->DST_TRANSFER_STEP = deststep;			// TRANSFER_STEP is ignored when WRAP occurs

	EDIS;
}

