/*******************************************************************
 *
 *    DESCRIPTION: 
 *		this function contains the spin lock/unlock related functions.
 *		It is ported from CM3 MP system to DSP/BIOS. Initially, spin_lock
 *		just disables the interrupt, the spin_unlock will restore the interrupt
 *
 *		It will call HWI_disable, HWI_restore function in BIOS
 *
 *  Copyright (c) 2004 Texas Instruments Inc.
 *  All Rights Reserved This program is the confidential and proprietary
 *  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
 *  transfer of this program is strictly prohibited.
 *
 *    AUTHOR:
 *
 *    HISTORY:
 *		11/21/2008 R.Liang           initial version
 *
 *******************************************************************/
#if defined (CM3)
#include <portmacro.h>

#else
//#include <inttypes.h>
//#include <std.h>
//#include <hwi.h>
#endif

/** include files **/
#include <spinlock.h>

#if !defined(_M_IX86)    // Visual Studio 2005 (Windows)
// R.Liang need to port for F28335
//
//#include "csl_intc.h"
#endif // #if !defined(_M_IX86)    // Visual Studio 2005 (Windows)

/** local definitions **/

/** default settings **/

/** external functions **/

/** external data **/

/** internal functions **/

/** public data **/

/** private data **/

/** public functions **/

/** private functions **/

SPIN_HND_s spin_hnd;

/*
 *  FUNCTION: spin_lock
 *
 *  PARAMETERS:
 *      input   : lock_num. For single core, it can be any value. For MP core
 *                we need to hardware support to specify which HW semaphore.
 *      output  : no
 *
 *  DESCRIPTION:
 *      In single core, this function just disables the global interrupt.
 *
 *  RETURNS: 
 *      old CSR value. It will be used when HWI_restore function
 *
 */

uint32 spin_lock(uint16 lock_num)
{
#if !defined(_M_IX86)    // Visual Studio 2005 (Windows)

  uint32 state=0;
  (void) lock_num;

  // F28335 intrisic
  //  asm(" setc INTM");
#if defined (CM3)
  //state =_disable_interrupts();
  vPortEnterCritical();

#else
  if (spin_hnd.disable)
  { // call disable interrupt functions
    state =  (spin_hnd.disable)();
  }
  
#endif

  return (uint32) state;
#else // #if !defined(_M_IX86)    // Visual Studio 2005 (Windows)
  return 0;
#endif // #if !defined(_M_IX86)    // Visual Studio 2005 (Windows)
}

/*
 *  FUNCTION: spin_unlock
 *
 *  PARAMETERS:
 *      input   : 
 *          lock_num    : lock_num
 *          interrupt_save: saved CSR
 *      output  : no
 *
 *  DESCRIPTION:
 *      this function will restore the previous stored CSR to re-enable
 *      the interrupt
 *
 *  RETURNS: 
 *      No
 */
 
void spin_unlock(uint16 lock_num,uint32 interrupt_save)
{ 
#if !defined(_M_IX86)    // Visual Studio 2005 (Windows)
  (void) lock_num;

// R.Liang fix me
// F28335 intrisic 

#if defined (CM3)
  vPortExitCritical();
#else
  //  asm(" clrc INTM");
  if (spin_hnd.restore)
  { // restore previous disabled interrupt
    (spin_hnd.restore)(interrupt_save);
  }
  
#endif


#endif // #if !defined(_M_IX86)    // Visual Studio 2005 (Windows)
}

// init spin lock
void spin_lock_init(spinlock_DisableIntCbFunc disableFunc,spinlock_RestoreIntCbFunc restoreFunc)
{
  spin_hnd.disable = disableFunc;
  spin_hnd.restore = restoreFunc;

}

