/******************************************************************************
* FILE PURPOSE: Module for CRC-5 calculation
*******************************************************************************
*
* FILE NAME: crc5.c
*
* DESCRIPTION:
*  This file contains the functions to do the MAC CRC8, CRC16, CRC32
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
*  03/18/2010  : fum, initial version
*  09/28/2010  : gxu, changed to shift register based solution
*
* LIST OF FUNCTION POTOTYPES:
*
*
******************************************************************************/
#include <typedefs.h>

#include "crc5.h"

/* CRC5 LUT, G(x)=x^5+x^2+1 or 0x25 */

/******************************************************************************
* FUNCTION NAME: getCRC5
*
* DESCRIPTION:   Get CRC5 for input bit stream. Input data is arranged as 1b/W
*
* Return Value:  None
*
* Input Parameters:
*               *in_p - pointer to input bit stream
*                len  - length (num of bits) of the input data
*
* Output Parameters:
*               Return CRC5 value
* Functions Called:
*
******************************************************************************/
UINT16 getCRC5(UINT16 *in_p, SINT16 len)
{

  UINT16 crc[5];
  UINT16 tmpVar; 
  UINT16 kk, crcOut = 0;
  
  /* initialize all states to 1 */
  crc[0] = 1;
  crc[1] = 1;
  crc[2] = 1;
  crc[3] = 1;
  crc[4] = 1;
  
  for (kk = 0; kk < len; kk++)
  {
  	tmpVar = *in_p++ ^ crc[4] ;
  	crc[4] = crc[3];
  	crc[3] = crc[2];
  	crc[2] = tmpVar ^ crc[1];
  	crc[1] = crc[0];
  	crc[0] = tmpVar;
  }
  
  /* swap the order of CRC5 */
  crcOut =  (crc[3] << 4) | (crc[2] << 3) | (crc[1] << 2) | (crc[0] << 1) | crc[4];

  /* flip all CRC bits to protect trailing zeros */
  return (crcOut ^ 0x1F);
}
