
/*******************************************************************
 *
 *    DESCRIPTION: LTE assert function
 *
 *    AUTHOR:	Robert Liang
 *
 *    HISTORY: 12/15/2008
 *    01/15/2012    R.Liang     port for Concert CM3
 
 *******************************************************************/

/** include files **/

#include <stdio.h>
#include <proj_assert.h>

/** local definitions **/

/** default settings **/

/** external functions **/

/** external data **/

/** internal functions **/

/** public data **/

/** private data **/

/** public functions **/

/** private functions **/


/*
 *  FUNCTION: LTE_assert
 *
 *  PARAMETERS:
 *
 *  DESCRIPTION:
 *
 *  RETURNS: 
 *
 */
 
volatile UINT32 proj_assert_cnt=0;
volatile int forever = 1;
#if !defined(_M_IX86)    // Visual Studio 2005 (Windows)

//void _proj_assert(const char * expr,const char *filename, int line_num)
void _proj_assert(void)
{
#if defined (CM3)
  unsigned int dst;
  
#endif
  // for F28X
  proj_assert_cnt++;

  // emulator stop  
  //  asm( "ESTOP0 ");

  //printf("expression (%s) File(%s) line(%d)\n",expr,filename,line_num);
#if defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
    //SW_BREAKPOINT;
    // for DSPc6x
    //asm( " swbp 0 ");

#endif

  // disable global interrupt
#if defined (CM3)
  // ARM intrinsic
  dst = _disable_interrupts();

#else
  asm(" setc INTM");         // DINT; // Disable Interrupts at the CPU level
#endif

#ifndef _DEBUG
  // for release don't wait forever  
#else
  // proj_assert_cnt is volatile so the loop will not be optimized out
  while (forever)
  {
#if 0
     TSK_sleep(1000);
     DIAG_printf(DIAG_LOG_LEVEL_ERROR, DIAG_LOG_ASSERT, 0); 
#endif
  }
#endif

  // enable interrupt    
#if defined (CM3)
  // enable interrupt (intrinsic)
  _restore_interrupts(dst);
#else
  asm(" clrc INTM");          //  EINT; // Enable Interrupts at the CPU level
#endif

}
#endif

