#include <algorithm>
#include <string.h>
#include "Trim.h"


// A function to trim whitespace from both sides of a given std::string
void Trim(std::string& str, const std::string & ChrsToTrim, int TrimDir)
{
    size_t startIndex = str.find_first_not_of(ChrsToTrim);
    if (startIndex == std::string::npos){str.erase(); return;}
    if (TrimDir < 2) str = str.substr(startIndex, str.size()-startIndex);
    if (TrimDir!=1) str = str.substr(0, str.find_last_not_of(ChrsToTrim) + 1);
}

void TrimRight(std::string& str, const std::string & ChrsToTrim)
{
    Trim(str, ChrsToTrim, 2);
}

void TrimLeft(std::string& str, const std::string & ChrsToTrim)
{
    Trim(str, ChrsToTrim, 1);
}

// A function to transform a string to uppercase if neccessary
void UCase(std::string& str, bool ucase)
{
	if(ucase) transform(str.begin(), str.end(), str.begin(), std::toupper);
}
