/** Set functions for YAFFS header file
 *
 * @file yaffs_setfuncs.h
 * @author Igor Kondrashenkov
 * @date 2012-08-02
 *
 * Copyright (c) 2012 Kelvatek Ltd. All rights reserved.
 */

#ifndef __YAFFS_SETFUNCS_H__
#define __YAFFS_SETFUNCS_H__

#include "yaffs_guts.h"
#include "yaffs_packedtags2.h"
//
// ************ INBAND TAG structures **************
//
/** physical implementation for a full TAG information */
//! use inbandTags, so everything should be like this:
// totalBytesPerChunk = PAGE_SIZE - sizeof(yaffs_user_inbandtag_t) + sizeof(yaffs_PackedTags2TagsPart);
//! this will be done in yaffs_guts.c:5155, because of inbandTags
// nDataBytesPerChunk = totalBytesPerChunk - spareBytesPerChunk;
// spareBytesPerChunk = sizeof(yaffs_inbandtag_t);
typedef struct {
    yaffs_PackedTags2 pt2;  //! packed tag with ECC
    //! stores ECC for data block
    uint32_t ecc_data[2];
    char blockState;        // 0xFF for a good block	
} yaffs_inbandtag_t;

// ************       externs        **************
#ifdef __cplusplus
extern "C" {
#endif

    int InitialiseNAND(yaffs_Device *dev);
    int DeinitialiseNAND(yaffs_Device *dev);
    int WriteChunkWithTagsToNAND(yaffs_Device *dev,int chunkInNAND,const __u8 *data, const yaffs_ExtendedTags *tags);
    int ReadChunkWithTagsFromNAND(yaffs_Device *dev, int chunkInNAND, __u8 *data, yaffs_ExtendedTags *tags);
    int MarkNANDBlockBad(struct yaffs_DeviceStruct *dev, int blockNo);
    int EraseBlockInNAND(yaffs_Device *dev, int blockNo);
    int QueryNANDBlock(struct yaffs_DeviceStruct *dev, int blockNo, yaffs_BlockState *state, __u32 *sequenceNumber);

#ifdef __cplusplus
}
#endif

#endif /*__YAFFS_SETFUNCS_H__*/
