/**
 * \file YAFFS/Direct/yaffs_utils.cpp
 * \brief YAFFS user utilities
 *
 * \author Igor Kondrashenkov <igor@kelvatek.com>
 *
 * \note
 *  - Project: Kelvatek PGM
 *  - Copyright (c) 2012 by Kelvatek Ltd.
 */
#include <stdlib.h>
#include "yaffsfs.h"
#include <string>

/* extern */
extern "C" void yaffsfs_log(const char *buf);

/** logger for YAFFS */
extern "C" void yaffs_log(const char *buf);
void yaffs_log(const char *buf)
{
	yaffsfs_log(buf);
}

extern "C" void yaffs_ssync(const char* path);
void yaffs_ssync(const char* path)
{
    std::string str = "Flushing ";
    str += path;
    str += " partition to flash ...";
    yaffs_log(str.c_str());
    int e = yaffs_sync(path);
    str = "Partition ";
    str += path;
    str += " has been flushed ";
    str += (e == -1) ? "with an error!" : "successfully.";
    yaffs_log(str.c_str());
}

extern "C" int yaffs_copy(const char* src, const char* dst, const int ChunkSz);
int yaffs_copy(const char* src, const char* dst, const int ChunkSz)
{
    char* buf = (char* ) yaffs_malloc(ChunkSz);

    if (buf == NULL)
        return 0;

    int fsrc = -1;
    int fdst = -1;
    int total = 0;

    yaffs_unlink(dst);

    while (1) {
        fsrc = yaffs_open(src, O_RDONLY, 0);
        if (fsrc == -1) break;

        fdst = yaffs_open(dst, O_WRONLY|O_CREAT|O_TRUNC, S_IREAD | S_IWRITE);
        if (fdst == -1) break;

        int rbytes = 0;
        int wbytes = 0;

        do {
            rbytes = yaffs_read(fsrc, buf, ChunkSz);
            if (rbytes == -1) {
                total = 0;
                break;
            }

            wbytes = yaffs_write(fdst, buf, rbytes);
            if (wbytes == -1) {
                total = 0;
                break;
            }

            total += wbytes;
        } while (rbytes != 0);
        break;
    }

    if (fsrc != -1) yaffs_close(fsrc);
    if (fdst != -1) yaffs_close(fdst);
    yaffs_free(buf);

    return total;
}
