/*
 * YAFFS: Yet another Flash File System . A NAND-flash specific file system. 
 *
 * Copyright (C) 2002-2010 Aleph One Ltd.
 *   for Toby Churchill Ltd and Brightstar Engineering
 *
 * Created by Charles Manning <charles@aleph1.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1 as
 * published by the Free Software Foundation.
 *
 * Note: Only YAFFS headers are LGPL, YAFFS C code is covered by GPL.
 */

/*
 * Header file for using yaffs in an application via
 * a direct interface.
 */


#ifndef __YAFFSCFG_H__
#define __YAFFSCFG_H__

#include "yportenv.h"
#include "devextras.h"

#define YAFFSFS_N_HANDLES 100

typedef struct yaffsfs_DeviceConfigurationStruct {
    const YCHAR *prefix;
    struct yaffs_DeviceStruct *dev;
} yaffsfs_DeviceConfiguration;

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/
   
    int yaffsfs_Format(const char *dir);
    void yaffsfs_Lock(void);
    void yaffsfs_Unlock(void);
    __u32 yaffsfs_CurrentTime(void);
    void yaffsfs_SetError(int err);
    int yaffsfs_GetLastError(void);
    int yaffs_copy(const char* src, const char* dst, const int ChunkSz);
    void yaffs_ssync(const char* path);
    void yaffsfs_log(const char *buf);
    
#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /*__YAFFSCFG_H__*/

