/** Hardware Abstraction Layer for flash IO for YAFFS needs
 *
 * @file hal_nand.h
 * @author Igor Kondrashenkov
 * @date 2012-08-02
 *
 * Copyright (c) 2012 Kelvatek Ltd. All rights reserved.
 */

#ifndef _HAL_NAND_H_
#define _HAL_NAND_H_

/** definitions of NAND device */
/*! this is a physical data
 *  then driver emulates this
 *  now based on 64kb blocks
 */
#define HAL_NAND_PAGE_SIZE     		256
#define HAL_NAND_PAGES_PER_BLK  	256		// block size 64kb
#define HAL_NAND_BLKS_PER_DEV64   	128		// 64Mbit device
#define HAL_NAND_BLKS_PER_DEV128   	256		// 128Mbit device

/** definitions of logical geometry */
/*! if this is not the same as a physical data
 *  then HAL driver emulates this
 */
#define HAL_CHUNK_SIZE			512
#define HAL_CHUNKS_PER_BLK		((HAL_NAND_PAGE_SIZE * HAL_NAND_PAGES_PER_BLK) / HAL_CHUNK_SIZE)

#define FLASH_OP_OK     1
#define FLASH_OP_FAIL   0

// interface to helper functions
#ifdef __cplusplus
extern "C" {
#endif

    int Hal_Nand_IoInit(void);
    int Hal_Nand_IoEraseBlock(uint32_t IOID, uint32_t blockno);
    int Hal_Nand_IoWrite(uint32_t IOID, uint32_t ChunkNo, uint32_t offset, const void *data, uint32_t size);
    int Hal_Nand_IoRead(uint32_t IOID, uint32_t ChunkNo, uint32_t offset, void *data, uint32_t size);
    int Hal_Nand_IoEraseFlash(uint32_t IOID);

#ifdef __cplusplus
}
#endif

#endif /* _HAL_NAND_H_ */

