/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Main header file of Board Support Library for SPM6420/6430
* FILENAME......... bsl_bsl.h
*------------------------------------------------------------------------------
*
* The User has to define either BOARD_SPM6420 or BOARD_SPM6430 in the
* project's settings according to the board to be programmed.
*
* This header file should be included by the main header file of all the
* projects that applies the BSL.
*
\******************************************************************************/
#ifndef _BSL_BSL_H_
#define _BSL_BSL_H_

#ifndef _INLINE
    #define _INLINE
#endif

#include <stddef.h>
#include <csl.h>
#include <csl_stdinc.h>
#include <csl_irq.h>
#include <bsl_stdinchal.h>

/******************************************************************************\
* scope and inline control macros
\******************************************************************************/
#ifdef __cplusplus
    #define BSLAPI extern "C" far
#else
    #define BSLAPI extern far
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _BSL_BSL_MOD_
    #define IDECL BSLAPI
    #define USEDEFS
    #define IDEF
#else
    #ifdef  _INLINE
        #define IDECL static inline
        #define USEDEFS
        #define IDEF  static inline
    #else
        #define IDECL BSLAPI
    #endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

#ifdef BOARD_SPM6420
    #define BOARD_SPM6420_SUPPORT           1
    #define CHIP_6416                       1
#else
    #define BOARD_SPM6420_SUPPORT           0
#endif // #ifdef BOARD_SPM6420

#ifdef BOARD_SPM6430
    #define BOARD_SPM6430_SUPPORT           1
    #define CHIP_6416                       1
#else
    #define BOARD_SPM6430_SUPPORT           0
#endif // #ifdef BOARD_SPM6430

#ifdef BOARD_SPM6431
    #define BOARD_SPM6431_SUPPORT           1
    #define CHIP_6416                       1
#else
    #define BOARD_SPM6431_SUPPORT           0
#endif // #ifdef BOARD_SPM6431

// Testing the correct BOARD_SPM64xx define
#if ((BOARD_SPM6420_SUPPORT + BOARD_SPM6430_SUPPORT + BOARD_SPM6431_SUPPORT) == 0)
    #error You have to define either BOARD_SPM6420, BOARD_SPM6430, or BOARD_SPM6431.
#endif

#if ((BOARD_SPM6420_SUPPORT + BOARD_SPM6430_SUPPORT + BOARD_SPM6431_SUPPORT) > 1)
    #error You can define only one symbol from BOARD_SPM6420, BOARD_SPM6430, and BOARD_SPM6431.
#endif

// on-board device supports
#define BOARD_SUPPORT(b0,b1,b2) ( \
    ( b0 * BOARD_SPM6420_SUPPORT)  | \
    ( b1 * BOARD_SPM6430_SUPPORT)  | \
    ( b2 * BOARD_SPM6431_SUPPORT)    \
)

//-------------------------------------------------------
//                                                S S S
//                                                P P P
//                                                M M M
//                                                6 6 6
//                                                4 4 4
//                                                2 3 3
//                                                0 0 1
//-------------------------------------------------------
#define BSL_SYNCBUS_SUPPORT         BOARD_SUPPORT(1,1,1)
#define BSL_WATCHDOG_SUPPORT        BOARD_SUPPORT(1,1,1)
#define BSL_UMISC_SUPPORT           BOARD_SUPPORT(1,1,1)
#define BSL_USIG_SUPPORT            BOARD_SUPPORT(1,1,1)
#define BSL_UINT_SUPPORT            BOARD_SUPPORT(1,1,1)
#define BSL_UCOMM_SUPPORT           BOARD_SUPPORT(1,1,1)
#define BSL_FLASH_SUPPORT           BOARD_SUPPORT(1,1,1)
#define BSL_PCIBUS_SUPPORT          BOARD_SUPPORT(1,1,1)
#define BSL_PDEV_SUPPORT            BOARD_SUPPORT(1,1,1)
#define BSL_DUART_SUPPORT           BOARD_SUPPORT(0,0,1)
#define BSL_ADIO_SUPPORT            BOARD_SUPPORT(0,0,1)
#define BSL_AC97_SUPPORT            BOARD_SUPPORT(0,0,1)
// boards on Platform Bus
#define BSL_AIM6020_SUPPORT         BOARD_SUPPORT(1,0,0)

// Platform bus initializations
#define PLATFORMBUS0                0x0401
#define PLATFORMBUS1                0x2112

/*----------------------------------------------------------------------------*/
/* invalid function */
#define INVALID_VFXN                ((VFxn)(0xFFFFFFFF))


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

typedef double  Double;

typedef void (*VFxn)();

typedef Uint32 BOOL;

/* Board descriptor (hardware identifiers) */
typedef struct {

    Uint32  dspNomSpeed;        /* DSP processor nominal speed in MHz */
    Uint32  flashSize;          /* Flash memory size in MB */
    Uint32  sdramSize;          /* SDRAM memory size in MB */
    Uint32  flashAutoDetected;   /* Confirms that the board write to flash
                                   bit was set and that the flash size could
                                   be automatically detected */
} BSL_BoardDescriptor;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI BSL_BoardDescriptor BSL_boardDescriptor;



/******************************************************************************\
* global function declarations
\******************************************************************************/
BSLAPI void BSL_init();

// for the FLASH module initialization
BSLAPI void FLASH_init();   // defined in the bsl_flash.c

// for the COMM module initialization
BSLAPI void COMM_init();    // defined in the bsl_comm.c

#ifdef BSL_DUART_SUPPORT
// for the Dual Uart module initialization
BSLAPI void DUART_init();   // defined in the bsl_duart.c
#endif /* BSL_DUART_SUPPORT */

/******************************************************************************\
* inline function declarations
\******************************************************************************/

IDECL Uint32 BSL_getDspNominalSpeed();
IDECL Uint32 BSL_getFlashSize();
IDECL Uint32 BSL_getFlashAutoDetected();
IDECL Uint32 BSL_getSdramSize();


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
// returns the DSP processor's nominal speed in MHz
// according to the PCI interface's EEPROM content
IDEF Uint32 BSL_getDspNominalSpeed()
{
    return BSL_boardDescriptor.dspNomSpeed;
}

/*----------------------------------------------------------------------------*/
// returns the installed flash memory size in MBytes
// according to the PCI interface's EEPROM content
IDEF Uint32 BSL_getFlashSize()
{
    return BSL_boardDescriptor.flashSize;
}

/*----------------------------------------------------------------------------*/
// returns whether the the flash size above was auto detected during
// BSL_init() function call (the write flash dip switch must be on to do this)
// or whether a default of 2MB was placed in flashSize because the
// write to flash dip switch was turned off during the first call
// to BSL_init()
IDEF Uint32 BSL_getFlashAutoDetected()
{
    return BSL_boardDescriptor.flashAutoDetected;
}

/*----------------------------------------------------------------------------*/
// returns the installed SDRAM memory size in MBytes
// according to the PCI interface's EEPROM content
IDEF Uint32 BSL_getSdramSize()
{
    return BSL_boardDescriptor.sdramSize;
}

#endif /* USEDEFS */

#endif /* _BSL_BSL_H_ */
/******************************************************************************\
* End of bsl_bsl.h
\******************************************************************************/

