/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral AIM6020
* FILENAME......... bsl_aim6020hal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 02/20/2004 09:13:10
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. AIM6020
* PERIPHERAL TYPE.. Multi-device peripheral
* ACCESS MODE...... Through handle
* REGISTER ACCESS.. 32-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. AIM60200 is 0x6C040000u
* BASE ADDRESS OF.. AIM60201 is 0x6C050000u
* BASE ADDRESS OF.. AIM60202 is 0x6C060000u
* BASE ADDRESS OF.. AIM60203 is 0x6C070000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* DEVID       -  Identification Register
* CONFIG      -  Configuration Register
* AD1RD       -  A/D 1 Read Register
* DA1WR       -  D/A 1 Write Register
* AD2RD       -  A/D 2 Read Register
* DA2WR       -  D/A 2 Write Register
* AD1STRT     -  A/D 1 Software Start Register
* DA1UPDT     -  D/A 1 Software Update Register
* AD2STRT     -  A/D 2 Software Start Register
* DA2UPDT     -  D/A 2 Software Update Register
* AD12STRT    -  A/D 1 and 2 Simultaneous Software Start Register
* DA12UPDT    -  D/A 1 and 2 Simultaneous Software Update Register
* FLTCLK1     -  Filter Clock 1 Register
* FLTCLK2     -  Filter Clock 2 Register
* FLTCFG      -  Filter Configuration Register
* INTCFG      -  Interrupt Configuration Register
* SERIAL      -  Serial Data Register
* DISPLAY     -  Display Register
* I2CDAT      -  I2C Serial Data
* I2CCLK      -  I2C Serial Clock
* I2COE       -  I2C Serial Output Enable
* DUMMY       -  Dummy register
*
\******************************************************************************/
#ifndef _BSL_AIM6020HAL_H_
#define _BSL_AIM6020HAL_H_

#include <bsl.h>


#if (BSL_AIM6020_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _AIM6020_DEVICE_COUNT                      4

  #define _AIM60200_BASE_ADDRESS                     0x6C040000u
  #define _AIM60201_BASE_ADDRESS                     0x6C050000u
  #define _AIM60202_BASE_ADDRESS                     0x6C060000u
  #define _AIM60203_BASE_ADDRESS                     0x6C070000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define AIM6020_FMK(REG,FIELD,val)\
    _PER_FMK32(AIM6020,##REG,##FIELD,val)

  #define AIM6020_FMKS(REG,FIELD,SYM)\
    _PER_FMKS32(AIM6020,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define AIM6020_ADDR(REG)\
    _AIM6020_##REG##_ADDR

  #define AIM6020_RGET(REG)\
    _PER_RGET32(_AIM6020_##REG##_ADDR,AIM6020,##REG) & 0x0000FFFF

  #define AIM6020_RSET(REG,val)\
    _PER_RSET32(_AIM6020_##REG##_ADDR,AIM6020,##REG,val)

  #define AIM6020_FGET(REG,FIELD)\
    _PER_FGET32(_AIM6020_##REG##_ADDR,AIM6020,##REG,##FIELD)

  #define AIM6020_FSET(REG,FIELD,val)\
    _PER_FSET32(_AIM6020_##REG##_ADDR,AIM6020,##REG,##FIELD,val)

  #define AIM6020_FSETS(REG,FIELD,SYM)\
    _PER_FSETS32(_AIM6020_##REG##_ADDR,AIM6020,##REG,##FIELD,##SYM)

  #define AIM6020_FGETQ(REG,FIELD,val)\
    _PER_FGETQ32(_AIM6020_##REG##_ADDR,AIM6020,##REG,##FIELD,val)

  #define AIM6020_FGETSQ(REG,FIELD,SYM)\
    _PER_FGETSQ32(_AIM6020_##REG##_ADDR,AIM6020,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define AIM6020_RGETA(addr,REG)\
    _PER_RGET32(addr,AIM6020,##REG) & 0x0000FFFF

  #define AIM6020_RSETA(addr,REG,val)\
    _PER_RSET32(addr,AIM6020,##REG,val)

  #define AIM6020_FGETA(addr,REG,FIELD)\
    _PER_FGET32(addr,AIM6020,##REG,##FIELD)

  #define AIM6020_FSETA(addr,REG,FIELD,val)\
    _PER_FSET32(addr,AIM6020,##REG,##FIELD,val)

  #define AIM6020_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS32(addr,AIM6020,##REG,##FIELD,##SYM)

  #define AIM6020_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ32(addr,AIM6020,##REG,##FIELD,val)

  #define AIM6020_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ32(addr,AIM6020,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* HANDLE BASED REGISTER/FIELD ACCESS MACROS   */
  /* ------------------------------------------- */

  #define AIM6020_ADDRH(h,REG)\
    ((Uint32)(((h)->baseAddr) + (Uint32)(_AIM6020_##REG##_REGOFFS)))

  #define AIM6020_RGETH(h,REG)\
    AIM6020_RGETA(AIM6020_ADDRH(h,##REG),##REG)

  #define AIM6020_RSETH(h,REG,val)\
    AIM6020_RSETA(AIM6020_ADDRH(h,##REG),##REG,val)

  #define AIM6020_FGETH(h,REG,FIELD)\
    AIM6020_FGETA(AIM6020_ADDRH(h,##REG),##REG,##FIELD)

  #define AIM6020_FSETH(h,REG,FIELD,val)\
    AIM6020_FSETA(AIM6020_ADDRH(h,##REG),##REG,##FIELD,val)

  #define AIM6020_FSETSH(h,REG,FIELD,SYM)\
    AIM6020_FSETSA(AIM6020_ADDRH(h,##REG),##REG,##FIELD,##SYM)

  #define AIM6020_FGETQH(h,REG,FIELD,val)\
    AIM6020_FGETQA(AIM6020_ADDRH(h,##REG),##REG,##FIELD,val)

  #define AIM6020_FGETSQH(h,REG,FIELD,SYM)\
    AIM6020_FGETSQA(AIM6020_ADDRH(h,##REG),##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define AIM6020_VRGET(var,REG)\
    _PER_VRGET32(var,AIM6020,##REG)

  #define AIM6020_VRSET(var,REG,val)\
    _PER_VRSET32(var,AIM6020,##REG,val)

  #define AIM6020_VFGET(var,REG,FIELD)\
    _PER_VFGET32(var,AIM6020,##REG,##FIELD)

  #define AIM6020_VFSET(var,REG,FIELD,val)\
    _PER_VFSET32(var,AIM6020,##REG,##FIELD,val)

  #define AIM6020_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS32(var,AIM6020,##REG,##FIELD,##SYM)

  #define AIM6020_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ32(var,AIM6020,##REG,##FIELD,val)

  #define AIM6020_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ32(var,AIM6020,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  D E V I D            |
* |_______________________|
*
* DEVID - Identification Register
*
* FIELDS (msb -> lsb)
* (R.)  DEVID       [15: 0]  - Hardcoded Device ID (0x6020 or 0x6021)
*
\******************************************************************************/
/*#define _AIM6020_DEVID_RECIDX                      No recorded */

  #define _AIM6020_DEVID0_ADDR                       0x6C040000u
  #define _AIM6020_DEVID1_ADDR                       0x6C050000u
  #define _AIM6020_DEVID2_ADDR                       0x6C060000u
  #define _AIM6020_DEVID3_ADDR                       0x6C070000u

  #define _AIM6020_DEVID_REGOFFS                     0x00000000u
  #define _AIM6020_DEVID_REGOFFS16                   0x00000000u

  #define _AIM6020_DEVID_DEVID_MASK                  0x0000FFFFu
  #define _AIM6020_DEVID_DEVID_SHIFT                 0
  #define AIM6020_DEVID_DEVID_DEFAULT                0x00000000u
  #define AIM6020_DEVID_DEVID_OF(x)                  _VALUEOF16(x)
  #define AIM6020_DEVID_DEVID_AIM6020                0x00006020u
  #define AIM6020_DEVID_DEVID_AIM6021                0x00006021u
  #define _AIM6020_DEVID_DEVID_AIM6020_SV            0x00006020u
  #define _AIM6020_DEVID_DEVID_AIM6021_SV            0x00006021u

  #define AIM6020_DEVID_OF(val)                      _VALUEOF16(val)
  #define AIM6020_DEVID_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,DEVID,DEVID)           \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  C O N F I G          |
* |_______________________|
*
* CONFIG - Configuration Register
*
* FIELDS (msb -> lsb)
* (.W)  DA2UPDT     [ 7: 6]  - D/A 2 Update Signal
* (.W)  DA1UPDT     [ 5: 4]  - D/A 1 Update Signal
* (.W)  AD2STRT     [ 3: 2]  - A/D 2 Start Signal
* (.W)  AD1STRT     [ 1: 0]  - A/D 1 Start Signal
*
\******************************************************************************/
  #define _AIM6020_CONFIG_RECIDX                     0

  #define _AIM6020_CONFIG0_ADDR                      0x6C040000u
  #define _AIM6020_CONFIG1_ADDR                      0x6C050000u
  #define _AIM6020_CONFIG2_ADDR                      0x6C060000u
  #define _AIM6020_CONFIG3_ADDR                      0x6C070000u

  #define _AIM6020_CONFIG_REGOFFS                    0x00000000u
  #define _AIM6020_CONFIG_REGOFFS16                  0x00000000u

  #define _AIM6020_CONFIG_DA2UPDT_MASK               0x000000C0u
  #define _AIM6020_CONFIG_DA2UPDT_SHIFT              6
  #define AIM6020_CONFIG_DA2UPDT_DEFAULT             0x00000000u
  #define AIM6020_CONFIG_DA2UPDT_OF(x)               _VALUEOF16(x)
  #define AIM6020_CONFIG_DA2UPDT_SOFTWARE            0x00000000u
  #define AIM6020_CONFIG_DA2UPDT_SYNCBUS0            0x00000001u
  #define AIM6020_CONFIG_DA2UPDT_SYNCBUS1            0x00000002u
  #define AIM6020_CONFIG_DA2UPDT_SYNCBUS2            0x00000003u
  #define _AIM6020_CONFIG_DA2UPDT_SOFTWARE_SV        0x00000000u
  #define _AIM6020_CONFIG_DA2UPDT_SYNCBUS0_SV        0x00000040u
  #define _AIM6020_CONFIG_DA2UPDT_SYNCBUS1_SV        0x00000080u
  #define _AIM6020_CONFIG_DA2UPDT_SYNCBUS2_SV        0x000000C0u

  #define _AIM6020_CONFIG_DA1UPDT_MASK               0x00000030u
  #define _AIM6020_CONFIG_DA1UPDT_SHIFT              4
  #define AIM6020_CONFIG_DA1UPDT_DEFAULT             0x00000000u
  #define AIM6020_CONFIG_DA1UPDT_OF(x)               _VALUEOF16(x)
  #define AIM6020_CONFIG_DA1UPDT_SOFTWARE            0x00000000u
  #define AIM6020_CONFIG_DA1UPDT_SYNCBUS0            0x00000001u
  #define AIM6020_CONFIG_DA1UPDT_SYNCBUS1            0x00000002u
  #define AIM6020_CONFIG_DA1UPDT_SYNCBUS2            0x00000003u
  #define _AIM6020_CONFIG_DA1UPDT_SOFTWARE_SV        0x00000000u
  #define _AIM6020_CONFIG_DA1UPDT_SYNCBUS0_SV        0x00000010u
  #define _AIM6020_CONFIG_DA1UPDT_SYNCBUS1_SV        0x00000020u
  #define _AIM6020_CONFIG_DA1UPDT_SYNCBUS2_SV        0x00000030u

  #define _AIM6020_CONFIG_AD2STRT_MASK               0x0000000Cu
  #define _AIM6020_CONFIG_AD2STRT_SHIFT              2
  #define AIM6020_CONFIG_AD2STRT_DEFAULT             0x00000000u
  #define AIM6020_CONFIG_AD2STRT_OF(x)               _VALUEOF16(x)
  #define AIM6020_CONFIG_AD2STRT_SOFTWARE            0x00000000u
  #define AIM6020_CONFIG_AD2STRT_SYNCBUS0            0x00000001u
  #define AIM6020_CONFIG_AD2STRT_SYNCBUS1            0x00000002u
  #define AIM6020_CONFIG_AD2STRT_SYNCBUS2            0x00000003u
  #define _AIM6020_CONFIG_AD2STRT_SOFTWARE_SV        0x00000000u
  #define _AIM6020_CONFIG_AD2STRT_SYNCBUS0_SV        0x00000004u
  #define _AIM6020_CONFIG_AD2STRT_SYNCBUS1_SV        0x00000008u
  #define _AIM6020_CONFIG_AD2STRT_SYNCBUS2_SV        0x0000000Cu

  #define _AIM6020_CONFIG_AD1STRT_MASK               0x00000003u
  #define _AIM6020_CONFIG_AD1STRT_SHIFT              0
  #define AIM6020_CONFIG_AD1STRT_DEFAULT             0x00000000u
  #define AIM6020_CONFIG_AD1STRT_OF(x)               _VALUEOF16(x)
  #define AIM6020_CONFIG_AD1STRT_SOFTWARE            0x00000000u
  #define AIM6020_CONFIG_AD1STRT_SYNCBUS0            0x00000001u
  #define AIM6020_CONFIG_AD1STRT_SYNCBUS1            0x00000002u
  #define AIM6020_CONFIG_AD1STRT_SYNCBUS2            0x00000003u
  #define _AIM6020_CONFIG_AD1STRT_SOFTWARE_SV        0x00000000u
  #define _AIM6020_CONFIG_AD1STRT_SYNCBUS0_SV        0x00000001u
  #define _AIM6020_CONFIG_AD1STRT_SYNCBUS1_SV        0x00000002u
  #define _AIM6020_CONFIG_AD1STRT_SYNCBUS2_SV        0x00000003u

  #define AIM6020_CONFIG_OF(val)                     _VALUEOF16(val)
  #define AIM6020_CONFIG_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,CONFIG,DA2UPDT)        \
    | _PER_FDEFAULT32(AIM6020,CONFIG,DA1UPDT)        \
    | _PER_FDEFAULT32(AIM6020,CONFIG,AD2STRT)        \
    | _PER_FDEFAULT32(AIM6020,CONFIG,AD1STRT)        \
  )

  #define AIM6020_CONFIG_RMK(da2updt,da1updt,        \
    ad2strt,ad1strt)                                 \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,CONFIG,DA2UPDT,da2updt)     \
    | _PER_FMK32(AIM6020,CONFIG,DA1UPDT,da1updt)     \
    | _PER_FMK32(AIM6020,CONFIG,AD2STRT,ad2strt)     \
    | _PER_FMK32(AIM6020,CONFIG,AD1STRT,ad1strt)     \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  A D 1 R D            |
* |_______________________|
*
* AD1RD - A/D 1 Read Register
*
* FIELDS (msb -> lsb)
* (R.)  DATA        [15: 0]  - A/D 1 Read
*
\******************************************************************************/
/*#define _AIM6020_AD1RD_RECIDX                      No recorded */

  #define _AIM6020_AD1RD0_ADDR                       0x6C040004u
  #define _AIM6020_AD1RD1_ADDR                       0x6C050004u
  #define _AIM6020_AD1RD2_ADDR                       0x6C060004u
  #define _AIM6020_AD1RD3_ADDR                       0x6C070004u

  #define _AIM6020_AD1RD_REGOFFS                     0x00000004u
  #define _AIM6020_AD1RD_REGOFFS16                   0x00000002u

  #define _AIM6020_AD1RD_DATA_MASK                   0x0000FFFFu
  #define _AIM6020_AD1RD_DATA_SHIFT                  0
  #define AIM6020_AD1RD_DATA_DEFAULT                 0x00000000u
  #define AIM6020_AD1RD_DATA_OF(x)                   _VALUEOF16(x)

  #define AIM6020_AD1RD_OF(val)                      _VALUEOF16(val)
  #define AIM6020_AD1RD_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,AD1RD,DATA)            \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D A 1 W R            |
* |_______________________|
*
* DA1WR - D/A 1 Write Register
*
* FIELDS (msb -> lsb)
* (.W)  DATA        [15: 0]  - D/A 1 Write
*
\******************************************************************************/
/*#define _AIM6020_DA1WR_RECIDX                      No recorded */

  #define _AIM6020_DA1WR0_ADDR                       0x6C040004u
  #define _AIM6020_DA1WR1_ADDR                       0x6C050004u
  #define _AIM6020_DA1WR2_ADDR                       0x6C060004u
  #define _AIM6020_DA1WR3_ADDR                       0x6C070004u

  #define _AIM6020_DA1WR_REGOFFS                     0x00000004u
  #define _AIM6020_DA1WR_REGOFFS16                   0x00000002u

  #define _AIM6020_DA1WR_DATA_MASK                   0x0000FFFFu
  #define _AIM6020_DA1WR_DATA_SHIFT                  0
  #define AIM6020_DA1WR_DATA_DEFAULT                 0x00000000u
  #define AIM6020_DA1WR_DATA_OF(x)                   _VALUEOF16(x)

  #define AIM6020_DA1WR_OF(val)                      _VALUEOF16(val)
  #define AIM6020_DA1WR_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,DA1WR,DATA)            \
  )

  #define AIM6020_DA1WR_RMK(data)                    \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DA1WR,DATA,data)            \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  A D 2 R D            |
* |_______________________|
*
* AD2RD - A/D 2 Read Register
*
* FIELDS (msb -> lsb)
* (R.)  DATA        [15: 0]  - A/D 2 Read
*
\******************************************************************************/
/*#define _AIM6020_AD2RD_RECIDX                      No recorded */

  #define _AIM6020_AD2RD0_ADDR                       0x6C040008u
  #define _AIM6020_AD2RD1_ADDR                       0x6C050008u
  #define _AIM6020_AD2RD2_ADDR                       0x6C060008u
  #define _AIM6020_AD2RD3_ADDR                       0x6C070008u

  #define _AIM6020_AD2RD_REGOFFS                     0x00000008u
  #define _AIM6020_AD2RD_REGOFFS16                   0x00000004u

  #define _AIM6020_AD2RD_DATA_MASK                   0x0000FFFFu
  #define _AIM6020_AD2RD_DATA_SHIFT                  0
  #define AIM6020_AD2RD_DATA_DEFAULT                 0x00000000u
  #define AIM6020_AD2RD_DATA_OF(x)                   _VALUEOF16(x)

  #define AIM6020_AD2RD_OF(val)                      _VALUEOF16(val)
  #define AIM6020_AD2RD_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,AD2RD,DATA)            \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D A 2 W R            |
* |_______________________|
*
* DA2WR - D/A 2 Write Register
*
* FIELDS (msb -> lsb)
* (.W)  DATA        [15: 0]  - D/A 2 Write
*
\******************************************************************************/
/*#define _AIM6020_DA2WR_RECIDX                      No recorded */

  #define _AIM6020_DA2WR0_ADDR                       0x6C040008u
  #define _AIM6020_DA2WR1_ADDR                       0x6C050008u
  #define _AIM6020_DA2WR2_ADDR                       0x6C060008u
  #define _AIM6020_DA2WR3_ADDR                       0x6C070008u

  #define _AIM6020_DA2WR_REGOFFS                     0x00000008u
  #define _AIM6020_DA2WR_REGOFFS16                   0x00000004u

  #define _AIM6020_DA2WR_DATA_MASK                   0x0000FFFFu
  #define _AIM6020_DA2WR_DATA_SHIFT                  0
  #define AIM6020_DA2WR_DATA_DEFAULT                 0x00000000u
  #define AIM6020_DA2WR_DATA_OF(x)                   _VALUEOF16(x)

  #define AIM6020_DA2WR_OF(val)                      _VALUEOF16(val)
  #define AIM6020_DA2WR_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,DA2WR,DATA)            \
  )

  #define AIM6020_DA2WR_RMK(data)                    \
    (Uint16)(                                        \
      _PER_FMK16(AIM6020,DA2WR,DATA,data)            \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  A D 1 S T R T        |
* |_______________________|
*
* AD1STRT - A/D 1 Software Start Register
*
* FIELDS (msb -> lsb)
* (R.)  START       [ 0: 0]  - A/D 1 Software Start
*
\******************************************************************************/
/*#define _AIM6020_AD1STRT_RECIDX                    No recorded */

  #define _AIM6020_AD1STRT0_ADDR                     0x6C04000Cu
  #define _AIM6020_AD1STRT1_ADDR                     0x6C05000Cu
  #define _AIM6020_AD1STRT2_ADDR                     0x6C06000Cu
  #define _AIM6020_AD1STRT3_ADDR                     0x6C07000Cu

  #define _AIM6020_AD1STRT_REGOFFS                   0x0000000Cu
  #define _AIM6020_AD1STRT_REGOFFS16                 0x00000006u

  #define _AIM6020_AD1STRT_START_MASK                0x00000001u
  #define _AIM6020_AD1STRT_START_SHIFT               0
  #define AIM6020_AD1STRT_START_DEFAULT              0x00000000u
  #define AIM6020_AD1STRT_START_OF(x)                _VALUEOF16(x)
  #define AIM6020_AD1STRT_START_START                0x00000000u
  #define _AIM6020_AD1STRT_START_START_SV            0x00000000u

  #define AIM6020_AD1STRT_OF(val)                    _VALUEOF16(val)
  #define AIM6020_AD1STRT_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,AD1STRT,START)         \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D A 1 U P D T        |
* |_______________________|
*
* DA1UPDT - D/A 1 Software Update Register
*
* FIELDS (msb -> lsb)
* (.W)  UPDATE      [ 0: 0]  - D/A 1 Software Update
*
\******************************************************************************/
/*#define _AIM6020_DA1UPDT_RECIDX                    No recorded */

  #define _AIM6020_DA1UPDT0_ADDR                     0x6C04000Cu
  #define _AIM6020_DA1UPDT1_ADDR                     0x6C05000Cu
  #define _AIM6020_DA1UPDT2_ADDR                     0x6C06000Cu
  #define _AIM6020_DA1UPDT3_ADDR                     0x6C07000Cu

  #define _AIM6020_DA1UPDT_REGOFFS                   0x0000000Cu
  #define _AIM6020_DA1UPDT_REGOFFS16                 0x00000006u

  #define _AIM6020_DA1UPDT_UPDATE_MASK               0x00000001u
  #define _AIM6020_DA1UPDT_UPDATE_SHIFT              0
  #define AIM6020_DA1UPDT_UPDATE_DEFAULT             0x00000000u
  #define AIM6020_DA1UPDT_UPDATE_OF(x)               _VALUEOF16(x)
  #define AIM6020_DA1UPDT_UPDATE_UPDATE              0x00000000u
  #define _AIM6020_DA1UPDT_UPDATE_UPDATE_SV          0x00000000u

  #define AIM6020_DA1UPDT_OF(val)                    _VALUEOF16(val)
  #define AIM6020_DA1UPDT_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,DA1UPDT,UPDATE)        \
  )

  #define AIM6020_DA1UPDT_RMK(update)                \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DA1UPDT,UPDATE,update)      \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  A D 2 S T R T        |
* |_______________________|
*
* AD2STRT - A/D 2 Software Start Register
*
* FIELDS (msb -> lsb)
* (R.)  START       [ 0: 0]  - A/D 2 Software Start
*
\******************************************************************************/
/*#define _AIM6020_AD2STRT_RECIDX                    No recorded */

  #define _AIM6020_AD2STRT0_ADDR                     0x6C040010u
  #define _AIM6020_AD2STRT1_ADDR                     0x6C050010u
  #define _AIM6020_AD2STRT2_ADDR                     0x6C060010u
  #define _AIM6020_AD2STRT3_ADDR                     0x6C070010u

  #define _AIM6020_AD2STRT_REGOFFS                   0x00000010u
  #define _AIM6020_AD2STRT_REGOFFS16                 0x00000008u

  #define _AIM6020_AD2STRT_START_MASK                0x00000001u
  #define _AIM6020_AD2STRT_START_SHIFT               0
  #define AIM6020_AD2STRT_START_DEFAULT              0x00000000u
  #define AIM6020_AD2STRT_START_OF(x)                _VALUEOF16(x)
  #define AIM6020_AD2STRT_START_START                0x00000000u
  #define _AIM6020_AD2STRT_START_START_SV            0x00000000u

  #define AIM6020_AD2STRT_OF(val)                    _VALUEOF16(val)
  #define AIM6020_AD2STRT_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,AD2STRT,START)         \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D A 2 U P D T        |
* |_______________________|
*
* DA2UPDT - D/A 2 Software Update Register
*
* FIELDS (msb -> lsb)
* (.W)  UPDATE      [ 0: 0]  - D/A 2 Software Update
*
\******************************************************************************/
/*#define _AIM6020_DA2UPDT_RECIDX                    No recorded */

  #define _AIM6020_DA2UPDT0_ADDR                     0x6C040010u
  #define _AIM6020_DA2UPDT1_ADDR                     0x6C050010u
  #define _AIM6020_DA2UPDT2_ADDR                     0x6C060010u
  #define _AIM6020_DA2UPDT3_ADDR                     0x6C070010u

  #define _AIM6020_DA2UPDT_REGOFFS                   0x00000010u
  #define _AIM6020_DA2UPDT_REGOFFS16                 0x00000008u

  #define _AIM6020_DA2UPDT_UPDATE_MASK               0x00000001u
  #define _AIM6020_DA2UPDT_UPDATE_SHIFT              0
  #define AIM6020_DA2UPDT_UPDATE_DEFAULT             0x00000000u
  #define AIM6020_DA2UPDT_UPDATE_OF(x)               _VALUEOF16(x)
  #define AIM6020_DA2UPDT_UPDATE_UPDATE              0x00000000u
  #define _AIM6020_DA2UPDT_UPDATE_UPDATE_SV          0x00000000u

  #define AIM6020_DA2UPDT_OF(val)                    _VALUEOF16(val)
  #define AIM6020_DA2UPDT_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,DA2UPDT,UPDATE)        \
  )

  #define AIM6020_DA2UPDT_RMK(update)                \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DA2UPDT,UPDATE,update)      \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  A D 1 2 S T R T      |
* |_______________________|
*
* AD12STRT - A/D 1 and 2 Simultaneous Software Start Register
*
* FIELDS (msb -> lsb)
* (R.)  START       [ 0: 0]  - A/D 1 and 2 Simultaneous Software Start
*
\******************************************************************************/
/*#define _AIM6020_AD12STRT_RECIDX                   No recorded */

  #define _AIM6020_AD12STRT0_ADDR                    0x6C040014u
  #define _AIM6020_AD12STRT1_ADDR                    0x6C050014u
  #define _AIM6020_AD12STRT2_ADDR                    0x6C060014u
  #define _AIM6020_AD12STRT3_ADDR                    0x6C070014u

  #define _AIM6020_AD12STRT_REGOFFS                  0x00000014u
  #define _AIM6020_AD12STRT_REGOFFS16                0x0000000Au

  #define _AIM6020_AD12STRT_START_MASK               0x00000001u
  #define _AIM6020_AD12STRT_START_SHIFT              0
  #define AIM6020_AD12STRT_START_DEFAULT             0x00000000u
  #define AIM6020_AD12STRT_START_OF(x)               _VALUEOF16(x)
  #define AIM6020_AD12STRT_START_START               0x00000000u
  #define _AIM6020_AD12STRT_START_START_SV           0x00000000u

  #define AIM6020_AD12STRT_OF(val)                   _VALUEOF16(val)
  #define AIM6020_AD12STRT_DEFAULT (Uint16)(         \
      _PER_FDEFAULT32(AIM6020,AD12STRT,START)        \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D A 1 2 U P D T      |
* |_______________________|
*
* DA12UPDT - D/A 1 and 2 Simultaneous Software Update Register
*
* FIELDS (msb -> lsb)
* (.W)  UPDATE      [ 0: 0]  - D/A 1 and 2 Simultaneous Software Update
*
\******************************************************************************/
/*#define _AIM6020_DA12UPDT_RECIDX                   No recorded */

  #define _AIM6020_DA12UPDT0_ADDR                    0x6C040014u
  #define _AIM6020_DA12UPDT1_ADDR                    0x6C050014u
  #define _AIM6020_DA12UPDT2_ADDR                    0x6C060014u
  #define _AIM6020_DA12UPDT3_ADDR                    0x6C070014u

  #define _AIM6020_DA12UPDT_REGOFFS                  0x00000014u
  #define _AIM6020_DA12UPDT_REGOFFS16                0x0000000Au

  #define _AIM6020_DA12UPDT_UPDATE_MASK              0x00000001u
  #define _AIM6020_DA12UPDT_UPDATE_SHIFT             0
  #define AIM6020_DA12UPDT_UPDATE_DEFAULT            0x00000000u
  #define AIM6020_DA12UPDT_UPDATE_OF(x)              _VALUEOF16(x)
  #define AIM6020_DA12UPDT_UPDATE_UPDATE             0x00000000u
  #define _AIM6020_DA12UPDT_UPDATE_UPDATE_SV         0x00000000u

  #define AIM6020_DA12UPDT_OF(val)                   _VALUEOF16(val)
  #define AIM6020_DA12UPDT_DEFAULT (Uint16)(         \
      _PER_FDEFAULT32(AIM6020,DA12UPDT,UPDATE)       \
  )

  #define AIM6020_DA12UPDT_RMK(update)               \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DA12UPDT,UPDATE,update)     \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  F L T C L K 1        |
* |_______________________|
*
* FLTCLK1 - Filter Clock 1 Register
*
* FIELDS (msb -> lsb)
* (.W)  CLKDIV      [ 7: 0]  - Filter Clock 1 Division
*
\******************************************************************************/
  #define _AIM6020_FLTCLK1_RECIDX                    1

  #define _AIM6020_FLTCLK10_ADDR                     0x6C040018u
  #define _AIM6020_FLTCLK11_ADDR                     0x6C050018u
  #define _AIM6020_FLTCLK12_ADDR                     0x6C060018u
  #define _AIM6020_FLTCLK13_ADDR                     0x6C070018u

  #define _AIM6020_FLTCLK1_REGOFFS                   0x00000018u
  #define _AIM6020_FLTCLK1_REGOFFS16                 0x0000000Cu

  #define _AIM6020_FLTCLK1_CLKDIV_MASK               0x000000FFu
  #define _AIM6020_FLTCLK1_CLKDIV_SHIFT              0
  #define AIM6020_FLTCLK1_CLKDIV_DEFAULT             0x00000000u
  #define AIM6020_FLTCLK1_CLKDIV_OF(x)               _VALUEOF16(x)

  #define AIM6020_FLTCLK1_OF(val)                    _VALUEOF16(val)
  #define AIM6020_FLTCLK1_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,FLTCLK1,CLKDIV)        \
  )

  #define AIM6020_FLTCLK1_RMK(clkdiv)                \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,FLTCLK1,CLKDIV,clkdiv)      \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  F L T C L K 2        |
* |_______________________|
*
* FLTCLK2 - Filter Clock 2 Register
*
* FIELDS (msb -> lsb)
* (.W)  CLKDIV      [ 7: 0]  - Filter Clock 2 Division
*
\******************************************************************************/
  #define _AIM6020_FLTCLK2_RECIDX                    2

  #define _AIM6020_FLTCLK20_ADDR                     0x6C04001Cu
  #define _AIM6020_FLTCLK21_ADDR                     0x6C05001Cu
  #define _AIM6020_FLTCLK22_ADDR                     0x6C06001Cu
  #define _AIM6020_FLTCLK23_ADDR                     0x6C07001Cu

  #define _AIM6020_FLTCLK2_REGOFFS                   0x0000001Cu
  #define _AIM6020_FLTCLK2_REGOFFS16                 0x0000000Eu

  #define _AIM6020_FLTCLK2_CLKDIV_MASK               0x000000FFu
  #define _AIM6020_FLTCLK2_CLKDIV_SHIFT              0
  #define AIM6020_FLTCLK2_CLKDIV_DEFAULT             0x00000000u
  #define AIM6020_FLTCLK2_CLKDIV_OF(x)               _VALUEOF16(x)

  #define AIM6020_FLTCLK2_OF(val)                    _VALUEOF16(val)
  #define AIM6020_FLTCLK2_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,FLTCLK2,CLKDIV)        \
  )

  #define AIM6020_FLTCLK2_RMK(clkdiv)                \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,FLTCLK2,CLKDIV,clkdiv)      \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  F L T C F G          |
* |_______________________|
*
* FLTCFG - Filter Configuration Register
*
* FIELDS (msb -> lsb)
* (.W)  AD2FSW      [ 5: 5]  - A/D 2 Filter Switch
* (.W)  AD1FSW      [ 4: 4]  - A/D 1 Filter Switch
* (.W)  DA2FCLK     [ 3: 3]  - D/A 2 Filter Clock Select
* (.W)  DA1FCLK     [ 2: 2]  - D/A 1 Filter Clock Select
* (.W)  AD2FCLK     [ 1: 1]  - A/D 2 Filter Clock Select
* (.W)  AD1FCLK     [ 0: 0]  - A/D 1 Filter Clock Select
*
\******************************************************************************/
  #define _AIM6020_FLTCFG_RECIDX                     3

  #define _AIM6020_FLTCFG0_ADDR                      0x6C040020u
  #define _AIM6020_FLTCFG1_ADDR                      0x6C050020u
  #define _AIM6020_FLTCFG2_ADDR                      0x6C060020u
  #define _AIM6020_FLTCFG3_ADDR                      0x6C070020u

  #define _AIM6020_FLTCFG_REGOFFS                    0x00000020u
  #define _AIM6020_FLTCFG_REGOFFS16                  0x00000010u

  #define _AIM6020_FLTCFG_AD2FSW_MASK                0x00000020u
  #define _AIM6020_FLTCFG_AD2FSW_SHIFT               5
  #define AIM6020_FLTCFG_AD2FSW_DEFAULT              0x00000000u
  #define AIM6020_FLTCFG_AD2FSW_OF(x)                _VALUEOF16(x)
  #define AIM6020_FLTCFG_AD2FSW_OFF                  0x00000000u
  #define AIM6020_FLTCFG_AD2FSW_ON                   0x00000001u
  #define AIM6020_FLTCFG_AD2FSW_DISABLE              0x00000000u
  #define AIM6020_FLTCFG_AD2FSW_ENABLE               0x00000001u
  #define AIM6020_FLTCFG_AD2FSW_DISABLED             0x00000000u
  #define AIM6020_FLTCFG_AD2FSW_ENABLED              0x00000001u
  #define _AIM6020_FLTCFG_AD2FSW_OFF_SV              0x00000000u
  #define _AIM6020_FLTCFG_AD2FSW_ON_SV               0x00000020u
  #define _AIM6020_FLTCFG_AD2FSW_DISABLE_SV          0x00000000u
  #define _AIM6020_FLTCFG_AD2FSW_ENABLE_SV           0x00000020u
  #define _AIM6020_FLTCFG_AD2FSW_DISABLED_SV         0x00000000u
  #define _AIM6020_FLTCFG_AD2FSW_ENABLED_SV          0x00000020u

  #define _AIM6020_FLTCFG_AD1FSW_MASK                0x00000010u
  #define _AIM6020_FLTCFG_AD1FSW_SHIFT               4
  #define AIM6020_FLTCFG_AD1FSW_DEFAULT              0x00000000u
  #define AIM6020_FLTCFG_AD1FSW_OF(x)                _VALUEOF16(x)
  #define AIM6020_FLTCFG_AD1FSW_OFF                  0x00000000u
  #define AIM6020_FLTCFG_AD1FSW_ON                   0x00000001u
  #define AIM6020_FLTCFG_AD1FSW_DISABLE              0x00000000u
  #define AIM6020_FLTCFG_AD1FSW_ENABLE               0x00000001u
  #define AIM6020_FLTCFG_AD1FSW_DISABLED             0x00000000u
  #define AIM6020_FLTCFG_AD1FSW_ENABLED              0x00000001u
  #define _AIM6020_FLTCFG_AD1FSW_OFF_SV              0x00000000u
  #define _AIM6020_FLTCFG_AD1FSW_ON_SV               0x00000010u
  #define _AIM6020_FLTCFG_AD1FSW_DISABLE_SV          0x00000000u
  #define _AIM6020_FLTCFG_AD1FSW_ENABLE_SV           0x00000010u
  #define _AIM6020_FLTCFG_AD1FSW_DISABLED_SV         0x00000000u
  #define _AIM6020_FLTCFG_AD1FSW_ENABLED_SV          0x00000010u

  #define _AIM6020_FLTCFG_DA2FCLK_MASK               0x00000008u
  #define _AIM6020_FLTCFG_DA2FCLK_SHIFT              3
  #define AIM6020_FLTCFG_DA2FCLK_DEFAULT             0x00000000u
  #define AIM6020_FLTCFG_DA2FCLK_OF(x)               _VALUEOF16(x)
  #define AIM6020_FLTCFG_DA2FCLK_FCLK1               0x00000000u
  #define AIM6020_FLTCFG_DA2FCLK_FCLK2               0x00000001u
  #define _AIM6020_FLTCFG_DA2FCLK_FCLK1_SV           0x00000000u
  #define _AIM6020_FLTCFG_DA2FCLK_FCLK2_SV           0x00000008u

  #define _AIM6020_FLTCFG_DA1FCLK_MASK               0x00000004u
  #define _AIM6020_FLTCFG_DA1FCLK_SHIFT              2
  #define AIM6020_FLTCFG_DA1FCLK_DEFAULT             0x00000000u
  #define AIM6020_FLTCFG_DA1FCLK_OF(x)               _VALUEOF16(x)
  #define AIM6020_FLTCFG_DA1FCLK_FCLK1               0x00000000u
  #define AIM6020_FLTCFG_DA1FCLK_FCLK2               0x00000001u
  #define _AIM6020_FLTCFG_DA1FCLK_FCLK1_SV           0x00000000u
  #define _AIM6020_FLTCFG_DA1FCLK_FCLK2_SV           0x00000004u

  #define _AIM6020_FLTCFG_AD2FCLK_MASK               0x00000002u
  #define _AIM6020_FLTCFG_AD2FCLK_SHIFT              1
  #define AIM6020_FLTCFG_AD2FCLK_DEFAULT             0x00000000u
  #define AIM6020_FLTCFG_AD2FCLK_OF(x)               _VALUEOF16(x)
  #define AIM6020_FLTCFG_AD2FCLK_FCLK1               0x00000000u
  #define AIM6020_FLTCFG_AD2FCLK_FCLK2               0x00000001u
  #define _AIM6020_FLTCFG_AD2FCLK_FCLK1_SV           0x00000000u
  #define _AIM6020_FLTCFG_AD2FCLK_FCLK2_SV           0x00000002u

  #define _AIM6020_FLTCFG_AD1FCLK_MASK               0x00000001u
  #define _AIM6020_FLTCFG_AD1FCLK_SHIFT              0
  #define AIM6020_FLTCFG_AD1FCLK_DEFAULT             0x00000000u
  #define AIM6020_FLTCFG_AD1FCLK_OF(x)               _VALUEOF16(x)
  #define AIM6020_FLTCFG_AD1FCLK_FCLK1               0x00000000u
  #define AIM6020_FLTCFG_AD1FCLK_FCLK2               0x00000001u
  #define _AIM6020_FLTCFG_AD1FCLK_FCLK1_SV           0x00000000u
  #define _AIM6020_FLTCFG_AD1FCLK_FCLK2_SV           0x00000001u

  #define AIM6020_FLTCFG_OF(val)                     _VALUEOF16(val)
  #define AIM6020_FLTCFG_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,FLTCFG,AD2FSW)         \
    | _PER_FDEFAULT32(AIM6020,FLTCFG,AD1FSW)         \
    | _PER_FDEFAULT32(AIM6020,FLTCFG,DA2FCLK)        \
    | _PER_FDEFAULT32(AIM6020,FLTCFG,DA1FCLK)        \
    | _PER_FDEFAULT32(AIM6020,FLTCFG,AD2FCLK)        \
    | _PER_FDEFAULT32(AIM6020,FLTCFG,AD1FCLK)        \
  )

  #define AIM6020_FLTCFG_RMK(ad2fsw,ad1fsw,          \
    da2fclk,da1fclk,ad2fclk,ad1fclk)                 \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,FLTCFG,AD2FSW,ad2fsw)       \
    | _PER_FMK32(AIM6020,FLTCFG,AD1FSW,ad1fsw)       \
    | _PER_FMK32(AIM6020,FLTCFG,DA2FCLK,da2fclk)     \
    | _PER_FMK32(AIM6020,FLTCFG,DA1FCLK,da1fclk)     \
    | _PER_FMK32(AIM6020,FLTCFG,AD2FCLK,ad2fclk)     \
    | _PER_FMK32(AIM6020,FLTCFG,AD1FCLK,ad1fclk)     \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  I N T C F G          |
* |_______________________|
*
* INTCFG - Interrupt Configuration Register
*
* FIELDS (msb -> lsb)
* (.W)  PINT7       [ 3: 2]  - PINT7 Select
* (.W)  PINT6       [ 1: 0]  - PINT6 Select
*
\******************************************************************************/
  #define _AIM6020_INTCFG_RECIDX                     4

  #define _AIM6020_INTCFG0_ADDR                      0x6C040024u
  #define _AIM6020_INTCFG1_ADDR                      0x6C050024u
  #define _AIM6020_INTCFG2_ADDR                      0x6C060024u
  #define _AIM6020_INTCFG3_ADDR                      0x6C070024u

  #define _AIM6020_INTCFG_REGOFFS                    0x00000024u
  #define _AIM6020_INTCFG_REGOFFS16                  0x00000012u

  #define _AIM6020_INTCFG_PINT7_MASK                 0x0000000Cu
  #define _AIM6020_INTCFG_PINT7_SHIFT                2
  #define AIM6020_INTCFG_PINT7_DEFAULT               0x00000000u
  #define AIM6020_INTCFG_PINT7_OF(x)                 _VALUEOF16(x)
  #define AIM6020_INTCFG_PINT7_DISABLED              0x00000000u
  #define AIM6020_INTCFG_PINT7_AD1EOC                0x00000001u
  #define AIM6020_INTCFG_PINT7_AD2EOC                0x00000002u
  #define AIM6020_INTCFG_PINT7_PARLOAD               0x00000003u
  #define _AIM6020_INTCFG_PINT7_DISABLED_SV          0x00000000u
  #define _AIM6020_INTCFG_PINT7_AD1EOC_SV            0x00000004u
  #define _AIM6020_INTCFG_PINT7_AD2EOC_SV            0x00000008u
  #define _AIM6020_INTCFG_PINT7_PARLOAD_SV           0x0000000Cu

  #define _AIM6020_INTCFG_PINT6_MASK                 0x00000003u
  #define _AIM6020_INTCFG_PINT6_SHIFT                0
  #define AIM6020_INTCFG_PINT6_DEFAULT               0x00000000u
  #define AIM6020_INTCFG_PINT6_OF(x)                 _VALUEOF16(x)
  #define AIM6020_INTCFG_PINT6_DISABLED              0x00000000u
  #define AIM6020_INTCFG_PINT6_AD1EOC                0x00000001u
  #define AIM6020_INTCFG_PINT6_AD2EOC                0x00000002u
  #define AIM6020_INTCFG_PINT6_PARLOAD               0x00000003u
  #define _AIM6020_INTCFG_PINT6_DISABLED_SV          0x00000000u
  #define _AIM6020_INTCFG_PINT6_AD1EOC_SV            0x00000001u
  #define _AIM6020_INTCFG_PINT6_AD2EOC_SV            0x00000002u
  #define _AIM6020_INTCFG_PINT6_PARLOAD_SV           0x00000003u

  #define AIM6020_INTCFG_OF(val)                     _VALUEOF16(val)
  #define AIM6020_INTCFG_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,INTCFG,PINT7)          \
    | _PER_FDEFAULT32(AIM6020,INTCFG,PINT6)          \
  )

  #define AIM6020_INTCFG_RMK(pint7,pint6)            \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,INTCFG,PINT7,pint7)         \
    | _PER_FMK32(AIM6020,INTCFG,PINT6,pint6)         \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  S E R I A L          |
* |_______________________|
*
* SERIAL - Serial Data Register
*
* FIELDS (msb -> lsb)
* (RW)  DATA        [15: 0]  - Serial Data
*
\******************************************************************************/
/*#define _AIM6020_SERIAL_RECIDX                     No recorded */

  #define _AIM6020_SERIAL0_ADDR                      0x6C040028u
  #define _AIM6020_SERIAL1_ADDR                      0x6C050028u
  #define _AIM6020_SERIAL2_ADDR                      0x6C060028u
  #define _AIM6020_SERIAL3_ADDR                      0x6C070028u

  #define _AIM6020_SERIAL_REGOFFS                    0x00000028u
  #define _AIM6020_SERIAL_REGOFFS16                  0x00000014u

  #define _AIM6020_SERIAL_DATA_MASK                  0x0000FFFFu
  #define _AIM6020_SERIAL_DATA_SHIFT                 0
  #define AIM6020_SERIAL_DATA_DEFAULT                0x00000000u
  #define AIM6020_SERIAL_DATA_OF(x)                  _VALUEOF16(x)

  #define AIM6020_SERIAL_OF(val)                     _VALUEOF16(val)
  #define AIM6020_SERIAL_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,SERIAL,DATA)           \
  )

  #define AIM6020_SERIAL_RMK(data)                   \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,SERIAL,DATA,data)           \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D I S P L A Y        |
* |_______________________|
*
* DISPLAY - Display Register
*
* FIELDS (msb -> lsb)
* (.W)  SYMBOL      [ 7: 0]  - Symbol on the display (digit and dot)
*
\******************************************************************************/
  #define _AIM6020_DISPLAY_RECIDX                    5

  #define _AIM6020_DISPLAY0_ADDR                     0x6C04002Cu
  #define _AIM6020_DISPLAY1_ADDR                     0x6C05002Cu
  #define _AIM6020_DISPLAY2_ADDR                     0x6C06002Cu
  #define _AIM6020_DISPLAY3_ADDR                     0x6C07002Cu

  #define _AIM6020_DISPLAY_REGOFFS                   0x0000002Cu
  #define _AIM6020_DISPLAY_REGOFFS16                 0x00000016u

  #define _AIM6020_DISPLAY_SYMBOL_MASK               0x000000FFu
  #define _AIM6020_DISPLAY_SYMBOL_SHIFT              0
  #define AIM6020_DISPLAY_SYMBOL_DEFAULT             0x00000000u
  #define AIM6020_DISPLAY_SYMBOL_OF(x)               _VALUEOF16(x)

  #define AIM6020_DISPLAY_OF(val)                    _VALUEOF16(val)
  #define AIM6020_DISPLAY_DEFAULT (Uint16)(          \
      _PER_FDEFAULT32(AIM6020,DISPLAY,SYMBOL)        \
  )

  #define AIM6020_DISPLAY_RMK(symbol)                \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DISPLAY,SYMBOL,symbol)      \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  I 2 C D A T          |
* |_______________________|
*
* I2CDAT - I2C Serial Data
*
* FIELDS (msb -> lsb)
* (RW)  DATA        [ 0: 0]  - Data wire of bus I2C of digital potentiometers
*
\******************************************************************************/
/*#define _AIM6020_I2CDAT_RECIDX                     No recorded */

  #define _AIM6020_I2CDAT0_ADDR                      0x6C040030u
  #define _AIM6020_I2CDAT1_ADDR                      0x6C050030u
  #define _AIM6020_I2CDAT2_ADDR                      0x6C060030u
  #define _AIM6020_I2CDAT3_ADDR                      0x6C070030u

  #define _AIM6020_I2CDAT_REGOFFS                    0x00000030u
  #define _AIM6020_I2CDAT_REGOFFS16                  0x00000018u

  #define _AIM6020_I2CDAT_DATA_MASK                  0x00000001u
  #define _AIM6020_I2CDAT_DATA_SHIFT                 0
  #define AIM6020_I2CDAT_DATA_DEFAULT                0x00000000u
  #define AIM6020_I2CDAT_DATA_OF(x)                  _VALUEOF16(x)
  #define AIM6020_I2CDAT_DATA_LOW                    0x00000000u
  #define AIM6020_I2CDAT_DATA_HIGH                   0x00000001u
  #define _AIM6020_I2CDAT_DATA_LOW_SV                0x00000000u
  #define _AIM6020_I2CDAT_DATA_HIGH_SV               0x00000001u

  #define AIM6020_I2CDAT_OF(val)                     _VALUEOF16(val)
  #define AIM6020_I2CDAT_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,I2CDAT,DATA)           \
  )

  #define AIM6020_I2CDAT_RMK(data)                   \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,I2CDAT,DATA,data)           \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  I 2 C C L K          |
* |_______________________|
*
* I2CCLK - I2C Serial Clock
*
* FIELDS (msb -> lsb)
* (RW)  CLOCK       [ 0: 0]  - Clock wire of bus I2C of digital potentiometers
*
\******************************************************************************/
/*#define _AIM6020_I2CCLK_RECIDX                     No recorded */

  #define _AIM6020_I2CCLK0_ADDR                      0x6C040034u
  #define _AIM6020_I2CCLK1_ADDR                      0x6C050034u
  #define _AIM6020_I2CCLK2_ADDR                      0x6C060034u
  #define _AIM6020_I2CCLK3_ADDR                      0x6C070034u

  #define _AIM6020_I2CCLK_REGOFFS                    0x00000034u
  #define _AIM6020_I2CCLK_REGOFFS16                  0x0000001Au

  #define _AIM6020_I2CCLK_CLOCK_MASK                 0x00000001u
  #define _AIM6020_I2CCLK_CLOCK_SHIFT                0
  #define AIM6020_I2CCLK_CLOCK_DEFAULT               0x00000000u
  #define AIM6020_I2CCLK_CLOCK_OF(x)                 _VALUEOF16(x)
  #define AIM6020_I2CCLK_CLOCK_LOW                   0x00000000u
  #define AIM6020_I2CCLK_CLOCK_HIGH                  0x00000001u
  #define _AIM6020_I2CCLK_CLOCK_LOW_SV               0x00000000u
  #define _AIM6020_I2CCLK_CLOCK_HIGH_SV              0x00000001u

  #define AIM6020_I2CCLK_OF(val)                     _VALUEOF16(val)
  #define AIM6020_I2CCLK_DEFAULT (Uint16)(           \
      _PER_FDEFAULT32(AIM6020,I2CCLK,CLOCK)          \
  )

  #define AIM6020_I2CCLK_RMK(clock)                  \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,I2CCLK,CLOCK,clock)         \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  I 2 C O E            |
* |_______________________|
*
* I2COE - I2C Serial Output Enable
*
* FIELDS (msb -> lsb)
* (RW)  ENABLE      [ 0: 0]  - I2C bus data wire output enable
*
\******************************************************************************/
/*#define _AIM6020_I2COE_RECIDX                      No recorded */

  #define _AIM6020_I2COE0_ADDR                       0x6C040038u
  #define _AIM6020_I2COE1_ADDR                       0x6C050038u
  #define _AIM6020_I2COE2_ADDR                       0x6C060038u
  #define _AIM6020_I2COE3_ADDR                       0x6C070038u

  #define _AIM6020_I2COE_REGOFFS                     0x00000038u
  #define _AIM6020_I2COE_REGOFFS16                   0x0000001Cu

  #define _AIM6020_I2COE_ENABLE_MASK                 0x00000001u
  #define _AIM6020_I2COE_ENABLE_SHIFT                0
  #define AIM6020_I2COE_ENABLE_DEFAULT               0x00000000u
  #define AIM6020_I2COE_ENABLE_OF(x)                 _VALUEOF16(x)
  #define AIM6020_I2COE_ENABLE_NO                    0x00000000u
  #define AIM6020_I2COE_ENABLE_YES                   0x00000001u
  #define AIM6020_I2COE_ENABLE_DISABLE               0x00000000u
  #define AIM6020_I2COE_ENABLE_ENABLE                0x00000001u
  #define AIM6020_I2COE_ENABLE_DISABLED              0x00000000u
  #define AIM6020_I2COE_ENABLE_ENABLED               0x00000001u
  #define _AIM6020_I2COE_ENABLE_NO_SV                0x00000000u
  #define _AIM6020_I2COE_ENABLE_YES_SV               0x00000001u
  #define _AIM6020_I2COE_ENABLE_DISABLE_SV           0x00000000u
  #define _AIM6020_I2COE_ENABLE_ENABLE_SV            0x00000001u
  #define _AIM6020_I2COE_ENABLE_DISABLED_SV          0x00000000u
  #define _AIM6020_I2COE_ENABLE_ENABLED_SV           0x00000001u

  #define AIM6020_I2COE_OF(val)                      _VALUEOF16(val)
  #define AIM6020_I2COE_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,I2COE,ENABLE)          \
  )

  #define AIM6020_I2COE_RMK(enable)                  \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,I2COE,ENABLE,enable)        \
  )

/******************************************************************************\
* _________________________
* |                       |
* |  D U M M Y            |
* |_______________________|
*
* DUMMY - Dummy register
*
* FIELDS (msb -> lsb)
* (.W)  DUMMY       [ 0: 0]  - Dummy
*
\******************************************************************************/
/*#define _AIM6020_DUMMY_RECIDX                      No recorded */

  #define _AIM6020_DUMMY0_ADDR                       0x6C04003Cu
  #define _AIM6020_DUMMY1_ADDR                       0x6C05003Cu
  #define _AIM6020_DUMMY2_ADDR                       0x6C06003Cu
  #define _AIM6020_DUMMY3_ADDR                       0x6C07003Cu

  #define _AIM6020_DUMMY_REGOFFS                     0x0000003Cu
  #define _AIM6020_DUMMY_REGOFFS16                   0x0000001Eu

  #define _AIM6020_DUMMY_DUMMY_MASK                  0x00000001u
  #define _AIM6020_DUMMY_DUMMY_SHIFT                 0
  #define AIM6020_DUMMY_DUMMY_DEFAULT                0x00000000u
  #define AIM6020_DUMMY_DUMMY_OF(x)                  _VALUEOF16(x)

  #define AIM6020_DUMMY_OF(val)                      _VALUEOF16(val)
  #define AIM6020_DUMMY_DEFAULT (Uint16)(            \
      _PER_FDEFAULT32(AIM6020,DUMMY,DUMMY)           \
  )

  #define AIM6020_DUMMY_RMK(dummy)                   \
    (Uint16)(                                        \
      _PER_FMK32(AIM6020,DUMMY,DUMMY,dummy)          \
  )

/*----------------------------------------------------------------------------*/

#endif /* (BSL_AIM6020_SUPPORT) */
#endif /* _BSL_AIM6020HAL_H_ */
/******************************************************************************\
* End of bsl_aim6020hal.h
\******************************************************************************/
