/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Incorporated.
* All rights reserved. Property of RTD Embedded Technologies, Incorporated.
* Restricted rights to use, duplicate or disclose this code are
* granted through contract.
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM64XX
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... DSP side of the Host-DSP Communication's HAL
* FILENAME......... bsl_commhal.h
* GENERATED BY..... Communication HAL Generator v1.3
* GENERATED AT..... 03/29/2004 09:14:20
*------------------------------------------------------------------------------
* COMM. BUF. ADDR.. 0x00000200
* COMM. BUF. SIZE.. 0x00000080 (128 bytes)
* NUM. OF PARAMS... up to 32
\******************************************************************************/

#ifndef _BSL_COMMHAL_H_
#define _BSL_COMMHAL_H_

//#include <std.h>
#include <csl_stdinc.h>

/* Communication data buffer starting address and size in bytes */
#define COMM_DATA_BUF_START_ADDR    ((Uint32)(0x00000200u))
#define COMM_DATA_BUF_SIZE          ((Uint32)(0x00000080u))

/* Dedicated communication mailbox addresses */
#define COMM_TO_HOST_MSG_MBOX_ADDR  (COMM_DATA_BUF_START_ADDR)
#define COMM_TO_HOST_ERR_MBOX_ADDR  (COMM_DATA_BUF_START_ADDR + 4)
#define COMM_DSP_STATE_MBOX_ADDR    (COMM_DATA_BUF_START_ADDR + 8)
#define COMM_TO_DSP_MSG_MBOX_ADDR   (COMM_DATA_BUF_START_ADDR + 12)

/* Read/write dedicated comm. mailboxes */
#define COMM_READ_MBOX( MBOX ) \
    (*((Uint32 *)COMM_##MBOX##_MBOX_ADDR))
#define COMM_WRITE_MBOX( MBOX, val ) \
    (*((Uint32 *)COMM_##MBOX##_MBOX_ADDR) = ((Uint32)(val)))

/* Communication parameter buffer starting address and size in bytes */
#define COMM_PARAM_BUF_START_OFFS   16
#define COMM_PARAM_BUF_START_ADDR \
    (COMM_DATA_BUF_START_ADDR+COMM_PARAM_BUF_START_OFFS)
#define COMM_PARAM_BUF_SIZE \
    (COMM_DATA_BUF_SIZE-COMM_PARAM_BUF_START_OFFS)
#define COMM_PARAM_BUF_LAST_ADDR \
    (COMM_DATA_BUF_START_ADDR+COMM_DATA_BUF_SIZE-1)

/* size of types in bytes */
#define SIZE_OF_Uint8       1
#define SIZE_OF_uint8       1
#define SIZE_OF_Int8        1
#define SIZE_OF_int8        1
#define SIZE_OF_SmUns       1
#define SIZE_OF_SmInt       1

#define SIZE_OF_Uint16      2
#define SIZE_OF_uint16      2
#define SIZE_OF_Int16       2
#define SIZE_OF_int16       2
#define SIZE_OF_MdUns       2
#define SIZE_OF_MdInt       2

#define SIZE_OF_Uint32      4
#define SIZE_OF_uint32      4
#define SIZE_OF_Int32       4
#define SIZE_OF_int32       4
#define SIZE_OF_LgUns       4
#define SIZE_OF_LgInt       4
#define SIZE_OF_Float       4
#define SIZE_OF_float       4
#define SIZE_OF_Bool        4
#define SIZE_OF_bool        4
#define SIZE_OF_BOOL        4

#define SIZE_OF_Uint40      8
#define SIZE_OF_uint40      8
#define SIZE_OF_Int40       8
#define SIZE_OF_int40       8
#define SIZE_OF_Double      8
#define SIZE_OF_double      8

/* alignment calculation according to a type */
#define ALIGN_FOR(bytes,addr)       (((addr)+bytes-1) & ((Uint32)(-bytes)))
#define _ALIGN_(T,addr)             ALIGN_FOR(SIZE_OF_##T,addr)
/* Parameter address (in the comm. param. buffer) */
#define COMM_P1_ADDR(T1) \
    (_ALIGN_(T1,COMM_PARAM_BUF_START_ADDR))
#define COMM_P2_ADDR(T1,T2) \
    (_ALIGN_(T2,COMM_P1_ADDR(T1)+SIZE_OF_##T1))
#define COMM_P3_ADDR(T1,T2,T3) \
    (_ALIGN_(T3,COMM_P2_ADDR(T1,T2)+SIZE_OF_##T2))
#define COMM_P4_ADDR(T1,T2,T3,T4) \
    (_ALIGN_(T4,COMM_P3_ADDR(T1,T2,T3)+SIZE_OF_##T3))
#define COMM_P5_ADDR(T1,T2,T3,T4,T5) \
    (_ALIGN_(T5,COMM_P4_ADDR(T1,T2,T3,T4)+SIZE_OF_##T4))
#define COMM_P6_ADDR(T1,T2,T3,T4,T5,T6) \
    (_ALIGN_(T6,COMM_P5_ADDR(T1,T2,T3,T4,T5)+SIZE_OF_##T5))
#define COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7) \
    (_ALIGN_(T7,COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)+SIZE_OF_##T6))
#define COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8) \
    (_ALIGN_(T8,COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)+SIZE_OF_##T7))
#define COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9) \
    (_ALIGN_(T9,COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)+SIZE_OF_##T8))
#define COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) \
    (_ALIGN_(T10,COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)+SIZE_OF_##T9))
#define COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11) \
    (_ALIGN_(T11,COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)+SIZE_OF_##T10))
#define COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12) \
    (_ALIGN_(T12,COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)+SIZE_OF_##T11))
#define COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13) \
    (_ALIGN_(T13,COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)+SIZE_OF_##T12))
#define COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14) \
    (_ALIGN_(T14,COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)+SIZE_OF_##T13))
#define COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15) \
    (_ALIGN_(T15,COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)+SIZE_OF_##T14))
#define COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16) \
    (_ALIGN_(T16,COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)+SIZE_OF_##T15))
#define COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17) \
    (_ALIGN_(T17,COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)+SIZE_OF_##T16))
#define COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18) \
    (_ALIGN_(T18,COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)+SIZE_OF_##T17))
#define COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19) \
    (_ALIGN_(T19,COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)+SIZE_OF_##T18))
#define COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20) \
    (_ALIGN_(T20,COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)+SIZE_OF_##T19))
#define COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21) \
    (_ALIGN_(T21,COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)+SIZE_OF_##T20))
#define COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22) \
    (_ALIGN_(T22,COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)+SIZE_OF_##T21))
#define COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23) \
    (_ALIGN_(T23,COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)+SIZE_OF_##T22))
#define COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24) \
    (_ALIGN_(T24,COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)+SIZE_OF_##T23))
#define COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25) \
    (_ALIGN_(T25,COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)+SIZE_OF_##T24))
#define COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26) \
    (_ALIGN_(T26,COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)+SIZE_OF_##T25))
#define COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27) \
    (_ALIGN_(T27,COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)+SIZE_OF_##T26))
#define COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28) \
    (_ALIGN_(T28,COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)+SIZE_OF_##T27))
#define COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29) \
    (_ALIGN_(T29,COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)+SIZE_OF_##T28))
#define COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30) \
    (_ALIGN_(T30,COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)+SIZE_OF_##T29))
#define COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31) \
    (_ALIGN_(T31,COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)+SIZE_OF_##T30))
#define COMM_P32_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32) \
    (_ALIGN_(T32,COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)+SIZE_OF_##T31))

/* Address of parameter's last byte (in the comm. param. buffer) */
#define COMM_P1_LAST_ADDR(T1) \
    (COMM_P1_ADDR(T1)+SIZE_OF_##T1-1)
#define COMM_P2_LAST_ADDR(T1,T2) \
    (COMM_P2_ADDR(T1,T2)+SIZE_OF_##T2-1)
#define COMM_P3_LAST_ADDR(T1,T2,T3) \
    (COMM_P3_ADDR(T1,T2,T3)+SIZE_OF_##T3-1)
#define COMM_P4_LAST_ADDR(T1,T2,T3,T4) \
    (COMM_P4_ADDR(T1,T2,T3,T4)+SIZE_OF_##T4-1)
#define COMM_P5_LAST_ADDR(T1,T2,T3,T4,T5) \
    (COMM_P5_ADDR(T1,T2,T3,T4,T5)+SIZE_OF_##T5-1)
#define COMM_P6_LAST_ADDR(T1,T2,T3,T4,T5,T6) \
    (COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)+SIZE_OF_##T6-1)
#define COMM_P7_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7) \
    (COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)+SIZE_OF_##T7-1)
#define COMM_P8_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8) \
    (COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)+SIZE_OF_##T8-1)
#define COMM_P9_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9) \
    (COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)+SIZE_OF_##T9-1)
#define COMM_P10_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) \
    (COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)+SIZE_OF_##T10-1)
#define COMM_P11_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11) \
    (COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)+SIZE_OF_##T11-1)
#define COMM_P12_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12) \
    (COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)+SIZE_OF_##T12-1)
#define COMM_P13_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13) \
    (COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)+SIZE_OF_##T13-1)
#define COMM_P14_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14) \
    (COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)+SIZE_OF_##T14-1)
#define COMM_P15_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15) \
    (COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)+SIZE_OF_##T15-1)
#define COMM_P16_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16) \
    (COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)+SIZE_OF_##T16-1)
#define COMM_P17_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17) \
    (COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)+SIZE_OF_##T17-1)
#define COMM_P18_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18) \
    (COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)+SIZE_OF_##T18-1)
#define COMM_P19_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19) \
    (COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)+SIZE_OF_##T19-1)
#define COMM_P20_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20) \
    (COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)+SIZE_OF_##T20-1)
#define COMM_P21_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21) \
    (COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)+SIZE_OF_##T21-1)
#define COMM_P22_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22) \
    (COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)+SIZE_OF_##T22-1)
#define COMM_P23_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23) \
    (COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)+SIZE_OF_##T23-1)
#define COMM_P24_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24) \
    (COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)+SIZE_OF_##T24-1)
#define COMM_P25_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25) \
    (COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)+SIZE_OF_##T25-1)
#define COMM_P26_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26) \
    (COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)+SIZE_OF_##T26-1)
#define COMM_P27_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27) \
    (COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)+SIZE_OF_##T27-1)
#define COMM_P28_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28) \
    (COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)+SIZE_OF_##T28-1)
#define COMM_P29_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29) \
    (COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)+SIZE_OF_##T29-1)
#define COMM_P30_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30) \
    (COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)+SIZE_OF_##T30-1)
#define COMM_P31_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31) \
    (COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)+SIZE_OF_##T31-1)
#define COMM_P32_LAST_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32) \
    (COMM_P32_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32)+SIZE_OF_##T32-1)

/* DSP Function Call macros */
#define FUNC_CALL_0(funcName) funcName ()
#define FUNC_CALL_1(funcName,T1) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)))
#define FUNC_CALL_2(funcName,T1,T2) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)))
#define FUNC_CALL_3(funcName,T1,T2,T3) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)))
#define FUNC_CALL_4(funcName,T1,T2,T3,T4) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)))
#define FUNC_CALL_5(funcName,T1,T2,T3,T4,T5) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)))
#define FUNC_CALL_6(funcName,T1,T2,T3,T4,T5,T6) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)))
#define FUNC_CALL_7(funcName,T1,T2,T3,T4,T5,T6,T7) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)))
#define FUNC_CALL_8(funcName,T1,T2,T3,T4,T5,T6,T7,T8) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)))
#define FUNC_CALL_9(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)))
#define FUNC_CALL_10(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)))
#define FUNC_CALL_11(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)))
#define FUNC_CALL_12(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)))
#define FUNC_CALL_13(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)))
#define FUNC_CALL_14(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)))
#define FUNC_CALL_15(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)))
#define FUNC_CALL_16(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)))
#define FUNC_CALL_17(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)))
#define FUNC_CALL_18(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)))
#define FUNC_CALL_19(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)))
#define FUNC_CALL_20(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)))
#define FUNC_CALL_21(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)))
#define FUNC_CALL_22(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)))
#define FUNC_CALL_23(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)))
#define FUNC_CALL_24(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)))
#define FUNC_CALL_25(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)))
#define FUNC_CALL_26(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)))
#define FUNC_CALL_27(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)))
#define FUNC_CALL_28(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)), \
    *((T28*)COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)))
#define FUNC_CALL_29(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)), \
    *((T28*)COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)), \
    *((T29*)COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)))
#define FUNC_CALL_30(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)), \
    *((T28*)COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)), \
    *((T29*)COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)), \
    *((T30*)COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)))
#define FUNC_CALL_31(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)), \
    *((T28*)COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)), \
    *((T29*)COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)), \
    *((T30*)COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)), \
    *((T31*)COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)))
#define FUNC_CALL_32(funcName,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32) \
    funcName ( \
    *((T1*)COMM_P1_ADDR(T1)), \
    *((T2*)COMM_P2_ADDR(T1,T2)), \
    *((T3*)COMM_P3_ADDR(T1,T2,T3)), \
    *((T4*)COMM_P4_ADDR(T1,T2,T3,T4)), \
    *((T5*)COMM_P5_ADDR(T1,T2,T3,T4,T5)), \
    *((T6*)COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)), \
    *((T7*)COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)), \
    *((T8*)COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)), \
    *((T9*)COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)), \
    *((T10*)COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)), \
    *((T11*)COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)), \
    *((T12*)COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)), \
    *((T13*)COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)), \
    *((T14*)COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)), \
    *((T15*)COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)), \
    *((T16*)COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)), \
    *((T17*)COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)), \
    *((T18*)COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)), \
    *((T19*)COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)), \
    *((T20*)COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)), \
    *((T21*)COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)), \
    *((T22*)COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)), \
    *((T23*)COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)), \
    *((T24*)COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)), \
    *((T25*)COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)), \
    *((T26*)COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)), \
    *((T27*)COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)), \
    *((T28*)COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)), \
    *((T29*)COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)), \
    *((T30*)COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)), \
    *((T31*)COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)), \
    *((T32*)COMM_P32_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32)))

/* DSP Fucntion Call return macros */
#define FUNC_RET_Uint8(funcCall)            COMM_WRITE_PARAM_BUF_1(Uint8,funcCall)
#define FUNC_RET_uint8(funcCall)            COMM_WRITE_PARAM_BUF_1(uint8,funcCall)
#define FUNC_RET_Int8(funcCall)             COMM_WRITE_PARAM_BUF_1(Int8,funcCall)
#define FUNC_RET_int8(funcCall)             COMM_WRITE_PARAM_BUF_1(int8,funcCall)
#define FUNC_RET_SmUns(funcCall)            COMM_WRITE_PARAM_BUF_1(SmUns,funcCall)
#define FUNC_RET_SmInt(funcCall)            COMM_WRITE_PARAM_BUF_1(SmInt,funcCall)

#define FUNC_RET_Uint16(funcCall)           COMM_WRITE_PARAM_BUF_1(Uint16,funcCall)
#define FUNC_RET_uint16(funcCall)           COMM_WRITE_PARAM_BUF_1(uint16,funcCall)
#define FUNC_RET_Int16(funcCall)            COMM_WRITE_PARAM_BUF_1(Int16,funcCall)
#define FUNC_RET_int16(funcCall)            COMM_WRITE_PARAM_BUF_1(int16,funcCall)
#define FUNC_RET_MdUns(funcCall)            COMM_WRITE_PARAM_BUF_1(MdUns,funcCall)
#define FUNC_RET_MDInt(funcCall)            COMM_WRITE_PARAM_BUF_1(MdInt,funcCall)

#define FUNC_RET_Uint32(funcCall)           COMM_WRITE_PARAM_BUF_1(Uint32,funcCall)
#define FUNC_RET_uint32(funcCall)           COMM_WRITE_PARAM_BUF_1(uint32,funcCall)
#define FUNC_RET_Int32(funcCall)            COMM_WRITE_PARAM_BUF_1(Int32,funcCall)
#define FUNC_RET_int32(funcCall)            COMM_WRITE_PARAM_BUF_1(int32,funcCall)
#define FUNC_RET_LgUns(funcCall)            COMM_WRITE_PARAM_BUF_1(LgUns,funcCall)
#define FUNC_RET_LgInt(funcCall)            COMM_WRITE_PARAM_BUF_1(LgInt,funcCall)
#define FUNC_RET_Float(funcCall)            COMM_WRITE_PARAM_BUF_1(Float,funcCall)
#define FUNC_RET_float(funcCall)            COMM_WRITE_PARAM_BUF_1(float,funcCall)
#define FUNC_RET_Bool(funcCall)             COMM_WRITE_PARAM_BUF_1(Bool,funcCall)
#define FUNC_RET_bool(funcCall)             COMM_WRITE_PARAM_BUF_1(bool,funcCall)
#define FUNC_RET_BOOL(funcCall)             COMM_WRITE_PARAM_BUF_1(BOOL,funcCall)

#define FUNC_RET_Uint40(funcCall)           COMM_WRITE_PARAM_BUF_1(Uint40,funcCall)
#define FUNC_RET_uint40(funcCall)           COMM_WRITE_PARAM_BUF_1(uint40,funcCall)
#define FUNC_RET_Int40(funcCall)            COMM_WRITE_PARAM_BUF_1(Int40,funcCall)
#define FUNC_RET_int40(funcCall)            COMM_WRITE_PARAM_BUF_1(int40,funcCall)
#define FUNC_RET_Double(funcCall)           COMM_WRITE_PARAM_BUF_1(Double,funcCall)
#define FUNC_RET_double(funcCall)           COMM_WRITE_PARAM_BUF_1(double,funcCall)

#define FUNC_RET_Void(funcCall)             funcCall
#define FUNC_RET_void(funcCall)             funcCall

#define FUNC_RET( TYPE, funcCall )          FUNC_RET_##TYPE(funcCall)

/* Function Call macros */
/* FCID_functName must be defined for funcName() function */
#define COMM_FUNC_CALL_0(RT,FN) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_0(FN)); \
    break
#define COMM_FUNC_CALL_1(RT,FN,T1) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_1(FN,T1)); \
    break
#define COMM_FUNC_CALL_2(RT,FN,T1,T2) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_2(FN,T1,T2)); \
    break
#define COMM_FUNC_CALL_3(RT,FN,T1,T2,T3) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_3(FN,T1,T2,T3)); \
    break
#define COMM_FUNC_CALL_4(RT,FN,T1,T2,T3,T4) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_4(FN,T1,T2,T3,T4)); \
    break
#define COMM_FUNC_CALL_5(RT,FN,T1,T2,T3,T4,T5) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_5(FN,T1,T2,T3,T4,T5)); \
    break
#define COMM_FUNC_CALL_6(RT,FN,T1,T2,T3,T4,T5,T6) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_6(FN,T1,T2,T3,T4,T5,T6)); \
    break
#define COMM_FUNC_CALL_7(RT,FN,T1,T2,T3,T4,T5,T6,T7) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_7(FN,T1,T2,T3,T4,T5,T6,T7)); \
    break
#define COMM_FUNC_CALL_8(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_8(FN,T1,T2,T3,T4,T5,T6,T7,T8)); \
    break
#define COMM_FUNC_CALL_9(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_9(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    break
#define COMM_FUNC_CALL_10(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_10(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    break
#define COMM_FUNC_CALL_11(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_11(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    break
#define COMM_FUNC_CALL_12(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_12(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    break
#define COMM_FUNC_CALL_13(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_13(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    break
#define COMM_FUNC_CALL_14(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_14(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    break
#define COMM_FUNC_CALL_15(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_15(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    break
#define COMM_FUNC_CALL_16(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_16(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    break
#define COMM_FUNC_CALL_17(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_17(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    break
#define COMM_FUNC_CALL_18(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_18(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    break
#define COMM_FUNC_CALL_19(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_19(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    break
#define COMM_FUNC_CALL_20(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_20(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    break
#define COMM_FUNC_CALL_21(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_21(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    break
#define COMM_FUNC_CALL_22(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_22(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    break
#define COMM_FUNC_CALL_23(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_23(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    break
#define COMM_FUNC_CALL_24(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_24(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    break
#define COMM_FUNC_CALL_25(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_25(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    break
#define COMM_FUNC_CALL_26(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_26(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26)); \
    break
#define COMM_FUNC_CALL_27(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_27(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27)); \
    break
#define COMM_FUNC_CALL_28(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_28(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28)); \
    break
#define COMM_FUNC_CALL_29(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_29(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29)); \
    break
#define COMM_FUNC_CALL_30(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_30(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30)); \
    break
#define COMM_FUNC_CALL_31(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30,T31) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_31(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30,T31)); \
    break
#define COMM_FUNC_CALL_32(RT,FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30,T31,T32) \
case FCID_##FN: \
    FUNC_RET(RT,FUNC_CALL_32(FN,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25, \
    T26,T27,T28,T29,T30,T31,T32)); \
    break

/* Write parameter buffer */
#define COMM_WRITE_PARAM_BUF_1(T1,val1) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
}
#define COMM_WRITE_PARAM_BUF_2(T1,val1,T2,val2) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
}
#define COMM_WRITE_PARAM_BUF_3(T1,val1,T2,val2,T3,val3) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
}
#define COMM_WRITE_PARAM_BUF_4(T1,val1,T2,val2,T3,val3,T4,val4) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
}
#define COMM_WRITE_PARAM_BUF_5(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
}
#define COMM_WRITE_PARAM_BUF_6(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
}
#define COMM_WRITE_PARAM_BUF_7(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
}
#define COMM_WRITE_PARAM_BUF_8(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
}
#define COMM_WRITE_PARAM_BUF_9(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
}
#define COMM_WRITE_PARAM_BUF_10(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
}
#define COMM_WRITE_PARAM_BUF_11(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
}
#define COMM_WRITE_PARAM_BUF_12(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
}
#define COMM_WRITE_PARAM_BUF_13(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
}
#define COMM_WRITE_PARAM_BUF_14(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
}
#define COMM_WRITE_PARAM_BUF_15(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
}
#define COMM_WRITE_PARAM_BUF_16(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
}
#define COMM_WRITE_PARAM_BUF_17(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
}
#define COMM_WRITE_PARAM_BUF_18(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
}
#define COMM_WRITE_PARAM_BUF_19(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
}
#define COMM_WRITE_PARAM_BUF_20(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
}
#define COMM_WRITE_PARAM_BUF_21(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
}
#define COMM_WRITE_PARAM_BUF_22(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
}
#define COMM_WRITE_PARAM_BUF_23(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
}
#define COMM_WRITE_PARAM_BUF_24(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
}
#define COMM_WRITE_PARAM_BUF_25(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
}
#define COMM_WRITE_PARAM_BUF_26(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
}
#define COMM_WRITE_PARAM_BUF_27(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
}
#define COMM_WRITE_PARAM_BUF_28(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27, \
    T28,val28) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
    *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)) = (val28); \
}
#define COMM_WRITE_PARAM_BUF_29(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27, \
    T28,val28,T29,val29) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
    *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)) = (val28); \
    *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)) = (val29); \
}
#define COMM_WRITE_PARAM_BUF_30(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27, \
    T28,val28,T29,val29,T30,val30) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
    *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)) = (val28); \
    *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)) = (val29); \
    *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)) = (val30); \
}
#define COMM_WRITE_PARAM_BUF_31(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27, \
    T28,val28,T29,val29,T30,val30,T31,val31) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
    *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)) = (val28); \
    *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)) = (val29); \
    *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)) = (val30); \
    *(T31*)(COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)) = (val31); \
}
#define COMM_WRITE_PARAM_BUF_32(T1,val1,T2,val2,T3,val3,T4,val4,T5,val5, \
    T6,val6,T7,val7,T8,val8,T9,val9,T10,val10,T11,val11,T12,val12,T13,val13, \
    T14,val14,T15,val15,T16,val16,T17,val17,T18,val18,T19,val19,T20,val20, \
    T21,val21,T22,val22,T23,val23,T24,val24,T25,val25,T26,val26,T27,val27, \
    T28,val28,T29,val29,T30,val30,T31,val31,T32,val32) \
{ \
    *(T1*)(COMM_P1_ADDR(T1)) = (val1); \
    *(T2*)(COMM_P2_ADDR(T1,T2)) = (val2); \
    *(T3*)(COMM_P3_ADDR(T1,T2,T3)) = (val3); \
    *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)) = (val4); \
    *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)) = (val5); \
    *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)) = (val6); \
    *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)) = (val7); \
    *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)) = (val8); \
    *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)) = (val9); \
    *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)) = (val10); \
    *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)) = (val11); \
    *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)) = (val12); \
    *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)) = (val13); \
    *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)) = (val14); \
    *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)) = (val15); \
    *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)) = (val16); \
    *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)) = (val17); \
    *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)) = (val18); \
    *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)) = (val19); \
    *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)) = (val20); \
    *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)) = (val21); \
    *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)) = (val22); \
    *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)) = (val23); \
    *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24)) = (val24); \
    *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25)) = (val25); \
    *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26)) = (val26); \
    *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27)) = (val27); \
    *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28)) = (val28); \
    *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29)) = (val29); \
    *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30)) = (val30); \
    *(T31*)(COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31)) = (val31); \
    *(T32*)(COMM_P32_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32)) = (val32); \
}

/* Read parameter buffer */
#define COMM_READ_PARAM_BUF_1(T1,var1) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
}
#define COMM_READ_PARAM_BUF_2(T1,var1,T2,var2) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
}
#define COMM_READ_PARAM_BUF_3(T1,var1,T2,var2,T3,var3) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
}
#define COMM_READ_PARAM_BUF_4(T1,var1,T2,var2,T3,var3,T4,var4) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
}
#define COMM_READ_PARAM_BUF_5(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
}
#define COMM_READ_PARAM_BUF_6(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
}
#define COMM_READ_PARAM_BUF_7(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
}
#define COMM_READ_PARAM_BUF_8(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
}
#define COMM_READ_PARAM_BUF_9(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
}
#define COMM_READ_PARAM_BUF_10(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
}
#define COMM_READ_PARAM_BUF_11(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
}
#define COMM_READ_PARAM_BUF_12(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
}
#define COMM_READ_PARAM_BUF_13(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
}
#define COMM_READ_PARAM_BUF_14(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
}
#define COMM_READ_PARAM_BUF_15(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
}
#define COMM_READ_PARAM_BUF_16(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
}
#define COMM_READ_PARAM_BUF_17(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
}
#define COMM_READ_PARAM_BUF_18(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
}
#define COMM_READ_PARAM_BUF_19(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
}
#define COMM_READ_PARAM_BUF_20(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
}
#define COMM_READ_PARAM_BUF_21(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
}
#define COMM_READ_PARAM_BUF_22(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
}
#define COMM_READ_PARAM_BUF_23(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
}
#define COMM_READ_PARAM_BUF_24(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
}
#define COMM_READ_PARAM_BUF_25(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
}
#define COMM_READ_PARAM_BUF_26(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
}
#define COMM_READ_PARAM_BUF_27(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
}
#define COMM_READ_PARAM_BUF_28(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27, \
    T28,var28) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
    (var28) = *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28)); \
}
#define COMM_READ_PARAM_BUF_29(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27, \
    T28,var28,T29,var29) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
    (var28) = *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28)); \
    (var29) = *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29)); \
}
#define COMM_READ_PARAM_BUF_30(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27, \
    T28,var28,T29,var29,T30,var30) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
    (var28) = *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28)); \
    (var29) = *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29)); \
    (var30) = *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30)); \
}
#define COMM_READ_PARAM_BUF_31(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27, \
    T28,var28,T29,var29,T30,var30,T31,var31) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
    (var28) = *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28)); \
    (var29) = *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29)); \
    (var30) = *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30)); \
    (var31) = *(T31*)(COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30,T31)); \
}
#define COMM_READ_PARAM_BUF_32(T1,var1,T2,var2,T3,var3,T4,var4,T5,var5, \
    T6,var6,T7,var7,T8,var8,T9,var9,T10,var10,T11,var11,T12,var12,T13,var13, \
    T14,var14,T15,var15,T16,var16,T17,var17,T18,var18,T19,var19,T20,var20, \
    T21,var21,T22,var22,T23,var23,T24,var24,T25,var25,T26,var26,T27,var27, \
    T28,var28,T29,var29,T30,var30,T31,var31,T32,var32) \
{ \
    (var1) = *(T1*)(COMM_P1_ADDR(T1)); \
    (var2) = *(T2*)(COMM_P2_ADDR(T1,T2)); \
    (var3) = *(T3*)(COMM_P3_ADDR(T1,T2,T3)); \
    (var4) = *(T4*)(COMM_P4_ADDR(T1,T2,T3,T4)); \
    (var5) = *(T5*)(COMM_P5_ADDR(T1,T2,T3,T4,T5)); \
    (var6) = *(T6*)(COMM_P6_ADDR(T1,T2,T3,T4,T5,T6)); \
    (var7) = *(T7*)(COMM_P7_ADDR(T1,T2,T3,T4,T5,T6,T7)); \
    (var8) = *(T8*)(COMM_P8_ADDR(T1,T2,T3,T4,T5,T6,T7,T8)); \
    (var9) = *(T9*)(COMM_P9_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9)); \
    (var10) = *(T10*)(COMM_P10_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)); \
    (var11) = *(T11*)(COMM_P11_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11)); \
    (var12) = *(T12*)(COMM_P12_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12)); \
    (var13) = *(T13*)(COMM_P13_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13)); \
    (var14) = *(T14*)(COMM_P14_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14)); \
    (var15) = *(T15*)(COMM_P15_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15)); \
    (var16) = *(T16*)(COMM_P16_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16)); \
    (var17) = *(T17*)(COMM_P17_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17)); \
    (var18) = *(T18*)(COMM_P18_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18)); \
    (var19) = *(T19*)(COMM_P19_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19)); \
    (var20) = *(T20*)(COMM_P20_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)); \
    (var21) = *(T21*)(COMM_P21_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)); \
    (var22) = *(T22*)(COMM_P22_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)); \
    (var23) = *(T23*)(COMM_P23_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23)); \
    (var24) = *(T24*)(COMM_P24_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24)); \
    (var25) = *(T25*)(COMM_P25_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25)); \
    (var26) = *(T26*)(COMM_P26_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26)); \
    (var27) = *(T27*)(COMM_P27_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27)); \
    (var28) = *(T28*)(COMM_P28_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28)); \
    (var29) = *(T29*)(COMM_P29_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29)); \
    (var30) = *(T30*)(COMM_P30_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30)); \
    (var31) = *(T31*)(COMM_P31_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30,T31)); \
    (var32) = *(T32*)(COMM_P32_ADDR(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26, \
    T27,T28,T29,T30,T31,T32)); \
}

/* Check length */
/*
 *#if COMM_CHECK_LENGTH_3(T1,T2,T3) < 0
 *  #pragma Too many (too long) parameters!
 *#endif
 */
#define COMM_CHECK_LENGTH_1(T1) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P1_LAST_ADDR(T1)))
#define COMM_CHECK_LENGTH_2(T1,T2) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P2_LAST_ADDR(T1,T2)))
#define COMM_CHECK_LENGTH_3(T1,T2,T3) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P3_LAST_ADDR(T1,T2,T3)))
#define COMM_CHECK_LENGTH_4(T1,T2,T3,T4) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P4_LAST_ADDR(T1,T2,T3,T4)))
#define COMM_CHECK_LENGTH_5(T1,T2,T3,T4,T5) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P5_LAST_ADDR(T1,T2,T3,T4,T5)))
#define COMM_CHECK_LENGTH_6(T1,T2,T3,T4,T5,T6) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P6_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6)))
#define COMM_CHECK_LENGTH_7(T1,T2,T3,T4,T5,T6,T7) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P7_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7)))
#define COMM_CHECK_LENGTH_8(T1,T2,T3,T4,T5,T6,T7,T8) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P8_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8)))
#define COMM_CHECK_LENGTH_9(T1,T2,T3,T4,T5,T6,T7,T8,T9) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P9_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9)))
#define COMM_CHECK_LENGTH_10(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P10_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10)))
#define COMM_CHECK_LENGTH_11(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P11_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11)))
#define COMM_CHECK_LENGTH_12(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P12_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12)))
#define COMM_CHECK_LENGTH_13(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P13_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13)))
#define COMM_CHECK_LENGTH_14(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P14_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14)))
#define COMM_CHECK_LENGTH_15(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P15_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15)))
#define COMM_CHECK_LENGTH_16(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P16_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16)))
#define COMM_CHECK_LENGTH_17(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P17_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17)))
#define COMM_CHECK_LENGTH_18(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P18_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18)))
#define COMM_CHECK_LENGTH_19(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P19_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19)))
#define COMM_CHECK_LENGTH_20(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P20_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20)))
#define COMM_CHECK_LENGTH_21(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P21_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21)))
#define COMM_CHECK_LENGTH_22(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P22_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22)))
#define COMM_CHECK_LENGTH_23(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P23_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23)))
#define COMM_CHECK_LENGTH_24(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P24_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24)))
#define COMM_CHECK_LENGTH_25(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P25_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25)))
#define COMM_CHECK_LENGTH_26(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P26_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26)))
#define COMM_CHECK_LENGTH_27(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P27_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27)))
#define COMM_CHECK_LENGTH_28(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P28_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27,T28)))
#define COMM_CHECK_LENGTH_29(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P29_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27,T28,T29)))
#define COMM_CHECK_LENGTH_30(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P30_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27,T28,T29,T30)))
#define COMM_CHECK_LENGTH_31(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P31_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27,T28,T29,T30,T31)))
#define COMM_CHECK_LENGTH_32(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, \
    T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23, \
    T24,T25,T26,T27,T28,T29,T30,T31,T32) \
    ((Int32)(COMM_PARAM_BUF_LAST_ADDR-COMM_P32_LAST_ADDR(T1,T2,T3,T4,T5, \
    T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22, \
    T23,T24,T25,T26,T27,T28,T29,T30,T31,T32)))


/******************************************************************************
* Message Mailbox details
******************************************************************************/

/*------------------------------------------------------------------------------
 * Regions in the Message Mailboxes
 */

/* Mask for Function Call Identifiers (FCID) */
#define _COMM_MM_FCID_MASK                  0x00FFFFFFu

/* Mask for Control Bits */
#define _COMM_MM_CTRL_MASK                  0xFF000000u

/*------------------------------------------------------------------------------
 * Control Bits in the Message Mailboxes
 */

/* Select type of FCID */
#define _COMM_MM_FCID_SELECT_MASK           0x0C000000u
#define _COMM_MM_USER_FCID                  0x04000000u
#define _COMM_MM_SYSTEM_FCID                0x08000000u

/* The host application is waiting for an interrupt after the called DSP
 * function has already finished.
 * If there is no Interrupt Request, the host application polls the
 * TO_HOST_MSG Mailbox in the communication data buffer.
 */
#define _COMM_MM_IT_REQ                     0x10000000u

/* When a DSP function calls the COMM_setError() function to write the
 * DSP-to-Host Error Message Mailbox, this bit is set to indicate to the Host
 * there was an error and it has to read the DSP-to-Host Error Message Mailbox.
 */
#define _COMM_MM_FUNCTION_FAILED            0x20000000u

/* When there is not a handler function for the required Function Call Request
 * (FCID), the _COMM_MM_UNKNOWN_FCID is set in the response message.
 */
#define _COMM_MM_UNKNOWN_FCID               0x40000000u

/* The DSP tells to the Host the called function is completed.
 * It can mean good and bad result. When the _COMM_MM_FUNCTION_FAILED is set,
 * it means that the function failed.
 */
#define _COMM_MM_FUNC_IS_COMPLETED          0x80000000u



/*----------------------------------------------------------------------------*/
/* DSP System Function Call Identifiers */
#define FCID_SYSTEM_CHECK_LIVE              0x000001u

/* Host System Function Call Identifiers */
#define FCID_SYSTEM_HANDSHAKE               0xFFFFFFu


/*----------------------------------------------------------------------------*/

#endif /* _BSL_COMMHAL_H_ */
