/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral SYNCBUS
* FILENAME......... bsl_syncbus.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 08:50:53
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. SYNCBUS
* PERIPHERAL TYPE.. Multi-device peripheral
* ACCESS MODE...... Through handle
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_SYNCBUS_H_
#define _BSL_SYNCBUS_H_

#include <bsl_syncbushal.h>


#if (BSL_SYNCBUS_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_SYNCBUS_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

/* SYNCBUS_open() flags */
#define SYNCBUS_OPEN_RESET                           0x00000001u

/* device identifiers for SYNCBUS_open() */
#define SYNCBUS_DEV0                                 0
#define SYNCBUS_DEV1                                 1
#define SYNCBUS_DEV2                                 2

/* for backwards compatible with SPM6020 */
#define SYNCBUS_CH0						(0)
#define SYNCBUS_CH1						(1)
#define SYNCBUS_CH2						(2)

/* source constants */
#define SYNCBUS_SOURCE_SWCMD			SYNCBUS_SRCSEL_SRC_SWCMD
#define SYNCBUS_SOURCE_TOUT0			SYNCBUS_SRCSEL_SRC_TOUT0
#define SYNCBUS_SOURCE_TOUT1			SYNCBUS_SRCSEL_SRC_TOUT1
#define SYNCBUS_SOURCE_TOUT2			SYNCBUS_SRCSEL_SRC_TOUT2

/* direction constants */
#define SYNCBUS_DIR_INPUT				SYNCBUS_DIR_DIR_INPUT
#define SYNCBUS_DIR_OUTPUT				SYNCBUS_DIR_DIR_OUTPUT
#define SYNCBUS_DIR_ENABLE				SYNCBUS_DIR_DIR_ENABLE
#define SYNCBUS_DIR_DISABLE				SYNCBUS_DIR_DIR_DISABLE
#define SYNCBUS_DIR_SLAVE				SYNCBUS_DIR_DIR_SLAVE
#define SYNCBUS_DIR_MASTER				SYNCBUS_DIR_DIR_MASTER


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint16 regSRCSEL;
	Uint16 regDIR;
} SYNCBUS_Config;

/* handle structure */
typedef struct {
	Uint32 allocated;
	Uint32 baseAddr;
} SYNCBUS_Obj, *SYNCBUS_Handle;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI SYNCBUS_Obj _SYNCBUS_obj;	/* defined in bsl_syncbus.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/

BSLAPI void SYNCBUS_reset(SYNCBUS_Handle hSyncbus);
BSLAPI void SYNCBUS_resetAll();

BSLAPI SYNCBUS_Handle SYNCBUS_open(Uint32 devNum, Uint32 flags);
BSLAPI void SYNCBUS_close(SYNCBUS_Handle hSyncbus);


/******************************************************************************\
* inline function declarations
\******************************************************************************/

//==============================================================================
//	Selects the source of the given sync bus
//
//	parameters:
//		hSyncbus		handle from the SYNCBUS_open()
//		src				source identifier
//						constants from SYNCBUS_SOURCE_x
//==============================================================================
IDECL void SYNCBUS_selectSource(SYNCBUS_Handle hSyncbus, Uint32 src);

//==============================================================================
//	Returns the currently set source of the given sync bus
//
//	parameters:
//		hSyncbus		handle from the SYNCBUS_open()
//
//	returns:
//		The currently set source of the given sync bus.
//		constant from SYNCBUS_SOURCE_x
//==============================================================================
IDECL Uint32 SYNCBUS_getSource(SYNCBUS_Handle hSyncbus);

//==============================================================================
//	Sets the direction (enables the output driving) of the given sync bus
//
//	parameters:
//		hSyncbus		handle from the SYNCBUS_open()
//		dir				direction identifier
//						constants from SYNCBUS_DIR_x
//==============================================================================
IDECL void SYNCBUS_setDir(SYNCBUS_Handle hSyncbus, Uint32 dir);

//==============================================================================
//	Returns the currently set direction of the given sync bus
//
//	parameters:
//		hSyncbus		handle from the SYNCBUS_open()
//
//	returns:
//		The currently set direction of the given sync bus.
//		constant from SYNCBUS_DIR_x
//==============================================================================
IDECL Uint32 SYNCBUS_getDir(SYNCBUS_Handle hSyncbus);

//==============================================================================
//	Sends a low-high-low pulse on the given sync bus, if the given sync bus's
//	source was selected for software command and the direction was set to
//	output.
//
//	parameters:
//		hSyncbus		handle from the SYNCBUS_open()
//==============================================================================
IDECL void SYNCBUS_sendPulse(SYNCBUS_Handle hSyncbus);

IDECL void SYNCBUS_config(SYNCBUS_Handle hSyncbus, SYNCBUS_Config *config);
IDECL void SYNCBUS_configArgs(SYNCBUS_Handle hSyncbus, Uint32 srcsel,
	Uint32 dir);
IDECL void SYNCBUS_getConfig(SYNCBUS_Handle hSyncbus, SYNCBUS_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_selectSource(SYNCBUS_Handle hSyncbus, Uint32 src)
{
	SYNCBUS_RSETH(hSyncbus,SRCSEL,src);
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 SYNCBUS_getSource(SYNCBUS_Handle hSyncbus)
{
	return ((Uint32)SYNCBUS_RGETH(hSyncbus,SRCSEL));
}

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_setDir(SYNCBUS_Handle hSyncbus, Uint32 dir)
{
	SYNCBUS_RSETH(hSyncbus,DIR,dir);
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 SYNCBUS_getDir(SYNCBUS_Handle hSyncbus)
{
	return ((Uint32)SYNCBUS_RGETH(hSyncbus,DIR));
}

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_sendPulse(SYNCBUS_Handle hSyncbus)
{
	SYNCBUS_RSETH(hSyncbus,SWCMD,SYNCBUS_SWCMD_CMD_EVENT);
}

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_config(SYNCBUS_Handle hSyncbus, SYNCBUS_Config *config)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1;

	base = (volatile Uint16 *)(hSyncbus->baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regSRCSEL;
	r1 = config->regDIR;
	base[_SYNCBUS_SRCSEL_REGOFFS16] = (Uint16)(r0);
	base[_SYNCBUS_DIR_REGOFFS16] = (Uint16)(r1);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_configArgs(SYNCBUS_Handle hSyncbus, Uint32 srcsel,
	Uint32 dir)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1;

	base = (volatile Uint16 *)(hSyncbus->baseAddr);

	gie = IRQ_globalDisable();

	r0 = srcsel;
	r1 = dir;
	base[_SYNCBUS_SRCSEL_REGOFFS16] = (Uint16)(r0);
	base[_SYNCBUS_DIR_REGOFFS16] = (Uint16)(r1);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void SYNCBUS_getConfig(SYNCBUS_Handle hSyncbus, SYNCBUS_Config *config)
{
	Uint32 gie;
	volatile SYNCBUS_Config *cfg;
	cfg = (volatile SYNCBUS_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regSRCSEL = SYNCBUS_RGETH(hSyncbus,SRCSEL);
	cfg->regDIR = SYNCBUS_RGETH(hSyncbus,DIR);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_SYNCBUS_SUPPORT */
#endif /* _BSL_SYNCBUS_H_ */
/******************************************************************************\
* End of bsl_syncbus.h
\******************************************************************************/
