/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral SYNCBUS
* FILENAME......... bsl_syncbushal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 02/20/2004 09:13:10
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. SYNCBUS
* PERIPHERAL TYPE.. Multi-device peripheral
* ACCESS MODE...... Through handle
* REGISTER ACCESS.. 16-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. SYNCBUS0 is 0x6C080000u
* BASE ADDRESS OF.. SYNCBUS1 is 0x6C080008u
* BASE ADDRESS OF.. SYNCBUS2 is 0x6C080010u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* SRCSEL      -  Source select
* DIR         -  Direction (Output Enable)
* SWCMD       -  Software command
*
\******************************************************************************/
#ifndef _BSL_SYNCBUSHAL_H_
#define _BSL_SYNCBUSHAL_H_

#include <bsl.h>


#if (BSL_SYNCBUS_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _SYNCBUS_DEVICE_COUNT                      3

  #define _SYNCBUS0_BASE_ADDRESS                     0x6C080000u
  #define _SYNCBUS1_BASE_ADDRESS                     0x6C080008u
  #define _SYNCBUS2_BASE_ADDRESS                     0x6C080010u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define SYNCBUS_FMK(REG,FIELD,val)\
    _PER_FMK16(SYNCBUS,##REG,##FIELD,val)

  #define SYNCBUS_FMKS(REG,FIELD,SYM)\
    _PER_FMKS16(SYNCBUS,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define SYNCBUS_ADDR(REG)\
    _SYNCBUS_##REG##_ADDR

  #define SYNCBUS_RGET(REG)\
    _PER_RGET16(_SYNCBUS_##REG##_ADDR,SYNCBUS,##REG)

  #define SYNCBUS_RSET(REG,val)\
    _PER_RSET16(_SYNCBUS_##REG##_ADDR,SYNCBUS,##REG,val)

  #define SYNCBUS_RFSETS(REG,FIELD,SYM)\
    SYNCBUS_RSET(##REG,_SYNCBUS_##REG##_##FIELD##_##SYM##_SV)

  #define SYNCBUS_FGET(REG,FIELD)\
    _SYNCBUS_##REG##_FGET(##FIELD)

  #define SYNCBUS_FSET(REG,FIELD,val)\
    _SYNCBUS_##REG##_FSET(##FIELD,val)

  #define SYNCBUS_FSETS(REG,FIELD,SYM)\
    _SYNCBUS_##REG##_FSETS(##FIELD,##SYM)

  #define SYNCBUS_FGETQ(REG,FIELD,val)\
    _SYNCBUS_##REG##_FGETQ(##FIELD,val)

  #define SYNCBUS_FGETSQ(REG,FIELD,SYM)\
    _SYNCBUS_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define SYNCBUS_RGETA(addr,REG)\
    _PER_RGET16(addr,SYNCBUS,##REG)

  #define SYNCBUS_RSETA(addr,REG,val)\
    _PER_RSET16(addr,SYNCBUS,##REG,val)

  #define SYNCBUS_RFSETSA(addr,REG,FIELD,SYM)\
    SYNCBUS_RSETA(addr,##REG,_SYNCBUS_##REG##_##FIELD##_##SYM##_SV)

  #define SYNCBUS_FGETA(addr,REG,FIELD)\
    _PER_FGET16(addr,SYNCBUS,##REG,##FIELD)

  #define SYNCBUS_FSETA(addr,REG,FIELD,val)\
    _PER_FSET16(addr,SYNCBUS,##REG,##FIELD,val)

  #define SYNCBUS_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS16(addr,SYNCBUS,##REG,##FIELD,##SYM)

  #define SYNCBUS_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ16(addr,SYNCBUS,##REG,##FIELD,val)

  #define SYNCBUS_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ16(addr,SYNCBUS,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* HANDLE BASED REGISTER/FIELD ACCESS MACROS   */
  /* ------------------------------------------- */

  #define SYNCBUS_ADDRH(h,REG)\
    ((Uint32)(((h)->baseAddr) + (Uint32)(_SYNCBUS_##REG##_REGOFFS)))

  #define SYNCBUS_RGETH(h,REG)\
    SYNCBUS_RGETA(SYNCBUS_ADDRH(h,##REG),##REG)

  #define SYNCBUS_RSETH(h,REG,val)\
    SYNCBUS_RSETA(SYNCBUS_ADDRH(h,##REG),##REG,val)

  #define SYNCBUS_RFSETSH(h,REG,FIELD,SYM)\
    SYNCBUS_RSETH(h,##REG,_SYNCBUS_##REG##_##FIELD##_##SYM##_SV)

  #define SYNCBUS_FGETH(h,REG,FIELD)\
    SYNCBUS_FGETA(SYNCBUS_ADDRH(h,##REG),##REG,##FIELD)

  #define SYNCBUS_FSETH(h,REG,FIELD,val)\
    SYNCBUS_FSETA(SYNCBUS_ADDRH(h,##REG),##REG,##FIELD,val)

  #define SYNCBUS_FSETSH(h,REG,FIELD,SYM)\
    SYNCBUS_FSETSA(SYNCBUS_ADDRH(h,##REG),##REG,##FIELD,##SYM)

  #define SYNCBUS_FGETQH(h,REG,FIELD,val)\
    SYNCBUS_FGETQA(SYNCBUS_ADDRH(h,##REG),##REG,##FIELD,val)

  #define SYNCBUS_FGETSQH(h,REG,FIELD,SYM)\
    SYNCBUS_FGETSQA(SYNCBUS_ADDRH(h,##REG),##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define SYNCBUS_VRGET(var,REG)\
    _PER_VRGET16(var,SYNCBUS,##REG)

  #define SYNCBUS_VRSET(var,REG,val)\
    _PER_VRSET16(var,SYNCBUS,##REG,val)

  #define SYNCBUS_VRFSETS(var,REG,FIELD,SYM)\
    SYNCBUS_VRSET(var,##REG,_SYNCBUS_##REG##_##FIELD##_##SYM##_SV)

  #define SYNCBUS_VFGET(var,REG,FIELD)\
    _PER_VFGET16(var,SYNCBUS,##REG,##FIELD)

  #define SYNCBUS_VFSET(var,REG,FIELD,val)\
    _PER_VFSET16(var,SYNCBUS,##REG,##FIELD,val)

  #define SYNCBUS_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS16(var,SYNCBUS,##REG,##FIELD,##SYM)

  #define SYNCBUS_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ16(var,SYNCBUS,##REG,##FIELD,val)

  #define SYNCBUS_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ16(var,SYNCBUS,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  S R C S E L          |
* |_______________________|
*
* SRCSEL - Source select
*
* FIELDS (msb -> lsb)
* (RW)	SRC       	[ 1: 0]	 - Source
*
\******************************************************************************/
/*#define _SYNCBUS_SRCSEL_RECIDX                     No recorded */

  #define _SYNCBUS_SRCSEL0_ADDR                      0x6C080000u
  #define _SYNCBUS_SRCSEL1_ADDR                      0x6C080008u
  #define _SYNCBUS_SRCSEL2_ADDR                      0x6C080010u

  #define _SYNCBUS_SRCSEL_REGOFFS                    0x00000000u
  #define _SYNCBUS_SRCSEL_REGOFFS16                  0x00000000u

  #define _SYNCBUS_SRCSEL_SRC_MASK                   0x0003u
  #define _SYNCBUS_SRCSEL_SRC_SHIFT                  0
  #define SYNCBUS_SRCSEL_SRC_DEFAULT                 0x0000u
  #define SYNCBUS_SRCSEL_SRC_OF(x)                   _VALUEOF16(x)
  #define SYNCBUS_SRCSEL_SRC_SWCMD                   0x0000u
  #define SYNCBUS_SRCSEL_SRC_TOUT0                   0x0001u
  #define SYNCBUS_SRCSEL_SRC_TOUT1                   0x0002u
  #define SYNCBUS_SRCSEL_SRC_TOUT2                   0x0003u
  #define _SYNCBUS_SRCSEL_SRC_SWCMD_SV               0x0000u
  #define _SYNCBUS_SRCSEL_SRC_TOUT0_SV               0x0001u
  #define _SYNCBUS_SRCSEL_SRC_TOUT1_SV               0x0002u
  #define _SYNCBUS_SRCSEL_SRC_TOUT2_SV               0x0003u

  #define SYNCBUS_SRCSEL_OF(val)                     _VALUEOF16(val)
  #define SYNCBUS_SRCSEL_DEFAULT (Uint16)(           \
      _PER_FDEFAULT16(SYNCBUS,SRCSEL,SRC)            \
  )

  #define SYNCBUS_SRCSEL_RMK(src)                    \
    (Uint16)(                                        \
      _PER_FMK16(SYNCBUS,SRCSEL,SRC,src)             \
  )

  #define _SYNCBUS_SRCSEL_FGET(N,FIELD)              \
    _PER_FGET16(_SYNCBUS_SRCSEL##N##_ADDR,           \
      SYNCBUS,SRCSEL,##FIELD)

  #define _SYNCBUS_SRCSEL_FSET(N,FIELD,field)        \
    _PER_FSET16(_SYNCBUS_SRCSEL##N##_ADDR,           \
      SYNCBUS,SRCSEL,##FIELD,field)

  #define _SYNCBUS_SRCSEL_FSETS(N,FIELD,SYM)         \
    _PER_FSETS16(_SYNCBUS_SRCSEL##N##_ADDR,          \
      SYNCBUS,SRCSEL,##FIELD,##SYM)

  #define _SYNCBUS_SRCSEL_FGETQ(N,FIELD,val)         \
    _PER_FGETQ16(_SYNCBUS_SRCSEL##N##_ADDR,          \
      SYNCBUS,SRCSEL,##FIELD,val)

  #define _SYNCBUS_SRCSEL_FGETSQ(N,FIELD,SYM)        \
    _PER_FGETSQ16(_SYNCBUS_SRCSEL##N##_ADDR,         \
      SYNCBUS,SRCSEL,##FIELD,##SYM)

  #define _SYNCBUS_SRCSEL0_FGET(FIELD)               \
    _SYNCBUS_SRCSEL_FGET(0,##FIELD)
  #define _SYNCBUS_SRCSEL1_FGET(FIELD)               \
    _SYNCBUS_SRCSEL_FGET(1,##FIELD)
  #define _SYNCBUS_SRCSEL2_FGET(FIELD)               \
    _SYNCBUS_SRCSEL_FGET(2,##FIELD)

  #define _SYNCBUS_SRCSEL0_FSET(FIELD,field)         \
    _SYNCBUS_SRCSEL_FSET(0,##FIELD,field)
  #define _SYNCBUS_SRCSEL1_FSET(FIELD,field)         \
    _SYNCBUS_SRCSEL_FSET(1,##FIELD,field)
  #define _SYNCBUS_SRCSEL2_FSET(FIELD,field)         \
    _SYNCBUS_SRCSEL_FSET(2,##FIELD,field)

  #define _SYNCBUS_SRCSEL0_FSETS(FIELD,SYM)          \
    _SYNCBUS_SRCSEL_FSETS(0,##FIELD,##SYM)
  #define _SYNCBUS_SRCSEL1_FSETS(FIELD,SYM)          \
    _SYNCBUS_SRCSEL_FSETS(1,##FIELD,##SYM)
  #define _SYNCBUS_SRCSEL2_FSETS(FIELD,SYM)          \
    _SYNCBUS_SRCSEL_FSETS(2,##FIELD,##SYM)

  #define _SYNCBUS_SRCSEL0_FGETQ(FIELD,val)          \
    _SYNCBUS_SRCSEL_FGETQ(0,##FIELD,val)
  #define _SYNCBUS_SRCSEL1_FGETQ(FIELD,val)          \
    _SYNCBUS_SRCSEL_FGETQ(1,##FIELD,val)
  #define _SYNCBUS_SRCSEL2_FGETQ(FIELD,val)          \
    _SYNCBUS_SRCSEL_FGETQ(2,##FIELD,val)

  #define _SYNCBUS_SRCSEL0_FGETSQ(FIELD,SYM)         \
    _SYNCBUS_SRCSEL_FGETSQ(0,##FIELD,##SYM)
  #define _SYNCBUS_SRCSEL1_FGETSQ(FIELD,SYM)         \
    _SYNCBUS_SRCSEL_FGETSQ(1,##FIELD,##SYM)
  #define _SYNCBUS_SRCSEL2_FGETSQ(FIELD,SYM)         \
    _SYNCBUS_SRCSEL_FGETSQ(2,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D I R                |
* |_______________________|
*
* DIR - Direction (Output Enable)
*
* FIELDS (msb -> lsb)
* (RW)	DIR       	[ 0: 0]	 - Direction
*
\******************************************************************************/
/*#define _SYNCBUS_DIR_RECIDX                        No recorded */

  #define _SYNCBUS_DIR0_ADDR                         0x6C080002u
  #define _SYNCBUS_DIR1_ADDR                         0x6C08000Au
  #define _SYNCBUS_DIR2_ADDR                         0x6C080012u

  #define _SYNCBUS_DIR_REGOFFS                       0x00000002u
  #define _SYNCBUS_DIR_REGOFFS16                     0x00000001u

  #define _SYNCBUS_DIR_DIR_MASK                      0x0001u
  #define _SYNCBUS_DIR_DIR_SHIFT                     0
  #define SYNCBUS_DIR_DIR_DEFAULT                    0x0000u
  #define SYNCBUS_DIR_DIR_OF(x)                      _VALUEOF16(x)
  #define SYNCBUS_DIR_DIR_INPUT                      0x0000u
  #define SYNCBUS_DIR_DIR_OUTPUT                     0x0001u
  #define SYNCBUS_DIR_DIR_DISABLE                    0x0000u
  #define SYNCBUS_DIR_DIR_ENABLE                     0x0001u
  #define SYNCBUS_DIR_DIR_SLAVE                      0x0000u
  #define SYNCBUS_DIR_DIR_MASTER                     0x0001u
  #define _SYNCBUS_DIR_DIR_INPUT_SV                  0x0000u
  #define _SYNCBUS_DIR_DIR_OUTPUT_SV                 0x0001u
  #define _SYNCBUS_DIR_DIR_DISABLE_SV                0x0000u
  #define _SYNCBUS_DIR_DIR_ENABLE_SV                 0x0001u
  #define _SYNCBUS_DIR_DIR_SLAVE_SV                  0x0000u
  #define _SYNCBUS_DIR_DIR_MASTER_SV                 0x0001u

  #define SYNCBUS_DIR_OF(val)                        _VALUEOF16(val)
  #define SYNCBUS_DIR_DEFAULT (Uint16)(              \
      _PER_FDEFAULT16(SYNCBUS,DIR,DIR)               \
  )

  #define SYNCBUS_DIR_RMK(dir)                       \
    (Uint16)(                                        \
      _PER_FMK16(SYNCBUS,DIR,DIR,dir)                \
  )

  #define _SYNCBUS_DIR_FGET(N,FIELD)                 \
    _PER_FGET16(_SYNCBUS_DIR##N##_ADDR,              \
      SYNCBUS,DIR,##FIELD)

  #define _SYNCBUS_DIR_FSET(N,FIELD,field)           \
    _PER_FSET16(_SYNCBUS_DIR##N##_ADDR,              \
      SYNCBUS,DIR,##FIELD,field)

  #define _SYNCBUS_DIR_FSETS(N,FIELD,SYM)            \
    _PER_FSETS16(_SYNCBUS_DIR##N##_ADDR,             \
      SYNCBUS,DIR,##FIELD,##SYM)

  #define _SYNCBUS_DIR_FGETQ(N,FIELD,val)            \
    _PER_FGETQ16(_SYNCBUS_DIR##N##_ADDR,             \
      SYNCBUS,DIR,##FIELD,val)

  #define _SYNCBUS_DIR_FGETSQ(N,FIELD,SYM)           \
    _PER_FGETSQ16(_SYNCBUS_DIR##N##_ADDR,            \
      SYNCBUS,DIR,##FIELD,##SYM)

  #define _SYNCBUS_DIR0_FGET(FIELD)                  \
    _SYNCBUS_DIR_FGET(0,##FIELD)
  #define _SYNCBUS_DIR1_FGET(FIELD)                  \
    _SYNCBUS_DIR_FGET(1,##FIELD)
  #define _SYNCBUS_DIR2_FGET(FIELD)                  \
    _SYNCBUS_DIR_FGET(2,##FIELD)

  #define _SYNCBUS_DIR0_FSET(FIELD,field)            \
    _SYNCBUS_DIR_FSET(0,##FIELD,field)
  #define _SYNCBUS_DIR1_FSET(FIELD,field)            \
    _SYNCBUS_DIR_FSET(1,##FIELD,field)
  #define _SYNCBUS_DIR2_FSET(FIELD,field)            \
    _SYNCBUS_DIR_FSET(2,##FIELD,field)

  #define _SYNCBUS_DIR0_FSETS(FIELD,SYM)             \
    _SYNCBUS_DIR_FSETS(0,##FIELD,##SYM)
  #define _SYNCBUS_DIR1_FSETS(FIELD,SYM)             \
    _SYNCBUS_DIR_FSETS(1,##FIELD,##SYM)
  #define _SYNCBUS_DIR2_FSETS(FIELD,SYM)             \
    _SYNCBUS_DIR_FSETS(2,##FIELD,##SYM)

  #define _SYNCBUS_DIR0_FGETQ(FIELD,val)             \
    _SYNCBUS_DIR_FGETQ(0,##FIELD,val)
  #define _SYNCBUS_DIR1_FGETQ(FIELD,val)             \
    _SYNCBUS_DIR_FGETQ(1,##FIELD,val)
  #define _SYNCBUS_DIR2_FGETQ(FIELD,val)             \
    _SYNCBUS_DIR_FGETQ(2,##FIELD,val)

  #define _SYNCBUS_DIR0_FGETSQ(FIELD,SYM)            \
    _SYNCBUS_DIR_FGETSQ(0,##FIELD,##SYM)
  #define _SYNCBUS_DIR1_FGETSQ(FIELD,SYM)            \
    _SYNCBUS_DIR_FGETSQ(1,##FIELD,##SYM)
  #define _SYNCBUS_DIR2_FGETSQ(FIELD,SYM)            \
    _SYNCBUS_DIR_FGETSQ(2,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  S W C M D            |
* |_______________________|
*
* SWCMD - Software command
*
* FIELDS (msb -> lsb)
* (.W)	CMD       	[ 0: 0]	 - Command
*
\******************************************************************************/
/*#define _SYNCBUS_SWCMD_RECIDX                      No recorded */

  #define _SYNCBUS_SWCMD0_ADDR                       0x6C080004u
  #define _SYNCBUS_SWCMD1_ADDR                       0x6C08000Cu
  #define _SYNCBUS_SWCMD2_ADDR                       0x6C080014u

  #define _SYNCBUS_SWCMD_REGOFFS                     0x00000004u
  #define _SYNCBUS_SWCMD_REGOFFS16                   0x00000002u

  #define _SYNCBUS_SWCMD_CMD_MASK                    0x0001u
  #define _SYNCBUS_SWCMD_CMD_SHIFT                   0
  #define SYNCBUS_SWCMD_CMD_DEFAULT                  0x0000u
  #define SYNCBUS_SWCMD_CMD_OF(x)                    _VALUEOF16(x)
  #define SYNCBUS_SWCMD_CMD_EVENT                    0x0001u
  #define SYNCBUS_SWCMD_CMD_PULSE                    0x0001u
  #define _SYNCBUS_SWCMD_CMD_EVENT_SV                0x0001u
  #define _SYNCBUS_SWCMD_CMD_PULSE_SV                0x0001u

  #define SYNCBUS_SWCMD_OF(val)                      _VALUEOF16(val)
  #define SYNCBUS_SWCMD_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(SYNCBUS,SWCMD,CMD)             \
  )

  #define SYNCBUS_SWCMD_RMK(cmd)                     \
    (Uint16)(                                        \
      _PER_FMK16(SYNCBUS,SWCMD,CMD,cmd)              \
  )

  #define _SYNCBUS_SWCMD_FGET(N,FIELD)               \
    _PER_FGET16(_SYNCBUS_SWCMD##N##_ADDR,            \
      SYNCBUS,SWCMD,##FIELD)

  #define _SYNCBUS_SWCMD_FSET(N,FIELD,field)         \
    _PER_FSET16(_SYNCBUS_SWCMD##N##_ADDR,            \
      SYNCBUS,SWCMD,##FIELD,field)

  #define _SYNCBUS_SWCMD_FSETS(N,FIELD,SYM)          \
    _PER_FSETS16(_SYNCBUS_SWCMD##N##_ADDR,           \
      SYNCBUS,SWCMD,##FIELD,##SYM)

  #define _SYNCBUS_SWCMD_FGETQ(N,FIELD,val)          \
    _PER_FGETQ16(_SYNCBUS_SWCMD##N##_ADDR,           \
      SYNCBUS,SWCMD,##FIELD,val)

  #define _SYNCBUS_SWCMD_FGETSQ(N,FIELD,SYM)         \
    _PER_FGETSQ16(_SYNCBUS_SWCMD##N##_ADDR,          \
      SYNCBUS,SWCMD,##FIELD,##SYM)

  #define _SYNCBUS_SWCMD0_FGET(FIELD)                \
    _SYNCBUS_SWCMD_FGET(0,##FIELD)
  #define _SYNCBUS_SWCMD1_FGET(FIELD)                \
    _SYNCBUS_SWCMD_FGET(1,##FIELD)
  #define _SYNCBUS_SWCMD2_FGET(FIELD)                \
    _SYNCBUS_SWCMD_FGET(2,##FIELD)

  #define _SYNCBUS_SWCMD0_FSET(FIELD,field)          \
    _SYNCBUS_SWCMD_FSET(0,##FIELD,field)
  #define _SYNCBUS_SWCMD1_FSET(FIELD,field)          \
    _SYNCBUS_SWCMD_FSET(1,##FIELD,field)
  #define _SYNCBUS_SWCMD2_FSET(FIELD,field)          \
    _SYNCBUS_SWCMD_FSET(2,##FIELD,field)

  #define _SYNCBUS_SWCMD0_FSETS(FIELD,SYM)           \
    _SYNCBUS_SWCMD_FSETS(0,##FIELD,##SYM)
  #define _SYNCBUS_SWCMD1_FSETS(FIELD,SYM)           \
    _SYNCBUS_SWCMD_FSETS(1,##FIELD,##SYM)
  #define _SYNCBUS_SWCMD2_FSETS(FIELD,SYM)           \
    _SYNCBUS_SWCMD_FSETS(2,##FIELD,##SYM)

  #define _SYNCBUS_SWCMD0_FGETQ(FIELD,val)           \
    _SYNCBUS_SWCMD_FGETQ(0,##FIELD,val)
  #define _SYNCBUS_SWCMD1_FGETQ(FIELD,val)           \
    _SYNCBUS_SWCMD_FGETQ(1,##FIELD,val)
  #define _SYNCBUS_SWCMD2_FGETQ(FIELD,val)           \
    _SYNCBUS_SWCMD_FGETQ(2,##FIELD,val)

  #define _SYNCBUS_SWCMD0_FGETSQ(FIELD,SYM)          \
    _SYNCBUS_SWCMD_FGETSQ(0,##FIELD,##SYM)
  #define _SYNCBUS_SWCMD1_FGETSQ(FIELD,SYM)          \
    _SYNCBUS_SWCMD_FGETSQ(1,##FIELD,##SYM)
  #define _SYNCBUS_SWCMD2_FGETSQ(FIELD,SYM)          \
    _SYNCBUS_SWCMD_FGETSQ(2,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_SYNCBUS_SUPPORT) */
#endif /* _BSL_SYNCBUSHAL_H_ */
/******************************************************************************\
* End of bsl_syncbushal.h
\******************************************************************************/
