/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral UCOMM
* FILENAME......... bsl_ucommhal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 02/20/2004 09:13:10
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UCOMM
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 32-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. UCOMM is 0x6C080000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* MBOX0       -  Mailbox 0
* MBOX1       -  Mailbox 1
* MBOX2       -  Mailbox 2
* MBOX3       -  Mailbox 3
* L2PDBSET    -  Local-to-PCI Doorbell Set (write from DSP)
* L2PDBCLR    -  Local-to-PCI Doorbell Clear (write from PCI)
* P2LDBSET    -  PCI-to-Local Doorbell Set (write from PCI)
* P2LDBCLR    -  PCI-to-Local Doorbell Clear (write from DSP)
*
\******************************************************************************/
#ifndef _BSL_UCOMMHAL_H_
#define _BSL_UCOMMHAL_H_

#include <bsl.h>


#if (BSL_UCOMM_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _UCOMM_DEVICE_COUNT                        1

  #define _UCOMM_BASE_ADDRESS                        0x6C080000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define UCOMM_FMK(REG,FIELD,val)\
    _PER_FMK32(UCOMM,##REG,##FIELD,val)

  #define UCOMM_FMKS(REG,FIELD,SYM)\
    _PER_FMKS32(UCOMM,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define UCOMM_ADDR(REG)\
    _UCOMM_##REG##_ADDR

  #define UCOMM_RGET(REG)\
    _PER_RGET32(_UCOMM_##REG##_ADDR,UCOMM,##REG)

  #define UCOMM_RSET(REG,val)\
    _PER_RSET32(_UCOMM_##REG##_ADDR,UCOMM,##REG,val)

  #define UCOMM_RFSETS(REG,FIELD,SYM)\
    UCOMM_RSET(##REG,_UCOMM_##REG##_##FIELD##_##SYM##_SV)

  #define UCOMM_FGET(REG,FIELD)\
    _UCOMM_##REG##_FGET(##FIELD)

  #define UCOMM_FSET(REG,FIELD,val)\
    _UCOMM_##REG##_FSET(##FIELD,val)

  #define UCOMM_FSETS(REG,FIELD,SYM)\
    _UCOMM_##REG##_FSETS(##FIELD,##SYM)

  #define UCOMM_FGETQ(REG,FIELD,val)\
    _UCOMM_##REG##_FGETQ(##FIELD,val)

  #define UCOMM_FGETSQ(REG,FIELD,SYM)\
    _UCOMM_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define UCOMM_RGETA(addr,REG)\
    _PER_RGET32(addr,UCOMM,##REG)

  #define UCOMM_RSETA(addr,REG,val)\
    _PER_RSET32(addr,UCOMM,##REG,val)

  #define UCOMM_RFSETSA(addr,REG,FIELD,SYM)\
    UCOMM_RSETA(addr,##REG,_UCOMM_##REG##_##FIELD##_##SYM##_SV)

  #define UCOMM_FGETA(addr,REG,FIELD)\
    _PER_FGET32(addr,UCOMM,##REG,##FIELD)

  #define UCOMM_FSETA(addr,REG,FIELD,val)\
    _PER_FSET32(addr,UCOMM,##REG,##FIELD,val)

  #define UCOMM_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS32(addr,UCOMM,##REG,##FIELD,##SYM)

  #define UCOMM_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ32(addr,UCOMM,##REG,##FIELD,val)

  #define UCOMM_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ32(addr,UCOMM,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define UCOMM_VRGET(var,REG)\
    _PER_VRGET32(var,UCOMM,##REG)

  #define UCOMM_VRSET(var,REG,val)\
    _PER_VRSET32(var,UCOMM,##REG,val)

  #define UCOMM_VRFSETS(var,REG,FIELD,SYM)\
    UCOMM_VRSET(var,##REG,_UCOMM_##REG##_##FIELD##_##SYM##_SV)

  #define UCOMM_VFGET(var,REG,FIELD)\
    _PER_VFGET32(var,UCOMM,##REG,##FIELD)

  #define UCOMM_VFSET(var,REG,FIELD,val)\
    _PER_VFSET32(var,UCOMM,##REG,##FIELD,val)

  #define UCOMM_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS32(var,UCOMM,##REG,##FIELD,##SYM)

  #define UCOMM_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ32(var,UCOMM,##REG,##FIELD,val)

  #define UCOMM_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ32(var,UCOMM,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS32         Offset in 32-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  M B O X 0            |
* |_______________________|
*
* MBOX0 - Mailbox 0
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Value
*
\******************************************************************************/
/*#define _UCOMM_MBOX0_RECIDX                        No recorded */

  #define _UCOMM_MBOX0_ADDR                          0x6C080060u

  #define _UCOMM_MBOX0_REGOFFS                       0x00000060u
  #define _UCOMM_MBOX0_REGOFFS32                     0x00000018u

  #define _UCOMM_MBOX0_VALUE_MASK                    0xFFFFFFFFu
  #define _UCOMM_MBOX0_VALUE_SHIFT                   0
  #define UCOMM_MBOX0_VALUE_DEFAULT                  0x00000000u
  #define UCOMM_MBOX0_VALUE_OF(x)                    _VALUEOF32(x)

  #define UCOMM_MBOX0_OF(val)                        _VALUEOF32(val)
  #define UCOMM_MBOX0_DEFAULT (Uint32)(              \
      _PER_FDEFAULT32(UCOMM,MBOX0,VALUE)             \
  )

  #define UCOMM_MBOX0_RMK(value)                     \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,MBOX0,VALUE,value)            \
  )

  #define _UCOMM_MBOX0_FGET(FIELD)                   \
    _PER_FGET32(_UCOMM_MBOX0_ADDR,                   \
      UCOMM,MBOX0,##FIELD)

  #define _UCOMM_MBOX0_FSET(FIELD,field)             \
    _PER_FSET32(_UCOMM_MBOX0_ADDR,                   \
      UCOMM,MBOX0,##FIELD,field)

  #define _UCOMM_MBOX0_FSETS(FIELD,SYM)              \
    _PER_FSETS32(_UCOMM_MBOX0_ADDR,                  \
      UCOMM,MBOX0,##FIELD,##SYM)

  #define _UCOMM_MBOX0_FGETQ(FIELD,val)              \
    _PER_FGETQ32(_UCOMM_MBOX0_ADDR,                  \
      UCOMM,MBOX0,##FIELD,val)

  #define _UCOMM_MBOX0_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ32(_UCOMM_MBOX0_ADDR,                 \
      UCOMM,MBOX0,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  M B O X 1            |
* |_______________________|
*
* MBOX1 - Mailbox 1
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Value
*
\******************************************************************************/
/*#define _UCOMM_MBOX1_RECIDX                        No recorded */

  #define _UCOMM_MBOX1_ADDR                          0x6C080064u

  #define _UCOMM_MBOX1_REGOFFS                       0x00000064u
  #define _UCOMM_MBOX1_REGOFFS32                     0x00000019u

  #define _UCOMM_MBOX1_VALUE_MASK                    0xFFFFFFFFu
  #define _UCOMM_MBOX1_VALUE_SHIFT                   0
  #define UCOMM_MBOX1_VALUE_DEFAULT                  0x00000000u
  #define UCOMM_MBOX1_VALUE_OF(x)                    _VALUEOF32(x)

  #define UCOMM_MBOX1_OF(val)                        _VALUEOF32(val)
  #define UCOMM_MBOX1_DEFAULT (Uint32)(              \
      _PER_FDEFAULT32(UCOMM,MBOX1,VALUE)             \
  )

  #define UCOMM_MBOX1_RMK(value)                     \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,MBOX1,VALUE,value)            \
  )

  #define _UCOMM_MBOX1_FGET(FIELD)                   \
    _PER_FGET32(_UCOMM_MBOX1_ADDR,                   \
      UCOMM,MBOX1,##FIELD)

  #define _UCOMM_MBOX1_FSET(FIELD,field)             \
    _PER_FSET32(_UCOMM_MBOX1_ADDR,                   \
      UCOMM,MBOX1,##FIELD,field)

  #define _UCOMM_MBOX1_FSETS(FIELD,SYM)              \
    _PER_FSETS32(_UCOMM_MBOX1_ADDR,                  \
      UCOMM,MBOX1,##FIELD,##SYM)

  #define _UCOMM_MBOX1_FGETQ(FIELD,val)              \
    _PER_FGETQ32(_UCOMM_MBOX1_ADDR,                  \
      UCOMM,MBOX1,##FIELD,val)

  #define _UCOMM_MBOX1_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ32(_UCOMM_MBOX1_ADDR,                 \
      UCOMM,MBOX1,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  M B O X 2            |
* |_______________________|
*
* MBOX2 - Mailbox 2
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Value
*
\******************************************************************************/
/*#define _UCOMM_MBOX2_RECIDX                        No recorded */

  #define _UCOMM_MBOX2_ADDR                          0x6C080068u

  #define _UCOMM_MBOX2_REGOFFS                       0x00000068u
  #define _UCOMM_MBOX2_REGOFFS32                     0x0000001Au

  #define _UCOMM_MBOX2_VALUE_MASK                    0xFFFFFFFFu
  #define _UCOMM_MBOX2_VALUE_SHIFT                   0
  #define UCOMM_MBOX2_VALUE_DEFAULT                  0x00000000u
  #define UCOMM_MBOX2_VALUE_OF(x)                    _VALUEOF32(x)

  #define UCOMM_MBOX2_OF(val)                        _VALUEOF32(val)
  #define UCOMM_MBOX2_DEFAULT (Uint32)(              \
      _PER_FDEFAULT32(UCOMM,MBOX2,VALUE)             \
  )

  #define UCOMM_MBOX2_RMK(value)                     \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,MBOX2,VALUE,value)            \
  )

  #define _UCOMM_MBOX2_FGET(FIELD)                   \
    _PER_FGET32(_UCOMM_MBOX2_ADDR,                   \
      UCOMM,MBOX2,##FIELD)

  #define _UCOMM_MBOX2_FSET(FIELD,field)             \
    _PER_FSET32(_UCOMM_MBOX2_ADDR,                   \
      UCOMM,MBOX2,##FIELD,field)

  #define _UCOMM_MBOX2_FSETS(FIELD,SYM)              \
    _PER_FSETS32(_UCOMM_MBOX2_ADDR,                  \
      UCOMM,MBOX2,##FIELD,##SYM)

  #define _UCOMM_MBOX2_FGETQ(FIELD,val)              \
    _PER_FGETQ32(_UCOMM_MBOX2_ADDR,                  \
      UCOMM,MBOX2,##FIELD,val)

  #define _UCOMM_MBOX2_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ32(_UCOMM_MBOX2_ADDR,                 \
      UCOMM,MBOX2,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  M B O X 3            |
* |_______________________|
*
* MBOX3 - Mailbox 3
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Value
*
\******************************************************************************/
/*#define _UCOMM_MBOX3_RECIDX                        No recorded */

  #define _UCOMM_MBOX3_ADDR                          0x6C08006Cu

  #define _UCOMM_MBOX3_REGOFFS                       0x0000006Cu
  #define _UCOMM_MBOX3_REGOFFS32                     0x0000001Bu

  #define _UCOMM_MBOX3_VALUE_MASK                    0xFFFFFFFFu
  #define _UCOMM_MBOX3_VALUE_SHIFT                   0
  #define UCOMM_MBOX3_VALUE_DEFAULT                  0x00000000u
  #define UCOMM_MBOX3_VALUE_OF(x)                    _VALUEOF32(x)

  #define UCOMM_MBOX3_OF(val)                        _VALUEOF32(val)
  #define UCOMM_MBOX3_DEFAULT (Uint32)(              \
      _PER_FDEFAULT32(UCOMM,MBOX3,VALUE)             \
  )

  #define UCOMM_MBOX3_RMK(value)                     \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,MBOX3,VALUE,value)            \
  )

  #define _UCOMM_MBOX3_FGET(FIELD)                   \
    _PER_FGET32(_UCOMM_MBOX3_ADDR,                   \
      UCOMM,MBOX3,##FIELD)

  #define _UCOMM_MBOX3_FSET(FIELD,field)             \
    _PER_FSET32(_UCOMM_MBOX3_ADDR,                   \
      UCOMM,MBOX3,##FIELD,field)

  #define _UCOMM_MBOX3_FSETS(FIELD,SYM)              \
    _PER_FSETS32(_UCOMM_MBOX3_ADDR,                  \
      UCOMM,MBOX3,##FIELD,##SYM)

  #define _UCOMM_MBOX3_FGETQ(FIELD,val)              \
    _PER_FGETQ32(_UCOMM_MBOX3_ADDR,                  \
      UCOMM,MBOX3,##FIELD,val)

  #define _UCOMM_MBOX3_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ32(_UCOMM_MBOX3_ADDR,                 \
      UCOMM,MBOX3,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  L 2 P D B S E T      |
* |_______________________|
*
* L2PDBSET - Local-to-PCI Doorbell Set (write from DSP)
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Set Value
*
\******************************************************************************/
/*#define _UCOMM_L2PDBSET_RECIDX                     No recorded */

  #define _UCOMM_L2PDBSET_ADDR                       0x6C080070u

  #define _UCOMM_L2PDBSET_REGOFFS                    0x00000070u
  #define _UCOMM_L2PDBSET_REGOFFS32                  0x0000001Cu

  #define _UCOMM_L2PDBSET_VALUE_MASK                 0xFFFFFFFFu
  #define _UCOMM_L2PDBSET_VALUE_SHIFT                0
  #define UCOMM_L2PDBSET_VALUE_DEFAULT               0x00000000u
  #define UCOMM_L2PDBSET_VALUE_OF(x)                 _VALUEOF32(x)

  #define UCOMM_L2PDBSET_OF(val)                     _VALUEOF32(val)
  #define UCOMM_L2PDBSET_DEFAULT (Uint32)(           \
      _PER_FDEFAULT32(UCOMM,L2PDBSET,VALUE)          \
  )

  #define UCOMM_L2PDBSET_RMK(value)                  \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,L2PDBSET,VALUE,value)         \
  )

  #define _UCOMM_L2PDBSET_FGET(FIELD)                \
    _PER_FGET32(_UCOMM_L2PDBSET_ADDR,                \
      UCOMM,L2PDBSET,##FIELD)

  #define _UCOMM_L2PDBSET_FSET(FIELD,field)          \
    _PER_FSET32(_UCOMM_L2PDBSET_ADDR,                \
      UCOMM,L2PDBSET,##FIELD,field)

  #define _UCOMM_L2PDBSET_FSETS(FIELD,SYM)           \
    _PER_FSETS32(_UCOMM_L2PDBSET_ADDR,               \
      UCOMM,L2PDBSET,##FIELD,##SYM)

  #define _UCOMM_L2PDBSET_FGETQ(FIELD,val)           \
    _PER_FGETQ32(_UCOMM_L2PDBSET_ADDR,               \
      UCOMM,L2PDBSET,##FIELD,val)

  #define _UCOMM_L2PDBSET_FGETSQ(FIELD,SYM)          \
    _PER_FGETSQ32(_UCOMM_L2PDBSET_ADDR,              \
      UCOMM,L2PDBSET,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  L 2 P D B C L R      |
* |_______________________|
*
* L2PDBCLR - Local-to-PCI Doorbell Clear (write from PCI)
*
* FIELDS (msb -> lsb)
* (.W)	VALUE     	[31: 0]	 - Clear Value
*
\******************************************************************************/
/*#define _UCOMM_L2PDBCLR_RECIDX                     No recorded */

  #define _UCOMM_L2PDBCLR_ADDR                       0x6C080074u

  #define _UCOMM_L2PDBCLR_REGOFFS                    0x00000074u
  #define _UCOMM_L2PDBCLR_REGOFFS32                  0x0000001Du

  #define _UCOMM_L2PDBCLR_VALUE_MASK                 0xFFFFFFFFu
  #define _UCOMM_L2PDBCLR_VALUE_SHIFT                0
  #define UCOMM_L2PDBCLR_VALUE_DEFAULT               0x00000000u
  #define UCOMM_L2PDBCLR_VALUE_OF(x)                 _VALUEOF32(x)
  #define UCOMM_L2PDBCLR_VALUE_CLRALL                0xFFFFFFFFu
  #define _UCOMM_L2PDBCLR_VALUE_CLRALL_SV            0xFFFFFFFFu

  #define UCOMM_L2PDBCLR_OF(val)                     _VALUEOF32(val)
  #define UCOMM_L2PDBCLR_DEFAULT (Uint32)(           \
      _PER_FDEFAULT32(UCOMM,L2PDBCLR,VALUE)          \
  )

  #define UCOMM_L2PDBCLR_RMK(value)                  \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,L2PDBCLR,VALUE,value)         \
  )

  #define _UCOMM_L2PDBCLR_FGET(FIELD)                \
    _PER_FGET32(_UCOMM_L2PDBCLR_ADDR,                \
      UCOMM,L2PDBCLR,##FIELD)

  #define _UCOMM_L2PDBCLR_FSET(FIELD,field)          \
    _PER_FSET32(_UCOMM_L2PDBCLR_ADDR,                \
      UCOMM,L2PDBCLR,##FIELD,field)

  #define _UCOMM_L2PDBCLR_FSETS(FIELD,SYM)           \
    _PER_FSETS32(_UCOMM_L2PDBCLR_ADDR,               \
      UCOMM,L2PDBCLR,##FIELD,##SYM)

  #define _UCOMM_L2PDBCLR_FGETQ(FIELD,val)           \
    _PER_FGETQ32(_UCOMM_L2PDBCLR_ADDR,               \
      UCOMM,L2PDBCLR,##FIELD,val)

  #define _UCOMM_L2PDBCLR_FGETSQ(FIELD,SYM)          \
    _PER_FGETSQ32(_UCOMM_L2PDBCLR_ADDR,              \
      UCOMM,L2PDBCLR,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P 2 L D B S E T      |
* |_______________________|
*
* P2LDBSET - PCI-to-Local Doorbell Set (write from PCI)
*
* FIELDS (msb -> lsb)
* (RW)	VALUE     	[31: 0]	 - Set Value
*
\******************************************************************************/
/*#define _UCOMM_P2LDBSET_RECIDX                     No recorded */

  #define _UCOMM_P2LDBSET_ADDR                       0x6C080078u

  #define _UCOMM_P2LDBSET_REGOFFS                    0x00000078u
  #define _UCOMM_P2LDBSET_REGOFFS32                  0x0000001Eu

  #define _UCOMM_P2LDBSET_VALUE_MASK                 0xFFFFFFFFu
  #define _UCOMM_P2LDBSET_VALUE_SHIFT                0
  #define UCOMM_P2LDBSET_VALUE_DEFAULT               0x00000000u
  #define UCOMM_P2LDBSET_VALUE_OF(x)                 _VALUEOF32(x)

  #define UCOMM_P2LDBSET_OF(val)                     _VALUEOF32(val)
  #define UCOMM_P2LDBSET_DEFAULT (Uint32)(           \
      _PER_FDEFAULT32(UCOMM,P2LDBSET,VALUE)          \
  )

  #define UCOMM_P2LDBSET_RMK(value)                  \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,P2LDBSET,VALUE,value)         \
  )

  #define _UCOMM_P2LDBSET_FGET(FIELD)                \
    _PER_FGET32(_UCOMM_P2LDBSET_ADDR,                \
      UCOMM,P2LDBSET,##FIELD)

  #define _UCOMM_P2LDBSET_FSET(FIELD,field)          \
    _PER_FSET32(_UCOMM_P2LDBSET_ADDR,                \
      UCOMM,P2LDBSET,##FIELD,field)

  #define _UCOMM_P2LDBSET_FSETS(FIELD,SYM)           \
    _PER_FSETS32(_UCOMM_P2LDBSET_ADDR,               \
      UCOMM,P2LDBSET,##FIELD,##SYM)

  #define _UCOMM_P2LDBSET_FGETQ(FIELD,val)           \
    _PER_FGETQ32(_UCOMM_P2LDBSET_ADDR,               \
      UCOMM,P2LDBSET,##FIELD,val)

  #define _UCOMM_P2LDBSET_FGETSQ(FIELD,SYM)          \
    _PER_FGETSQ32(_UCOMM_P2LDBSET_ADDR,              \
      UCOMM,P2LDBSET,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P 2 L D B C L R      |
* |_______________________|
*
* P2LDBCLR - PCI-to-Local Doorbell Clear (write from DSP)
*
* FIELDS (msb -> lsb)
* (.W)	VALUE     	[31: 0]	 - Clear Value
*
\******************************************************************************/
/*#define _UCOMM_P2LDBCLR_RECIDX                     No recorded */

  #define _UCOMM_P2LDBCLR_ADDR                       0x6C08007Cu

  #define _UCOMM_P2LDBCLR_REGOFFS                    0x0000007Cu
  #define _UCOMM_P2LDBCLR_REGOFFS32                  0x0000001Fu

  #define _UCOMM_P2LDBCLR_VALUE_MASK                 0xFFFFFFFFu
  #define _UCOMM_P2LDBCLR_VALUE_SHIFT                0
  #define UCOMM_P2LDBCLR_VALUE_DEFAULT               0xFFFFFFFFu
  #define UCOMM_P2LDBCLR_VALUE_OF(x)                 _VALUEOF32(x)
  #define UCOMM_P2LDBCLR_VALUE_CLRALL                0xFFFFFFFFu
  #define _UCOMM_P2LDBCLR_VALUE_CLRALL_SV            0xFFFFFFFFu

  #define UCOMM_P2LDBCLR_OF(val)                     _VALUEOF32(val)
  #define UCOMM_P2LDBCLR_DEFAULT (Uint32)(           \
      _PER_FDEFAULT32(UCOMM,P2LDBCLR,VALUE)          \
  )

  #define UCOMM_P2LDBCLR_RMK(value)                  \
    (Uint32)(                                        \
      _PER_FMK32(UCOMM,P2LDBCLR,VALUE,value)         \
  )

  #define _UCOMM_P2LDBCLR_FGET(FIELD)                \
    _PER_FGET32(_UCOMM_P2LDBCLR_ADDR,                \
      UCOMM,P2LDBCLR,##FIELD)

  #define _UCOMM_P2LDBCLR_FSET(FIELD,field)          \
    _PER_FSET32(_UCOMM_P2LDBCLR_ADDR,                \
      UCOMM,P2LDBCLR,##FIELD,field)

  #define _UCOMM_P2LDBCLR_FSETS(FIELD,SYM)           \
    _PER_FSETS32(_UCOMM_P2LDBCLR_ADDR,               \
      UCOMM,P2LDBCLR,##FIELD,##SYM)

  #define _UCOMM_P2LDBCLR_FGETQ(FIELD,val)           \
    _PER_FGETQ32(_UCOMM_P2LDBCLR_ADDR,               \
      UCOMM,P2LDBCLR,##FIELD,val)

  #define _UCOMM_P2LDBCLR_FGETSQ(FIELD,SYM)          \
    _PER_FGETSQ32(_UCOMM_P2LDBCLR_ADDR,              \
      UCOMM,P2LDBCLR,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_UCOMM_SUPPORT) */
#endif /* _BSL_UCOMMHAL_H_ */
/******************************************************************************\
* End of bsl_ucommhal.h
\******************************************************************************/
