/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral UINT
* FILENAME......... bsl_uint.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 15:27:04
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UINT
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_UINT_H_
#define _BSL_UINT_H_

#include <bsl_uinthal.h>


#if (BSL_UINT_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef BSL_UINT_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

//==============================================================================
// Macro to clear the sticky bit of a single interrupt source from the
// Interrupt Status register at a time.
//
// pararmeters:
//		IT_SOURCE		register field name to select the proper IT source
//						valid:	PCIRSTIA, P2LDBIA, MBOX3IA, MBOX2IA, MBOX1IA,
//								MBOX0IA, PBINT7IA, PBINT6IA, PBTIN1IA, PBTIN0IA,
//								FRYBYIA, SB2IA, SB1IA, SB0IA
//==============================================================================
#define UINT_CLEAR_STATUS_S( IT_SOURCE ) \
	UINT_RFSETS( STATUS, ##IT_SOURCE, CLEAR )

// IT source constants for the UINT_CLEAR_STATUS() macro
#define UINT_STATUS_PCIRSTIA		_UINT_STATUS_PCIRSTIA_MASK
#define UINT_STATUS_P2LDBIA			_UINT_STATUS_P2LDBIA_MASK
#define UINT_STATUS_MBOX3IA			_UINT_STATUS_MBOX3IA_MASK
#define UINT_STATUS_MBOX2IA			_UINT_STATUS_MBOX2IA_MASK
#define UINT_STATUS_MBOX1IA			_UINT_STATUS_MBOX1IA_MASK
#define UINT_STATUS_MBOX0IA			_UINT_STATUS_MBOX0IA_MASK
#define UINT_STATUS_PBINT7IA		_UINT_STATUS_PBINT7IA_MASK
#define UINT_STATUS_PBINT6IA		_UINT_STATUS_PBINT6IA_MASK
#define UINT_STATUS_PBTIN1IA		_UINT_STATUS_PBTIN1IA_MASK
#define UINT_STATUS_PBTIN0IA		_UINT_STATUS_PBTIN0IA_MASK
#define UINT_STATUS_FRYBYIA			_UINT_STATUS_FRYBYIA_MASK
#define UINT_STATUS_SB2IA			_UINT_STATUS_SB2IA_MASK
#define UINT_STATUS_SB1IA			_UINT_STATUS_SB1IA_MASK
#define UINT_STATUS_SB0IA			_UINT_STATUS_SB0IA_MASK

//==============================================================================
// Macro to clear the sticky bits of more interrupt sources from the Interrupt
// Status register at a time.
//
// pararmeters:
//		it_source_mask	value, which defines the proper '1' bits to clear the
//						appropriate IT sources' sticky bits
//						To create the proper value, the UINT_STATUS_x consants
//						can be used OR-ed.
//==============================================================================
#define UINT_CLEAR_STATUS( it_source_mask ) \
	UINT_RSET( STATUS, it_source_mask )


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint16 regPCIITEN;
	Uint16 regEIT4SRC;
	Uint16 regEIT5SRC;
	Uint16 regEIT6SRC;
	Uint16 regEIT7SRC;
} UINT_Config;

/* object structure */
typedef struct {
	Uint32 baseAddr;
} UINT_Obj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI UINT_Obj _UINT_obj;	/* defined in bsl_uint.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/

BSLAPI void UINT_reset();


/******************************************************************************\
* inline function declarations
\******************************************************************************/

IDECL void UINT_config(UINT_Config *config);
IDECL void UINT_configArgs(Uint32 pciiten, Uint32 eit4src, Uint32 eit5src,
	Uint32 eit6src, Uint32 eit7src);
IDECL void UINT_getConfig(UINT_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF void UINT_config(UINT_Config *config)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_UINT_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regPCIITEN;
	r1 = config->regEIT4SRC;
	r2 = config->regEIT5SRC;
	r3 = config->regEIT6SRC;
	r4 = config->regEIT7SRC;
	base[_UINT_PCIITEN_REGOFFS16] = (Uint16)(r0);
	base[_UINT_EIT4SRC_REGOFFS16] = (Uint16)(r1);
	base[_UINT_EIT5SRC_REGOFFS16] = (Uint16)(r2);
	base[_UINT_EIT6SRC_REGOFFS16] = (Uint16)(r3);
	base[_UINT_EIT7SRC_REGOFFS16] = (Uint16)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UINT_configArgs(Uint32 pciiten, Uint32 eit4src, Uint32 eit5src,
	Uint32 eit6src, Uint32 eit7src)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_UINT_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = pciiten;
	r1 = eit4src;
	r2 = eit5src;
	r3 = eit6src;
	r4 = eit7src;
	base[_UINT_PCIITEN_REGOFFS16] = (Uint16)(r0);
	base[_UINT_EIT4SRC_REGOFFS16] = (Uint16)(r1);
	base[_UINT_EIT5SRC_REGOFFS16] = (Uint16)(r2);
	base[_UINT_EIT6SRC_REGOFFS16] = (Uint16)(r3);
	base[_UINT_EIT7SRC_REGOFFS16] = (Uint16)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UINT_getConfig(UINT_Config *config)
{
	Uint32 gie;
	volatile UINT_Config *cfg;
	cfg = (volatile UINT_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regPCIITEN = UINT_RGET(PCIITEN);
	cfg->regEIT4SRC = UINT_RGET(EIT4SRC);
	cfg->regEIT5SRC = UINT_RGET(EIT5SRC);
	cfg->regEIT6SRC = UINT_RGET(EIT6SRC);
	cfg->regEIT7SRC = UINT_RGET(EIT7SRC);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_UINT_SUPPORT */
#endif /* _BSL_UINT_H_ */
/******************************************************************************\
* End of bsl_uint.h
\******************************************************************************/
