/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral UINT
* FILENAME......... bsl_uinthal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 02/20/2004 09:13:10
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UINT
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. UINT is 0x6C080000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* PCIITST     -  PCI Interrupt Status
* PCIITEN     -  PCI Interrupt Enable
* STATUS      -  Interrupt Status (Status Register must be cleared by writing '1')
* EIT4SRC     -  DSP External Interrupt 4 Source Select
* EIT5SRC     -  DSP External Interrupt 5 Source Select
* EIT6SRC     -  DSP External Interrupt 6 Source Select
* EIT7SRC     -  DSP External Interrupt 7 Source Select
*
\******************************************************************************/
#ifndef _BSL_UINTHAL_H_
#define _BSL_UINTHAL_H_

#include <bsl.h>


#if (BSL_UINT_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _UINT_DEVICE_COUNT                         1

  #define _UINT_BASE_ADDRESS                         0x6C080000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define UINT_FMK(REG,FIELD,val)\
    _PER_FMK16(UINT,##REG,##FIELD,val)

  #define UINT_FMKS(REG,FIELD,SYM)\
    _PER_FMKS16(UINT,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define UINT_ADDR(REG)\
    _UINT_##REG##_ADDR

  #define UINT_RGET(REG)\
    _PER_RGET16(_UINT_##REG##_ADDR,UINT,##REG)

  #define UINT_RSET(REG,val)\
    _PER_RSET16(_UINT_##REG##_ADDR,UINT,##REG,val)

  #define UINT_RFSETS(REG,FIELD,SYM)\
    UINT_RSET(##REG,_UINT_##REG##_##FIELD##_##SYM##_SV)

  #define UINT_FGET(REG,FIELD)\
    _UINT_##REG##_FGET(##FIELD)

  #define UINT_FSET(REG,FIELD,val)\
    _UINT_##REG##_FSET(##FIELD,val)

  #define UINT_FSETS(REG,FIELD,SYM)\
    _UINT_##REG##_FSETS(##FIELD,##SYM)

  #define UINT_FGETQ(REG,FIELD,val)\
    _UINT_##REG##_FGETQ(##FIELD,val)

  #define UINT_FGETSQ(REG,FIELD,SYM)\
    _UINT_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define UINT_RGETA(addr,REG)\
    _PER_RGET16(addr,UINT,##REG)

  #define UINT_RSETA(addr,REG,val)\
    _PER_RSET16(addr,UINT,##REG,val)

  #define UINT_RFSETSA(addr,REG,FIELD,SYM)\
    UINT_RSETA(addr,##REG,_UINT_##REG##_##FIELD##_##SYM##_SV)

  #define UINT_FGETA(addr,REG,FIELD)\
    _PER_FGET16(addr,UINT,##REG,##FIELD)

  #define UINT_FSETA(addr,REG,FIELD,val)\
    _PER_FSET16(addr,UINT,##REG,##FIELD,val)

  #define UINT_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS16(addr,UINT,##REG,##FIELD,##SYM)

  #define UINT_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ16(addr,UINT,##REG,##FIELD,val)

  #define UINT_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ16(addr,UINT,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define UINT_VRGET(var,REG)\
    _PER_VRGET16(var,UINT,##REG)

  #define UINT_VRSET(var,REG,val)\
    _PER_VRSET16(var,UINT,##REG,val)

  #define UINT_VRFSETS(var,REG,FIELD,SYM)\
    UINT_VRSET(var,##REG,_UINT_##REG##_##FIELD##_##SYM##_SV)

  #define UINT_VFGET(var,REG,FIELD)\
    _PER_VFGET16(var,UINT,##REG,##FIELD)

  #define UINT_VFSET(var,REG,FIELD,val)\
    _PER_VFSET16(var,UINT,##REG,##FIELD,val)

  #define UINT_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS16(var,UINT,##REG,##FIELD,##SYM)

  #define UINT_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ16(var,UINT,##REG,##FIELD,val)

  #define UINT_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ16(var,UINT,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  P C I I T S T        |
* |_______________________|
*
* PCIITST - PCI Interrupt Status
*
* FIELDS (msb -> lsb)
* (R.)	L2PDBIA   	[ 1: 1]	 - Local-to-PCI Doorbell Interrupt Active
* (R.)	DSPPCIIA  	[ 0: 0]	 - DSP PCI Interrupt (generated by RSTSRC) Active
*
\******************************************************************************/
/*#define _UINT_PCIITST_RECIDX                       No recorded */

  #define _UINT_PCIITST_ADDR                         0x6C08003Cu

  #define _UINT_PCIITST_REGOFFS                      0x0000003Cu
  #define _UINT_PCIITST_REGOFFS16                    0x0000001Eu

  #define _UINT_PCIITST_L2PDBIA_MASK                 0x0002u
  #define _UINT_PCIITST_L2PDBIA_SHIFT                1
  #define UINT_PCIITST_L2PDBIA_DEFAULT               0x0000u
  #define UINT_PCIITST_L2PDBIA_OF(x)                 _VALUEOF16(x)
  #define UINT_PCIITST_L2PDBIA_INACTIVE              0x0000u
  #define UINT_PCIITST_L2PDBIA_ACTIVE                0x0001u
  #define _UINT_PCIITST_L2PDBIA_INACTIVE_SV          0x0000u
  #define _UINT_PCIITST_L2PDBIA_ACTIVE_SV            0x0002u

  #define _UINT_PCIITST_DSPPCIIA_MASK                0x0001u
  #define _UINT_PCIITST_DSPPCIIA_SHIFT               0
  #define UINT_PCIITST_DSPPCIIA_DEFAULT              0x0000u
  #define UINT_PCIITST_DSPPCIIA_OF(x)                _VALUEOF16(x)
  #define UINT_PCIITST_DSPPCIIA_INACTIVE             0x0000u
  #define UINT_PCIITST_DSPPCIIA_ACTIVE               0x0001u
  #define _UINT_PCIITST_DSPPCIIA_INACTIVE_SV         0x0000u
  #define _UINT_PCIITST_DSPPCIIA_ACTIVE_SV           0x0001u

  #define UINT_PCIITST_OF(val)                       _VALUEOF16(val)
  #define UINT_PCIITST_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,PCIITST,L2PDBIA)          \
    | _PER_FDEFAULT16(UINT,PCIITST,DSPPCIIA)         \
  )

  #define _UINT_PCIITST_FGET(FIELD)                  \
    _PER_FGET16(_UINT_PCIITST_ADDR,                  \
      UINT,PCIITST,##FIELD)

  #define _UINT_PCIITST_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_PCIITST_ADDR,                  \
      UINT,PCIITST,##FIELD,field)

  #define _UINT_PCIITST_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_PCIITST_ADDR,                 \
      UINT,PCIITST,##FIELD,##SYM)

  #define _UINT_PCIITST_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_PCIITST_ADDR,                 \
      UINT,PCIITST,##FIELD,val)

  #define _UINT_PCIITST_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_PCIITST_ADDR,                \
      UINT,PCIITST,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P C I I T E N        |
* |_______________________|
*
* PCIITEN - PCI Interrupt Enable
*
* FIELDS (msb -> lsb)
* (RW)	L2PDBIE   	[ 1: 1]	 - Local-to-PCI Doorbell Interrupt Enable
* (RW)	DSPPCIIE  	[ 0: 0]	 - DSP PCI Interrupt (generated by RSTSRC) Enable
*
\******************************************************************************/
/*#define _UINT_PCIITEN_RECIDX                       No recorded */

  #define _UINT_PCIITEN_ADDR                         0x6C08003Eu

  #define _UINT_PCIITEN_REGOFFS                      0x0000003Eu
  #define _UINT_PCIITEN_REGOFFS16                    0x0000001Fu

  #define _UINT_PCIITEN_L2PDBIE_MASK                 0x0002u
  #define _UINT_PCIITEN_L2PDBIE_SHIFT                1
  #define UINT_PCIITEN_L2PDBIE_DEFAULT               0x0000u
  #define UINT_PCIITEN_L2PDBIE_OF(x)                 _VALUEOF16(x)
  #define UINT_PCIITEN_L2PDBIE_DISABLED              0x0000u
  #define UINT_PCIITEN_L2PDBIE_ENABLED               0x0001u
  #define UINT_PCIITEN_L2PDBIE_DISABLE               0x0000u
  #define UINT_PCIITEN_L2PDBIE_ENABLE                0x0001u
  #define _UINT_PCIITEN_L2PDBIE_DISABLED_SV          0x0000u
  #define _UINT_PCIITEN_L2PDBIE_ENABLED_SV           0x0002u
  #define _UINT_PCIITEN_L2PDBIE_DISABLE_SV           0x0000u
  #define _UINT_PCIITEN_L2PDBIE_ENABLE_SV            0x0002u

  #define _UINT_PCIITEN_DSPPCIIE_MASK                0x0001u
  #define _UINT_PCIITEN_DSPPCIIE_SHIFT               0
  #define UINT_PCIITEN_DSPPCIIE_DEFAULT              0x0000u
  #define UINT_PCIITEN_DSPPCIIE_OF(x)                _VALUEOF16(x)
  #define UINT_PCIITEN_DSPPCIIE_DISABLED             0x0000u
  #define UINT_PCIITEN_DSPPCIIE_ENABLED              0x0001u
  #define UINT_PCIITEN_DSPPCIIE_DISABLE              0x0000u
  #define UINT_PCIITEN_DSPPCIIE_ENABLE               0x0001u
  #define _UINT_PCIITEN_DSPPCIIE_DISABLED_SV         0x0000u
  #define _UINT_PCIITEN_DSPPCIIE_ENABLED_SV          0x0001u
  #define _UINT_PCIITEN_DSPPCIIE_DISABLE_SV          0x0000u
  #define _UINT_PCIITEN_DSPPCIIE_ENABLE_SV           0x0001u

  #define UINT_PCIITEN_OF(val)                       _VALUEOF16(val)
  #define UINT_PCIITEN_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,PCIITEN,L2PDBIE)          \
    | _PER_FDEFAULT16(UINT,PCIITEN,DSPPCIIE)         \
  )

  #define UINT_PCIITEN_RMK(l2pdbie,dsppciie)         \
    (Uint16)(                                        \
      _PER_FMK16(UINT,PCIITEN,L2PDBIE,l2pdbie)       \
    | _PER_FMK16(UINT,PCIITEN,DSPPCIIE,dsppciie)     \
  )

  #define _UINT_PCIITEN_FGET(FIELD)                  \
    _PER_FGET16(_UINT_PCIITEN_ADDR,                  \
      UINT,PCIITEN,##FIELD)

  #define _UINT_PCIITEN_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_PCIITEN_ADDR,                  \
      UINT,PCIITEN,##FIELD,field)

  #define _UINT_PCIITEN_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_PCIITEN_ADDR,                 \
      UINT,PCIITEN,##FIELD,##SYM)

  #define _UINT_PCIITEN_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_PCIITEN_ADDR,                 \
      UINT,PCIITEN,##FIELD,val)

  #define _UINT_PCIITEN_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_PCIITEN_ADDR,                \
      UINT,PCIITEN,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  S T A T U S          |
* |_______________________|
*
* STATUS - Interrupt Status (Status Register must be cleared by writing '1')
*
* FIELDS (msb -> lsb)
* (RW)	PCIRSTIA  	[13:13]	 - PCI Reset Interrupt Active
* (RW)	P2LDBIA   	[12:12]	 - PCI-to-Local Doorbell Interrupt Active
* (RW)	MBOX3IA   	[11:11]	 - Mailbox 3 Interrupt Active
* (RW)	MBOX2IA   	[10:10]	 - Mailbox 2 Interrupt Active
* (RW)	MBOX1IA   	[ 9: 9]	 - Mailbox 1 Interrupt Active
* (RW)	MBOX0IA   	[ 8: 8]	 - Mailbox 0 Interrupt Active
* (RW)	PBINT7IA  	[ 7: 7]	 - Platform Bus INT7 (GPI3) Interrupt Active
* (RW)	PBINT6IA  	[ 6: 6]	 - Platform Bus INT6 (GPI2) Interrupt Active
* (RW)	PBTIN1IA  	[ 5: 5]	 - Platform Bus Tin1 (GPI1) Interrupt Active
* (RW)	PBTIN0IA  	[ 4: 4]	 - Platform Bus Tin0 (GPI0) Interrupt Active
* (RW)	FRYBYIA   	[ 3: 3]	 - Flash Ready / Busy# Interrupt Active
* (RW)	SB2IA     	[ 2: 2]	 - Sync Bus 2 Event Interrupt Active
* (RW)	SB1IA     	[ 1: 1]	 - Sync Bus 1 Event Interrupt Active
* (RW)	SB0IA     	[ 0: 0]	 - Sync Bus 0 Event Interrupt Active
*
\******************************************************************************/
/*#define _UINT_STATUS_RECIDX                        No recorded */

  #define _UINT_STATUS_ADDR                          0x6C080044u

  #define _UINT_STATUS_REGOFFS                       0x00000044u
  #define _UINT_STATUS_REGOFFS16                     0x00000022u

  #define _UINT_STATUS_PCIRSTIA_MASK                 0x2000u
  #define _UINT_STATUS_PCIRSTIA_SHIFT                13
  #define UINT_STATUS_PCIRSTIA_DEFAULT               0x0000u
  #define UINT_STATUS_PCIRSTIA_OF(x)                 _VALUEOF16(x)
  #define UINT_STATUS_PCIRSTIA_INACTIVE              0x0000u
  #define UINT_STATUS_PCIRSTIA_ACTIVE                0x0001u
  #define UINT_STATUS_PCIRSTIA_CLEAR                 0x0001u
  #define _UINT_STATUS_PCIRSTIA_INACTIVE_SV          0x0000u
  #define _UINT_STATUS_PCIRSTIA_ACTIVE_SV            0x2000u
  #define _UINT_STATUS_PCIRSTIA_CLEAR_SV             0x2000u

  #define _UINT_STATUS_P2LDBIA_MASK                  0x1000u
  #define _UINT_STATUS_P2LDBIA_SHIFT                 12
  #define UINT_STATUS_P2LDBIA_DEFAULT                0x0000u
  #define UINT_STATUS_P2LDBIA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_P2LDBIA_INACTIVE               0x0000u
  #define UINT_STATUS_P2LDBIA_ACTIVE                 0x0001u
  #define UINT_STATUS_P2LDBIA_CLEAR                  0x0001u
  #define _UINT_STATUS_P2LDBIA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_P2LDBIA_ACTIVE_SV             0x1000u
  #define _UINT_STATUS_P2LDBIA_CLEAR_SV              0x1000u

  #define _UINT_STATUS_MBOX3IA_MASK                  0x0800u
  #define _UINT_STATUS_MBOX3IA_SHIFT                 11
  #define UINT_STATUS_MBOX3IA_DEFAULT                0x0000u
  #define UINT_STATUS_MBOX3IA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_MBOX3IA_INACTIVE               0x0000u
  #define UINT_STATUS_MBOX3IA_ACTIVE                 0x0001u
  #define UINT_STATUS_MBOX3IA_CLEAR                  0x0001u
  #define _UINT_STATUS_MBOX3IA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_MBOX3IA_ACTIVE_SV             0x0800u
  #define _UINT_STATUS_MBOX3IA_CLEAR_SV              0x0800u

  #define _UINT_STATUS_MBOX2IA_MASK                  0x0400u
  #define _UINT_STATUS_MBOX2IA_SHIFT                 10
  #define UINT_STATUS_MBOX2IA_DEFAULT                0x0000u
  #define UINT_STATUS_MBOX2IA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_MBOX2IA_INACTIVE               0x0000u
  #define UINT_STATUS_MBOX2IA_ACTIVE                 0x0001u
  #define UINT_STATUS_MBOX2IA_CLEAR                  0x0001u
  #define _UINT_STATUS_MBOX2IA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_MBOX2IA_ACTIVE_SV             0x0400u
  #define _UINT_STATUS_MBOX2IA_CLEAR_SV              0x0400u

  #define _UINT_STATUS_MBOX1IA_MASK                  0x0200u
  #define _UINT_STATUS_MBOX1IA_SHIFT                 9
  #define UINT_STATUS_MBOX1IA_DEFAULT                0x0000u
  #define UINT_STATUS_MBOX1IA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_MBOX1IA_INACTIVE               0x0000u
  #define UINT_STATUS_MBOX1IA_ACTIVE                 0x0001u
  #define UINT_STATUS_MBOX1IA_CLEAR                  0x0001u
  #define _UINT_STATUS_MBOX1IA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_MBOX1IA_ACTIVE_SV             0x0200u
  #define _UINT_STATUS_MBOX1IA_CLEAR_SV              0x0200u

  #define _UINT_STATUS_MBOX0IA_MASK                  0x0100u
  #define _UINT_STATUS_MBOX0IA_SHIFT                 8
  #define UINT_STATUS_MBOX0IA_DEFAULT                0x0000u
  #define UINT_STATUS_MBOX0IA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_MBOX0IA_INACTIVE               0x0000u
  #define UINT_STATUS_MBOX0IA_ACTIVE                 0x0001u
  #define UINT_STATUS_MBOX0IA_CLEAR                  0x0001u
  #define _UINT_STATUS_MBOX0IA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_MBOX0IA_ACTIVE_SV             0x0100u
  #define _UINT_STATUS_MBOX0IA_CLEAR_SV              0x0100u

  #define _UINT_STATUS_PBINT7IA_MASK                 0x0080u
  #define _UINT_STATUS_PBINT7IA_SHIFT                7
  #define UINT_STATUS_PBINT7IA_DEFAULT               0x0000u
  #define UINT_STATUS_PBINT7IA_OF(x)                 _VALUEOF16(x)
  #define UINT_STATUS_PBINT7IA_INACTIVE              0x0000u
  #define UINT_STATUS_PBINT7IA_ACTIVE                0x0001u
  #define UINT_STATUS_PBINT7IA_CLEAR                 0x0001u
  #define _UINT_STATUS_PBINT7IA_INACTIVE_SV          0x0000u
  #define _UINT_STATUS_PBINT7IA_ACTIVE_SV            0x0080u
  #define _UINT_STATUS_PBINT7IA_CLEAR_SV             0x0080u

  #define _UINT_STATUS_PBINT6IA_MASK                 0x0040u
  #define _UINT_STATUS_PBINT6IA_SHIFT                6
  #define UINT_STATUS_PBINT6IA_DEFAULT               0x0000u
  #define UINT_STATUS_PBINT6IA_OF(x)                 _VALUEOF16(x)
  #define UINT_STATUS_PBINT6IA_INACTIVE              0x0000u
  #define UINT_STATUS_PBINT6IA_ACTIVE                0x0001u
  #define UINT_STATUS_PBINT6IA_CLEAR                 0x0001u
  #define _UINT_STATUS_PBINT6IA_INACTIVE_SV          0x0000u
  #define _UINT_STATUS_PBINT6IA_ACTIVE_SV            0x0040u
  #define _UINT_STATUS_PBINT6IA_CLEAR_SV             0x0040u

  #define _UINT_STATUS_PBTIN1IA_MASK                 0x0020u
  #define _UINT_STATUS_PBTIN1IA_SHIFT                5
  #define UINT_STATUS_PBTIN1IA_DEFAULT               0x0000u
  #define UINT_STATUS_PBTIN1IA_OF(x)                 _VALUEOF16(x)
  #define UINT_STATUS_PBTIN1IA_INACTIVE              0x0000u
  #define UINT_STATUS_PBTIN1IA_ACTIVE                0x0001u
  #define UINT_STATUS_PBTIN1IA_CLEAR                 0x0001u
  #define _UINT_STATUS_PBTIN1IA_INACTIVE_SV          0x0000u
  #define _UINT_STATUS_PBTIN1IA_ACTIVE_SV            0x0020u
  #define _UINT_STATUS_PBTIN1IA_CLEAR_SV             0x0020u

  #define _UINT_STATUS_PBTIN0IA_MASK                 0x0010u
  #define _UINT_STATUS_PBTIN0IA_SHIFT                4
  #define UINT_STATUS_PBTIN0IA_DEFAULT               0x0000u
  #define UINT_STATUS_PBTIN0IA_OF(x)                 _VALUEOF16(x)
  #define UINT_STATUS_PBTIN0IA_INACTIVE              0x0000u
  #define UINT_STATUS_PBTIN0IA_ACTIVE                0x0001u
  #define UINT_STATUS_PBTIN0IA_CLEAR                 0x0001u
  #define _UINT_STATUS_PBTIN0IA_INACTIVE_SV          0x0000u
  #define _UINT_STATUS_PBTIN0IA_ACTIVE_SV            0x0010u
  #define _UINT_STATUS_PBTIN0IA_CLEAR_SV             0x0010u

  #define _UINT_STATUS_FRYBYIA_MASK                  0x0008u
  #define _UINT_STATUS_FRYBYIA_SHIFT                 3
  #define UINT_STATUS_FRYBYIA_DEFAULT                0x0000u
  #define UINT_STATUS_FRYBYIA_OF(x)                  _VALUEOF16(x)
  #define UINT_STATUS_FRYBYIA_INACTIVE               0x0000u
  #define UINT_STATUS_FRYBYIA_ACTIVE                 0x0001u
  #define UINT_STATUS_FRYBYIA_CLEAR                  0x0001u
  #define _UINT_STATUS_FRYBYIA_INACTIVE_SV           0x0000u
  #define _UINT_STATUS_FRYBYIA_ACTIVE_SV             0x0008u
  #define _UINT_STATUS_FRYBYIA_CLEAR_SV              0x0008u

  #define _UINT_STATUS_SB2IA_MASK                    0x0004u
  #define _UINT_STATUS_SB2IA_SHIFT                   2
  #define UINT_STATUS_SB2IA_DEFAULT                  0x0000u
  #define UINT_STATUS_SB2IA_OF(x)                    _VALUEOF16(x)
  #define UINT_STATUS_SB2IA_INACTIVE                 0x0000u
  #define UINT_STATUS_SB2IA_ACTIVE                   0x0001u
  #define UINT_STATUS_SB2IA_CLEAR                    0x0001u
  #define _UINT_STATUS_SB2IA_INACTIVE_SV             0x0000u
  #define _UINT_STATUS_SB2IA_ACTIVE_SV               0x0004u
  #define _UINT_STATUS_SB2IA_CLEAR_SV                0x0004u

  #define _UINT_STATUS_SB1IA_MASK                    0x0002u
  #define _UINT_STATUS_SB1IA_SHIFT                   1
  #define UINT_STATUS_SB1IA_DEFAULT                  0x0000u
  #define UINT_STATUS_SB1IA_OF(x)                    _VALUEOF16(x)
  #define UINT_STATUS_SB1IA_INACTIVE                 0x0000u
  #define UINT_STATUS_SB1IA_ACTIVE                   0x0001u
  #define UINT_STATUS_SB1IA_CLEAR                    0x0001u
  #define _UINT_STATUS_SB1IA_INACTIVE_SV             0x0000u
  #define _UINT_STATUS_SB1IA_ACTIVE_SV               0x0002u
  #define _UINT_STATUS_SB1IA_CLEAR_SV                0x0002u

  #define _UINT_STATUS_SB0IA_MASK                    0x0001u
  #define _UINT_STATUS_SB0IA_SHIFT                   0
  #define UINT_STATUS_SB0IA_DEFAULT                  0x0000u
  #define UINT_STATUS_SB0IA_OF(x)                    _VALUEOF16(x)
  #define UINT_STATUS_SB0IA_INACTIVE                 0x0000u
  #define UINT_STATUS_SB0IA_ACTIVE                   0x0001u
  #define UINT_STATUS_SB0IA_CLEAR                    0x0001u
  #define _UINT_STATUS_SB0IA_INACTIVE_SV             0x0000u
  #define _UINT_STATUS_SB0IA_ACTIVE_SV               0x0001u
  #define _UINT_STATUS_SB0IA_CLEAR_SV                0x0001u

  #define UINT_STATUS_OF(val)                        _VALUEOF16(val)
  #define UINT_STATUS_DEFAULT (Uint16)(              \
      _PER_FDEFAULT16(UINT,STATUS,PCIRSTIA)          \
    | _PER_FDEFAULT16(UINT,STATUS,P2LDBIA)           \
    | _PER_FDEFAULT16(UINT,STATUS,MBOX3IA)           \
    | _PER_FDEFAULT16(UINT,STATUS,MBOX2IA)           \
    | _PER_FDEFAULT16(UINT,STATUS,MBOX1IA)           \
    | _PER_FDEFAULT16(UINT,STATUS,MBOX0IA)           \
    | _PER_FDEFAULT16(UINT,STATUS,PBINT7IA)          \
    | _PER_FDEFAULT16(UINT,STATUS,PBINT6IA)          \
    | _PER_FDEFAULT16(UINT,STATUS,PBTIN1IA)          \
    | _PER_FDEFAULT16(UINT,STATUS,PBTIN0IA)          \
    | _PER_FDEFAULT16(UINT,STATUS,FRYBYIA)           \
    | _PER_FDEFAULT16(UINT,STATUS,SB2IA)             \
    | _PER_FDEFAULT16(UINT,STATUS,SB1IA)             \
    | _PER_FDEFAULT16(UINT,STATUS,SB0IA)             \
  )

  #define UINT_STATUS_RMK(pcirstia,p2ldbia,          \
    mbox3ia,mbox2ia,mbox1ia,mbox0ia,pbint7ia,        \
    pbint6ia,pbtin1ia,pbtin0ia,frybyia,sb2ia,        \
    sb1ia,sb0ia)                                     \
    (Uint16)(                                        \
      _PER_FMK16(UINT,STATUS,PCIRSTIA,pcirstia)      \
    | _PER_FMK16(UINT,STATUS,P2LDBIA,p2ldbia)        \
    | _PER_FMK16(UINT,STATUS,MBOX3IA,mbox3ia)        \
    | _PER_FMK16(UINT,STATUS,MBOX2IA,mbox2ia)        \
    | _PER_FMK16(UINT,STATUS,MBOX1IA,mbox1ia)        \
    | _PER_FMK16(UINT,STATUS,MBOX0IA,mbox0ia)        \
    | _PER_FMK16(UINT,STATUS,PBINT7IA,pbint7ia)      \
    | _PER_FMK16(UINT,STATUS,PBINT6IA,pbint6ia)      \
    | _PER_FMK16(UINT,STATUS,PBTIN1IA,pbtin1ia)      \
    | _PER_FMK16(UINT,STATUS,PBTIN0IA,pbtin0ia)      \
    | _PER_FMK16(UINT,STATUS,FRYBYIA,frybyia)        \
    | _PER_FMK16(UINT,STATUS,SB2IA,sb2ia)            \
    | _PER_FMK16(UINT,STATUS,SB1IA,sb1ia)            \
    | _PER_FMK16(UINT,STATUS,SB0IA,sb0ia)            \
  )

  #define _UINT_STATUS_FGET(FIELD)                   \
    _PER_FGET16(_UINT_STATUS_ADDR,                   \
      UINT,STATUS,##FIELD)

  #define _UINT_STATUS_FSET(FIELD,field)             \
    _PER_FSET16(_UINT_STATUS_ADDR,                   \
      UINT,STATUS,##FIELD,field)

  #define _UINT_STATUS_FSETS(FIELD,SYM)              \
    _PER_FSETS16(_UINT_STATUS_ADDR,                  \
      UINT,STATUS,##FIELD,##SYM)

  #define _UINT_STATUS_FGETQ(FIELD,val)              \
    _PER_FGETQ16(_UINT_STATUS_ADDR,                  \
      UINT,STATUS,##FIELD,val)

  #define _UINT_STATUS_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ16(_UINT_STATUS_ADDR,                 \
      UINT,STATUS,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  E I T 4 S R C        |
* |_______________________|
*
* EIT4SRC - DSP External Interrupt 4 Source Select
*
* FIELDS (msb -> lsb)
* (RW)	PCIRSTIT  	[13:13]	 - PCI Reset Interrupt
* (RW)	P2LDBIT   	[12:12]	 - PCI-to-Local Doorbell Interrupt
* (RW)	MBOX3IT   	[11:11]	 - Mailbox 3 Interrupt
* (RW)	MBOX2IT   	[10:10]	 - Mailbox 2 Interrupt
* (RW)	MBOX1IT   	[ 9: 9]	 - Mailbox 1 Interrupt
* (RW)	MBOX0IT   	[ 8: 8]	 - Mailbox 0 Interrupt
* (RW)	PBINT7IT  	[ 7: 7]	 - Platform Bus INT7 (GPI3) Interrupt
* (RW)	PBINT6IT  	[ 6: 6]	 - Platform Bus INT6 (GPI2) Interrupt
* (RW)	PBTIN1IT  	[ 5: 5]	 - Platform Bus Tin1 (GPI1) Interrupt
* (RW)	PBTIN0IT  	[ 4: 4]	 - Platform Bus Tin0 (GPI0) Interrupt
* (RW)	FRYBYIT   	[ 3: 3]	 - Flash Ready / Busy# Interrupt
* (RW)	SB2IT     	[ 2: 2]	 - Sync Bus 2 Event Interrupt
* (RW)	SB1IT     	[ 1: 1]	 - Sync Bus 1 Event Interrupt
* (RW)	SB0IT     	[ 0: 0]	 - Sync Bus 0 Event Interrupt
*
\******************************************************************************/
/*#define _UINT_EIT4SRC_RECIDX                       No recorded */

  #define _UINT_EIT4SRC_ADDR                         0x6C080048u

  #define _UINT_EIT4SRC_REGOFFS                      0x00000048u
  #define _UINT_EIT4SRC_REGOFFS16                    0x00000024u

  #define _UINT_EIT4SRC_PCIRSTIT_MASK                0x2000u
  #define _UINT_EIT4SRC_PCIRSTIT_SHIFT               13
  #define UINT_EIT4SRC_PCIRSTIT_DEFAULT              0x0000u
  #define UINT_EIT4SRC_PCIRSTIT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT4SRC_PCIRSTIT_DISABLED             0x0000u
  #define UINT_EIT4SRC_PCIRSTIT_ENABLED              0x0001u
  #define UINT_EIT4SRC_PCIRSTIT_DISABLE              0x0000u
  #define UINT_EIT4SRC_PCIRSTIT_ENABLE               0x0001u
  #define _UINT_EIT4SRC_PCIRSTIT_DISABLED_SV         0x0000u
  #define _UINT_EIT4SRC_PCIRSTIT_ENABLED_SV          0x2000u
  #define _UINT_EIT4SRC_PCIRSTIT_DISABLE_SV          0x0000u
  #define _UINT_EIT4SRC_PCIRSTIT_ENABLE_SV           0x2000u

  #define _UINT_EIT4SRC_P2LDBIT_MASK                 0x1000u
  #define _UINT_EIT4SRC_P2LDBIT_SHIFT                12
  #define UINT_EIT4SRC_P2LDBIT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_P2LDBIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_P2LDBIT_DISABLED              0x0000u
  #define UINT_EIT4SRC_P2LDBIT_ENABLED               0x0001u
  #define UINT_EIT4SRC_P2LDBIT_DISABLE               0x0000u
  #define UINT_EIT4SRC_P2LDBIT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_P2LDBIT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_P2LDBIT_ENABLED_SV           0x1000u
  #define _UINT_EIT4SRC_P2LDBIT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_P2LDBIT_ENABLE_SV            0x1000u

  #define _UINT_EIT4SRC_MBOX3IT_MASK                 0x0800u
  #define _UINT_EIT4SRC_MBOX3IT_SHIFT                11
  #define UINT_EIT4SRC_MBOX3IT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_MBOX3IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_MBOX3IT_DISABLED              0x0000u
  #define UINT_EIT4SRC_MBOX3IT_ENABLED               0x0001u
  #define UINT_EIT4SRC_MBOX3IT_DISABLE               0x0000u
  #define UINT_EIT4SRC_MBOX3IT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_MBOX3IT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_MBOX3IT_ENABLED_SV           0x0800u
  #define _UINT_EIT4SRC_MBOX3IT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_MBOX3IT_ENABLE_SV            0x0800u

  #define _UINT_EIT4SRC_MBOX2IT_MASK                 0x0400u
  #define _UINT_EIT4SRC_MBOX2IT_SHIFT                10
  #define UINT_EIT4SRC_MBOX2IT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_MBOX2IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_MBOX2IT_DISABLED              0x0000u
  #define UINT_EIT4SRC_MBOX2IT_ENABLED               0x0001u
  #define UINT_EIT4SRC_MBOX2IT_DISABLE               0x0000u
  #define UINT_EIT4SRC_MBOX2IT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_MBOX2IT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_MBOX2IT_ENABLED_SV           0x0400u
  #define _UINT_EIT4SRC_MBOX2IT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_MBOX2IT_ENABLE_SV            0x0400u

  #define _UINT_EIT4SRC_MBOX1IT_MASK                 0x0200u
  #define _UINT_EIT4SRC_MBOX1IT_SHIFT                9
  #define UINT_EIT4SRC_MBOX1IT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_MBOX1IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_MBOX1IT_DISABLED              0x0000u
  #define UINT_EIT4SRC_MBOX1IT_ENABLED               0x0001u
  #define UINT_EIT4SRC_MBOX1IT_DISABLE               0x0000u
  #define UINT_EIT4SRC_MBOX1IT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_MBOX1IT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_MBOX1IT_ENABLED_SV           0x0200u
  #define _UINT_EIT4SRC_MBOX1IT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_MBOX1IT_ENABLE_SV            0x0200u

  #define _UINT_EIT4SRC_MBOX0IT_MASK                 0x0100u
  #define _UINT_EIT4SRC_MBOX0IT_SHIFT                8
  #define UINT_EIT4SRC_MBOX0IT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_MBOX0IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_MBOX0IT_DISABLED              0x0000u
  #define UINT_EIT4SRC_MBOX0IT_ENABLED               0x0001u
  #define UINT_EIT4SRC_MBOX0IT_DISABLE               0x0000u
  #define UINT_EIT4SRC_MBOX0IT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_MBOX0IT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_MBOX0IT_ENABLED_SV           0x0100u
  #define _UINT_EIT4SRC_MBOX0IT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_MBOX0IT_ENABLE_SV            0x0100u

  #define _UINT_EIT4SRC_PBINT7IT_MASK                0x0080u
  #define _UINT_EIT4SRC_PBINT7IT_SHIFT               7
  #define UINT_EIT4SRC_PBINT7IT_DEFAULT              0x0000u
  #define UINT_EIT4SRC_PBINT7IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT4SRC_PBINT7IT_DISABLED             0x0000u
  #define UINT_EIT4SRC_PBINT7IT_ENABLED              0x0001u
  #define UINT_EIT4SRC_PBINT7IT_DISABLE              0x0000u
  #define UINT_EIT4SRC_PBINT7IT_ENABLE               0x0001u
  #define _UINT_EIT4SRC_PBINT7IT_DISABLED_SV         0x0000u
  #define _UINT_EIT4SRC_PBINT7IT_ENABLED_SV          0x0080u
  #define _UINT_EIT4SRC_PBINT7IT_DISABLE_SV          0x0000u
  #define _UINT_EIT4SRC_PBINT7IT_ENABLE_SV           0x0080u

  #define _UINT_EIT4SRC_PBINT6IT_MASK                0x0040u
  #define _UINT_EIT4SRC_PBINT6IT_SHIFT               6
  #define UINT_EIT4SRC_PBINT6IT_DEFAULT              0x0000u
  #define UINT_EIT4SRC_PBINT6IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT4SRC_PBINT6IT_DISABLED             0x0000u
  #define UINT_EIT4SRC_PBINT6IT_ENABLED              0x0001u
  #define UINT_EIT4SRC_PBINT6IT_DISABLE              0x0000u
  #define UINT_EIT4SRC_PBINT6IT_ENABLE               0x0001u
  #define _UINT_EIT4SRC_PBINT6IT_DISABLED_SV         0x0000u
  #define _UINT_EIT4SRC_PBINT6IT_ENABLED_SV          0x0040u
  #define _UINT_EIT4SRC_PBINT6IT_DISABLE_SV          0x0000u
  #define _UINT_EIT4SRC_PBINT6IT_ENABLE_SV           0x0040u

  #define _UINT_EIT4SRC_PBTIN1IT_MASK                0x0020u
  #define _UINT_EIT4SRC_PBTIN1IT_SHIFT               5
  #define UINT_EIT4SRC_PBTIN1IT_DEFAULT              0x0000u
  #define UINT_EIT4SRC_PBTIN1IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT4SRC_PBTIN1IT_DISABLED             0x0000u
  #define UINT_EIT4SRC_PBTIN1IT_ENABLED              0x0001u
  #define UINT_EIT4SRC_PBTIN1IT_DISABLE              0x0000u
  #define UINT_EIT4SRC_PBTIN1IT_ENABLE               0x0001u
  #define _UINT_EIT4SRC_PBTIN1IT_DISABLED_SV         0x0000u
  #define _UINT_EIT4SRC_PBTIN1IT_ENABLED_SV          0x0020u
  #define _UINT_EIT4SRC_PBTIN1IT_DISABLE_SV          0x0000u
  #define _UINT_EIT4SRC_PBTIN1IT_ENABLE_SV           0x0020u

  #define _UINT_EIT4SRC_PBTIN0IT_MASK                0x0010u
  #define _UINT_EIT4SRC_PBTIN0IT_SHIFT               4
  #define UINT_EIT4SRC_PBTIN0IT_DEFAULT              0x0000u
  #define UINT_EIT4SRC_PBTIN0IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT4SRC_PBTIN0IT_DISABLED             0x0000u
  #define UINT_EIT4SRC_PBTIN0IT_ENABLED              0x0001u
  #define UINT_EIT4SRC_PBTIN0IT_DISABLE              0x0000u
  #define UINT_EIT4SRC_PBTIN0IT_ENABLE               0x0001u
  #define _UINT_EIT4SRC_PBTIN0IT_DISABLED_SV         0x0000u
  #define _UINT_EIT4SRC_PBTIN0IT_ENABLED_SV          0x0010u
  #define _UINT_EIT4SRC_PBTIN0IT_DISABLE_SV          0x0000u
  #define _UINT_EIT4SRC_PBTIN0IT_ENABLE_SV           0x0010u

  #define _UINT_EIT4SRC_FRYBYIT_MASK                 0x0008u
  #define _UINT_EIT4SRC_FRYBYIT_SHIFT                3
  #define UINT_EIT4SRC_FRYBYIT_DEFAULT               0x0000u
  #define UINT_EIT4SRC_FRYBYIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT4SRC_FRYBYIT_DISABLED              0x0000u
  #define UINT_EIT4SRC_FRYBYIT_ENABLED               0x0001u
  #define UINT_EIT4SRC_FRYBYIT_DISABLE               0x0000u
  #define UINT_EIT4SRC_FRYBYIT_ENABLE                0x0001u
  #define _UINT_EIT4SRC_FRYBYIT_DISABLED_SV          0x0000u
  #define _UINT_EIT4SRC_FRYBYIT_ENABLED_SV           0x0008u
  #define _UINT_EIT4SRC_FRYBYIT_DISABLE_SV           0x0000u
  #define _UINT_EIT4SRC_FRYBYIT_ENABLE_SV            0x0008u

  #define _UINT_EIT4SRC_SB2IT_MASK                   0x0004u
  #define _UINT_EIT4SRC_SB2IT_SHIFT                  2
  #define UINT_EIT4SRC_SB2IT_DEFAULT                 0x0000u
  #define UINT_EIT4SRC_SB2IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT4SRC_SB2IT_DISABLED                0x0000u
  #define UINT_EIT4SRC_SB2IT_ENABLED                 0x0001u
  #define UINT_EIT4SRC_SB2IT_DISABLE                 0x0000u
  #define UINT_EIT4SRC_SB2IT_ENABLE                  0x0001u
  #define _UINT_EIT4SRC_SB2IT_DISABLED_SV            0x0000u
  #define _UINT_EIT4SRC_SB2IT_ENABLED_SV             0x0004u
  #define _UINT_EIT4SRC_SB2IT_DISABLE_SV             0x0000u
  #define _UINT_EIT4SRC_SB2IT_ENABLE_SV              0x0004u

  #define _UINT_EIT4SRC_SB1IT_MASK                   0x0002u
  #define _UINT_EIT4SRC_SB1IT_SHIFT                  1
  #define UINT_EIT4SRC_SB1IT_DEFAULT                 0x0000u
  #define UINT_EIT4SRC_SB1IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT4SRC_SB1IT_DISABLED                0x0000u
  #define UINT_EIT4SRC_SB1IT_ENABLED                 0x0001u
  #define UINT_EIT4SRC_SB1IT_DISABLE                 0x0000u
  #define UINT_EIT4SRC_SB1IT_ENABLE                  0x0001u
  #define _UINT_EIT4SRC_SB1IT_DISABLED_SV            0x0000u
  #define _UINT_EIT4SRC_SB1IT_ENABLED_SV             0x0002u
  #define _UINT_EIT4SRC_SB1IT_DISABLE_SV             0x0000u
  #define _UINT_EIT4SRC_SB1IT_ENABLE_SV              0x0002u

  #define _UINT_EIT4SRC_SB0IT_MASK                   0x0001u
  #define _UINT_EIT4SRC_SB0IT_SHIFT                  0
  #define UINT_EIT4SRC_SB0IT_DEFAULT                 0x0000u
  #define UINT_EIT4SRC_SB0IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT4SRC_SB0IT_DISABLED                0x0000u
  #define UINT_EIT4SRC_SB0IT_ENABLED                 0x0001u
  #define UINT_EIT4SRC_SB0IT_DISABLE                 0x0000u
  #define UINT_EIT4SRC_SB0IT_ENABLE                  0x0001u
  #define _UINT_EIT4SRC_SB0IT_DISABLED_SV            0x0000u
  #define _UINT_EIT4SRC_SB0IT_ENABLED_SV             0x0001u
  #define _UINT_EIT4SRC_SB0IT_DISABLE_SV             0x0000u
  #define _UINT_EIT4SRC_SB0IT_ENABLE_SV              0x0001u

  #define UINT_EIT4SRC_OF(val)                       _VALUEOF16(val)
  #define UINT_EIT4SRC_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,EIT4SRC,PCIRSTIT)         \
    | _PER_FDEFAULT16(UINT,EIT4SRC,P2LDBIT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,MBOX3IT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,MBOX2IT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,MBOX1IT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,MBOX0IT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,PBINT7IT)         \
    | _PER_FDEFAULT16(UINT,EIT4SRC,PBINT6IT)         \
    | _PER_FDEFAULT16(UINT,EIT4SRC,PBTIN1IT)         \
    | _PER_FDEFAULT16(UINT,EIT4SRC,PBTIN0IT)         \
    | _PER_FDEFAULT16(UINT,EIT4SRC,FRYBYIT)          \
    | _PER_FDEFAULT16(UINT,EIT4SRC,SB2IT)            \
    | _PER_FDEFAULT16(UINT,EIT4SRC,SB1IT)            \
    | _PER_FDEFAULT16(UINT,EIT4SRC,SB0IT)            \
  )

  #define UINT_EIT4SRC_RMK(pcirstit,p2ldbit,         \
    mbox3it,mbox2it,mbox1it,mbox0it,pbint7it,        \
    pbint6it,pbtin1it,pbtin0it,frybyit,sb2it,        \
    sb1it,sb0it)                                     \
    (Uint16)(                                        \
      _PER_FMK16(UINT,EIT4SRC,PCIRSTIT,pcirstit)     \
    | _PER_FMK16(UINT,EIT4SRC,P2LDBIT,p2ldbit)       \
    | _PER_FMK16(UINT,EIT4SRC,MBOX3IT,mbox3it)       \
    | _PER_FMK16(UINT,EIT4SRC,MBOX2IT,mbox2it)       \
    | _PER_FMK16(UINT,EIT4SRC,MBOX1IT,mbox1it)       \
    | _PER_FMK16(UINT,EIT4SRC,MBOX0IT,mbox0it)       \
    | _PER_FMK16(UINT,EIT4SRC,PBINT7IT,pbint7it)     \
    | _PER_FMK16(UINT,EIT4SRC,PBINT6IT,pbint6it)     \
    | _PER_FMK16(UINT,EIT4SRC,PBTIN1IT,pbtin1it)     \
    | _PER_FMK16(UINT,EIT4SRC,PBTIN0IT,pbtin0it)     \
    | _PER_FMK16(UINT,EIT4SRC,FRYBYIT,frybyit)       \
    | _PER_FMK16(UINT,EIT4SRC,SB2IT,sb2it)           \
    | _PER_FMK16(UINT,EIT4SRC,SB1IT,sb1it)           \
    | _PER_FMK16(UINT,EIT4SRC,SB0IT,sb0it)           \
  )

  #define _UINT_EIT4SRC_FGET(FIELD)                  \
    _PER_FGET16(_UINT_EIT4SRC_ADDR,                  \
      UINT,EIT4SRC,##FIELD)

  #define _UINT_EIT4SRC_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_EIT4SRC_ADDR,                  \
      UINT,EIT4SRC,##FIELD,field)

  #define _UINT_EIT4SRC_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_EIT4SRC_ADDR,                 \
      UINT,EIT4SRC,##FIELD,##SYM)

  #define _UINT_EIT4SRC_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_EIT4SRC_ADDR,                 \
      UINT,EIT4SRC,##FIELD,val)

  #define _UINT_EIT4SRC_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_EIT4SRC_ADDR,                \
      UINT,EIT4SRC,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  E I T 5 S R C        |
* |_______________________|
*
* EIT5SRC - DSP External Interrupt 5 Source Select
*
* FIELDS (msb -> lsb)
* (RW)	PCIRSTIT  	[13:13]	 - PCI Reset Interrupt
* (RW)	P2LDBIT   	[12:12]	 - PCI-to-Local Doorbell Interrupt
* (RW)	MBOX3IT   	[11:11]	 - Mailbox 3 Interrupt
* (RW)	MBOX2IT   	[10:10]	 - Mailbox 2 Interrupt
* (RW)	MBOX1IT   	[ 9: 9]	 - Mailbox 1 Interrupt
* (RW)	MBOX0IT   	[ 8: 8]	 - Mailbox 0 Interrupt
* (RW)	PBINT7IT  	[ 7: 7]	 - Platform Bus INT7 (GPI3) Interrupt
* (RW)	PBINT6IT  	[ 6: 6]	 - Platform Bus INT6 (GPI2) Interrupt
* (RW)	PBTIN1IT  	[ 5: 5]	 - Platform Bus Tin1 (GPI1) Interrupt
* (RW)	PBTIN0IT  	[ 4: 4]	 - Platform Bus Tin0 (GPI0) Interrupt
* (RW)	FRYBYIT   	[ 3: 3]	 - Flash Ready / Busy# Interrupt
* (RW)	SB2IT     	[ 2: 2]	 - Sync Bus 2 Event Interrupt
* (RW)	SB1IT     	[ 1: 1]	 - Sync Bus 1 Event Interrupt
* (RW)	SB0IT     	[ 0: 0]	 - Sync Bus 0 Event Interrupt
*
\******************************************************************************/
/*#define _UINT_EIT5SRC_RECIDX                       No recorded */

  #define _UINT_EIT5SRC_ADDR                         0x6C08004Cu

  #define _UINT_EIT5SRC_REGOFFS                      0x0000004Cu
  #define _UINT_EIT5SRC_REGOFFS16                    0x00000026u

  #define _UINT_EIT5SRC_PCIRSTIT_MASK                0x2000u
  #define _UINT_EIT5SRC_PCIRSTIT_SHIFT               13
  #define UINT_EIT5SRC_PCIRSTIT_DEFAULT              0x0000u
  #define UINT_EIT5SRC_PCIRSTIT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT5SRC_PCIRSTIT_DISABLED             0x0000u
  #define UINT_EIT5SRC_PCIRSTIT_ENABLED              0x0001u
  #define UINT_EIT5SRC_PCIRSTIT_DISABLE              0x0000u
  #define UINT_EIT5SRC_PCIRSTIT_ENABLE               0x0001u
  #define _UINT_EIT5SRC_PCIRSTIT_DISABLED_SV         0x0000u
  #define _UINT_EIT5SRC_PCIRSTIT_ENABLED_SV          0x2000u
  #define _UINT_EIT5SRC_PCIRSTIT_DISABLE_SV          0x0000u
  #define _UINT_EIT5SRC_PCIRSTIT_ENABLE_SV           0x2000u

  #define _UINT_EIT5SRC_P2LDBIT_MASK                 0x1000u
  #define _UINT_EIT5SRC_P2LDBIT_SHIFT                12
  #define UINT_EIT5SRC_P2LDBIT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_P2LDBIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_P2LDBIT_DISABLED              0x0000u
  #define UINT_EIT5SRC_P2LDBIT_ENABLED               0x0001u
  #define UINT_EIT5SRC_P2LDBIT_DISABLE               0x0000u
  #define UINT_EIT5SRC_P2LDBIT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_P2LDBIT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_P2LDBIT_ENABLED_SV           0x1000u
  #define _UINT_EIT5SRC_P2LDBIT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_P2LDBIT_ENABLE_SV            0x1000u

  #define _UINT_EIT5SRC_MBOX3IT_MASK                 0x0800u
  #define _UINT_EIT5SRC_MBOX3IT_SHIFT                11
  #define UINT_EIT5SRC_MBOX3IT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_MBOX3IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_MBOX3IT_DISABLED              0x0000u
  #define UINT_EIT5SRC_MBOX3IT_ENABLED               0x0001u
  #define UINT_EIT5SRC_MBOX3IT_DISABLE               0x0000u
  #define UINT_EIT5SRC_MBOX3IT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_MBOX3IT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_MBOX3IT_ENABLED_SV           0x0800u
  #define _UINT_EIT5SRC_MBOX3IT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_MBOX3IT_ENABLE_SV            0x0800u

  #define _UINT_EIT5SRC_MBOX2IT_MASK                 0x0400u
  #define _UINT_EIT5SRC_MBOX2IT_SHIFT                10
  #define UINT_EIT5SRC_MBOX2IT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_MBOX2IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_MBOX2IT_DISABLED              0x0000u
  #define UINT_EIT5SRC_MBOX2IT_ENABLED               0x0001u
  #define UINT_EIT5SRC_MBOX2IT_DISABLE               0x0000u
  #define UINT_EIT5SRC_MBOX2IT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_MBOX2IT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_MBOX2IT_ENABLED_SV           0x0400u
  #define _UINT_EIT5SRC_MBOX2IT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_MBOX2IT_ENABLE_SV            0x0400u

  #define _UINT_EIT5SRC_MBOX1IT_MASK                 0x0200u
  #define _UINT_EIT5SRC_MBOX1IT_SHIFT                9
  #define UINT_EIT5SRC_MBOX1IT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_MBOX1IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_MBOX1IT_DISABLED              0x0000u
  #define UINT_EIT5SRC_MBOX1IT_ENABLED               0x0001u
  #define UINT_EIT5SRC_MBOX1IT_DISABLE               0x0000u
  #define UINT_EIT5SRC_MBOX1IT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_MBOX1IT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_MBOX1IT_ENABLED_SV           0x0200u
  #define _UINT_EIT5SRC_MBOX1IT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_MBOX1IT_ENABLE_SV            0x0200u

  #define _UINT_EIT5SRC_MBOX0IT_MASK                 0x0100u
  #define _UINT_EIT5SRC_MBOX0IT_SHIFT                8
  #define UINT_EIT5SRC_MBOX0IT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_MBOX0IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_MBOX0IT_DISABLED              0x0000u
  #define UINT_EIT5SRC_MBOX0IT_ENABLED               0x0001u
  #define UINT_EIT5SRC_MBOX0IT_DISABLE               0x0000u
  #define UINT_EIT5SRC_MBOX0IT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_MBOX0IT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_MBOX0IT_ENABLED_SV           0x0100u
  #define _UINT_EIT5SRC_MBOX0IT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_MBOX0IT_ENABLE_SV            0x0100u

  #define _UINT_EIT5SRC_PBINT7IT_MASK                0x0080u
  #define _UINT_EIT5SRC_PBINT7IT_SHIFT               7
  #define UINT_EIT5SRC_PBINT7IT_DEFAULT              0x0000u
  #define UINT_EIT5SRC_PBINT7IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT5SRC_PBINT7IT_DISABLED             0x0000u
  #define UINT_EIT5SRC_PBINT7IT_ENABLED              0x0001u
  #define UINT_EIT5SRC_PBINT7IT_DISABLE              0x0000u
  #define UINT_EIT5SRC_PBINT7IT_ENABLE               0x0001u
  #define _UINT_EIT5SRC_PBINT7IT_DISABLED_SV         0x0000u
  #define _UINT_EIT5SRC_PBINT7IT_ENABLED_SV          0x0080u
  #define _UINT_EIT5SRC_PBINT7IT_DISABLE_SV          0x0000u
  #define _UINT_EIT5SRC_PBINT7IT_ENABLE_SV           0x0080u

  #define _UINT_EIT5SRC_PBINT6IT_MASK                0x0040u
  #define _UINT_EIT5SRC_PBINT6IT_SHIFT               6
  #define UINT_EIT5SRC_PBINT6IT_DEFAULT              0x0000u
  #define UINT_EIT5SRC_PBINT6IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT5SRC_PBINT6IT_DISABLED             0x0000u
  #define UINT_EIT5SRC_PBINT6IT_ENABLED              0x0001u
  #define UINT_EIT5SRC_PBINT6IT_DISABLE              0x0000u
  #define UINT_EIT5SRC_PBINT6IT_ENABLE               0x0001u
  #define _UINT_EIT5SRC_PBINT6IT_DISABLED_SV         0x0000u
  #define _UINT_EIT5SRC_PBINT6IT_ENABLED_SV          0x0040u
  #define _UINT_EIT5SRC_PBINT6IT_DISABLE_SV          0x0000u
  #define _UINT_EIT5SRC_PBINT6IT_ENABLE_SV           0x0040u

  #define _UINT_EIT5SRC_PBTIN1IT_MASK                0x0020u
  #define _UINT_EIT5SRC_PBTIN1IT_SHIFT               5
  #define UINT_EIT5SRC_PBTIN1IT_DEFAULT              0x0000u
  #define UINT_EIT5SRC_PBTIN1IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT5SRC_PBTIN1IT_DISABLED             0x0000u
  #define UINT_EIT5SRC_PBTIN1IT_ENABLED              0x0001u
  #define UINT_EIT5SRC_PBTIN1IT_DISABLE              0x0000u
  #define UINT_EIT5SRC_PBTIN1IT_ENABLE               0x0001u
  #define _UINT_EIT5SRC_PBTIN1IT_DISABLED_SV         0x0000u
  #define _UINT_EIT5SRC_PBTIN1IT_ENABLED_SV          0x0020u
  #define _UINT_EIT5SRC_PBTIN1IT_DISABLE_SV          0x0000u
  #define _UINT_EIT5SRC_PBTIN1IT_ENABLE_SV           0x0020u

  #define _UINT_EIT5SRC_PBTIN0IT_MASK                0x0010u
  #define _UINT_EIT5SRC_PBTIN0IT_SHIFT               4
  #define UINT_EIT5SRC_PBTIN0IT_DEFAULT              0x0000u
  #define UINT_EIT5SRC_PBTIN0IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT5SRC_PBTIN0IT_DISABLED             0x0000u
  #define UINT_EIT5SRC_PBTIN0IT_ENABLED              0x0001u
  #define UINT_EIT5SRC_PBTIN0IT_DISABLE              0x0000u
  #define UINT_EIT5SRC_PBTIN0IT_ENABLE               0x0001u
  #define _UINT_EIT5SRC_PBTIN0IT_DISABLED_SV         0x0000u
  #define _UINT_EIT5SRC_PBTIN0IT_ENABLED_SV          0x0010u
  #define _UINT_EIT5SRC_PBTIN0IT_DISABLE_SV          0x0000u
  #define _UINT_EIT5SRC_PBTIN0IT_ENABLE_SV           0x0010u

  #define _UINT_EIT5SRC_FRYBYIT_MASK                 0x0008u
  #define _UINT_EIT5SRC_FRYBYIT_SHIFT                3
  #define UINT_EIT5SRC_FRYBYIT_DEFAULT               0x0000u
  #define UINT_EIT5SRC_FRYBYIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT5SRC_FRYBYIT_DISABLED              0x0000u
  #define UINT_EIT5SRC_FRYBYIT_ENABLED               0x0001u
  #define UINT_EIT5SRC_FRYBYIT_DISABLE               0x0000u
  #define UINT_EIT5SRC_FRYBYIT_ENABLE                0x0001u
  #define _UINT_EIT5SRC_FRYBYIT_DISABLED_SV          0x0000u
  #define _UINT_EIT5SRC_FRYBYIT_ENABLED_SV           0x0008u
  #define _UINT_EIT5SRC_FRYBYIT_DISABLE_SV           0x0000u
  #define _UINT_EIT5SRC_FRYBYIT_ENABLE_SV            0x0008u

  #define _UINT_EIT5SRC_SB2IT_MASK                   0x0004u
  #define _UINT_EIT5SRC_SB2IT_SHIFT                  2
  #define UINT_EIT5SRC_SB2IT_DEFAULT                 0x0000u
  #define UINT_EIT5SRC_SB2IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT5SRC_SB2IT_DISABLED                0x0000u
  #define UINT_EIT5SRC_SB2IT_ENABLED                 0x0001u
  #define UINT_EIT5SRC_SB2IT_DISABLE                 0x0000u
  #define UINT_EIT5SRC_SB2IT_ENABLE                  0x0001u
  #define _UINT_EIT5SRC_SB2IT_DISABLED_SV            0x0000u
  #define _UINT_EIT5SRC_SB2IT_ENABLED_SV             0x0004u
  #define _UINT_EIT5SRC_SB2IT_DISABLE_SV             0x0000u
  #define _UINT_EIT5SRC_SB2IT_ENABLE_SV              0x0004u

  #define _UINT_EIT5SRC_SB1IT_MASK                   0x0002u
  #define _UINT_EIT5SRC_SB1IT_SHIFT                  1
  #define UINT_EIT5SRC_SB1IT_DEFAULT                 0x0000u
  #define UINT_EIT5SRC_SB1IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT5SRC_SB1IT_DISABLED                0x0000u
  #define UINT_EIT5SRC_SB1IT_ENABLED                 0x0001u
  #define UINT_EIT5SRC_SB1IT_DISABLE                 0x0000u
  #define UINT_EIT5SRC_SB1IT_ENABLE                  0x0001u
  #define _UINT_EIT5SRC_SB1IT_DISABLED_SV            0x0000u
  #define _UINT_EIT5SRC_SB1IT_ENABLED_SV             0x0002u
  #define _UINT_EIT5SRC_SB1IT_DISABLE_SV             0x0000u
  #define _UINT_EIT5SRC_SB1IT_ENABLE_SV              0x0002u

  #define _UINT_EIT5SRC_SB0IT_MASK                   0x0001u
  #define _UINT_EIT5SRC_SB0IT_SHIFT                  0
  #define UINT_EIT5SRC_SB0IT_DEFAULT                 0x0000u
  #define UINT_EIT5SRC_SB0IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT5SRC_SB0IT_DISABLED                0x0000u
  #define UINT_EIT5SRC_SB0IT_ENABLED                 0x0001u
  #define UINT_EIT5SRC_SB0IT_DISABLE                 0x0000u
  #define UINT_EIT5SRC_SB0IT_ENABLE                  0x0001u
  #define _UINT_EIT5SRC_SB0IT_DISABLED_SV            0x0000u
  #define _UINT_EIT5SRC_SB0IT_ENABLED_SV             0x0001u
  #define _UINT_EIT5SRC_SB0IT_DISABLE_SV             0x0000u
  #define _UINT_EIT5SRC_SB0IT_ENABLE_SV              0x0001u

  #define UINT_EIT5SRC_OF(val)                       _VALUEOF16(val)
  #define UINT_EIT5SRC_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,EIT5SRC,PCIRSTIT)         \
    | _PER_FDEFAULT16(UINT,EIT5SRC,P2LDBIT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,MBOX3IT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,MBOX2IT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,MBOX1IT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,MBOX0IT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,PBINT7IT)         \
    | _PER_FDEFAULT16(UINT,EIT5SRC,PBINT6IT)         \
    | _PER_FDEFAULT16(UINT,EIT5SRC,PBTIN1IT)         \
    | _PER_FDEFAULT16(UINT,EIT5SRC,PBTIN0IT)         \
    | _PER_FDEFAULT16(UINT,EIT5SRC,FRYBYIT)          \
    | _PER_FDEFAULT16(UINT,EIT5SRC,SB2IT)            \
    | _PER_FDEFAULT16(UINT,EIT5SRC,SB1IT)            \
    | _PER_FDEFAULT16(UINT,EIT5SRC,SB0IT)            \
  )

  #define UINT_EIT5SRC_RMK(pcirstit,p2ldbit,         \
    mbox3it,mbox2it,mbox1it,mbox0it,pbint7it,        \
    pbint6it,pbtin1it,pbtin0it,frybyit,sb2it,        \
    sb1it,sb0it)                                     \
    (Uint16)(                                        \
      _PER_FMK16(UINT,EIT5SRC,PCIRSTIT,pcirstit)     \
    | _PER_FMK16(UINT,EIT5SRC,P2LDBIT,p2ldbit)       \
    | _PER_FMK16(UINT,EIT5SRC,MBOX3IT,mbox3it)       \
    | _PER_FMK16(UINT,EIT5SRC,MBOX2IT,mbox2it)       \
    | _PER_FMK16(UINT,EIT5SRC,MBOX1IT,mbox1it)       \
    | _PER_FMK16(UINT,EIT5SRC,MBOX0IT,mbox0it)       \
    | _PER_FMK16(UINT,EIT5SRC,PBINT7IT,pbint7it)     \
    | _PER_FMK16(UINT,EIT5SRC,PBINT6IT,pbint6it)     \
    | _PER_FMK16(UINT,EIT5SRC,PBTIN1IT,pbtin1it)     \
    | _PER_FMK16(UINT,EIT5SRC,PBTIN0IT,pbtin0it)     \
    | _PER_FMK16(UINT,EIT5SRC,FRYBYIT,frybyit)       \
    | _PER_FMK16(UINT,EIT5SRC,SB2IT,sb2it)           \
    | _PER_FMK16(UINT,EIT5SRC,SB1IT,sb1it)           \
    | _PER_FMK16(UINT,EIT5SRC,SB0IT,sb0it)           \
  )

  #define _UINT_EIT5SRC_FGET(FIELD)                  \
    _PER_FGET16(_UINT_EIT5SRC_ADDR,                  \
      UINT,EIT5SRC,##FIELD)

  #define _UINT_EIT5SRC_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_EIT5SRC_ADDR,                  \
      UINT,EIT5SRC,##FIELD,field)

  #define _UINT_EIT5SRC_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_EIT5SRC_ADDR,                 \
      UINT,EIT5SRC,##FIELD,##SYM)

  #define _UINT_EIT5SRC_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_EIT5SRC_ADDR,                 \
      UINT,EIT5SRC,##FIELD,val)

  #define _UINT_EIT5SRC_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_EIT5SRC_ADDR,                \
      UINT,EIT5SRC,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  E I T 6 S R C        |
* |_______________________|
*
* EIT6SRC - DSP External Interrupt 6 Source Select
*
* FIELDS (msb -> lsb)
* (RW)	PCIRSTIT  	[13:13]	 - PCI Reset Interrupt
* (RW)	P2LDBIT   	[12:12]	 - PCI-to-Local Doorbell Interrupt
* (RW)	MBOX3IT   	[11:11]	 - Mailbox 3 Interrupt
* (RW)	MBOX2IT   	[10:10]	 - Mailbox 2 Interrupt
* (RW)	MBOX1IT   	[ 9: 9]	 - Mailbox 1 Interrupt
* (RW)	MBOX0IT   	[ 8: 8]	 - Mailbox 0 Interrupt
* (RW)	PBINT7IT  	[ 7: 7]	 - Platform Bus INT7 (GPI3) Interrupt
* (RW)	PBINT6IT  	[ 6: 6]	 - Platform Bus INT6 (GPI2) Interrupt
* (RW)	PBTIN1IT  	[ 5: 5]	 - Platform Bus Tin1 (GPI1) Interrupt
* (RW)	PBTIN0IT  	[ 4: 4]	 - Platform Bus Tin0 (GPI0) Interrupt
* (RW)	FRYBYIT   	[ 3: 3]	 - Flash Ready / Busy# Interrupt
* (RW)	SB2IT     	[ 2: 2]	 - Sync Bus 2 Event Interrupt
* (RW)	SB1IT     	[ 1: 1]	 - Sync Bus 1 Event Interrupt
* (RW)	SB0IT     	[ 0: 0]	 - Sync Bus 0 Event Interrupt
*
\******************************************************************************/
/*#define _UINT_EIT6SRC_RECIDX                       No recorded */

  #define _UINT_EIT6SRC_ADDR                         0x6C080050u

  #define _UINT_EIT6SRC_REGOFFS                      0x00000050u
  #define _UINT_EIT6SRC_REGOFFS16                    0x00000028u

  #define _UINT_EIT6SRC_PCIRSTIT_MASK                0x2000u
  #define _UINT_EIT6SRC_PCIRSTIT_SHIFT               13
  #define UINT_EIT6SRC_PCIRSTIT_DEFAULT              0x0000u
  #define UINT_EIT6SRC_PCIRSTIT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT6SRC_PCIRSTIT_DISABLED             0x0000u
  #define UINT_EIT6SRC_PCIRSTIT_ENABLED              0x0001u
  #define UINT_EIT6SRC_PCIRSTIT_DISABLE              0x0000u
  #define UINT_EIT6SRC_PCIRSTIT_ENABLE               0x0001u
  #define _UINT_EIT6SRC_PCIRSTIT_DISABLED_SV         0x0000u
  #define _UINT_EIT6SRC_PCIRSTIT_ENABLED_SV          0x2000u
  #define _UINT_EIT6SRC_PCIRSTIT_DISABLE_SV          0x0000u
  #define _UINT_EIT6SRC_PCIRSTIT_ENABLE_SV           0x2000u

  #define _UINT_EIT6SRC_P2LDBIT_MASK                 0x1000u
  #define _UINT_EIT6SRC_P2LDBIT_SHIFT                12
  #define UINT_EIT6SRC_P2LDBIT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_P2LDBIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_P2LDBIT_DISABLED              0x0000u
  #define UINT_EIT6SRC_P2LDBIT_ENABLED               0x0001u
  #define UINT_EIT6SRC_P2LDBIT_DISABLE               0x0000u
  #define UINT_EIT6SRC_P2LDBIT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_P2LDBIT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_P2LDBIT_ENABLED_SV           0x1000u
  #define _UINT_EIT6SRC_P2LDBIT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_P2LDBIT_ENABLE_SV            0x1000u

  #define _UINT_EIT6SRC_MBOX3IT_MASK                 0x0800u
  #define _UINT_EIT6SRC_MBOX3IT_SHIFT                11
  #define UINT_EIT6SRC_MBOX3IT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_MBOX3IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_MBOX3IT_DISABLED              0x0000u
  #define UINT_EIT6SRC_MBOX3IT_ENABLED               0x0001u
  #define UINT_EIT6SRC_MBOX3IT_DISABLE               0x0000u
  #define UINT_EIT6SRC_MBOX3IT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_MBOX3IT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_MBOX3IT_ENABLED_SV           0x0800u
  #define _UINT_EIT6SRC_MBOX3IT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_MBOX3IT_ENABLE_SV            0x0800u

  #define _UINT_EIT6SRC_MBOX2IT_MASK                 0x0400u
  #define _UINT_EIT6SRC_MBOX2IT_SHIFT                10
  #define UINT_EIT6SRC_MBOX2IT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_MBOX2IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_MBOX2IT_DISABLED              0x0000u
  #define UINT_EIT6SRC_MBOX2IT_ENABLED               0x0001u
  #define UINT_EIT6SRC_MBOX2IT_DISABLE               0x0000u
  #define UINT_EIT6SRC_MBOX2IT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_MBOX2IT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_MBOX2IT_ENABLED_SV           0x0400u
  #define _UINT_EIT6SRC_MBOX2IT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_MBOX2IT_ENABLE_SV            0x0400u

  #define _UINT_EIT6SRC_MBOX1IT_MASK                 0x0200u
  #define _UINT_EIT6SRC_MBOX1IT_SHIFT                9
  #define UINT_EIT6SRC_MBOX1IT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_MBOX1IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_MBOX1IT_DISABLED              0x0000u
  #define UINT_EIT6SRC_MBOX1IT_ENABLED               0x0001u
  #define UINT_EIT6SRC_MBOX1IT_DISABLE               0x0000u
  #define UINT_EIT6SRC_MBOX1IT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_MBOX1IT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_MBOX1IT_ENABLED_SV           0x0200u
  #define _UINT_EIT6SRC_MBOX1IT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_MBOX1IT_ENABLE_SV            0x0200u

  #define _UINT_EIT6SRC_MBOX0IT_MASK                 0x0100u
  #define _UINT_EIT6SRC_MBOX0IT_SHIFT                8
  #define UINT_EIT6SRC_MBOX0IT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_MBOX0IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_MBOX0IT_DISABLED              0x0000u
  #define UINT_EIT6SRC_MBOX0IT_ENABLED               0x0001u
  #define UINT_EIT6SRC_MBOX0IT_DISABLE               0x0000u
  #define UINT_EIT6SRC_MBOX0IT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_MBOX0IT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_MBOX0IT_ENABLED_SV           0x0100u
  #define _UINT_EIT6SRC_MBOX0IT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_MBOX0IT_ENABLE_SV            0x0100u

  #define _UINT_EIT6SRC_PBINT7IT_MASK                0x0080u
  #define _UINT_EIT6SRC_PBINT7IT_SHIFT               7
  #define UINT_EIT6SRC_PBINT7IT_DEFAULT              0x0000u
  #define UINT_EIT6SRC_PBINT7IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT6SRC_PBINT7IT_DISABLED             0x0000u
  #define UINT_EIT6SRC_PBINT7IT_ENABLED              0x0001u
  #define UINT_EIT6SRC_PBINT7IT_DISABLE              0x0000u
  #define UINT_EIT6SRC_PBINT7IT_ENABLE               0x0001u
  #define _UINT_EIT6SRC_PBINT7IT_DISABLED_SV         0x0000u
  #define _UINT_EIT6SRC_PBINT7IT_ENABLED_SV          0x0080u
  #define _UINT_EIT6SRC_PBINT7IT_DISABLE_SV          0x0000u
  #define _UINT_EIT6SRC_PBINT7IT_ENABLE_SV           0x0080u

  #define _UINT_EIT6SRC_PBINT6IT_MASK                0x0040u
  #define _UINT_EIT6SRC_PBINT6IT_SHIFT               6
  #define UINT_EIT6SRC_PBINT6IT_DEFAULT              0x0000u
  #define UINT_EIT6SRC_PBINT6IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT6SRC_PBINT6IT_DISABLED             0x0000u
  #define UINT_EIT6SRC_PBINT6IT_ENABLED              0x0001u
  #define UINT_EIT6SRC_PBINT6IT_DISABLE              0x0000u
  #define UINT_EIT6SRC_PBINT6IT_ENABLE               0x0001u
  #define _UINT_EIT6SRC_PBINT6IT_DISABLED_SV         0x0000u
  #define _UINT_EIT6SRC_PBINT6IT_ENABLED_SV          0x0040u
  #define _UINT_EIT6SRC_PBINT6IT_DISABLE_SV          0x0000u
  #define _UINT_EIT6SRC_PBINT6IT_ENABLE_SV           0x0040u

  #define _UINT_EIT6SRC_PBTIN1IT_MASK                0x0020u
  #define _UINT_EIT6SRC_PBTIN1IT_SHIFT               5
  #define UINT_EIT6SRC_PBTIN1IT_DEFAULT              0x0000u
  #define UINT_EIT6SRC_PBTIN1IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT6SRC_PBTIN1IT_DISABLED             0x0000u
  #define UINT_EIT6SRC_PBTIN1IT_ENABLED              0x0001u
  #define UINT_EIT6SRC_PBTIN1IT_DISABLE              0x0000u
  #define UINT_EIT6SRC_PBTIN1IT_ENABLE               0x0001u
  #define _UINT_EIT6SRC_PBTIN1IT_DISABLED_SV         0x0000u
  #define _UINT_EIT6SRC_PBTIN1IT_ENABLED_SV          0x0020u
  #define _UINT_EIT6SRC_PBTIN1IT_DISABLE_SV          0x0000u
  #define _UINT_EIT6SRC_PBTIN1IT_ENABLE_SV           0x0020u

  #define _UINT_EIT6SRC_PBTIN0IT_MASK                0x0010u
  #define _UINT_EIT6SRC_PBTIN0IT_SHIFT               4
  #define UINT_EIT6SRC_PBTIN0IT_DEFAULT              0x0000u
  #define UINT_EIT6SRC_PBTIN0IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT6SRC_PBTIN0IT_DISABLED             0x0000u
  #define UINT_EIT6SRC_PBTIN0IT_ENABLED              0x0001u
  #define UINT_EIT6SRC_PBTIN0IT_DISABLE              0x0000u
  #define UINT_EIT6SRC_PBTIN0IT_ENABLE               0x0001u
  #define _UINT_EIT6SRC_PBTIN0IT_DISABLED_SV         0x0000u
  #define _UINT_EIT6SRC_PBTIN0IT_ENABLED_SV          0x0010u
  #define _UINT_EIT6SRC_PBTIN0IT_DISABLE_SV          0x0000u
  #define _UINT_EIT6SRC_PBTIN0IT_ENABLE_SV           0x0010u

  #define _UINT_EIT6SRC_FRYBYIT_MASK                 0x0008u
  #define _UINT_EIT6SRC_FRYBYIT_SHIFT                3
  #define UINT_EIT6SRC_FRYBYIT_DEFAULT               0x0000u
  #define UINT_EIT6SRC_FRYBYIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT6SRC_FRYBYIT_DISABLED              0x0000u
  #define UINT_EIT6SRC_FRYBYIT_ENABLED               0x0001u
  #define UINT_EIT6SRC_FRYBYIT_DISABLE               0x0000u
  #define UINT_EIT6SRC_FRYBYIT_ENABLE                0x0001u
  #define _UINT_EIT6SRC_FRYBYIT_DISABLED_SV          0x0000u
  #define _UINT_EIT6SRC_FRYBYIT_ENABLED_SV           0x0008u
  #define _UINT_EIT6SRC_FRYBYIT_DISABLE_SV           0x0000u
  #define _UINT_EIT6SRC_FRYBYIT_ENABLE_SV            0x0008u

  #define _UINT_EIT6SRC_SB2IT_MASK                   0x0004u
  #define _UINT_EIT6SRC_SB2IT_SHIFT                  2
  #define UINT_EIT6SRC_SB2IT_DEFAULT                 0x0000u
  #define UINT_EIT6SRC_SB2IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT6SRC_SB2IT_DISABLED                0x0000u
  #define UINT_EIT6SRC_SB2IT_ENABLED                 0x0001u
  #define UINT_EIT6SRC_SB2IT_DISABLE                 0x0000u
  #define UINT_EIT6SRC_SB2IT_ENABLE                  0x0001u
  #define _UINT_EIT6SRC_SB2IT_DISABLED_SV            0x0000u
  #define _UINT_EIT6SRC_SB2IT_ENABLED_SV             0x0004u
  #define _UINT_EIT6SRC_SB2IT_DISABLE_SV             0x0000u
  #define _UINT_EIT6SRC_SB2IT_ENABLE_SV              0x0004u

  #define _UINT_EIT6SRC_SB1IT_MASK                   0x0002u
  #define _UINT_EIT6SRC_SB1IT_SHIFT                  1
  #define UINT_EIT6SRC_SB1IT_DEFAULT                 0x0000u
  #define UINT_EIT6SRC_SB1IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT6SRC_SB1IT_DISABLED                0x0000u
  #define UINT_EIT6SRC_SB1IT_ENABLED                 0x0001u
  #define UINT_EIT6SRC_SB1IT_DISABLE                 0x0000u
  #define UINT_EIT6SRC_SB1IT_ENABLE                  0x0001u
  #define _UINT_EIT6SRC_SB1IT_DISABLED_SV            0x0000u
  #define _UINT_EIT6SRC_SB1IT_ENABLED_SV             0x0002u
  #define _UINT_EIT6SRC_SB1IT_DISABLE_SV             0x0000u
  #define _UINT_EIT6SRC_SB1IT_ENABLE_SV              0x0002u

  #define _UINT_EIT6SRC_SB0IT_MASK                   0x0001u
  #define _UINT_EIT6SRC_SB0IT_SHIFT                  0
  #define UINT_EIT6SRC_SB0IT_DEFAULT                 0x0000u
  #define UINT_EIT6SRC_SB0IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT6SRC_SB0IT_DISABLED                0x0000u
  #define UINT_EIT6SRC_SB0IT_ENABLED                 0x0001u
  #define UINT_EIT6SRC_SB0IT_DISABLE                 0x0000u
  #define UINT_EIT6SRC_SB0IT_ENABLE                  0x0001u
  #define _UINT_EIT6SRC_SB0IT_DISABLED_SV            0x0000u
  #define _UINT_EIT6SRC_SB0IT_ENABLED_SV             0x0001u
  #define _UINT_EIT6SRC_SB0IT_DISABLE_SV             0x0000u
  #define _UINT_EIT6SRC_SB0IT_ENABLE_SV              0x0001u

  #define UINT_EIT6SRC_OF(val)                       _VALUEOF16(val)
  #define UINT_EIT6SRC_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,EIT6SRC,PCIRSTIT)         \
    | _PER_FDEFAULT16(UINT,EIT6SRC,P2LDBIT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,MBOX3IT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,MBOX2IT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,MBOX1IT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,MBOX0IT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,PBINT7IT)         \
    | _PER_FDEFAULT16(UINT,EIT6SRC,PBINT6IT)         \
    | _PER_FDEFAULT16(UINT,EIT6SRC,PBTIN1IT)         \
    | _PER_FDEFAULT16(UINT,EIT6SRC,PBTIN0IT)         \
    | _PER_FDEFAULT16(UINT,EIT6SRC,FRYBYIT)          \
    | _PER_FDEFAULT16(UINT,EIT6SRC,SB2IT)            \
    | _PER_FDEFAULT16(UINT,EIT6SRC,SB1IT)            \
    | _PER_FDEFAULT16(UINT,EIT6SRC,SB0IT)            \
  )

  #define UINT_EIT6SRC_RMK(pcirstit,p2ldbit,         \
    mbox3it,mbox2it,mbox1it,mbox0it,pbint7it,        \
    pbint6it,pbtin1it,pbtin0it,frybyit,sb2it,        \
    sb1it,sb0it)                                     \
    (Uint16)(                                        \
      _PER_FMK16(UINT,EIT6SRC,PCIRSTIT,pcirstit)     \
    | _PER_FMK16(UINT,EIT6SRC,P2LDBIT,p2ldbit)       \
    | _PER_FMK16(UINT,EIT6SRC,MBOX3IT,mbox3it)       \
    | _PER_FMK16(UINT,EIT6SRC,MBOX2IT,mbox2it)       \
    | _PER_FMK16(UINT,EIT6SRC,MBOX1IT,mbox1it)       \
    | _PER_FMK16(UINT,EIT6SRC,MBOX0IT,mbox0it)       \
    | _PER_FMK16(UINT,EIT6SRC,PBINT7IT,pbint7it)     \
    | _PER_FMK16(UINT,EIT6SRC,PBINT6IT,pbint6it)     \
    | _PER_FMK16(UINT,EIT6SRC,PBTIN1IT,pbtin1it)     \
    | _PER_FMK16(UINT,EIT6SRC,PBTIN0IT,pbtin0it)     \
    | _PER_FMK16(UINT,EIT6SRC,FRYBYIT,frybyit)       \
    | _PER_FMK16(UINT,EIT6SRC,SB2IT,sb2it)           \
    | _PER_FMK16(UINT,EIT6SRC,SB1IT,sb1it)           \
    | _PER_FMK16(UINT,EIT6SRC,SB0IT,sb0it)           \
  )

  #define _UINT_EIT6SRC_FGET(FIELD)                  \
    _PER_FGET16(_UINT_EIT6SRC_ADDR,                  \
      UINT,EIT6SRC,##FIELD)

  #define _UINT_EIT6SRC_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_EIT6SRC_ADDR,                  \
      UINT,EIT6SRC,##FIELD,field)

  #define _UINT_EIT6SRC_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_EIT6SRC_ADDR,                 \
      UINT,EIT6SRC,##FIELD,##SYM)

  #define _UINT_EIT6SRC_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_EIT6SRC_ADDR,                 \
      UINT,EIT6SRC,##FIELD,val)

  #define _UINT_EIT6SRC_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_EIT6SRC_ADDR,                \
      UINT,EIT6SRC,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  E I T 7 S R C        |
* |_______________________|
*
* EIT7SRC - DSP External Interrupt 7 Source Select
*
* FIELDS (msb -> lsb)
* (RW)	PCIRSTIT  	[13:13]	 - PCI Reset Interrupt
* (RW)	P2LDBIT   	[12:12]	 - PCI-to-Local Doorbell Interrupt
* (RW)	MBOX3IT   	[11:11]	 - Mailbox 3 Interrupt
* (RW)	MBOX2IT   	[10:10]	 - Mailbox 2 Interrupt
* (RW)	MBOX1IT   	[ 9: 9]	 - Mailbox 1 Interrupt
* (RW)	MBOX0IT   	[ 8: 8]	 - Mailbox 0 Interrupt
* (RW)	PBINT7IT  	[ 7: 7]	 - Platform Bus INT7 (GPI3) Interrupt
* (RW)	PBINT6IT  	[ 6: 6]	 - Platform Bus INT6 (GPI2) Interrupt
* (RW)	PBTIN1IT  	[ 5: 5]	 - Platform Bus Tin1 (GPI1) Interrupt
* (RW)	PBTIN0IT  	[ 4: 4]	 - Platform Bus Tin0 (GPI0) Interrupt
* (RW)	FRYBYIT   	[ 3: 3]	 - Flash Ready / Busy# Interrupt
* (RW)	SB2IT     	[ 2: 2]	 - Sync Bus 2 Event Interrupt
* (RW)	SB1IT     	[ 1: 1]	 - Sync Bus 1 Event Interrupt
* (RW)	SB0IT     	[ 0: 0]	 - Sync Bus 0 Event Interrupt
*
\******************************************************************************/
/*#define _UINT_EIT7SRC_RECIDX                       No recorded */

  #define _UINT_EIT7SRC_ADDR                         0x6C080054u

  #define _UINT_EIT7SRC_REGOFFS                      0x00000054u
  #define _UINT_EIT7SRC_REGOFFS16                    0x0000002Au

  #define _UINT_EIT7SRC_PCIRSTIT_MASK                0x2000u
  #define _UINT_EIT7SRC_PCIRSTIT_SHIFT               13
  #define UINT_EIT7SRC_PCIRSTIT_DEFAULT              0x0000u
  #define UINT_EIT7SRC_PCIRSTIT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT7SRC_PCIRSTIT_DISABLED             0x0000u
  #define UINT_EIT7SRC_PCIRSTIT_ENABLED              0x0001u
  #define UINT_EIT7SRC_PCIRSTIT_DISABLE              0x0000u
  #define UINT_EIT7SRC_PCIRSTIT_ENABLE               0x0001u
  #define _UINT_EIT7SRC_PCIRSTIT_DISABLED_SV         0x0000u
  #define _UINT_EIT7SRC_PCIRSTIT_ENABLED_SV          0x2000u
  #define _UINT_EIT7SRC_PCIRSTIT_DISABLE_SV          0x0000u
  #define _UINT_EIT7SRC_PCIRSTIT_ENABLE_SV           0x2000u

  #define _UINT_EIT7SRC_P2LDBIT_MASK                 0x1000u
  #define _UINT_EIT7SRC_P2LDBIT_SHIFT                12
  #define UINT_EIT7SRC_P2LDBIT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_P2LDBIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_P2LDBIT_DISABLED              0x0000u
  #define UINT_EIT7SRC_P2LDBIT_ENABLED               0x0001u
  #define UINT_EIT7SRC_P2LDBIT_DISABLE               0x0000u
  #define UINT_EIT7SRC_P2LDBIT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_P2LDBIT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_P2LDBIT_ENABLED_SV           0x1000u
  #define _UINT_EIT7SRC_P2LDBIT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_P2LDBIT_ENABLE_SV            0x1000u

  #define _UINT_EIT7SRC_MBOX3IT_MASK                 0x0800u
  #define _UINT_EIT7SRC_MBOX3IT_SHIFT                11
  #define UINT_EIT7SRC_MBOX3IT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_MBOX3IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_MBOX3IT_DISABLED              0x0000u
  #define UINT_EIT7SRC_MBOX3IT_ENABLED               0x0001u
  #define UINT_EIT7SRC_MBOX3IT_DISABLE               0x0000u
  #define UINT_EIT7SRC_MBOX3IT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_MBOX3IT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_MBOX3IT_ENABLED_SV           0x0800u
  #define _UINT_EIT7SRC_MBOX3IT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_MBOX3IT_ENABLE_SV            0x0800u

  #define _UINT_EIT7SRC_MBOX2IT_MASK                 0x0400u
  #define _UINT_EIT7SRC_MBOX2IT_SHIFT                10
  #define UINT_EIT7SRC_MBOX2IT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_MBOX2IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_MBOX2IT_DISABLED              0x0000u
  #define UINT_EIT7SRC_MBOX2IT_ENABLED               0x0001u
  #define UINT_EIT7SRC_MBOX2IT_DISABLE               0x0000u
  #define UINT_EIT7SRC_MBOX2IT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_MBOX2IT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_MBOX2IT_ENABLED_SV           0x0400u
  #define _UINT_EIT7SRC_MBOX2IT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_MBOX2IT_ENABLE_SV            0x0400u

  #define _UINT_EIT7SRC_MBOX1IT_MASK                 0x0200u
  #define _UINT_EIT7SRC_MBOX1IT_SHIFT                9
  #define UINT_EIT7SRC_MBOX1IT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_MBOX1IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_MBOX1IT_DISABLED              0x0000u
  #define UINT_EIT7SRC_MBOX1IT_ENABLED               0x0001u
  #define UINT_EIT7SRC_MBOX1IT_DISABLE               0x0000u
  #define UINT_EIT7SRC_MBOX1IT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_MBOX1IT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_MBOX1IT_ENABLED_SV           0x0200u
  #define _UINT_EIT7SRC_MBOX1IT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_MBOX1IT_ENABLE_SV            0x0200u

  #define _UINT_EIT7SRC_MBOX0IT_MASK                 0x0100u
  #define _UINT_EIT7SRC_MBOX0IT_SHIFT                8
  #define UINT_EIT7SRC_MBOX0IT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_MBOX0IT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_MBOX0IT_DISABLED              0x0000u
  #define UINT_EIT7SRC_MBOX0IT_ENABLED               0x0001u
  #define UINT_EIT7SRC_MBOX0IT_DISABLE               0x0000u
  #define UINT_EIT7SRC_MBOX0IT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_MBOX0IT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_MBOX0IT_ENABLED_SV           0x0100u
  #define _UINT_EIT7SRC_MBOX0IT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_MBOX0IT_ENABLE_SV            0x0100u

  #define _UINT_EIT7SRC_PBINT7IT_MASK                0x0080u
  #define _UINT_EIT7SRC_PBINT7IT_SHIFT               7
  #define UINT_EIT7SRC_PBINT7IT_DEFAULT              0x0000u
  #define UINT_EIT7SRC_PBINT7IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT7SRC_PBINT7IT_DISABLED             0x0000u
  #define UINT_EIT7SRC_PBINT7IT_ENABLED              0x0001u
  #define UINT_EIT7SRC_PBINT7IT_DISABLE              0x0000u
  #define UINT_EIT7SRC_PBINT7IT_ENABLE               0x0001u
  #define _UINT_EIT7SRC_PBINT7IT_DISABLED_SV         0x0000u
  #define _UINT_EIT7SRC_PBINT7IT_ENABLED_SV          0x0080u
  #define _UINT_EIT7SRC_PBINT7IT_DISABLE_SV          0x0000u
  #define _UINT_EIT7SRC_PBINT7IT_ENABLE_SV           0x0080u

  #define _UINT_EIT7SRC_PBINT6IT_MASK                0x0040u
  #define _UINT_EIT7SRC_PBINT6IT_SHIFT               6
  #define UINT_EIT7SRC_PBINT6IT_DEFAULT              0x0000u
  #define UINT_EIT7SRC_PBINT6IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT7SRC_PBINT6IT_DISABLED             0x0000u
  #define UINT_EIT7SRC_PBINT6IT_ENABLED              0x0001u
  #define UINT_EIT7SRC_PBINT6IT_DISABLE              0x0000u
  #define UINT_EIT7SRC_PBINT6IT_ENABLE               0x0001u
  #define _UINT_EIT7SRC_PBINT6IT_DISABLED_SV         0x0000u
  #define _UINT_EIT7SRC_PBINT6IT_ENABLED_SV          0x0040u
  #define _UINT_EIT7SRC_PBINT6IT_DISABLE_SV          0x0000u
  #define _UINT_EIT7SRC_PBINT6IT_ENABLE_SV           0x0040u

  #define _UINT_EIT7SRC_PBTIN1IT_MASK                0x0020u
  #define _UINT_EIT7SRC_PBTIN1IT_SHIFT               5
  #define UINT_EIT7SRC_PBTIN1IT_DEFAULT              0x0000u
  #define UINT_EIT7SRC_PBTIN1IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT7SRC_PBTIN1IT_DISABLED             0x0000u
  #define UINT_EIT7SRC_PBTIN1IT_ENABLED              0x0001u
  #define UINT_EIT7SRC_PBTIN1IT_DISABLE              0x0000u
  #define UINT_EIT7SRC_PBTIN1IT_ENABLE               0x0001u
  #define _UINT_EIT7SRC_PBTIN1IT_DISABLED_SV         0x0000u
  #define _UINT_EIT7SRC_PBTIN1IT_ENABLED_SV          0x0020u
  #define _UINT_EIT7SRC_PBTIN1IT_DISABLE_SV          0x0000u
  #define _UINT_EIT7SRC_PBTIN1IT_ENABLE_SV           0x0020u

  #define _UINT_EIT7SRC_PBTIN0IT_MASK                0x0010u
  #define _UINT_EIT7SRC_PBTIN0IT_SHIFT               4
  #define UINT_EIT7SRC_PBTIN0IT_DEFAULT              0x0000u
  #define UINT_EIT7SRC_PBTIN0IT_OF(x)                _VALUEOF16(x)
  #define UINT_EIT7SRC_PBTIN0IT_DISABLED             0x0000u
  #define UINT_EIT7SRC_PBTIN0IT_ENABLED              0x0001u
  #define UINT_EIT7SRC_PBTIN0IT_DISABLE              0x0000u
  #define UINT_EIT7SRC_PBTIN0IT_ENABLE               0x0001u
  #define _UINT_EIT7SRC_PBTIN0IT_DISABLED_SV         0x0000u
  #define _UINT_EIT7SRC_PBTIN0IT_ENABLED_SV          0x0010u
  #define _UINT_EIT7SRC_PBTIN0IT_DISABLE_SV          0x0000u
  #define _UINT_EIT7SRC_PBTIN0IT_ENABLE_SV           0x0010u

  #define _UINT_EIT7SRC_FRYBYIT_MASK                 0x0008u
  #define _UINT_EIT7SRC_FRYBYIT_SHIFT                3
  #define UINT_EIT7SRC_FRYBYIT_DEFAULT               0x0000u
  #define UINT_EIT7SRC_FRYBYIT_OF(x)                 _VALUEOF16(x)
  #define UINT_EIT7SRC_FRYBYIT_DISABLED              0x0000u
  #define UINT_EIT7SRC_FRYBYIT_ENABLED               0x0001u
  #define UINT_EIT7SRC_FRYBYIT_DISABLE               0x0000u
  #define UINT_EIT7SRC_FRYBYIT_ENABLE                0x0001u
  #define _UINT_EIT7SRC_FRYBYIT_DISABLED_SV          0x0000u
  #define _UINT_EIT7SRC_FRYBYIT_ENABLED_SV           0x0008u
  #define _UINT_EIT7SRC_FRYBYIT_DISABLE_SV           0x0000u
  #define _UINT_EIT7SRC_FRYBYIT_ENABLE_SV            0x0008u

  #define _UINT_EIT7SRC_SB2IT_MASK                   0x0004u
  #define _UINT_EIT7SRC_SB2IT_SHIFT                  2
  #define UINT_EIT7SRC_SB2IT_DEFAULT                 0x0000u
  #define UINT_EIT7SRC_SB2IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT7SRC_SB2IT_DISABLED                0x0000u
  #define UINT_EIT7SRC_SB2IT_ENABLED                 0x0001u
  #define UINT_EIT7SRC_SB2IT_DISABLE                 0x0000u
  #define UINT_EIT7SRC_SB2IT_ENABLE                  0x0001u
  #define _UINT_EIT7SRC_SB2IT_DISABLED_SV            0x0000u
  #define _UINT_EIT7SRC_SB2IT_ENABLED_SV             0x0004u
  #define _UINT_EIT7SRC_SB2IT_DISABLE_SV             0x0000u
  #define _UINT_EIT7SRC_SB2IT_ENABLE_SV              0x0004u

  #define _UINT_EIT7SRC_SB1IT_MASK                   0x0002u
  #define _UINT_EIT7SRC_SB1IT_SHIFT                  1
  #define UINT_EIT7SRC_SB1IT_DEFAULT                 0x0000u
  #define UINT_EIT7SRC_SB1IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT7SRC_SB1IT_DISABLED                0x0000u
  #define UINT_EIT7SRC_SB1IT_ENABLED                 0x0001u
  #define UINT_EIT7SRC_SB1IT_DISABLE                 0x0000u
  #define UINT_EIT7SRC_SB1IT_ENABLE                  0x0001u
  #define _UINT_EIT7SRC_SB1IT_DISABLED_SV            0x0000u
  #define _UINT_EIT7SRC_SB1IT_ENABLED_SV             0x0002u
  #define _UINT_EIT7SRC_SB1IT_DISABLE_SV             0x0000u
  #define _UINT_EIT7SRC_SB1IT_ENABLE_SV              0x0002u

  #define _UINT_EIT7SRC_SB0IT_MASK                   0x0001u
  #define _UINT_EIT7SRC_SB0IT_SHIFT                  0
  #define UINT_EIT7SRC_SB0IT_DEFAULT                 0x0000u
  #define UINT_EIT7SRC_SB0IT_OF(x)                   _VALUEOF16(x)
  #define UINT_EIT7SRC_SB0IT_DISABLED                0x0000u
  #define UINT_EIT7SRC_SB0IT_ENABLED                 0x0001u
  #define UINT_EIT7SRC_SB0IT_DISABLE                 0x0000u
  #define UINT_EIT7SRC_SB0IT_ENABLE                  0x0001u
  #define _UINT_EIT7SRC_SB0IT_DISABLED_SV            0x0000u
  #define _UINT_EIT7SRC_SB0IT_ENABLED_SV             0x0001u
  #define _UINT_EIT7SRC_SB0IT_DISABLE_SV             0x0000u
  #define _UINT_EIT7SRC_SB0IT_ENABLE_SV              0x0001u

  #define UINT_EIT7SRC_OF(val)                       _VALUEOF16(val)
  #define UINT_EIT7SRC_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UINT,EIT7SRC,PCIRSTIT)         \
    | _PER_FDEFAULT16(UINT,EIT7SRC,P2LDBIT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,MBOX3IT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,MBOX2IT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,MBOX1IT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,MBOX0IT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,PBINT7IT)         \
    | _PER_FDEFAULT16(UINT,EIT7SRC,PBINT6IT)         \
    | _PER_FDEFAULT16(UINT,EIT7SRC,PBTIN1IT)         \
    | _PER_FDEFAULT16(UINT,EIT7SRC,PBTIN0IT)         \
    | _PER_FDEFAULT16(UINT,EIT7SRC,FRYBYIT)          \
    | _PER_FDEFAULT16(UINT,EIT7SRC,SB2IT)            \
    | _PER_FDEFAULT16(UINT,EIT7SRC,SB1IT)            \
    | _PER_FDEFAULT16(UINT,EIT7SRC,SB0IT)            \
  )

  #define UINT_EIT7SRC_RMK(pcirstit,p2ldbit,         \
    mbox3it,mbox2it,mbox1it,mbox0it,pbint7it,        \
    pbint6it,pbtin1it,pbtin0it,frybyit,sb2it,        \
    sb1it,sb0it)                                     \
    (Uint16)(                                        \
      _PER_FMK16(UINT,EIT7SRC,PCIRSTIT,pcirstit)     \
    | _PER_FMK16(UINT,EIT7SRC,P2LDBIT,p2ldbit)       \
    | _PER_FMK16(UINT,EIT7SRC,MBOX3IT,mbox3it)       \
    | _PER_FMK16(UINT,EIT7SRC,MBOX2IT,mbox2it)       \
    | _PER_FMK16(UINT,EIT7SRC,MBOX1IT,mbox1it)       \
    | _PER_FMK16(UINT,EIT7SRC,MBOX0IT,mbox0it)       \
    | _PER_FMK16(UINT,EIT7SRC,PBINT7IT,pbint7it)     \
    | _PER_FMK16(UINT,EIT7SRC,PBINT6IT,pbint6it)     \
    | _PER_FMK16(UINT,EIT7SRC,PBTIN1IT,pbtin1it)     \
    | _PER_FMK16(UINT,EIT7SRC,PBTIN0IT,pbtin0it)     \
    | _PER_FMK16(UINT,EIT7SRC,FRYBYIT,frybyit)       \
    | _PER_FMK16(UINT,EIT7SRC,SB2IT,sb2it)           \
    | _PER_FMK16(UINT,EIT7SRC,SB1IT,sb1it)           \
    | _PER_FMK16(UINT,EIT7SRC,SB0IT,sb0it)           \
  )

  #define _UINT_EIT7SRC_FGET(FIELD)                  \
    _PER_FGET16(_UINT_EIT7SRC_ADDR,                  \
      UINT,EIT7SRC,##FIELD)

  #define _UINT_EIT7SRC_FSET(FIELD,field)            \
    _PER_FSET16(_UINT_EIT7SRC_ADDR,                  \
      UINT,EIT7SRC,##FIELD,field)

  #define _UINT_EIT7SRC_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UINT_EIT7SRC_ADDR,                 \
      UINT,EIT7SRC,##FIELD,##SYM)

  #define _UINT_EIT7SRC_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UINT_EIT7SRC_ADDR,                 \
      UINT,EIT7SRC,##FIELD,val)

  #define _UINT_EIT7SRC_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UINT_EIT7SRC_ADDR,                \
      UINT,EIT7SRC,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_UINT_SUPPORT) */
#endif /* _BSL_UINTHAL_H_ */
/******************************************************************************\
* End of bsl_uinthal.h
\******************************************************************************/
