/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral UMISC
* FILENAME......... bsl_umisc.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 03/10/2004 11:53:00
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UMISC
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_UMISC_H_
#define _BSL_UMISC_H_

#include <bsl_umischal.h>


#if (BSL_UMISC_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_UMISC_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

// BOOT_MODE_t identifiers
typedef Uint32	BOOT_MODE_t;
enum E_BOOT_MODE
{
	JUMPER_CONTROLLED_BOOT_MODE			= 0,
	PCI_BOOT_MODE						= 1,
	HPI_BOOT_MODE						= 1,
	HOST_BOOT_MODE 						= 1,
	ROM_BOOT_MODE 						= 2,
	FLASH_BOOT_MODE 					= 2,

	// values used by UMISC_getBootMode() only
	JUMPER_CONTROLLED_PCI_BOOT_MODE		= 3,
	JUMPER_CONTROLLED_HPI_BOOT_MODE		= 3,
	JUMPER_CONTROLLED_HOST_BOOT_MODE	= 3,
	JUMPER_CONTROLLED_ROM_BOOT_MODE		= 4,
	JUMPER_CONTROLLED_FLASH_BOOT_MODE	= 4
};


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint16 regBMCTL;
	Uint16 regSER2CTL;
	Uint16 regLED;
	Uint16 regPBCTL0;
	Uint16 regPBCTL1;
} UMISC_Config;

/* object structure */
typedef struct {
	Uint32 baseAddr;
} UMISC_Obj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI UMISC_Obj _UMISC_obj;	/* defined in bsl_umisc.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/

BSLAPI void UMISC_reset();


/******************************************************************************\
* inline function declarations
\******************************************************************************/

IDECL void UMISC_switchToEEPROM();
IDECL void UMISC_switchToMcBSP2();
IDECL void UMISC_switchToAuto();

IDECL Uint32 UMISC_jmpIsFlashWriteEnabled();
IDECL Uint32 UMISC_jmpIsBootModeFlash();
IDECL Uint32 UMISC_jmpIsBootModePci();
IDECL Uint32 UMISC_jmpIsPciMasterEnabled();

IDECL BOOT_MODE_t UMISC_getBootMode();
IDECL void UMISC_setBootMode(BOOT_MODE_t bootmode);

IDECL void UMISC_toggleLED();

IDECL void UMISC_config(UMISC_Config *config);
IDECL void UMISC_configArgs(Uint32 bmctl, Uint32 ser2ctl, Uint32 led,
	Uint32 pbctl0, Uint32 pbctl1);
IDECL void UMISC_getConfig(UMISC_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
// McBSP2 override for EEPROM access
IDEF void UMISC_switchToEEPROM()
{
	UMISC_RSET( SER2CTL,
		UMISC_SER2CTL_RMK(
			UMISC_SER2CTL_OVRSEREN_EEMODE,
			UMISC_SER2CTL_OVRSEROE_DISABLED,
    		UMISC_SER2CTL_OVREN_ENABLED
    	)
    );
}

/*----------------------------------------------------------------------------*/
// switch to normal McBSP2
IDEF void UMISC_switchToMcBSP2()
{
	UMISC_RSET( SER2CTL,
		UMISC_SER2CTL_RMK(
			UMISC_SER2CTL_OVRSEREN_SERMODE,
			UMISC_SER2CTL_OVRSEROE_ENABLED,
    		UMISC_SER2CTL_OVREN_ENABLED
    	)
    );
}

/*----------------------------------------------------------------------------*/
// switch to automatic mode(same as McBSP2 mode except for a few milliseconds of EEPROM mode after PCI reset)
IDEF void UMISC_switchToAuto()
{
	UMISC_RSET( SER2CTL,
		UMISC_SER2CTL_RMK(
			// These two don't matter, they are overlooked by last one
			UMISC_SER2CTL_OVRSEREN_EEMODE,
			UMISC_SER2CTL_OVRSEROE_DISABLED,
			// auto mode enabled, previous two are ignored
    		UMISC_SER2CTL_OVREN_DISABLED
    	)
    );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 UMISC_jmpIsFlashWriteEnabled()
{
	return UMISC_FGETSQ( JMPST, FLASHWE, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 UMISC_jmpIsBootModeFlash()
{
	return UMISC_FGETSQ( JMPST, BOOTMODE, FLASH );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 UMISC_jmpIsBootModePci()
{
	return UMISC_FGETSQ( JMPST, BOOTMODE, PCI );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 UMISC_jmpIsPciMasterEnabled()
{
	return UMISC_FGETSQ( JMPST, PCIMSTR, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF BOOT_MODE_t UMISC_getBootMode()
{
	switch( UMISC_RGET( BMCTL ) )
	{
	case (_UMISC_BMCTL_OVREN_OVRVAL_SV | _UMISC_BMCTL_OVRBMSEL_PCI_SV):
		return PCI_BOOT_MODE;
	case (_UMISC_BMCTL_OVREN_OVRVAL_SV | _UMISC_BMCTL_OVRBMSEL_FLASH_SV):
		return FLASH_BOOT_MODE;
	default:
		if( UMISC_jmpIsBootModePci() ) return JUMPER_CONTROLLED_PCI_BOOT_MODE;
		return JUMPER_CONTROLLED_FLASH_BOOT_MODE;
	}
}

/*----------------------------------------------------------------------------*/
IDEF void UMISC_setBootMode(BOOT_MODE_t bootmode)
{
	switch( bootmode )
	{
	case JUMPER_CONTROLLED_BOOT_MODE:
		UMISC_FSETS( BMCTL, OVREN, JUMPER );
		break;
	case FLASH_BOOT_MODE:
		UMISC_RSET( BMCTL,
			UMISC_BMCTL_RMK( UMISC_BMCTL_OVRBMSEL_FLASH, UMISC_BMCTL_OVREN_ENABLED )
    	);
		break;
	default:
	case PCI_BOOT_MODE:
		UMISC_RSET( BMCTL,
			UMISC_BMCTL_RMK( UMISC_BMCTL_OVRBMSEL_PCI, UMISC_BMCTL_OVREN_ENABLED )
    	);
		break;
	}
}

/*----------------------------------------------------------------------------*/
IDEF void UMISC_toggleLED()
{
	if( UMISC_RGET(LED) == UMISC_LED_TURN_OFF )	// check for zero value
	{
		UMISC_RFSETS(LED, TURN, ON);
	}
	else
	{
		UMISC_RFSETS(LED, TURN, OFF);
	}
}

/*----------------------------------------------------------------------------*/
IDEF void UMISC_config(UMISC_Config *config)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_UMISC_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regBMCTL;
	r1 = config->regSER2CTL;
	r2 = config->regLED;
	r3 = config->regPBCTL0;
	r4 = config->regPBCTL1;
	base[_UMISC_BMCTL_REGOFFS16] = (Uint16)(r0);
	base[_UMISC_SER2CTL_REGOFFS16] = (Uint16)(r1);
	base[_UMISC_LED_REGOFFS16] = (Uint16)(r2);
	base[_UMISC_PBCTL0_REGOFFS16] = (Uint16)(r3);
	base[_UMISC_PBCTL1_REGOFFS16] = (Uint16)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UMISC_configArgs(Uint32 bmctl, Uint32 ser2ctl, Uint32 led,
	Uint32 pbctl0, Uint32 pbctl1)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_UMISC_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = bmctl;
	r1 = ser2ctl;
	r2 = led;
	r3 = pbctl0;
	r4 = pbctl1;
	base[_UMISC_BMCTL_REGOFFS16] = (Uint16)(r0);
	base[_UMISC_SER2CTL_REGOFFS16] = (Uint16)(r1);
	base[_UMISC_LED_REGOFFS16] = (Uint16)(r2);
	base[_UMISC_PBCTL0_REGOFFS16] = (Uint16)(r3);
	base[_UMISC_PBCTL1_REGOFFS16] = (Uint16)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UMISC_getConfig(UMISC_Config *config)
{
	Uint32 gie;
	volatile UMISC_Config *cfg;
	cfg = (volatile UMISC_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regBMCTL = UMISC_RGET(BMCTL);
	cfg->regSER2CTL = UMISC_RGET(SER2CTL);
	cfg->regLED = UMISC_RGET(LED);
	cfg->regPBCTL0 = UMISC_RGET(PBCTL0);
	cfg->regPBCTL1 = UMISC_RGET(PBCTL1);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_UMISC_SUPPORT */
#endif /* _BSL_UMISC_H_ */
/******************************************************************************\
* End of bsl_umisc.h
\******************************************************************************/
