/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral UMISC
* FILENAME......... bsl_umischal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 03/14/2004 11:19:03
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UMISC
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. UMISC is 0x6C080000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* JMPST       -  Jumper Readback (Status)
* NMICMD      -  NMI Generator
* DSPRST      -  DSP Reset Generator
* BMCTL       -  Boot Mode Control/Status
* SER2CTL     -  McBSP 2 Control/Status
* LED         -  LED Control/Status
* PBCTL0      -  Platform Bus Control 0
* PBCTL1      -  Platform Bus Control 1
* DSPSPEED    -  DSP core speed
* VERSION     -  HW Version Descriptor
* DHCOMM      -  DSP-Host Communication
*
\******************************************************************************/
#ifndef _BSL_UMISCHAL_H_
#define _BSL_UMISCHAL_H_

#include <bsl.h>


#if (BSL_UMISC_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _UMISC_DEVICE_COUNT                        1

  #define _UMISC_BASE_ADDRESS                        0x6C080000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define UMISC_FMK(REG,FIELD,val)\
    _PER_FMK16(UMISC,##REG,##FIELD,val)

  #define UMISC_FMKS(REG,FIELD,SYM)\
    _PER_FMKS16(UMISC,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define UMISC_ADDR(REG)\
    _UMISC_##REG##_ADDR

  #define UMISC_RGET(REG)\
    _PER_RGET16(_UMISC_##REG##_ADDR,UMISC,##REG)

  #define UMISC_RSET(REG,val)\
    _PER_RSET16(_UMISC_##REG##_ADDR,UMISC,##REG,val)

  #define UMISC_RFSETS(REG,FIELD,SYM)\
    UMISC_RSET(##REG,_UMISC_##REG##_##FIELD##_##SYM##_SV)

  #define UMISC_FGET(REG,FIELD)\
    _UMISC_##REG##_FGET(##FIELD)

  #define UMISC_FSET(REG,FIELD,val)\
    _UMISC_##REG##_FSET(##FIELD,val)

  #define UMISC_FSETS(REG,FIELD,SYM)\
    _UMISC_##REG##_FSETS(##FIELD,##SYM)

  #define UMISC_FGETQ(REG,FIELD,val)\
    _UMISC_##REG##_FGETQ(##FIELD,val)

  #define UMISC_FGETSQ(REG,FIELD,SYM)\
    _UMISC_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define UMISC_RGETA(addr,REG)\
    _PER_RGET16(addr,UMISC,##REG)

  #define UMISC_RSETA(addr,REG,val)\
    _PER_RSET16(addr,UMISC,##REG,val)

  #define UMISC_RFSETSA(addr,REG,FIELD,SYM)\
    UMISC_RSETA(addr,##REG,_UMISC_##REG##_##FIELD##_##SYM##_SV)

  #define UMISC_FGETA(addr,REG,FIELD)\
    _PER_FGET16(addr,UMISC,##REG,##FIELD)

  #define UMISC_FSETA(addr,REG,FIELD,val)\
    _PER_FSET16(addr,UMISC,##REG,##FIELD,val)

  #define UMISC_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS16(addr,UMISC,##REG,##FIELD,##SYM)

  #define UMISC_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ16(addr,UMISC,##REG,##FIELD,val)

  #define UMISC_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ16(addr,UMISC,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define UMISC_VRGET(var,REG)\
    _PER_VRGET16(var,UMISC,##REG)

  #define UMISC_VRSET(var,REG,val)\
    _PER_VRSET16(var,UMISC,##REG,val)

  #define UMISC_VRFSETS(var,REG,FIELD,SYM)\
    UMISC_VRSET(var,##REG,_UMISC_##REG##_##FIELD##_##SYM##_SV)

  #define UMISC_VFGET(var,REG,FIELD)\
    _PER_VFGET16(var,UMISC,##REG,##FIELD)

  #define UMISC_VFSET(var,REG,FIELD,val)\
    _PER_VFSET16(var,UMISC,##REG,##FIELD,val)

  #define UMISC_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS16(var,UMISC,##REG,##FIELD,##SYM)

  #define UMISC_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ16(var,UMISC,##REG,##FIELD,val)

  #define UMISC_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ16(var,UMISC,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  J M P S T            |
* |_______________________|
*
* JMPST - Jumper Readback (Status)
*
* FIELDS (msb -> lsb)
* (R.)	SPARE     	[ 3: 3]	 - Spare Jumper state
* (R.)	FLASHWE   	[ 2: 2]	 - Flash Write Enable Jumper state
* (R.)	BOOTMODE  	[ 1: 1]	 - Boot Mode Jumper state
* (R.)	PCIMSTR   	[ 0: 0]	 - PCI Master Jumper state
*
\******************************************************************************/
/*#define _UMISC_JMPST_RECIDX                        No recorded */

  #define _UMISC_JMPST_ADDR                          0x6C080016u

  #define _UMISC_JMPST_REGOFFS                       0x00000016u
  #define _UMISC_JMPST_REGOFFS16                     0x0000000Bu

  #define _UMISC_JMPST_SPARE_MASK                    0x0008u
  #define _UMISC_JMPST_SPARE_SHIFT                   3
  #define UMISC_JMPST_SPARE_DEFAULT                  0x0000u
  #define UMISC_JMPST_SPARE_OF(x)                    _VALUEOF16(x)
  #define UMISC_JMPST_SPARE_ON                       0x0000u
  #define UMISC_JMPST_SPARE_OFF                      0x0001u
  #define _UMISC_JMPST_SPARE_ON_SV                   0x0000u
  #define _UMISC_JMPST_SPARE_OFF_SV                  0x0008u

  #define _UMISC_JMPST_FLASHWE_MASK                  0x0004u
  #define _UMISC_JMPST_FLASHWE_SHIFT                 2
  #define UMISC_JMPST_FLASHWE_DEFAULT                0x0000u
  #define UMISC_JMPST_FLASHWE_OF(x)                  _VALUEOF16(x)
  #define UMISC_JMPST_FLASHWE_ON                     0x0000u
  #define UMISC_JMPST_FLASHWE_OFF                    0x0001u
  #define UMISC_JMPST_FLASHWE_ENABLED                0x0000u
  #define UMISC_JMPST_FLASHWE_DISABLED               0x0001u
  #define _UMISC_JMPST_FLASHWE_ON_SV                 0x0000u
  #define _UMISC_JMPST_FLASHWE_OFF_SV                0x0004u
  #define _UMISC_JMPST_FLASHWE_ENABLED_SV            0x0000u
  #define _UMISC_JMPST_FLASHWE_DISABLED_SV           0x0004u

  #define _UMISC_JMPST_BOOTMODE_MASK                 0x0002u
  #define _UMISC_JMPST_BOOTMODE_SHIFT                1
  #define UMISC_JMPST_BOOTMODE_DEFAULT               0x0000u
  #define UMISC_JMPST_BOOTMODE_OF(x)                 _VALUEOF16(x)
  #define UMISC_JMPST_BOOTMODE_ON                    0x0000u
  #define UMISC_JMPST_BOOTMODE_OFF                   0x0001u
  #define UMISC_JMPST_BOOTMODE_FLASH                 0x0000u
  #define UMISC_JMPST_BOOTMODE_PCI                   0x0001u
  #define _UMISC_JMPST_BOOTMODE_ON_SV                0x0000u
  #define _UMISC_JMPST_BOOTMODE_OFF_SV               0x0002u
  #define _UMISC_JMPST_BOOTMODE_FLASH_SV             0x0000u
  #define _UMISC_JMPST_BOOTMODE_PCI_SV               0x0002u

  #define _UMISC_JMPST_PCIMSTR_MASK                  0x0001u
  #define _UMISC_JMPST_PCIMSTR_SHIFT                 0
  #define UMISC_JMPST_PCIMSTR_DEFAULT                0x0000u
  #define UMISC_JMPST_PCIMSTR_OF(x)                  _VALUEOF16(x)
  #define UMISC_JMPST_PCIMSTR_ON                     0x0000u
  #define UMISC_JMPST_PCIMSTR_OFF                    0x0001u
  #define UMISC_JMPST_PCIMSTR_ENABLED                0x0000u
  #define UMISC_JMPST_PCIMSTR_DISABLED               0x0001u
  #define _UMISC_JMPST_PCIMSTR_ON_SV                 0x0000u
  #define _UMISC_JMPST_PCIMSTR_OFF_SV                0x0001u
  #define _UMISC_JMPST_PCIMSTR_ENABLED_SV            0x0000u
  #define _UMISC_JMPST_PCIMSTR_DISABLED_SV           0x0001u

  #define UMISC_JMPST_OF(val)                        _VALUEOF16(val)
  #define UMISC_JMPST_DEFAULT (Uint16)(              \
      _PER_FDEFAULT16(UMISC,JMPST,SPARE)             \
    | _PER_FDEFAULT16(UMISC,JMPST,FLASHWE)           \
    | _PER_FDEFAULT16(UMISC,JMPST,BOOTMODE)          \
    | _PER_FDEFAULT16(UMISC,JMPST,PCIMSTR)           \
  )

  #define _UMISC_JMPST_FGET(FIELD)                   \
    _PER_FGET16(_UMISC_JMPST_ADDR,                   \
      UMISC,JMPST,##FIELD)

  #define _UMISC_JMPST_FSET(FIELD,field)             \
    _PER_FSET16(_UMISC_JMPST_ADDR,                   \
      UMISC,JMPST,##FIELD,field)

  #define _UMISC_JMPST_FSETS(FIELD,SYM)              \
    _PER_FSETS16(_UMISC_JMPST_ADDR,                  \
      UMISC,JMPST,##FIELD,##SYM)

  #define _UMISC_JMPST_FGETQ(FIELD,val)              \
    _PER_FGETQ16(_UMISC_JMPST_ADDR,                  \
      UMISC,JMPST,##FIELD,val)

  #define _UMISC_JMPST_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ16(_UMISC_JMPST_ADDR,                 \
      UMISC,JMPST,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  N M I C M D          |
* |_______________________|
*
* NMICMD - NMI Generator
*
* FIELDS (msb -> lsb)
* (.W)	CMD       	[15: 0]	 - Command
*
\******************************************************************************/
/*#define _UMISC_NMICMD_RECIDX                       No recorded */

  #define _UMISC_NMICMD_ADDR                         0x6C08001Cu

  #define _UMISC_NMICMD_REGOFFS                      0x0000001Cu
  #define _UMISC_NMICMD_REGOFFS16                    0x0000000Eu

  #define _UMISC_NMICMD_CMD_MASK                     0xFFFFu
  #define _UMISC_NMICMD_CMD_SHIFT                    0
  #define UMISC_NMICMD_CMD_DEFAULT                   0x0000u
  #define UMISC_NMICMD_CMD_OF(x)                     _VALUEOF16(x)
  #define UMISC_NMICMD_CMD_NMI                       0xAA55u
  #define _UMISC_NMICMD_CMD_NMI_SV                   0xAA55u

  #define UMISC_NMICMD_OF(val)                       _VALUEOF16(val)
  #define UMISC_NMICMD_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UMISC,NMICMD,CMD)              \
  )

  #define UMISC_NMICMD_RMK(cmd)                      \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,NMICMD,CMD,cmd)               \
  )

  #define _UMISC_NMICMD_FGET(FIELD)                  \
    _PER_FGET16(_UMISC_NMICMD_ADDR,                  \
      UMISC,NMICMD,##FIELD)

  #define _UMISC_NMICMD_FSET(FIELD,field)            \
    _PER_FSET16(_UMISC_NMICMD_ADDR,                  \
      UMISC,NMICMD,##FIELD,field)

  #define _UMISC_NMICMD_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UMISC_NMICMD_ADDR,                 \
      UMISC,NMICMD,##FIELD,##SYM)

  #define _UMISC_NMICMD_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UMISC_NMICMD_ADDR,                 \
      UMISC,NMICMD,##FIELD,val)

  #define _UMISC_NMICMD_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UMISC_NMICMD_ADDR,                \
      UMISC,NMICMD,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P R S T          |
* |_______________________|
*
* DSPRST - DSP Reset Generator
*
* FIELDS (msb -> lsb)
* (.W)	CMD       	[15: 0]	 - Command
*
\******************************************************************************/
/*#define _UMISC_DSPRST_RECIDX                       No recorded */

  #define _UMISC_DSPRST_ADDR                         0x6C08001Eu

  #define _UMISC_DSPRST_REGOFFS                      0x0000001Eu
  #define _UMISC_DSPRST_REGOFFS16                    0x0000000Fu

  #define _UMISC_DSPRST_CMD_MASK                     0xFFFFu
  #define _UMISC_DSPRST_CMD_SHIFT                    0
  #define UMISC_DSPRST_CMD_DEFAULT                   0x0000u
  #define UMISC_DSPRST_CMD_OF(x)                     _VALUEOF16(x)
  #define UMISC_DSPRST_CMD_RESET                     0xAA55u
  #define _UMISC_DSPRST_CMD_RESET_SV                 0xAA55u

  #define UMISC_DSPRST_OF(val)                       _VALUEOF16(val)
  #define UMISC_DSPRST_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UMISC,DSPRST,CMD)              \
  )

  #define UMISC_DSPRST_RMK(cmd)                      \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,DSPRST,CMD,cmd)               \
  )

  #define _UMISC_DSPRST_FGET(FIELD)                  \
    _PER_FGET16(_UMISC_DSPRST_ADDR,                  \
      UMISC,DSPRST,##FIELD)

  #define _UMISC_DSPRST_FSET(FIELD,field)            \
    _PER_FSET16(_UMISC_DSPRST_ADDR,                  \
      UMISC,DSPRST,##FIELD,field)

  #define _UMISC_DSPRST_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UMISC_DSPRST_ADDR,                 \
      UMISC,DSPRST,##FIELD,##SYM)

  #define _UMISC_DSPRST_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UMISC_DSPRST_ADDR,                 \
      UMISC,DSPRST,##FIELD,val)

  #define _UMISC_DSPRST_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UMISC_DSPRST_ADDR,                \
      UMISC,DSPRST,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  B M C T L            |
* |_______________________|
*
* BMCTL - Boot Mode Control/Status
*
* FIELDS (msb -> lsb)
* (RW)	OVRBMSEL  	[ 1: 1]	 - Override Boot Mode Select
* (RW)	OVREN     	[ 0: 0]	 - Override Enable
*
\******************************************************************************/
/*#define _UMISC_BMCTL_RECIDX                        No recorded */

  #define _UMISC_BMCTL_ADDR                          0x6C080020u

  #define _UMISC_BMCTL_REGOFFS                       0x00000020u
  #define _UMISC_BMCTL_REGOFFS16                     0x00000010u

  #define _UMISC_BMCTL_OVRBMSEL_MASK                 0x0002u
  #define _UMISC_BMCTL_OVRBMSEL_SHIFT                1
  #define UMISC_BMCTL_OVRBMSEL_DEFAULT               0x0000u
  #define UMISC_BMCTL_OVRBMSEL_OF(x)                 _VALUEOF16(x)
  #define UMISC_BMCTL_OVRBMSEL_PCI                   0x0000u
  #define UMISC_BMCTL_OVRBMSEL_HOST                  0x0000u
  #define UMISC_BMCTL_OVRBMSEL_FLASH                 0x0001u
  #define UMISC_BMCTL_OVRBMSEL_ROM                   0x0001u
  #define _UMISC_BMCTL_OVRBMSEL_PCI_SV               0x0000u
  #define _UMISC_BMCTL_OVRBMSEL_HOST_SV              0x0000u
  #define _UMISC_BMCTL_OVRBMSEL_FLASH_SV             0x0002u
  #define _UMISC_BMCTL_OVRBMSEL_ROM_SV               0x0002u

  #define _UMISC_BMCTL_OVREN_MASK                    0x0001u
  #define _UMISC_BMCTL_OVREN_SHIFT                   0
  #define UMISC_BMCTL_OVREN_DEFAULT                  0x0000u
  #define UMISC_BMCTL_OVREN_OF(x)                    _VALUEOF16(x)
  #define UMISC_BMCTL_OVREN_NO                       0x0000u
  #define UMISC_BMCTL_OVREN_YES                      0x0001u
  #define UMISC_BMCTL_OVREN_DISABLED                 0x0000u
  #define UMISC_BMCTL_OVREN_ENABLED                  0x0001u
  #define UMISC_BMCTL_OVREN_JUMPER                   0x0000u
  #define UMISC_BMCTL_OVREN_SWITCH                   0x0000u
  #define UMISC_BMCTL_OVREN_OVRVAL                   0x0001u
  #define UMISC_BMCTL_OVREN_OVRSEL                   0x0001u
  #define _UMISC_BMCTL_OVREN_NO_SV                   0x0000u
  #define _UMISC_BMCTL_OVREN_YES_SV                  0x0001u
  #define _UMISC_BMCTL_OVREN_DISABLED_SV             0x0000u
  #define _UMISC_BMCTL_OVREN_ENABLED_SV              0x0001u
  #define _UMISC_BMCTL_OVREN_JUMPER_SV               0x0000u
  #define _UMISC_BMCTL_OVREN_SWITCH_SV               0x0000u
  #define _UMISC_BMCTL_OVREN_OVRVAL_SV               0x0001u
  #define _UMISC_BMCTL_OVREN_OVRSEL_SV               0x0001u

  #define UMISC_BMCTL_OF(val)                        _VALUEOF16(val)
  #define UMISC_BMCTL_DEFAULT (Uint16)(              \
      _PER_FDEFAULT16(UMISC,BMCTL,OVRBMSEL)          \
    | _PER_FDEFAULT16(UMISC,BMCTL,OVREN)             \
  )

  #define UMISC_BMCTL_RMK(ovrbmsel,ovren)            \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,BMCTL,OVRBMSEL,ovrbmsel)      \
    | _PER_FMK16(UMISC,BMCTL,OVREN,ovren)            \
  )

  #define _UMISC_BMCTL_FGET(FIELD)                   \
    _PER_FGET16(_UMISC_BMCTL_ADDR,                   \
      UMISC,BMCTL,##FIELD)

  #define _UMISC_BMCTL_FSET(FIELD,field)             \
    _PER_FSET16(_UMISC_BMCTL_ADDR,                   \
      UMISC,BMCTL,##FIELD,field)

  #define _UMISC_BMCTL_FSETS(FIELD,SYM)              \
    _PER_FSETS16(_UMISC_BMCTL_ADDR,                  \
      UMISC,BMCTL,##FIELD,##SYM)

  #define _UMISC_BMCTL_FGETQ(FIELD,val)              \
    _PER_FGETQ16(_UMISC_BMCTL_ADDR,                  \
      UMISC,BMCTL,##FIELD,val)

  #define _UMISC_BMCTL_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ16(_UMISC_BMCTL_ADDR,                 \
      UMISC,BMCTL,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  S E R 2 C T L        |
* |_______________________|
*
* SER2CTL - McBSP 2 Control/Status
*
* FIELDS (msb -> lsb)
* (R.)	SERENST   	[ 4: 4]	 - McBSP 2 Enable Status
* (R.)	SEROEST   	[ 3: 3]	 - McBSP 2 OE Enable Status
* (RW)	OVRSEREN  	[ 2: 2]	 - Override McBSP 2 Enable
* (RW)	OVRSEROE  	[ 1: 1]	 - Override McBSP 2 OE Enable
* (RW)	OVREN     	[ 0: 0]	 - Override Enable
*
\******************************************************************************/
/*#define _UMISC_SER2CTL_RECIDX                      No recorded */

  #define _UMISC_SER2CTL_ADDR                        0x6C080022u

  #define _UMISC_SER2CTL_REGOFFS                     0x00000022u
  #define _UMISC_SER2CTL_REGOFFS16                   0x00000011u

  #define _UMISC_SER2CTL_SERENST_MASK                0x0010u
  #define _UMISC_SER2CTL_SERENST_SHIFT               4
  #define UMISC_SER2CTL_SERENST_DEFAULT              0x0000u
  #define UMISC_SER2CTL_SERENST_OF(x)                _VALUEOF16(x)
  #define UMISC_SER2CTL_SERENST_ENABLED              0x0000u
  #define UMISC_SER2CTL_SERENST_DISABLED             0x0001u
  #define UMISC_SER2CTL_SERENST_MCBSP                0x0000u
  #define UMISC_SER2CTL_SERENST_EEPROM               0x0001u
  #define UMISC_SER2CTL_SERENST_SERMODE              0x0000u
  #define UMISC_SER2CTL_SERENST_EEMODE               0x0001u
  #define _UMISC_SER2CTL_SERENST_ENABLED_SV          0x0000u
  #define _UMISC_SER2CTL_SERENST_DISABLED_SV         0x0010u
  #define _UMISC_SER2CTL_SERENST_MCBSP_SV            0x0000u
  #define _UMISC_SER2CTL_SERENST_EEPROM_SV           0x0010u
  #define _UMISC_SER2CTL_SERENST_SERMODE_SV          0x0000u
  #define _UMISC_SER2CTL_SERENST_EEMODE_SV           0x0010u

  #define _UMISC_SER2CTL_SEROEST_MASK                0x0008u
  #define _UMISC_SER2CTL_SEROEST_SHIFT               3
  #define UMISC_SER2CTL_SEROEST_DEFAULT              0x0000u
  #define UMISC_SER2CTL_SEROEST_OF(x)                _VALUEOF16(x)
  #define UMISC_SER2CTL_SEROEST_ENABLED              0x0000u
  #define UMISC_SER2CTL_SEROEST_DISABLED             0x0001u
  #define UMISC_SER2CTL_SEROEST_ACTIVE               0x0000u
  #define UMISC_SER2CTL_SEROEST_INACTIVE             0x0001u
  #define _UMISC_SER2CTL_SEROEST_ENABLED_SV          0x0000u
  #define _UMISC_SER2CTL_SEROEST_DISABLED_SV         0x0008u
  #define _UMISC_SER2CTL_SEROEST_ACTIVE_SV           0x0000u
  #define _UMISC_SER2CTL_SEROEST_INACTIVE_SV         0x0008u

  #define _UMISC_SER2CTL_OVRSEREN_MASK               0x0004u
  #define _UMISC_SER2CTL_OVRSEREN_SHIFT              2
  #define UMISC_SER2CTL_OVRSEREN_DEFAULT             0x0000u
  #define UMISC_SER2CTL_OVRSEREN_OF(x)               _VALUEOF16(x)
  #define UMISC_SER2CTL_OVRSEREN_ENABLED             0x0000u
  #define UMISC_SER2CTL_OVRSEREN_DISABLED            0x0001u
  #define UMISC_SER2CTL_OVRSEREN_MCBSP               0x0000u
  #define UMISC_SER2CTL_OVRSEREN_EEPROM              0x0001u
  #define UMISC_SER2CTL_OVRSEREN_SERMODE             0x0000u
  #define UMISC_SER2CTL_OVRSEREN_EEMODE              0x0001u
  #define _UMISC_SER2CTL_OVRSEREN_ENABLED_SV         0x0000u
  #define _UMISC_SER2CTL_OVRSEREN_DISABLED_SV        0x0004u
  #define _UMISC_SER2CTL_OVRSEREN_MCBSP_SV           0x0000u
  #define _UMISC_SER2CTL_OVRSEREN_EEPROM_SV          0x0004u
  #define _UMISC_SER2CTL_OVRSEREN_SERMODE_SV         0x0000u
  #define _UMISC_SER2CTL_OVRSEREN_EEMODE_SV          0x0004u

  #define _UMISC_SER2CTL_OVRSEROE_MASK               0x0002u
  #define _UMISC_SER2CTL_OVRSEROE_SHIFT              1
  #define UMISC_SER2CTL_OVRSEROE_DEFAULT             0x0000u
  #define UMISC_SER2CTL_OVRSEROE_OF(x)               _VALUEOF16(x)
  #define UMISC_SER2CTL_OVRSEROE_ENABLED             0x0000u
  #define UMISC_SER2CTL_OVRSEROE_DISABLED            0x0001u
  #define UMISC_SER2CTL_OVRSEROE_ACTIVE              0x0000u
  #define UMISC_SER2CTL_OVRSEROE_INACTIVE            0x0001u
  #define _UMISC_SER2CTL_OVRSEROE_ENABLED_SV         0x0000u
  #define _UMISC_SER2CTL_OVRSEROE_DISABLED_SV        0x0002u
  #define _UMISC_SER2CTL_OVRSEROE_ACTIVE_SV          0x0000u
  #define _UMISC_SER2CTL_OVRSEROE_INACTIVE_SV        0x0002u

  #define _UMISC_SER2CTL_OVREN_MASK                  0x0001u
  #define _UMISC_SER2CTL_OVREN_SHIFT                 0
  #define UMISC_SER2CTL_OVREN_DEFAULT                0x0000u
  #define UMISC_SER2CTL_OVREN_OF(x)                  _VALUEOF16(x)
  #define UMISC_SER2CTL_OVREN_NO                     0x0000u
  #define UMISC_SER2CTL_OVREN_YES                    0x0001u
  #define UMISC_SER2CTL_OVREN_DISABLED               0x0000u
  #define UMISC_SER2CTL_OVREN_ENABLED                0x0001u
  #define _UMISC_SER2CTL_OVREN_NO_SV                 0x0000u
  #define _UMISC_SER2CTL_OVREN_YES_SV                0x0001u
  #define _UMISC_SER2CTL_OVREN_DISABLED_SV           0x0000u
  #define _UMISC_SER2CTL_OVREN_ENABLED_SV            0x0001u

  #define UMISC_SER2CTL_OF(val)                      _VALUEOF16(val)
  #define UMISC_SER2CTL_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(UMISC,SER2CTL,SERENST)         \
    | _PER_FDEFAULT16(UMISC,SER2CTL,SEROEST)         \
    | _PER_FDEFAULT16(UMISC,SER2CTL,OVRSEREN)        \
    | _PER_FDEFAULT16(UMISC,SER2CTL,OVRSEROE)        \
    | _PER_FDEFAULT16(UMISC,SER2CTL,OVREN)           \
  )

  #define UMISC_SER2CTL_RMK(ovrseren,ovrseroe,       \
    ovren)                                           \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,SER2CTL,OVRSEREN,ovrseren)    \
    | _PER_FMK16(UMISC,SER2CTL,OVRSEROE,ovrseroe)    \
    | _PER_FMK16(UMISC,SER2CTL,OVREN,ovren)          \
  )

  #define _UMISC_SER2CTL_FGET(FIELD)                 \
    _PER_FGET16(_UMISC_SER2CTL_ADDR,                 \
      UMISC,SER2CTL,##FIELD)

  #define _UMISC_SER2CTL_FSET(FIELD,field)           \
    _PER_FSET16(_UMISC_SER2CTL_ADDR,                 \
      UMISC,SER2CTL,##FIELD,field)

  #define _UMISC_SER2CTL_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_UMISC_SER2CTL_ADDR,                \
      UMISC,SER2CTL,##FIELD,##SYM)

  #define _UMISC_SER2CTL_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_UMISC_SER2CTL_ADDR,                \
      UMISC,SER2CTL,##FIELD,val)

  #define _UMISC_SER2CTL_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_UMISC_SER2CTL_ADDR,               \
      UMISC,SER2CTL,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  L E D                |
* |_______________________|
*
* LED - LED Control/Status
*
* FIELDS (msb -> lsb)
* (RW)	TURN      	[ 3: 0]	 - Turn on/off
*
\******************************************************************************/
/*#define _UMISC_LED_RECIDX                          No recorded */

  #define _UMISC_LED_ADDR                            0x6C08003Au

  #define _UMISC_LED_REGOFFS                         0x0000003Au
  #define _UMISC_LED_REGOFFS16                       0x0000001Du

  #define _UMISC_LED_TURN_MASK                       0x000Fu
  #define _UMISC_LED_TURN_SHIFT                      0
  #define UMISC_LED_TURN_DEFAULT                     0x000Fu
  #define UMISC_LED_TURN_OF(x)                       _VALUEOF16(x)
  #define UMISC_LED_TURN_PULSE                       0x000Fu
  #define UMISC_LED_TURN_BLINK                       0x000Eu
  #define UMISC_LED_TURN_ON                          0x0001u
  #define UMISC_LED_TURN_OFF                         0x0000u
  #define UMISC_LED_TURN_LIGHT                       0x0001u
  #define UMISC_LED_TURN_DARK                        0x0000u
  #define _UMISC_LED_TURN_PULSE_SV                   0x000Fu
  #define _UMISC_LED_TURN_BLINK_SV                   0x000Eu
  #define _UMISC_LED_TURN_ON_SV                      0x0001u
  #define _UMISC_LED_TURN_OFF_SV                     0x0000u
  #define _UMISC_LED_TURN_LIGHT_SV                   0x0001u
  #define _UMISC_LED_TURN_DARK_SV                    0x0000u

  #define UMISC_LED_OF(val)                          _VALUEOF16(val)
  #define UMISC_LED_DEFAULT (Uint16)(                \
      _PER_FDEFAULT16(UMISC,LED,TURN)                \
  )

  #define UMISC_LED_RMK(turn)                        \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,LED,TURN,turn)                \
  )

  #define _UMISC_LED_FGET(FIELD)                     \
    _PER_FGET16(_UMISC_LED_ADDR,                     \
      UMISC,LED,##FIELD)

  #define _UMISC_LED_FSET(FIELD,field)               \
    _PER_FSET16(_UMISC_LED_ADDR,                     \
      UMISC,LED,##FIELD,field)

  #define _UMISC_LED_FSETS(FIELD,SYM)                \
    _PER_FSETS16(_UMISC_LED_ADDR,                    \
      UMISC,LED,##FIELD,##SYM)

  #define _UMISC_LED_FGETQ(FIELD,val)                \
    _PER_FGETQ16(_UMISC_LED_ADDR,                    \
      UMISC,LED,##FIELD,val)

  #define _UMISC_LED_FGETSQ(FIELD,SYM)               \
    _PER_FGETSQ16(_UMISC_LED_ADDR,                   \
      UMISC,LED,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P B C T L 0          |
* |_______________________|
*
* PBCTL0 - Platform Bus Control 0
*
* FIELDS (msb -> lsb)
* (RW)	RESET     	[15:15]	 - Reset Signal on Platform Bus
* (RW)	RDSTRB    	[13: 8]	 - Read Strobe
* (RW)	RDHOLD    	[ 1: 0]	 - Read Hold
*
\******************************************************************************/
/*#define _UMISC_PBCTL0_RECIDX                       No recorded */

  #define _UMISC_PBCTL0_ADDR                         0x6C080040u

  #define _UMISC_PBCTL0_REGOFFS                      0x00000040u
  #define _UMISC_PBCTL0_REGOFFS16                    0x00000020u

  #define _UMISC_PBCTL0_RESET_MASK                   0x8000u
  #define _UMISC_PBCTL0_RESET_SHIFT                  15
  #define UMISC_PBCTL0_RESET_DEFAULT                 0x0000u
  #define UMISC_PBCTL0_RESET_OF(x)                   _VALUEOF16(x)
  #define UMISC_PBCTL0_RESET_INACTIVE                0x0000u
  #define UMISC_PBCTL0_RESET_ACTIVE                  0x0001u
  #define UMISC_PBCTL0_RESET_OFF                     0x0000u
  #define UMISC_PBCTL0_RESET_ON                      0x0001u
  #define _UMISC_PBCTL0_RESET_INACTIVE_SV            0x0000u
  #define _UMISC_PBCTL0_RESET_ACTIVE_SV              0x8000u
  #define _UMISC_PBCTL0_RESET_OFF_SV                 0x0000u
  #define _UMISC_PBCTL0_RESET_ON_SV                  0x8000u

  #define _UMISC_PBCTL0_RDSTRB_MASK                  0x3F00u
  #define _UMISC_PBCTL0_RDSTRB_SHIFT                 8
  #define UMISC_PBCTL0_RDSTRB_DEFAULT                0x0000u
  #define UMISC_PBCTL0_RDSTRB_OF(x)                  _VALUEOF16(x)

  #define _UMISC_PBCTL0_RDHOLD_MASK                  0x0003u
  #define _UMISC_PBCTL0_RDHOLD_SHIFT                 0
  #define UMISC_PBCTL0_RDHOLD_DEFAULT                0x0000u
  #define UMISC_PBCTL0_RDHOLD_OF(x)                  _VALUEOF16(x)

  #define UMISC_PBCTL0_OF(val)                       _VALUEOF16(val)
  #define UMISC_PBCTL0_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UMISC,PBCTL0,RESET)            \
    | _PER_FDEFAULT16(UMISC,PBCTL0,RDSTRB)           \
    | _PER_FDEFAULT16(UMISC,PBCTL0,RDHOLD)           \
  )

  #define UMISC_PBCTL0_RMK(reset,rdstrb,rdhold)      \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,PBCTL0,RESET,reset)           \
    | _PER_FMK16(UMISC,PBCTL0,RDSTRB,rdstrb)         \
    | _PER_FMK16(UMISC,PBCTL0,RDHOLD,rdhold)         \
  )

  #define _UMISC_PBCTL0_FGET(FIELD)                  \
    _PER_FGET16(_UMISC_PBCTL0_ADDR,                  \
      UMISC,PBCTL0,##FIELD)

  #define _UMISC_PBCTL0_FSET(FIELD,field)            \
    _PER_FSET16(_UMISC_PBCTL0_ADDR,                  \
      UMISC,PBCTL0,##FIELD,field)

  #define _UMISC_PBCTL0_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UMISC_PBCTL0_ADDR,                 \
      UMISC,PBCTL0,##FIELD,##SYM)

  #define _UMISC_PBCTL0_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UMISC_PBCTL0_ADDR,                 \
      UMISC,PBCTL0,##FIELD,val)

  #define _UMISC_PBCTL0_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UMISC_PBCTL0_ADDR,                \
      UMISC,PBCTL0,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P B C T L 1          |
* |_______________________|
*
* PBCTL1 - Platform Bus Control 1
*
* FIELDS (msb -> lsb)
* (RW)	WRSTUP    	[15:12]	 - Write Setup
* (RW)	WRSTRB    	[11: 6]	 - Write Strobe
* (RW)	WRHOLD    	[ 5: 4]	 - Write Hold
* (RW)	RDSTUP    	[ 3: 0]	 - Read Setup
*
\******************************************************************************/
/*#define _UMISC_PBCTL1_RECIDX                       No recorded */

  #define _UMISC_PBCTL1_ADDR                         0x6C080042u

  #define _UMISC_PBCTL1_REGOFFS                      0x00000042u
  #define _UMISC_PBCTL1_REGOFFS16                    0x00000021u

  #define _UMISC_PBCTL1_WRSTUP_MASK                  0xF000u
  #define _UMISC_PBCTL1_WRSTUP_SHIFT                 12
  #define UMISC_PBCTL1_WRSTUP_DEFAULT                0x0000u
  #define UMISC_PBCTL1_WRSTUP_OF(x)                  _VALUEOF16(x)

  #define _UMISC_PBCTL1_WRSTRB_MASK                  0x0FC0u
  #define _UMISC_PBCTL1_WRSTRB_SHIFT                 6
  #define UMISC_PBCTL1_WRSTRB_DEFAULT                0x0000u
  #define UMISC_PBCTL1_WRSTRB_OF(x)                  _VALUEOF16(x)

  #define _UMISC_PBCTL1_WRHOLD_MASK                  0x0030u
  #define _UMISC_PBCTL1_WRHOLD_SHIFT                 4
  #define UMISC_PBCTL1_WRHOLD_DEFAULT                0x0000u
  #define UMISC_PBCTL1_WRHOLD_OF(x)                  _VALUEOF16(x)

  #define _UMISC_PBCTL1_RDSTUP_MASK                  0x000Fu
  #define _UMISC_PBCTL1_RDSTUP_SHIFT                 0
  #define UMISC_PBCTL1_RDSTUP_DEFAULT                0x0000u
  #define UMISC_PBCTL1_RDSTUP_OF(x)                  _VALUEOF16(x)

  #define UMISC_PBCTL1_OF(val)                       _VALUEOF16(val)
  #define UMISC_PBCTL1_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UMISC,PBCTL1,WRSTUP)           \
    | _PER_FDEFAULT16(UMISC,PBCTL1,WRSTRB)           \
    | _PER_FDEFAULT16(UMISC,PBCTL1,WRHOLD)           \
    | _PER_FDEFAULT16(UMISC,PBCTL1,RDSTUP)           \
  )

  #define UMISC_PBCTL1_RMK(wrstup,wrstrb,wrhold,     \
    rdstup)                                          \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,PBCTL1,WRSTUP,wrstup)         \
    | _PER_FMK16(UMISC,PBCTL1,WRSTRB,wrstrb)         \
    | _PER_FMK16(UMISC,PBCTL1,WRHOLD,wrhold)         \
    | _PER_FMK16(UMISC,PBCTL1,RDSTUP,rdstup)         \
  )

  #define _UMISC_PBCTL1_FGET(FIELD)                  \
    _PER_FGET16(_UMISC_PBCTL1_ADDR,                  \
      UMISC,PBCTL1,##FIELD)

  #define _UMISC_PBCTL1_FSET(FIELD,field)            \
    _PER_FSET16(_UMISC_PBCTL1_ADDR,                  \
      UMISC,PBCTL1,##FIELD,field)

  #define _UMISC_PBCTL1_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UMISC_PBCTL1_ADDR,                 \
      UMISC,PBCTL1,##FIELD,##SYM)

  #define _UMISC_PBCTL1_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UMISC_PBCTL1_ADDR,                 \
      UMISC,PBCTL1,##FIELD,val)

  #define _UMISC_PBCTL1_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UMISC_PBCTL1_ADDR,                \
      UMISC,PBCTL1,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P S P E E D      |
* |_______________________|
*
* DSPSPEED - DSP core speed
*
* FIELDS (msb -> lsb)
* (R.)	SPEED     	[11: 0]	 - Detected DSP core speed in MHz at power-on-reset
*
\******************************************************************************/
/*#define _UMISC_DSPSPEED_RECIDX                     No recorded */

  #define _UMISC_DSPSPEED_ADDR                       0x6C0800FCu

  #define _UMISC_DSPSPEED_REGOFFS                    0x000000FCu
  #define _UMISC_DSPSPEED_REGOFFS16                  0x0000007Eu

  #define _UMISC_DSPSPEED_SPEED_MASK                 0x0FFFu
  #define _UMISC_DSPSPEED_SPEED_SHIFT                0
  #define UMISC_DSPSPEED_SPEED_DEFAULT               0x0000u
  #define UMISC_DSPSPEED_SPEED_OF(x)                 _VALUEOF16(x)

  #define UMISC_DSPSPEED_OF(val)                     _VALUEOF16(val)
  #define UMISC_DSPSPEED_DEFAULT (Uint16)(           \
      _PER_FDEFAULT16(UMISC,DSPSPEED,SPEED)          \
  )

  #define _UMISC_DSPSPEED_FGET(FIELD)                \
    _PER_FGET16(_UMISC_DSPSPEED_ADDR,                \
      UMISC,DSPSPEED,##FIELD)

  #define _UMISC_DSPSPEED_FSET(FIELD,field)          \
    _PER_FSET16(_UMISC_DSPSPEED_ADDR,                \
      UMISC,DSPSPEED,##FIELD,field)

  #define _UMISC_DSPSPEED_FSETS(FIELD,SYM)           \
    _PER_FSETS16(_UMISC_DSPSPEED_ADDR,               \
      UMISC,DSPSPEED,##FIELD,##SYM)

  #define _UMISC_DSPSPEED_FGETQ(FIELD,val)           \
    _PER_FGETQ16(_UMISC_DSPSPEED_ADDR,               \
      UMISC,DSPSPEED,##FIELD,val)

  #define _UMISC_DSPSPEED_FGETSQ(FIELD,SYM)          \
    _PER_FGETSQ16(_UMISC_DSPSPEED_ADDR,              \
      UMISC,DSPSPEED,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  V E R S I O N        |
* |_______________________|
*
* VERSION - HW Version Descriptor
*
* FIELDS (msb -> lsb)
* (R.)	FPGACAP3  	[15:15]	 - FPGA Capabilities (bit 3)
* (R.)	FPGACAP2  	[14:14]	 - FPGA Capabilities (bit 2)
* (R.)	FPGACAP1  	[13:13]	 - FPGA Capabilities (bit 1)
* (R.)	FPGACAP0  	[12:12]	 - FPGA Capabilities (bit 0)
* (R.)	CUSTOMID  	[11: 8]	 - Custom Design Identifier
* (R.)	MAJORREV  	[ 7: 4]	 - Major Revision
* (R.)	MINORREV  	[ 3: 0]	 - Minor Revision
*
\******************************************************************************/
/*#define _UMISC_VERSION_RECIDX                      No recorded */

  #define _UMISC_VERSION_ADDR                        0x6C0800FEu

  #define _UMISC_VERSION_REGOFFS                     0x000000FEu
  #define _UMISC_VERSION_REGOFFS16                   0x0000007Fu

  #define _UMISC_VERSION_FPGACAP3_MASK               0x8000u
  #define _UMISC_VERSION_FPGACAP3_SHIFT              15
  #define UMISC_VERSION_FPGACAP3_DEFAULT             0x0000u
  #define UMISC_VERSION_FPGACAP3_OF(x)               _VALUEOF16(x)
  #define UMISC_VERSION_FPGACAP3_DEFAULT             0x0000u
  #define _UMISC_VERSION_FPGACAP3_DEFAULT_SV         0x0000u

  #define _UMISC_VERSION_FPGACAP2_MASK               0x4000u
  #define _UMISC_VERSION_FPGACAP2_SHIFT              14
  #define UMISC_VERSION_FPGACAP2_DEFAULT             0x0000u
  #define UMISC_VERSION_FPGACAP2_OF(x)               _VALUEOF16(x)
  #define UMISC_VERSION_FPGACAP2_DEFAULT             0x0000u
  #define _UMISC_VERSION_FPGACAP2_DEFAULT_SV         0x0000u

  #define _UMISC_VERSION_FPGACAP1_MASK               0x2000u
  #define _UMISC_VERSION_FPGACAP1_SHIFT              13
  #define UMISC_VERSION_FPGACAP1_DEFAULT             0x0000u
  #define UMISC_VERSION_FPGACAP1_OF(x)               _VALUEOF16(x)
  #define UMISC_VERSION_FPGACAP1_DEFAULT             0x0000u
  #define _UMISC_VERSION_FPGACAP1_DEFAULT_SV         0x0000u

  #define _UMISC_VERSION_FPGACAP0_MASK               0x1000u
  #define _UMISC_VERSION_FPGACAP0_SHIFT              12
  #define UMISC_VERSION_FPGACAP0_DEFAULT             0x0000u
  #define UMISC_VERSION_FPGACAP0_OF(x)               _VALUEOF16(x)
  #define UMISC_VERSION_FPGACAP0_PB1                 0x0000u
  #define UMISC_VERSION_FPGACAP0_PB2                 0x0001u
  #define _UMISC_VERSION_FPGACAP0_PB1_SV             0x0000u
  #define _UMISC_VERSION_FPGACAP0_PB2_SV             0x1000u

  #define _UMISC_VERSION_CUSTOMID_MASK               0x0F00u
  #define _UMISC_VERSION_CUSTOMID_SHIFT              8
  #define UMISC_VERSION_CUSTOMID_DEFAULT             0x0000u
  #define UMISC_VERSION_CUSTOMID_OF(x)               _VALUEOF16(x)
  #define UMISC_VERSION_CUSTOMID_STD                 0x0000u
  #define UMISC_VERSION_CUSTOMID_ENG                 0x000Fu
  #define UMISC_VERSION_CUSTOMID_DEV                 0x000Fu
  #define _UMISC_VERSION_CUSTOMID_STD_SV             0x0000u
  #define _UMISC_VERSION_CUSTOMID_ENG_SV             0x0F00u
  #define _UMISC_VERSION_CUSTOMID_DEV_SV             0x0F00u

  #define _UMISC_VERSION_MAJORREV_MASK               0x00F0u
  #define _UMISC_VERSION_MAJORREV_SHIFT              4
  #define UMISC_VERSION_MAJORREV_DEFAULT             0x0000u
  #define UMISC_VERSION_MAJORREV_OF(x)               _VALUEOF16(x)

  #define _UMISC_VERSION_MINORREV_MASK               0x000Fu
  #define _UMISC_VERSION_MINORREV_SHIFT              0
  #define UMISC_VERSION_MINORREV_DEFAULT             0x0000u
  #define UMISC_VERSION_MINORREV_OF(x)               _VALUEOF16(x)

  #define UMISC_VERSION_OF(val)                      _VALUEOF16(val)
  #define UMISC_VERSION_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(UMISC,VERSION,FPGACAP3)        \
    | _PER_FDEFAULT16(UMISC,VERSION,FPGACAP2)        \
    | _PER_FDEFAULT16(UMISC,VERSION,FPGACAP1)        \
    | _PER_FDEFAULT16(UMISC,VERSION,FPGACAP0)        \
    | _PER_FDEFAULT16(UMISC,VERSION,CUSTOMID)        \
    | _PER_FDEFAULT16(UMISC,VERSION,MAJORREV)        \
    | _PER_FDEFAULT16(UMISC,VERSION,MINORREV)        \
  )

  #define _UMISC_VERSION_FGET(FIELD)                 \
    _PER_FGET16(_UMISC_VERSION_ADDR,                 \
      UMISC,VERSION,##FIELD)

  #define _UMISC_VERSION_FSET(FIELD,field)           \
    _PER_FSET16(_UMISC_VERSION_ADDR,                 \
      UMISC,VERSION,##FIELD,field)

  #define _UMISC_VERSION_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_UMISC_VERSION_ADDR,                \
      UMISC,VERSION,##FIELD,##SYM)

  #define _UMISC_VERSION_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_UMISC_VERSION_ADDR,                \
      UMISC,VERSION,##FIELD,val)

  #define _UMISC_VERSION_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_UMISC_VERSION_ADDR,               \
      UMISC,VERSION,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D H C O M M          |
* |_______________________|
*
* DHCOMM - DSP-Host Communication
*
* FIELDS (msb -> lsb)
* (RW)	DSPINUSE  	[ 0: 0]	 - "DSP is in use" flag
*
\******************************************************************************/
/*#define _UMISC_DHCOMM_RECIDX                       No recorded */

  #define _UMISC_DHCOMM_ADDR                         0x6C080082u

  #define _UMISC_DHCOMM_REGOFFS                      0x00000082u
  #define _UMISC_DHCOMM_REGOFFS16                    0x00000041u

  #define _UMISC_DHCOMM_DSPINUSE_MASK                0x0001u
  #define _UMISC_DHCOMM_DSPINUSE_SHIFT               0
  #define UMISC_DHCOMM_DSPINUSE_DEFAULT              0x0000u
  #define UMISC_DHCOMM_DSPINUSE_OF(x)                _VALUEOF16(x)
  #define UMISC_DHCOMM_DSPINUSE_INUSE                0x0001u
  #define _UMISC_DHCOMM_DSPINUSE_INUSE_SV            0x0001u

  #define UMISC_DHCOMM_OF(val)                       _VALUEOF16(val)
  #define UMISC_DHCOMM_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(UMISC,DHCOMM,DSPINUSE)         \
  )

  #define UMISC_DHCOMM_RMK(dspinuse)                 \
    (Uint16)(                                        \
      _PER_FMK16(UMISC,DHCOMM,DSPINUSE,dspinuse)     \
  )

  #define _UMISC_DHCOMM_FGET(FIELD)                  \
    _PER_FGET16(_UMISC_DHCOMM_ADDR,                  \
      UMISC,DHCOMM,##FIELD)

  #define _UMISC_DHCOMM_FSET(FIELD,field)            \
    _PER_FSET16(_UMISC_DHCOMM_ADDR,                  \
      UMISC,DHCOMM,##FIELD,field)

  #define _UMISC_DHCOMM_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_UMISC_DHCOMM_ADDR,                 \
      UMISC,DHCOMM,##FIELD,##SYM)

  #define _UMISC_DHCOMM_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_UMISC_DHCOMM_ADDR,                 \
      UMISC,DHCOMM,##FIELD,val)

  #define _UMISC_DHCOMM_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_UMISC_DHCOMM_ADDR,                \
      UMISC,DHCOMM,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_UMISC_SUPPORT) */
#endif /* _BSL_UMISCHAL_H_ */
/******************************************************************************\
* End of bsl_umischal.h
\******************************************************************************/
