/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral USIG
* FILENAME......... bsl_usig.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 13:22:58
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. USIG
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_USIG_H_
#define _BSL_USIG_H_

#include <bsl_usighal.h>


#if (BSL_USIG_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_USIG_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/



/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint16 regDSPTIN0;
	Uint16 regDSPTIN1;
	Uint16 regDSPTIN2;
	Uint16 regPBTOUT0;
	Uint16 regPBTOUT1;
	Uint16 regDSPGPIO0;
	Uint16 regDSPGPIO1;
	Uint16 regDSPGPIO2;
	Uint16 regDSPGPIO3;
} USIG_Config;

/* object structure */
typedef struct {
	Uint32 baseAddr;
} USIG_Obj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI USIG_Obj _USIG_obj;	/* defined in bsl_usig.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/

BSLAPI void USIG_reset();


/******************************************************************************\
* inline function declarations
\******************************************************************************/

IDECL void USIG_config(USIG_Config *config);
IDECL void USIG_configArgs(Uint32 dsptin0, Uint32 dsptin1, Uint32 dsptin2,
	Uint32 pbtout0, Uint32 pbtout1, Uint32 dspgpio0, Uint32 dspgpio1,
	Uint32 dspgpio2, Uint32 dspgpio3);
IDECL void USIG_getConfig(USIG_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF void USIG_config(USIG_Config *config)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_USIG_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regDSPTIN0;
	r1 = config->regDSPTIN1;
	r2 = config->regDSPTIN2;
	r3 = config->regPBTOUT0;
	r4 = config->regPBTOUT1;
	base[_USIG_DSPTIN0_REGOFFS16] = (Uint16)(r0);
	r0 = config->regDSPGPIO0;
	base[_USIG_DSPTIN1_REGOFFS16] = (Uint16)(r1);
	r1 = config->regDSPGPIO1;
	base[_USIG_DSPTIN2_REGOFFS16] = (Uint16)(r2);
	r2 = config->regDSPGPIO2;
	base[_USIG_PBTOUT0_REGOFFS16] = (Uint16)(r3);
	r3 = config->regDSPGPIO3;
	base[_USIG_PBTOUT1_REGOFFS16] = (Uint16)(r4);
	base[_USIG_DSPGPIO0_REGOFFS16] = (Uint16)(r0);
	base[_USIG_DSPGPIO1_REGOFFS16] = (Uint16)(r1);
	base[_USIG_DSPGPIO2_REGOFFS16] = (Uint16)(r2);
	base[_USIG_DSPGPIO3_REGOFFS16] = (Uint16)(r3);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void USIG_configArgs(Uint32 dsptin0, Uint32 dsptin1, Uint32 dsptin2,
	Uint32 pbtout0, Uint32 pbtout1, Uint32 dspgpio0, Uint32 dspgpio1,
	Uint32 dspgpio2, Uint32 dspgpio3)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint16 *)(_USIG_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = dsptin0;
	r1 = dsptin1;
	r2 = dsptin2;
	r3 = pbtout0;
	r4 = pbtout1;
	base[_USIG_DSPTIN0_REGOFFS16] = (Uint16)(r0);
	r0 = dspgpio0;
	base[_USIG_DSPTIN1_REGOFFS16] = (Uint16)(r1);
	r1 = dspgpio1;
	base[_USIG_DSPTIN2_REGOFFS16] = (Uint16)(r2);
	r2 = dspgpio2;
	base[_USIG_PBTOUT0_REGOFFS16] = (Uint16)(r3);
	r3 = dspgpio3;
	base[_USIG_PBTOUT1_REGOFFS16] = (Uint16)(r4);
	base[_USIG_DSPGPIO0_REGOFFS16] = (Uint16)(r0);
	base[_USIG_DSPGPIO1_REGOFFS16] = (Uint16)(r1);
	base[_USIG_DSPGPIO2_REGOFFS16] = (Uint16)(r2);
	base[_USIG_DSPGPIO3_REGOFFS16] = (Uint16)(r3);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void USIG_getConfig(USIG_Config *config)
{
	Uint32 gie;
	volatile USIG_Config *cfg;
	cfg = (volatile USIG_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regDSPTIN0 = USIG_RGET(DSPTIN0);
	cfg->regDSPTIN1 = USIG_RGET(DSPTIN1);
	cfg->regDSPTIN2 = USIG_RGET(DSPTIN2);
	cfg->regPBTOUT0 = USIG_RGET(PBTOUT0);
	cfg->regPBTOUT1 = USIG_RGET(PBTOUT1);
	cfg->regDSPGPIO0 = USIG_RGET(DSPGPIO0);
	cfg->regDSPGPIO1 = USIG_RGET(DSPGPIO1);
	cfg->regDSPGPIO2 = USIG_RGET(DSPGPIO2);
	cfg->regDSPGPIO3 = USIG_RGET(DSPGPIO3);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_USIG_SUPPORT */
#endif /* _BSL_USIG_H_ */
/******************************************************************************\
* End of bsl_usig.h
\******************************************************************************/
