/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Utility functions
* FILENAME......... bsl_util.h
\******************************************************************************/
#ifndef _BSL_UTIL_H_
#define _BSL_UTIL_H_

#include <bsl.h>


/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_UINT_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

// defines for timerMode parameter of the UTIL_getTimerPeriod()
#define UTIL_GTP_PULSE_MODE					0
#define UTIL_GTP_CLOCK_MODE					1

// defines for roundMode parameter of the UTIL_getTimerPeriod()
#define UTIL_GTP_LOWER_FREQ					0
#define UTIL_GTP_HIGHER_FREQ				1
#define UTIL_GTP_LONGER_PERIOD				0
#define UTIL_GTP_SHORTER_PERIOD				1


/******************************************************************************\
* global typedef declarations
\******************************************************************************/


/******************************************************************************\
* global variable declarations
\******************************************************************************/


/******************************************************************************\
* global function declarations
\******************************************************************************/

//==============================================================================
// Returns the value for the timer's period register according to the desired
// frequency and the timer and the round modes.
//
// parameters:
//	desiredFreqInHz		Desired frequency in Hz.
//	timerMode			Selects the operating mode of the timer. Can be pulse
//						or clock.
//						UTIL_GTP_PULSE_MODE for pulse mode timer setting
//						UTIL_GTP_CLOCK_MODE for clock mode timer setting
//	roundMode			Defines how to calculate the exact value of the period
//						register, if the value is not an integer number
//						according to the desired frequency.
//						UTIL_GTP_LOWER_FREQ or
//						UTIL_GTP_LONGER_PERIOD for getting a lower frequency
//						UTIL_GTP_HIGHER_FREQ or
//						UTIL_GTP_SHORTER_PERIOD for getting a higher frequency
//	gotFreqInHz			Pointer to a double-type variable to return the got
//						frequency after rounding. The pointer can be NULL.
//
// returns:
//	Timer's period register value.
//==============================================================================
BSLAPI Uint32 UTIL_getTimerPeriod(
	double desiredFreqInHz, Uint32 timerMode, Uint32 roundMode,
	double * gotFreqInHz);


/******************************************************************************\
* inline function declarations
\******************************************************************************/


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

#endif /* USEDEFS */


#endif /* _BSL_UTIL_H_ */
/******************************************************************************\
* End of bsl_util.h
\******************************************************************************/
