/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral WATCHDOG
* FILENAME......... bsl_watchdoghal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 03/15/2004 10:17:52
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. WATCHDOG
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. WATCHDOG is 0x6C080000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* CTL         -  Control/Status
* TRIG        -  Trigger (to reset the watchdog's timer)
*
\******************************************************************************/
#ifndef _BSL_WATCHDOGHAL_H_
#define _BSL_WATCHDOGHAL_H_

#include <bsl.h>


#if (BSL_WATCHDOG_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _WATCHDOG_DEVICE_COUNT                     1

  #define _WATCHDOG_BASE_ADDRESS                     0x6C080000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define WATCHDOG_FMK(REG,FIELD,val)\
    _PER_FMK16(WATCHDOG,##REG,##FIELD,val)

  #define WATCHDOG_FMKS(REG,FIELD,SYM)\
    _PER_FMKS16(WATCHDOG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define WATCHDOG_ADDR(REG)\
    _WATCHDOG_##REG##_ADDR

  #define WATCHDOG_RGET(REG)\
    _PER_RGET16(_WATCHDOG_##REG##_ADDR,WATCHDOG,##REG)

  #define WATCHDOG_RSET(REG,val)\
    _PER_RSET16(_WATCHDOG_##REG##_ADDR,WATCHDOG,##REG,val)

  #define WATCHDOG_RFSETS(REG,FIELD,SYM)\
    WATCHDOG_RSET(##REG,_WATCHDOG_##REG##_##FIELD##_##SYM##_SV)

  #define WATCHDOG_FGET(REG,FIELD)\
    _WATCHDOG_##REG##_FGET(##FIELD)

  #define WATCHDOG_FSET(REG,FIELD,val)\
    _WATCHDOG_##REG##_FSET(##FIELD,val)

  #define WATCHDOG_FSETS(REG,FIELD,SYM)\
    _WATCHDOG_##REG##_FSETS(##FIELD,##SYM)

  #define WATCHDOG_FGETQ(REG,FIELD,val)\
    _WATCHDOG_##REG##_FGETQ(##FIELD,val)

  #define WATCHDOG_FGETSQ(REG,FIELD,SYM)\
    _WATCHDOG_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define WATCHDOG_RGETA(addr,REG)\
    _PER_RGET16(addr,WATCHDOG,##REG)

  #define WATCHDOG_RSETA(addr,REG,val)\
    _PER_RSET16(addr,WATCHDOG,##REG,val)

  #define WATCHDOG_RFSETSA(addr,REG,FIELD,SYM)\
    WATCHDOG_RSETA(addr,##REG,_WATCHDOG_##REG##_##FIELD##_##SYM##_SV)

  #define WATCHDOG_FGETA(addr,REG,FIELD)\
    _PER_FGET16(addr,WATCHDOG,##REG,##FIELD)

  #define WATCHDOG_FSETA(addr,REG,FIELD,val)\
    _PER_FSET16(addr,WATCHDOG,##REG,##FIELD,val)

  #define WATCHDOG_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS16(addr,WATCHDOG,##REG,##FIELD,##SYM)

  #define WATCHDOG_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ16(addr,WATCHDOG,##REG,##FIELD,val)

  #define WATCHDOG_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ16(addr,WATCHDOG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define WATCHDOG_VRGET(var,REG)\
    _PER_VRGET16(var,WATCHDOG,##REG)

  #define WATCHDOG_VRSET(var,REG,val)\
    _PER_VRSET16(var,WATCHDOG,##REG,val)

  #define WATCHDOG_VRFSETS(var,REG,FIELD,SYM)\
    WATCHDOG_VRSET(var,##REG,_WATCHDOG_##REG##_##FIELD##_##SYM##_SV)

  #define WATCHDOG_VFGET(var,REG,FIELD)\
    _PER_VFGET16(var,WATCHDOG,##REG,##FIELD)

  #define WATCHDOG_VFSET(var,REG,FIELD,val)\
    _PER_VFSET16(var,WATCHDOG,##REG,##FIELD,val)

  #define WATCHDOG_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS16(var,WATCHDOG,##REG,##FIELD,##SYM)

  #define WATCHDOG_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ16(var,WATCHDOG,##REG,##FIELD,val)

  #define WATCHDOG_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ16(var,WATCHDOG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  C T L                |
* |_______________________|
*
* CTL - Control/Status
*
* FIELDS (msb -> lsb)
* (RW)	WDBGEN    	[ 3: 3]	 - Watchdog B Generates...
* (RW)	WDBTO     	[ 2: 2]	 - Watchdog B Timeout
* (RW)	WDBEN     	[ 1: 1]	 - Watchdog B Enable
* (RW)	WDAEN     	[ 0: 0]	 - Watchdog A Enable
*
\******************************************************************************/
/*#define _WATCHDOG_CTL_RECIDX                       No recorded */

  #define _WATCHDOG_CTL_ADDR                         0x6C080018u

  #define _WATCHDOG_CTL_REGOFFS                      0x00000018u
  #define _WATCHDOG_CTL_REGOFFS16                    0x0000000Cu

  #define _WATCHDOG_CTL_WDBGEN_MASK                  0x0008u
  #define _WATCHDOG_CTL_WDBGEN_SHIFT                 3
  #define WATCHDOG_CTL_WDBGEN_DEFAULT                0x0000u
  #define WATCHDOG_CTL_WDBGEN_OF(x)                  _VALUEOF16(x)
  #define WATCHDOG_CTL_WDBGEN_RESET                  0x0000u
  #define WATCHDOG_CTL_WDBGEN_NMI                    0x0001u
  #define _WATCHDOG_CTL_WDBGEN_RESET_SV              0x0000u
  #define _WATCHDOG_CTL_WDBGEN_NMI_SV                0x0008u

  #define _WATCHDOG_CTL_WDBTO_MASK                   0x0004u
  #define _WATCHDOG_CTL_WDBTO_SHIFT                  2
  #define WATCHDOG_CTL_WDBTO_DEFAULT                 0x0000u
  #define WATCHDOG_CTL_WDBTO_OF(x)                   _VALUEOF16(x)
  #define WATCHDOG_CTL_WDBTO_TO5S3                   0x0000u
  #define WATCHDOG_CTL_WDBTO_TO336MS                 0x0001u
  #define _WATCHDOG_CTL_WDBTO_TO5S3_SV               0x0000u
  #define _WATCHDOG_CTL_WDBTO_TO336MS_SV             0x0004u

  #define _WATCHDOG_CTL_WDBEN_MASK                   0x0002u
  #define _WATCHDOG_CTL_WDBEN_SHIFT                  1
  #define WATCHDOG_CTL_WDBEN_DEFAULT                 0x0000u
  #define WATCHDOG_CTL_WDBEN_OF(x)                   _VALUEOF16(x)
  #define WATCHDOG_CTL_WDBEN_DISABLE                 0x0000u
  #define WATCHDOG_CTL_WDBEN_ENABLE                  0x0001u
  #define WATCHDOG_CTL_WDBEN_DISABLED                0x0000u
  #define WATCHDOG_CTL_WDBEN_ENABLED                 0x0001u
  #define WATCHDOG_CTL_WDBEN_NO                      0x0000u
  #define WATCHDOG_CTL_WDBEN_YES                     0x0001u
  #define _WATCHDOG_CTL_WDBEN_DISABLE_SV             0x0000u
  #define _WATCHDOG_CTL_WDBEN_ENABLE_SV              0x0002u
  #define _WATCHDOG_CTL_WDBEN_DISABLED_SV            0x0000u
  #define _WATCHDOG_CTL_WDBEN_ENABLED_SV             0x0002u
  #define _WATCHDOG_CTL_WDBEN_NO_SV                  0x0000u
  #define _WATCHDOG_CTL_WDBEN_YES_SV                 0x0002u

  #define _WATCHDOG_CTL_WDAEN_MASK                   0x0001u
  #define _WATCHDOG_CTL_WDAEN_SHIFT                  0
  #define WATCHDOG_CTL_WDAEN_DEFAULT                 0x0000u
  #define WATCHDOG_CTL_WDAEN_OF(x)                   _VALUEOF16(x)
  #define WATCHDOG_CTL_WDAEN_DISABLE                 0x0000u
  #define WATCHDOG_CTL_WDAEN_ENABLE                  0x0001u
  #define WATCHDOG_CTL_WDAEN_DISABLED                0x0000u
  #define WATCHDOG_CTL_WDAEN_ENABLED                 0x0001u
  #define WATCHDOG_CTL_WDAEN_NO                      0x0000u
  #define WATCHDOG_CTL_WDAEN_YES                     0x0001u
  #define _WATCHDOG_CTL_WDAEN_DISABLE_SV             0x0000u
  #define _WATCHDOG_CTL_WDAEN_ENABLE_SV              0x0001u
  #define _WATCHDOG_CTL_WDAEN_DISABLED_SV            0x0000u
  #define _WATCHDOG_CTL_WDAEN_ENABLED_SV             0x0001u
  #define _WATCHDOG_CTL_WDAEN_NO_SV                  0x0000u
  #define _WATCHDOG_CTL_WDAEN_YES_SV                 0x0001u

  #define WATCHDOG_CTL_OF(val)                       _VALUEOF16(val)
  #define WATCHDOG_CTL_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(WATCHDOG,CTL,WDBGEN)           \
    | _PER_FDEFAULT16(WATCHDOG,CTL,WDBTO)            \
    | _PER_FDEFAULT16(WATCHDOG,CTL,WDBEN)            \
    | _PER_FDEFAULT16(WATCHDOG,CTL,WDAEN)            \
  )

  #define WATCHDOG_CTL_RMK(wdbgen,wdbto,wdben,       \
    wdaen)                                           \
    (Uint16)(                                        \
      _PER_FMK16(WATCHDOG,CTL,WDBGEN,wdbgen)         \
    | _PER_FMK16(WATCHDOG,CTL,WDBTO,wdbto)           \
    | _PER_FMK16(WATCHDOG,CTL,WDBEN,wdben)           \
    | _PER_FMK16(WATCHDOG,CTL,WDAEN,wdaen)           \
  )

  #define _WATCHDOG_CTL_FGET(FIELD)                  \
    _PER_FGET16(_WATCHDOG_CTL_ADDR,                  \
      WATCHDOG,CTL,##FIELD)

  #define _WATCHDOG_CTL_FSET(FIELD,field)            \
    _PER_FSET16(_WATCHDOG_CTL_ADDR,                  \
      WATCHDOG,CTL,##FIELD,field)

  #define _WATCHDOG_CTL_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_WATCHDOG_CTL_ADDR,                 \
      WATCHDOG,CTL,##FIELD,##SYM)

  #define _WATCHDOG_CTL_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_WATCHDOG_CTL_ADDR,                 \
      WATCHDOG,CTL,##FIELD,val)

  #define _WATCHDOG_CTL_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_WATCHDOG_CTL_ADDR,                \
      WATCHDOG,CTL,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  T R I G              |
* |_______________________|
*
* TRIG - Trigger (to reset the watchdog's timer)
*
* FIELDS (msb -> lsb)
* (.W)	WDB       	[ 1: 1]	 - Trigger Watchdog B (value doesn't matter)
* (.W)	WDA       	[ 0: 0]	 - Trigger Watchdog A (value doesn't matter)
*
\******************************************************************************/
/*#define _WATCHDOG_TRIG_RECIDX                      No recorded */

  #define _WATCHDOG_TRIG_ADDR                        0x6C08001Au

  #define _WATCHDOG_TRIG_REGOFFS                     0x0000001Au
  #define _WATCHDOG_TRIG_REGOFFS16                   0x0000000Du

  #define _WATCHDOG_TRIG_WDB_MASK                    0x0002u
  #define _WATCHDOG_TRIG_WDB_SHIFT                   1
  #define WATCHDOG_TRIG_WDB_DEFAULT                  0x0000u
  #define WATCHDOG_TRIG_WDB_OF(x)                    _VALUEOF16(x)
  #define WATCHDOG_TRIG_WDB_RESET                    0x0001u
  #define WATCHDOG_TRIG_WDB_TRIG                     0x0001u
  #define WATCHDOG_TRIG_WDB_TRIGGER                  0x0001u
  #define _WATCHDOG_TRIG_WDB_RESET_SV                0x0002u
  #define _WATCHDOG_TRIG_WDB_TRIG_SV                 0x0002u
  #define _WATCHDOG_TRIG_WDB_TRIGGER_SV              0x0002u

  #define _WATCHDOG_TRIG_WDA_MASK                    0x0001u
  #define _WATCHDOG_TRIG_WDA_SHIFT                   0
  #define WATCHDOG_TRIG_WDA_DEFAULT                  0x0000u
  #define WATCHDOG_TRIG_WDA_OF(x)                    _VALUEOF16(x)
  #define WATCHDOG_TRIG_WDA_RESET                    0x0001u
  #define WATCHDOG_TRIG_WDA_TRIG                     0x0001u
  #define WATCHDOG_TRIG_WDA_TRIGGER                  0x0001u
  #define _WATCHDOG_TRIG_WDA_RESET_SV                0x0001u
  #define _WATCHDOG_TRIG_WDA_TRIG_SV                 0x0001u
  #define _WATCHDOG_TRIG_WDA_TRIGGER_SV              0x0001u

  #define WATCHDOG_TRIG_OF(val)                      _VALUEOF16(val)
  #define WATCHDOG_TRIG_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(WATCHDOG,TRIG,WDB)             \
    | _PER_FDEFAULT16(WATCHDOG,TRIG,WDA)             \
  )

  #define WATCHDOG_TRIG_RMK(wdb,wda)                 \
    (Uint16)(                                        \
      _PER_FMK16(WATCHDOG,TRIG,WDB,wdb)              \
    | _PER_FMK16(WATCHDOG,TRIG,WDA,wda)              \
  )

  #define _WATCHDOG_TRIG_FGET(FIELD)                 \
    _PER_FGET16(_WATCHDOG_TRIG_ADDR,                 \
      WATCHDOG,TRIG,##FIELD)

  #define _WATCHDOG_TRIG_FSET(FIELD,field)           \
    _PER_FSET16(_WATCHDOG_TRIG_ADDR,                 \
      WATCHDOG,TRIG,##FIELD,field)

  #define _WATCHDOG_TRIG_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_WATCHDOG_TRIG_ADDR,                \
      WATCHDOG,TRIG,##FIELD,##SYM)

  #define _WATCHDOG_TRIG_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_WATCHDOG_TRIG_ADDR,                \
      WATCHDOG,TRIG,##FIELD,val)

  #define _WATCHDOG_TRIG_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_WATCHDOG_TRIG_ADDR,               \
      WATCHDOG,TRIG,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_WATCHDOG_SUPPORT) */
#endif /* _BSL_WATCHDOGHAL_H_ */
/******************************************************************************\
* End of bsl_watchdoghal.h
\******************************************************************************/
