#include <stdio.h>
#include <csl_bootcfgaux.h>
#include <cslr_emif4f.h>
#include <cslr_cgem.h>
#include <csl_bootrom.h>
#include "KeyStone_DDR_Init.h"
#include "KeyStone_common.h"
#include <csl_pscAux.h>
//***** author Xue Chenguang****************/
#define CSL_BOOT_ROM_DDR3_REGS        (0x00883500)
unsigned int DSP_Core_Clock_KHz= 1000000;
CSL_BootcfgRegs * boot_cfg_regs = (CSL_BootcfgRegs *)CSL_BOOT_CFG_REGS;
//	CSL_RomcfgRegs   * boot_rom_ddr3_regs = (CSL_RomcfgRegs *) CSL_BOOT_ROM_DDR3_REGS;
CSL_Emif4fRegs * DDR_Regs= (CSL_Emif4fRegs *)CSL_DDR3_EMIF_CONFIG_REGS;
CSL_PllcRegs * pllc_regs = (CSL_PllcRegs * )0x02310000;
//void TCI6614_EVM_DDR_Init(float clock_MHz);
void _c_int00()
{    
	int i;
	float clock_MHz =666.667;
	/* Initialize Time stame counter to measure cycles*/
	//TSC_init();
	KeyStone_main_PLL_init (10, 1); 	//for 100MHz input clock

	KeyStone_DDR_PLL_init(20, 1);
	CSL_BootCfgUnlockKicker();

		/*Drives CKE low.
		This is a JEDEC requirement that we have 500us delay between reset de-assert
		and cke assert and then program the correct refresh rate
		The DDR internal clock is divide by 16 before SDCFG write*/
		DDR_Regs->SDRAM_REF_CTRL = 0x80000000|(unsigned int)(500.f*clock_MHz/16.f);

		DDR_Regs->SDRAM_TIM_1 =
			((unsigned int)(13.5*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_RP_SHIFT)|
			((unsigned int)(13.5*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_RCD_SHIFT)|
			((unsigned int)(15*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_WR_SHIFT)|
			((unsigned int)(36*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_RAS_SHIFT)|
			((unsigned int)(49.5*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_RC_SHIFT)|
			((unsigned int)(45*clock_MHz/4000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_RRD_SHIFT)| 	/*T_RRD = (tFAW/(4*tCK)) C 1*/
			((unsigned int)(7.5*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_1_REG_T_WTR_SHIFT);
		DDR_Regs->SDRAM_TIM_2   =
			((unsigned int)(6*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_2_REG_T_XP_SHIFT)|
			((unsigned int)(120*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSNR_SHIFT)| 	/*T_XSNR = (tXS /tCK)C 1*/
			((512-1)<<CSL_EMIF4F_SDRAM_TIM_2_REG_T_XSRD_SHIFT)| 	/*T_XSRD =tXSDLLC 1*/
			((unsigned int)(7.5*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_2_REG_T_RTP_SHIFT)|
			((unsigned int)(5.625*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_2_REG_T_CKE_SHIFT);
		DDR_Regs->SDRAM_TIM_3   =
			(5<<CSL_EMIF4F_SDRAM_TIM_3_REG_T_PDLL_UL_SHIFT)| 	/*This field must always be programmed to 0x5.*/
			((5)<<CSL_EMIF4F_SDRAM_TIM_3_REG_T_CSTA_SHIFT)| 	/*This field should be set according to PHY requirements as 0x5.*/
			((unsigned int)(5.625*clock_MHz/1000.f+0.9999f)<<CSL_EMIF4F_SDRAM_TIM_3_REG_T_CKESR_SHIFT)|
			((64-1)<<CSL_EMIF4F_SDRAM_TIM_3_REG_ZQ_ZQCS_SHIFT)|
			((unsigned int)(110*clock_MHz/1000.f-0.0001f)<<CSL_EMIF4F_SDRAM_TIM_3_REG_T_RFC_SHIFT)|
			(15<<CSL_EMIF4F_SDRAM_TIM_3_REG_T_RAS_MAX_SHIFT); 	/*This field must always be programmed to 0xF.*/

		DDR_Regs->DDR_PHY_CTRL_1  = 0x00100100|
			(12<<CSL_EMIF4F_DDR_PHY_CTRL_1_REG_READ_LATENCY_SHIFT); 	/*between CAS Latency + 1 and CAS Latency + 7*/

		DDR_Regs->ZQ_CONFIG =
			((0)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS1EN_SHIFT)|
			((1)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_CS0EN_SHIFT)|
			((1)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_DUALCALEN_SHIFT)| 	/*This bit should always be set to 1.*/
			((1)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_SFEXITEN_SHIFT)|
			((512/256-1)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQINIT_MULT_SHIFT)| 	/*T_ZQ_ZQINIT_MULT = (tZQinit/tZQoper C 1)*/
			((256/64-1)<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_ZQCL_MULT_SHIFT)| 	/*T_ZQ_ZQCL_MULT = (tZQoper/tZQCS C 1)*/
			/*interval between ZQCS commands = ZQCorrection/((TSens x Tdriftrate) + (VSens x Vdriftrate))
			= 0.5/((1.5*1.2)+(0.15*10))= 0.151515151s, this time need be converted to refresh period number*/
			((151515151/(64000000/8192))<<CSL_EMIF4F_ZQ_CONFIG_REG_ZQ_REFINTERVAL_SHIFT);

		/*map priority 0,1,2,3 to COS0,
		map priority 3,5,6,7 to COS1*/
		DDR_Regs->PRI_COS_MAP =
			((1)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_COS_MAP_EN_SHIFT)|
			((1)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_7_COS_SHIFT)|
			((1)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_6_COS_SHIFT)|
			((1)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_5_COS_SHIFT)|
			((1)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_4_COS_SHIFT)|
			((0)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_3_COS_SHIFT)|
			((0)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_2_COS_SHIFT)|
			((0)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_1_COS_SHIFT)|
			((0)<<CSL_EMIF4F_PRI_COS_MAP_REG_PRI_0_COS_SHIFT);

		/*master based COS map is disabled*/
		DDR_Regs->MSTID_COS_1_MAP= 0;
		DDR_Regs->MSTID_COS_2_MAP= 0;

		/*LAT_CONFIG*/
		DDR_Regs->VBUSM_CONFIG=
			(8<<CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_1_SHIFT)|
			(16<<CSL_EMIF4F_VBUSM_CONFIG_REG_COS_COUNT_2_SHIFT)|
			(32<<CSL_EMIF4F_VBUSM_CONFIG_REG_PR_OLD_COUNT_SHIFT);

		DDR_Regs->ECC_CTRL =
			((0)<<CSL_EMIF4F_ECC_CTRL_REG_ECC_EN_SHIFT)|
			((0)<<CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_PROT_SHIFT)|
			((0)<<CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_2_EN_SHIFT)|
			((0)<<CSL_EMIF4F_ECC_CTRL_REG_ECC_ADDR_RNG_1_EN_SHIFT);

		/* enables DRAM configuration.  It still has the refresh interval
		programmed to the longer number needed during DRAM initialization.*/
		DDR_Regs->SDRAM_REF_CTRL = (unsigned int)(500.f*clock_MHz/16.f);

		DDR_Regs->SDRAM_CONFIG =
			(3<<CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_TYPE_SHIFT)| 	/*Set to 3 for DDR3. All other values reserved.*/
			(0<<CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_POS_SHIFT)|
			(DDR_TERM_RZQ_OVER_6<<CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_TERM_SHIFT)|
			(DDR_DYN_ODT_DISABLED<<CSL_EMIF4F_SDRAM_CONFIG_REG_DYN_ODT_SHIFT)|
			(0<<CSL_EMIF4F_SDRAM_CONFIG_REG_DDR_DISABLE_DLL_SHIFT)|
			(SDRAM_DRIVE_RZQ_OVER_7<<CSL_EMIF4F_SDRAM_CONFIG_REG_SDRAM_DRIVE_SHIFT)|
			(DDR_CWL_7<<CSL_EMIF4F_SDRAM_CONFIG_REG_CWL_SHIFT)|
			(DDR_BUS_WIDTH_64<<CSL_EMIF4F_SDRAM_CONFIG_REG_NARROW_MODE_SHIFT)|
			(DDR_CL_9<<CSL_EMIF4F_SDRAM_CONFIG_REG_CL_SHIFT)|
			(DDR_ROW_SIZE_13_BIT<<CSL_EMIF4F_SDRAM_CONFIG_REG_ROWSIZE_SHIFT)|
			(DDR_BANK_NUM_8<<CSL_EMIF4F_SDRAM_CONFIG_REG_IBANK_SHIFT)|
			(0<<CSL_EMIF4F_SDRAM_CONFIG_REG_EBANK_SHIFT)|
			(DDR_PAGE_SIZE_10_BIT_1024_WORD<<CSL_EMIF4F_SDRAM_CONFIG_REG_PAGESIZE_SHIFT);

	//	DDR_Regs->SDRAM_REF_CTRL    = 64000000/8192/(1000/clock_MHz);
		DDR_Regs->SDRAM_REF_CTRL    = (unsigned int)64000.f*clock_MHz/8192.f;

		//initial vale for leveling
		/*GTLVL_INIT_RATIO*/
		boot_cfg_regs->DDR3_CONFIG_REG[14] = 0xA1;
		boot_cfg_regs->DDR3_CONFIG_REG[15] = 0x9E;
		boot_cfg_regs->DDR3_CONFIG_REG[16] = 0xA7;
		boot_cfg_regs->DDR3_CONFIG_REG[17] = 0xA9;
		boot_cfg_regs->DDR3_CONFIG_REG[18] = 0xCA;
		boot_cfg_regs->DDR3_CONFIG_REG[19] = 0xBE;
		boot_cfg_regs->DDR3_CONFIG_REG[20] = 0xDD;
		boot_cfg_regs->DDR3_CONFIG_REG[21] = 0xDD;
		boot_cfg_regs->DDR3_CONFIG_REG[22] = 0xBA;

		/*WRLVL_INIT_RATIO*/
		boot_cfg_regs->DDR3_CONFIG_REG[2] = 0x20;
		boot_cfg_regs->DDR3_CONFIG_REG[3] = 0x24;
		boot_cfg_regs->DDR3_CONFIG_REG[4] = 0x3A;
		boot_cfg_regs->DDR3_CONFIG_REG[5] = 0x38;
		boot_cfg_regs->DDR3_CONFIG_REG[6] = 0x51;
		boot_cfg_regs->DDR3_CONFIG_REG[7] = 0x5E;
		boot_cfg_regs->DDR3_CONFIG_REG[8] = 0x5E;
		boot_cfg_regs->DDR3_CONFIG_REG[9] = 0x5E;
		boot_cfg_regs->DDR3_CONFIG_REG[10] = 0x44;

		boot_cfg_regs->DDR3_CONFIG_REG[0] |= 0xF; 	// set dll_lock_diff to 15

		/*Invert Clock Out*/
		boot_cfg_regs->DDR3_CONFIG_REG[0] &= ~(0x007FE000);  // clear ctrl_slave_ratio field
		boot_cfg_regs->DDR3_CONFIG_REG[0] |= 0x00200000;     // set ctrl_slave_ratio to 0x100
		boot_cfg_regs->DDR3_CONFIG_REG[12] |= 0x08000000;    // Set invert_clkout = 1

		boot_cfg_regs->DDR3_CONFIG_REG[23] |= 0x00000200; //Set bit 9 = 1 to use forced ratio leveling for read DQS

		//enable full leveling, no incremental leveling
		/*Typically you program the ramp window for a higher rate of
		incremental leveling, meaning the 3 fields in the ramp control
		register will be smaller than the corresponding fields in the
		RDWR_LVL_CTRL.*/
		DDR_Regs->RDWR_LVL_RMP_WIN = 4096;
		DDR_Regs->RDWR_LVL_RMP_CTRL =
			(1<<CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVL_EN_SHIFT)|
			(16<<CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDWRLVLINC_RMP_PRE_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLINC_RMP_INT_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_RDLVLGATEINC_RMP_INT_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_RMP_CTRL_REG_WRLVLINC_RMP_INT_SHIFT);
		DDR_Regs->RDWR_LVL_CTRL =
			(1<<CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLFULL_START_SHIFT)|
			(32<<CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDWRLVLINC_PRE_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLINC_INT_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_CTRL_REG_RDLVLGATEINC_INT_SHIFT)|
			(0<<CSL_EMIF4F_RDWR_LVL_CTRL_REG_WRLVLINC_INT_SHIFT);

		CSL_BootCfgLockKicker();


}

void KeyStone_DDR_PLL_init (unsigned int DDR_PLLM, unsigned int DDR_PLLD)
{
	int i;

	if(0<DDR_PLLM&&DDR_PLLM<=8192&&0<DDR_PLLD&&DDR_PLLD<=64)
	{
		CSL_BootCfgUnlockKicker();

		printf("Initialize DDR PLL = x%d/%d\n", DDR_PLLM, DDR_PLLD);
		boot_cfg_regs->DDR3_PLL_CTL1 |= 0x00000040;      //Set ENSAT bit = 1
		boot_cfg_regs->DDR3_PLL_CTL1 |= 0x00002000;      //Set RESET bit = 1
		boot_cfg_regs->DDR3_PLL_CTL0 = (boot_cfg_regs->DDR3_PLL_CTL0&0x00780000)|
			((DDR_PLLM/2)<<24)|((DDR_PLLM-1)<<6)|(DDR_PLLD-1);
		for(i=0;i<1000;i++)
			asm(" nop");            //Wait for reset to complete
		boot_cfg_regs->DDR3_PLL_CTL1 &= ~(0x00002000);   //Clear RESET bit
		for(i=0;i<100000;i++)
			asm(" nop");          //Wait for PLL lock

		CSL_BootCfgLockKicker();
	}
}


void KeyStone_main_PLL_init ( unsigned int main_PLLM, unsigned int main_PLLD)
{
	unsigned int i;

	if(0<main_PLLM&&main_PLLM<=4096&&0<main_PLLD&&main_PLLD<=64)
	{
		CSL_BootCfgUnlockKicker();

		boot_cfg_regs->CORE_PLL_CTL1 |= 0x00000040; //Set ENSAT = 1

		printf("Initialize main PLL = x%d/%d\n", main_PLLM, main_PLLD);

		//Bypass the PLL, PLL OUTPUT_DIVIDER = 2
		pllc_regs->SECCTL |= 0x00880000;

		/*Clear the PLLENSRC bit in PLLCTL to 0 to allow PLLCTL.PLLEN to take effect*/
		pllc_regs->PLLCTL= pllc_regs->PLLCTL&(~(1<<5));

		/*Clear the PLLEN bit in PLLCTL to 0 (select PLL bypass mode)*/
		pllc_regs->PLLCTL= pllc_regs->PLLCTL&(~(1<<0));

		/*Wait for 4 input clock cycles to ensure PLLC switches to bypass mode properly*/
		for(i=0; i< 4*8192/5+1; i++)
			asm(" nop 5");

		/*The PLL has a bandgap generator circuit driving the PLL voltage regulator. In order
		to ensure proper PLL startup, the PLL power_down pin needs to be toggled. This is
		accomplished by toggling the PLLPWRDN bit in the PLLCTL register. This needs to
		be done before the main PLL initialization sequence. */
		pllc_regs->PLLCTL |= (1<<1);	//Power down the PLL
		// wait for 5 us (min)
		for(i=0; i< 1000; i++)
			asm(" nop 5");

		// Verify if pll is in power down
		if ((pllc_regs->PLLCTL & (1<<1)) !=0 )
		{
			pllc_regs->PLLCTL &= ~(1<<1);         // Power up PLL
			// Wait PLL Stabilization time that is 150 usec
			for(i=0; i< 30000; i++)
				asm(" nop 5");
		}

		/*In PLLCTL, write PLLRST = 1 (PLL is reset)*/
		pllc_regs->PLLCTL= pllc_regs->PLLCTL|(1<<3);

		/*Program the required multiplier and divider values*/
		//pllc_regs->PREDIV= 0x8000;
		pllc_regs->PLLM= (main_PLLM*2-1)&0x3F;
		boot_cfg_regs->CORE_PLL_CTL0 = ((main_PLLM-1)<<24)|
			(((main_PLLM*2-1)&0x1FC0)<<6)|(main_PLLD-1);
		boot_cfg_regs->CORE_PLL_CTL1 |= 0x00000040;      //Set ENSAT bit = 1
		//pllc_regs->POSTDIV= 0x8000;

		/*Wait 1000 ns for PLL reset*/
		for(i=0; i< 1500/5+1; i++)
			asm(" nop 5");

		/*In PLLCTL, write PLLRST = 0 to bring PLL out of reset*/
		pllc_regs->PLLCTL= pllc_regs->PLLCTL&(~(1<<3));

		/*Wait 2000 input clock cycles for PLL to lock*/
		for(i=0; i< 2000*8192/5+1; i++)
			asm(" nop 5");

		//clear the bypass bit, enable PLL
		pllc_regs->SECCTL &= ~(0x00800000);

		/*Set the PLLEN bit in PLLCTL to 1 to enable PLL mode*/
		pllc_regs->PLLCTL= pllc_regs->PLLCTL|(1<<0);

		CSL_BootCfgLockKicker();
	}

}
