/*
 *  Copyright 2009 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  AIC3204 Test
 *
 */

#define AIC3204_I2C_ADDR 0x18
#include "usbstk5505.h"
#include "usbstk5505_gpio.h"
#include "usbstk5505_i2c.h"
#include "stdio.h"

extern Int16 aic3204_tone_headphone( );
extern Int16 aic3204_loop_linein( );

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  _AIC3204_rget( regnum, regval )                                         *
 *                                                                          *
 *      Return value of codec register regnum                               *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 AIC3204_rget(  Uint16 regnum, Uint16* regval )
{
    Int16 retcode = 0;
    Uint8 cmd[2];

    cmd[0] = regnum & 0x007F;       // 7-bit Device Address
    cmd[1] = 0;

    retcode |= USBSTK5505_I2C_write( AIC3204_I2C_ADDR, cmd, 1 );
    retcode |= USBSTK5505_I2C_read( AIC3204_I2C_ADDR, cmd, 1 );

    *regval = cmd[0];
    USBSTK5505_wait( 10 );
    return retcode;
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  _AIC3204_rset( regnum, regval )                                         *
 *                                                                          *
 *      Set codec register regnum to value regval                           *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 AIC3204_rset( Uint16 regnum, Uint16 regval )
{
    Uint8 cmd[2];
    cmd[0] = regnum & 0x007F;       // 7-bit Device Address
    cmd[1] = regval;                // 8-bit Register Data

    return USBSTK5505_I2C_write( AIC3204_I2C_ADDR, cmd, 2 );
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  aic3204_test( )                                                           *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 aic3204_test( )
{
	SYS_EXBUSSEL |= 0x0020;  // Select A20/GPIO26 as GPIO26
	USBSTK5505_GPIO_init();
	USBSTK5505_GPIO_setDirection(GPIO26, GPIO_OUT);
	USBSTK5505_GPIO_setOutput( GPIO26, 1 );    // Take AIC3201 chip out of reset
	USBSTK5505_I2C_init( );                    // Initialize I2C
    /* Codec tests */
    printf( " -> 1 KHz Tone on Headphone.\n" );
    if ( aic3204_tone_headphone( ) )
        return 1;
        
    USBSTK5505_wait( 100 );  // Wait    
    printf( "<-> Audio Loopback from Stereo IN --> to HP/Lineout\n" );
    if ( aic3204_loop_linein( ) )
        return 3;
	USBSTK5505_GPIO_setOutput( GPIO26, 0 );
    return 0;
}
