/*
 *  Copyright 2009 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  LED Test
 *
 */

#include "usbstk5505.h"
#include "usbstk5505_led.h"

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  led_test( )                                                             *
 *      Running Eight LED test                                              *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 led_test( )
{
    Int16 j;

    /* Initialize the LED module */
    USBSTK5505_LED_init( );

    /* Running LED test */
    for ( j = 0 ; j < 20 ; j++ )
    {
        USBSTK5505_LED_on( 0 );
        USBSTK5505_waitusec( 500000 );
        USBSTK5505_LED_off( 0 );
        USBSTK5505_waitusec( 500000 );
    }

    /* Turn on LED to indicate a PASS */
    USBSTK5505_LED_on( 0 );

    return 0;
}

