/*
 *  Copyright 2009 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  SPI ROM test
 *
 */

#include "usbstk5505.h"
#include "spirom.h"
#include "stdio.h"

static Uint8 tx[spirom_PAGESIZE];
static Uint8 rx[spirom_PAGESIZE];

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  spirom_test( )                                                            *
 *      SPI ROM test, write then verify the contents of the first 4 pages   *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 spirom_test( )
{
    Int16 i, j;
    Uint16* pdata;

	/* Initialize the SPI interface */
    spirom_init( );

    /* Write to spirom */
    for ( i = 0 ; i < 2 ; i++ )
    {
        /* Create the test pattern */
        pdata = ( Uint16* )tx;
        for ( j = 0 ; j < spirom_PAGESIZE ; j++ )
            *pdata++ = ( Uint8 )( j + i + 8 );

        /* Write a page */
        spirom_write( ( Uint32 )tx, i * spirom_PAGESIZE, spirom_PAGESIZE );
    }


    /* Read and verify spirom */
    for ( i = 0 ; i < 2 ; i++ )
    {
    	/* Clear receive buffer */
        for ( j = 0 ; j < spirom_PAGESIZE ; j++ )
            rx[j] = 0;
            
        /* Read a page */
        spirom_read( i * spirom_PAGESIZE, ( Uint32 )rx, spirom_PAGESIZE );

        /* Check the pattern */
        pdata = ( Uint16* )rx;
        for ( j = 0 ; j < spirom_PAGESIZE ; j++ )
            if ( ( *pdata++ ) != ( Uint16 )( i + j + 8 ) )
                return 1;  // Fail
    }

    return 0;
}

