// Import the DSS packages into our namespace to save on typing

importPackage( Packages.com.ti.debug.engine.scripting )
importPackage( Packages.com.ti.ccstudio.scripting.environment )
importPackage( Packages.java.lang )

// Configure and launch DSS for analyzing a 64+ crash dump

System.out.println( "Launching DebugSession..." );
debugServer = ScriptingEnvironment.instance().getServer( "DebugServer.1" )
debugServer.setConfig( "C64xCrashDumpAnalysis.ccxml" )
debugSession = debugServer.openSession( ".*" )

System.out.println( "Loading crash dump..." );
debugSession.expression.evaluate( "GEL_SystemRestoreState( \"dsp.crashdump.txt\" )" )

System.out.println( "Analyzing...\n" );
debugSession.callStack.analyzeStackMemory( 0x8e1fd000, 0, 0x8000 );

// Once we're done inspecting the crash dump, we can end the script

debugServer.stop()

