/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... C source file for API of peripheral SYNCBUS
* FILENAME......... bsl_syncbus.c
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 08:50:53
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. SYNCBUS
* PERIPHERAL TYPE.. Multi-device peripheral
* ACCESS MODE...... Through handle
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#define _BSL_SYNCBUS_MOD_

#include <bsl_syncbus.h>


#if (BSL_SYNCBUS_SUPPORT)
/******************************************************************************\
*                         L O C A L   S E C T I O N
\******************************************************************************/


/******************************************************************************\
* static macro declarations
\******************************************************************************/

#define DEVICE_TABLE_ENTRY(devNum) { \
	/* allocated */ FALSE, \
	/* baseAddr  */ (Uint32)(_SYNCBUS##devNum##_BASE_ADDRESS), \
}


/******************************************************************************\
* static typedef declarations
\******************************************************************************/


/******************************************************************************\
* static function declarations
\******************************************************************************/


/******************************************************************************\
* static variable definitions
\******************************************************************************/


/******************************************************************************\
* static function definitions
\******************************************************************************/


/******************************************************************************\
*                        G L O B A L   S E C T I O N
\******************************************************************************/


/******************************************************************************\
* global variable definitions
\******************************************************************************/

SYNCBUS_Obj _SYNCBUS_deviceTable[_SYNCBUS_DEVICE_COUNT] = {
	DEVICE_TABLE_ENTRY(0),
	DEVICE_TABLE_ENTRY(1),
	DEVICE_TABLE_ENTRY(2)
};


/******************************************************************************\
* global function definitions
\******************************************************************************/

/*----------------------------------------------------------------------------*/
void SYNCBUS_reset(SYNCBUS_Handle hSyncbus)
{
	Uint32 gie;

	gie = IRQ_globalDisable();

	SYNCBUS_RSETH( hSyncbus, SRCSEL, SYNCBUS_SRCSEL_DEFAULT );
	SYNCBUS_RSETH( hSyncbus, DIR, SYNCBUS_DIR_DEFAULT );

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
void SYNCBUS_resetAll()
{
	SYNCBUS_reset( &(_SYNCBUS_deviceTable[0]) );
	SYNCBUS_reset( &(_SYNCBUS_deviceTable[1]) );
	SYNCBUS_reset( &(_SYNCBUS_deviceTable[2]) );
}

/*----------------------------------------------------------------------------*/
SYNCBUS_Handle SYNCBUS_open(Uint32 devNum, Uint32 flags)
{
	SYNCBUS_Handle hSyncbus = INV;
	Uint32 gie;

	gie = IRQ_globalDisable();
	if( !_SYNCBUS_deviceTable[devNum].allocated )
	{
		hSyncbus = (SYNCBUS_Handle) &(_SYNCBUS_deviceTable[devNum]);
		hSyncbus->allocated = TRUE;

		if( flags & SYNCBUS_OPEN_RESET ) SYNCBUS_reset( hSyncbus );
	}
	IRQ_globalRestore(gie);

	return hSyncbus;
}

/*----------------------------------------------------------------------------*/
void SYNCBUS_close(SYNCBUS_Handle hSyncbus)
{
	Uint32 gie;

	gie = IRQ_globalDisable();

	hSyncbus->allocated = FALSE;
	SYNCBUS_reset(hSyncbus);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/


#endif /* BSL_SYNCBUS_SUPPORT */
/******************************************************************************\
* End of bsl_syncbus.c
\******************************************************************************/
