/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Basic CSL-like macros for Hardver Abstraction Layer (HAL)
* FILENAME......... bsl_stdinchal.h
\******************************************************************************/
#ifndef _BSL_STDINCHAL_H_
#define _BSL_STDINCHAL_H_


#include <csl_stdinc.h>    /* includes the csl_stdinchal.h also */


/******************************************************************************\
* HAL macro definitions for 32-bit accesses
\******************************************************************************/

  #define _VALUEOF32(val) ((Uint32)(val))

  /*******************************************************/
  /* generic macros for field manipulation               */
  /*******************************************************/

  #define _PER_FSHIFT32(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_SHIFT

  #define _PER_FMASK32(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_MASK

  #define _PER_FSYM32(PER,REG,FIELD,SYM)\
    PER##_##REG##_##FIELD##_##SYM

  #define _PER_FDEFAULT32(PER,REG,FIELD) \
    ((##PER##_##REG##_##FIELD##_DEFAULT << _##PER##_##REG##_##FIELD##_SHIFT) \
    & _##PER##_##REG##_##FIELD##_MASK)

  #define _PER_FMK32(PER,REG,FIELD,val) ( \
    (((Uint32)(val)) << _PER_FSHIFT32(##PER,##REG,##FIELD)) \
    & _PER_FMASK32(##PER,##REG,##FIELD) \
  )

  #define _PER_FMKS32(PER,REG,FIELD,SYM) ( \
    (_PER_FSYM32(##PER,##REG,##FIELD,##SYM) << _PER_FSHIFT32(##PER,##REG,##FIELD)) \
    & _PER_FMASK32(##PER,##REG,##FIELD) \
  )

  #define _PER_FEXTRACT32(PER,REG,FIELD,reg) (Uint32)( \
    (((Uint32)(reg) & _PER_FMASK32(##PER,##REG,##FIELD)) \
    >> _PER_FSHIFT32(##PER,##REG,##FIELD)) \
  )

  #define _PER_FINSERT32(PER,REG,FIELD,reg,field) (Uint32)( \
    (((Uint32)(reg) & ~_PER_FMASK32(##PER,##REG,##FIELD)) | \
    (((Uint32)(field) << _PER_FSHIFT32(##PER,##REG,##FIELD)) \
    & _PER_FMASK32(##PER,##REG,##FIELD))) \
  )

  /*******************************************************/
  /* macros for memmory mapped registers                 */
  /*******************************************************/

  #define _PER_RAOI32(addr,PER,REG,and,or,inv) \
    (*(volatile Uint32*)(addr))=( \
      ((((*(volatile Uint32*)(addr)) \
      & ((Uint32)(and))) \
      | ((Uint32)(or))) \
      ^ ((Uint32)(inv))) \
    )

  #define _PER_RGET32(addr,PER,REG) \
    (*(volatile Uint32*)(addr))

  #define _PER_RSET32(addr,PER,REG,val) \
    (*(volatile Uint32*)(addr)) = ((Uint32)(val))

  #define _PER_FGET32(addr,PER,REG,FIELD) \
    _PER_FEXTRACT32(##PER,##REG,##FIELD,_PER_RGET32(addr,##PER,##REG))

  #define _PER_FSET32(addr,PER,REG,FIELD,field) \
    _PER_RSET32(addr,##PER,##REG, \
    _PER_FINSERT32(##PER,##REG,##FIELD,_PER_RGET32(addr,##PER,##REG),field))

  #define _PER_FSETS32(addr,PER,REG,FIELD,SYM) \
    _PER_RSET32(addr,##PER,##REG,_PER_FINSERT32(##PER,##REG,##FIELD,_PER_RGET32(addr,##PER,##REG), \
    _PER_FSYM32(##PER,##REG,##FIELD,##SYM)))

  #define _PER_FGETQ32(addr,PER,REG,FIELD,val) \
    (_PER_FGET32(addr,##PER,##REG,##FIELD) == ((Uint32)(val)))

  #define _PER_FGETSQ32(addr,PER,REG,FIELD,SYM) \
    ((_PER_RGET32(addr,##PER,##REG) & _PER_FMASK32(##PER,##REG,##FIELD)) \
    == ((Uint32)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))

  /*******************************************************/
  /* macros for variable-values                          */
  /*******************************************************/

  #define _PER_VRGET32(var,PER,REG) \
    ((Uint32)(var))

  #define _PER_VRSET32(var,PER,REG,reg) \
    var = ((Uint32)(reg))

  #define _PER_VFGET32(var,PER,REG,FIELD) \
    _PER_FEXTRACT32(##PER,##REG,##FIELD,_PER_VRGET32(var,##PER,##REG))

  #define _PER_VFSET32(var,PER,REG,FIELD,field) \
    _PER_VRSET32(var,##PER,##REG, \
    _PER_FINSERT32(##PER,##REG,##FIELD,_PER_VRGET32(var,##PER,##REG),field))

  #define _PER_VFSETS32(var,PER,REG,FIELD,SYM) \
    _PER_VRSET32(var,##PER,##REG, \
    _PER_FINSERT32(##PER,##REG,FIELD,_PER_VRGET32(var,##PER,##REG), \
    _PER_FSYM32(##PER,##REG,##FIELD,##SYM)))

  #define _PER_VFGETQ32(var,PER,REG,FIELD,val) \
    (_PER_VFGET32(var,##PER,##REG,##FIELD) == ((Uint32)(val)))

  #define _PER_VFGETSQ32(var,PER,REG,FIELD,SYM) \
    ((_PER_VRGET32(var,##PER,##REG,##FIELD) & _PER_FMASK32(##PER,##REG,##FIELD)) \
    == ((Uint32)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))


/******************************************************************************\
* HAL macro definitions for 16-bit accesses
\******************************************************************************/

  #define _VALUEOF16(val) ((Uint16)(val))

  /*******************************************************/
  /* generic macros for field manipulation               */
  /*******************************************************/

  #define _PER_FSHIFT16(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_SHIFT

  #define _PER_FMASK16(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_MASK

  #define _PER_FSYM16(PER,REG,FIELD,SYM)\
    PER##_##REG##_##FIELD##_##SYM

  #define _PER_FDEFAULT16(PER,REG,FIELD) \
    ((##PER##_##REG##_##FIELD##_DEFAULT << _##PER##_##REG##_##FIELD##_SHIFT) \
    & _##PER##_##REG##_##FIELD##_MASK)

  #define _PER_FMK16(PER,REG,FIELD,val) ( \
    (((Uint16)(val)) << _PER_FSHIFT16(##PER,##REG,##FIELD)) \
    & _PER_FMASK16(##PER,##REG,##FIELD) \
  )

  #define _PER_FMKS16(PER,REG,FIELD,SYM) ( \
    (_PER_FSYM16(##PER,##REG,##FIELD,##SYM) << _PER_FSHIFT16(##PER,##REG,##FIELD)) \
    & _PER_FMASK16(##PER,##REG,##FIELD) \
  )

  #define _PER_FEXTRACT16(PER,REG,FIELD,reg) (Uint16)( \
    (((Uint16)(reg) & _PER_FMASK16(##PER,##REG,##FIELD)) \
    >> _PER_FSHIFT16(##PER,##REG,##FIELD)) \
  )

  #define _PER_FINSERT16(PER,REG,FIELD,reg,field) (Uint16)( \
    (((Uint16)(reg) & ~_PER_FMASK16(##PER,##REG,##FIELD)) | \
    (((Uint16)(field) << _PER_FSHIFT16(##PER,##REG,##FIELD)) \
    & _PER_FMASK16(##PER,##REG,##FIELD))) \
  )

  /*******************************************************/
  /* macros for memmory mapped registers                 */
  /*******************************************************/

  #define _PER_RAOI16(addr,PER,REG,and,or,inv) \
    (*(volatile Uint16*)(addr))=( \
      ((((*(volatile Uint16*)(addr)) \
      & ((Uint16)(and))) \
      | ((Uint16)(or))) \
      ^ ((Uint16)(inv))) \
    )

  #define _PER_RGET16(addr,PER,REG) \
    (*(volatile Uint16*)(addr))

  #define _PER_RSET16(addr,PER,REG,val) \
    (*(volatile Uint16*)(addr)) = ((Uint16)(val))

  #define _PER_FGET16(addr,PER,REG,FIELD) \
    _PER_FEXTRACT16(##PER,##REG,##FIELD,_PER_RGET16(addr,##PER,##REG))

  #define _PER_FSET16(addr,PER,REG,FIELD,field) \
    _PER_RSET16(addr,##PER,##REG, \
    _PER_FINSERT16(##PER,##REG,##FIELD,_PER_RGET16(addr,##PER,##REG),field))

  #define _PER_FSETS16(addr,PER,REG,FIELD,SYM) \
    _PER_RSET16(addr,##PER,##REG,_PER_FINSERT16(##PER,##REG,##FIELD,_PER_RGET16(addr,##PER,##REG), \
    _PER_FSYM16(##PER,##REG,##FIELD,##SYM)))

  #define _PER_FGETQ16(addr,PER,REG,FIELD,val) \
    (_PER_FGET16(addr,##PER,##REG,##FIELD) == ((Uint16)(val)))

  #define _PER_FGETSQ16(addr,PER,REG,FIELD,SYM) \
    ((_PER_RGET16(addr,##PER,##REG) & _PER_FMASK16(##PER,##REG,##FIELD)) \
    == ((Uint16)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))

  /*******************************************************/
  /* macros for variable-values                          */
  /*******************************************************/

  #define _PER_VRGET16(var,PER,REG) \
    ((Uint16)(var))

  #define _PER_VRSET16(var,PER,REG,reg) \
    var = ((Uint16)(reg))

  #define _PER_VFGET16(var,PER,REG,FIELD) \
    _PER_FEXTRACT16(##PER,##REG,##FIELD,_PER_VRGET16(var,##PER,##REG))

  #define _PER_VFSET16(var,PER,REG,FIELD,field) \
    _PER_VRSET16(var,##PER,##REG, \
    _PER_FINSERT16(##PER,##REG,##FIELD,_PER_VRGET16(var,##PER,##REG),field))

  #define _PER_VFSETS16(var,PER,REG,FIELD,SYM) \
    _PER_VRSET16(var,##PER,##REG, \
    _PER_FINSERT16(##PER,##REG,FIELD,_PER_VRGET16(var,##PER,##REG), \
    _PER_FSYM16(##PER,##REG,##FIELD,##SYM)))

  #define _PER_VFGETQ16(var,PER,REG,FIELD,val) \
    (_PER_VFGET16(var,##PER,##REG,##FIELD) == ((Uint16)(val)))

  #define _PER_VFGETSQ16(var,PER,REG,FIELD,SYM) \
    ((_PER_VRGET16(var,##PER,##REG,##FIELD) & _PER_FMASK16(##PER,##REG,##FIELD)) \
    == ((Uint16)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))


/******************************************************************************\
* HAL macro definitions for 8-bit accesses
\******************************************************************************/

  #define _VALUEOF8(val) ((Uint8)(val))

  /*******************************************************/
  /* generic macros for field manipulation               */
  /*******************************************************/

  #define _PER_FSHIFT8(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_SHIFT

  #define _PER_FMASK8(PER,REG,FIELD) \
    _##PER##_##REG##_##FIELD##_MASK

  #define _PER_FSYM8(PER,REG,FIELD,SYM)\
    PER##_##REG##_##FIELD##_##SYM

  #define _PER_FDEFAULT8(PER,REG,FIELD) \
    ((##PER##_##REG##_##FIELD##_DEFAULT << _##PER##_##REG##_##FIELD##_SHIFT) \
    & _##PER##_##REG##_##FIELD##_MASK)

  #define _PER_FMK8(PER,REG,FIELD,val) ( \
    (((Uint8)(val)) << _PER_FSHIFT8(##PER,##REG,##FIELD)) \
    & _PER_FMASK8(##PER,##REG,##FIELD) \
  )

  #define _PER_FMKS8(PER,REG,FIELD,SYM) ( \
    (_PER_FSYM8(##PER,##REG,##FIELD,##SYM) << _PER_FSHIFT8(##PER,##REG,##FIELD)) \
    & _PER_FMASK8(##PER,##REG,##FIELD) \
  )

  #define _PER_FEXTRACT8(PER,REG,FIELD,reg) (Uint8)( \
    (((Uint8)(reg) & _PER_FMASK8(##PER,##REG,##FIELD)) \
    >> _PER_FSHIFT8(##PER,##REG,##FIELD)) \
  )

  #define _PER_FINSERT8(PER,REG,FIELD,reg,field) (Uint8)( \
    (((Uint8)(reg) & ~_PER_FMASK8(##PER,##REG,##FIELD)) | \
    (((Uint8)(field) << _PER_FSHIFT8(##PER,##REG,##FIELD)) \
    & _PER_FMASK8(##PER,##REG,##FIELD))) \
  )

  /*******************************************************/
  /* macros for memmory mapped registers                 */
  /*******************************************************/

  #define _PER_RAOI8(addr,PER,REG,and,or,inv) \
    (*(volatile Uint8*)(addr))=( \
      ((((*(volatile Uint8*)(addr)) \
      & ((Uint8)(and))) \
      | ((Uint8)(or))) \
      ^ ((Uint8)(inv))) \
    )

  #define _PER_RGET8(addr,PER,REG) \
    (*(volatile Uint8*)(addr))

  #define _PER_RSET8(addr,PER,REG,val) \
    (*(volatile Uint8*)(addr)) = ((Uint8)(val))

  #define _PER_FGET8(addr,PER,REG,FIELD) \
    _PER_FEXTRACT8(##PER,##REG,##FIELD,_PER_RGET8(addr,##PER,##REG))

  #define _PER_FSET8(addr,PER,REG,FIELD,field) \
    _PER_RSET8(addr,##PER,##REG, \
    _PER_FINSERT8(##PER,##REG,##FIELD,_PER_RGET8(addr,##PER,##REG),field))

  #define _PER_FSETS8(addr,PER,REG,FIELD,SYM) \
    _PER_RSET8(addr,##PER,##REG,_PER_FINSERT8(##PER,##REG,##FIELD,_PER_RGET8(addr,##PER,##REG), \
    _PER_FSYM8(##PER,##REG,##FIELD,##SYM)))

  #define _PER_FGETQ8(addr,PER,REG,FIELD,val) \
    (_PER_FGET8(addr,##PER,##REG,##FIELD) == ((Uint8)(val)))

  #define _PER_FGETSQ8(addr,PER,REG,FIELD,SYM) \
    ((_PER_RGET8(addr,##PER,##REG) & _PER_FMASK8(##PER,##REG,##FIELD)) \
    == ((Uint8)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))

  /*******************************************************/
  /* macros for variable-values                          */
  /*******************************************************/

  #define _PER_VRGET8(var,PER,REG) \
    ((Uint8)(var))

  #define _PER_VRSET8(var,PER,REG,reg) \
    var = ((Uint8)(reg))

  #define _PER_VFGET8(var,PER,REG,FIELD) \
    _PER_FEXTRACT8(##PER,##REG,##FIELD,_PER_VRGET8(var,##PER,##REG))

  #define _PER_VFSET8(var,PER,REG,FIELD,field) \
    _PER_VRSET8(var,##PER,##REG, \
    _PER_FINSERT8(##PER,##REG,##FIELD,_PER_VRGET8(var,##PER,##REG),field))

  #define _PER_VFSETS8(var,PER,REG,FIELD,SYM) \
    _PER_VRSET8(var,##PER,##REG, \
    _PER_FINSERT8(##PER,##REG,FIELD,_PER_VRGET8(var,##PER,##REG), \
    _PER_FSYM8(##PER,##REG,##FIELD,##SYM)))

  #define _PER_VFGETQ8(var,PER,REG,FIELD,val) \
    (_PER_VFGET8(var,##PER,##REG,##FIELD) == ((Uint8)(val)))

  #define _PER_VFGETSQ8(var,PER,REG,FIELD,SYM) \
    ((_PER_VRGET8(var,##PER,##REG,##FIELD) & _PER_FMASK8(##PER,##REG,##FIELD)) \
    == ((Uint8)(_##PER##_##REG##_##FIELD##_##SYM##_SV)))


#endif /* _BSL_STDINCHAL_H_ */
/******************************************************************************\
* End of bsl_stdinchal.h
\******************************************************************************/
