/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral UCOMM
* FILENAME......... bsl_ucomm.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 13:41:24
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. UCOMM
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 32-bit wide
\******************************************************************************/
#ifndef _BSL_UCOMM_H_
#define _BSL_UCOMM_H_

#include <bsl_ucommhal.h>


#if (BSL_UCOMM_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_UCOMM_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/



/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint32 regMBOX0;
	Uint32 regMBOX1;
	Uint32 regMBOX2;
	Uint32 regMBOX3;
	Uint32 regP2LDBCLR;
} UCOMM_Config;

/* object structure */
typedef struct {
	Uint32 baseAddr;
} UCOMM_Obj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI UCOMM_Obj _UCOMM_obj;	/* defined in bsl_ucomm.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/

BSLAPI void UCOMM_reset();


/******************************************************************************\
* inline function declarations
\******************************************************************************/

IDECL void UCOMM_config(UCOMM_Config *config);
IDECL void UCOMM_configArgs(Uint32 mbox0, Uint32 mbox1, Uint32 mbox2,
	Uint32 mbox3, Uint32 p2ldbclr);
IDECL void UCOMM_getConfig(UCOMM_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF void UCOMM_config(UCOMM_Config *config)
{
	Uint32 gie;
	volatile Uint32 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint32 *)(_UCOMM_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regMBOX0;
	r1 = config->regMBOX1;
	r2 = config->regMBOX2;
	r3 = config->regMBOX3;
	r4 = config->regP2LDBCLR;
	base[_UCOMM_MBOX0_REGOFFS32] = (Uint32)(r0);
	base[_UCOMM_MBOX1_REGOFFS32] = (Uint32)(r1);
	base[_UCOMM_MBOX2_REGOFFS32] = (Uint32)(r2);
	base[_UCOMM_MBOX3_REGOFFS32] = (Uint32)(r3);
	base[_UCOMM_P2LDBCLR_REGOFFS32] = (Uint32)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UCOMM_configArgs(Uint32 mbox0, Uint32 mbox1, Uint32 mbox2,
	Uint32 mbox3, Uint32 p2ldbclr)
{
	Uint32 gie;
	volatile Uint32 *base;
	register Uint32 r0, r1, r2, r3, r4;

	base = (volatile Uint32 *)(_UCOMM_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = mbox0;
	r1 = mbox1;
	r2 = mbox2;
	r3 = mbox3;
	r4 = p2ldbclr;
	base[_UCOMM_MBOX0_REGOFFS32] = (Uint32)(r0);
	base[_UCOMM_MBOX1_REGOFFS32] = (Uint32)(r1);
	base[_UCOMM_MBOX2_REGOFFS32] = (Uint32)(r2);
	base[_UCOMM_MBOX3_REGOFFS32] = (Uint32)(r3);
	base[_UCOMM_P2LDBCLR_REGOFFS32] = (Uint32)(r4);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void UCOMM_getConfig(UCOMM_Config *config)
{
	Uint32 gie;
	volatile UCOMM_Config *cfg;
	cfg = (volatile UCOMM_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regMBOX0 = UCOMM_RGET(MBOX0);
	cfg->regMBOX1 = UCOMM_RGET(MBOX1);
	cfg->regMBOX2 = UCOMM_RGET(MBOX2);
	cfg->regMBOX3 = UCOMM_RGET(MBOX3);
	cfg->regP2LDBCLR = UCOMM_RGET(P2LDBCLR);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_UCOMM_SUPPORT */
#endif /* _BSL_UCOMM_H_ */
/******************************************************************************\
* End of bsl_ucomm.h
\******************************************************************************/
