/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Hardware Abstraction Layer (HAL) of peripheral USIG
* FILENAME......... bsl_usighal.h
* GENERATED BY..... Peripheral Generator for DSP v1.2
* GENERATED AT..... 02/20/2004 09:13:10
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. USIG
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
*------------------------------------------------------------------------------
* BASE ADDRESS OF.. USIG is 0x6C080000u
*------------------------------------------------------------------------------
*
* REGISTERS
*
* DSPTIN0     -  DSP Tin0 Source
* DSPTIN1     -  DSP Tin1 Source
* DSPTIN2     -  DSP Tin2 Source
* PBTOUT0     -  Platform Bus Tout0 Source
* PBTOUT1     -  Platform Bus Tout1 Source
* DSPGPIO0    -  DSP General Purpose I/O 0 Control
* DSPGPIO1    -  DSP General Purpose I/O 1 Control
* DSPGPIO2    -  DSP General Purpose I/O 2 Control
* DSPGPIO3    -  DSP General Purpose I/O 3 Control
* STATUS      -  Signal Status (read-only)
*
\******************************************************************************/
#ifndef _BSL_USIGHAL_H_
#define _BSL_USIGHAL_H_

#include <bsl.h>


#if (BSL_USIG_SUPPORT)
/******************************************************************************\
* misc
\******************************************************************************/

  #define _USIG_DEVICE_COUNT                         1

  #define _USIG_BASE_ADDRESS                         0x6C080000u


/******************************************************************************\
* module level register/field access macros
\******************************************************************************/

  /* ------------------------------------------- */
  /* FIELD MAKE MACROS                           */
  /* ------------------------------------------- */

  #define USIG_FMK(REG,FIELD,val)\
    _PER_FMK16(USIG,##REG,##FIELD,val)

  #define USIG_FMKS(REG,FIELD,SYM)\
    _PER_FMKS16(USIG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* RAW REGISTER/FIELD ACCESS MACROS            */
  /* ------------------------------------------- */

  #define USIG_ADDR(REG)\
    _USIG_##REG##_ADDR

  #define USIG_RGET(REG)\
    _PER_RGET16(_USIG_##REG##_ADDR,USIG,##REG)

  #define USIG_RSET(REG,val)\
    _PER_RSET16(_USIG_##REG##_ADDR,USIG,##REG,val)

  #define USIG_RFSETS(REG,FIELD,SYM)\
    USIG_RSET(##REG,_USIG_##REG##_##FIELD##_##SYM##_SV)

  #define USIG_FGET(REG,FIELD)\
    _USIG_##REG##_FGET(##FIELD)

  #define USIG_FSET(REG,FIELD,val)\
    _USIG_##REG##_FSET(##FIELD,val)

  #define USIG_FSETS(REG,FIELD,SYM)\
    _USIG_##REG##_FSETS(##FIELD,##SYM)

  #define USIG_FGETQ(REG,FIELD,val)\
    _USIG_##REG##_FGETQ(##FIELD,val)

  #define USIG_FGETSQ(REG,FIELD,SYM)\
    _USIG_##REG##_FGETSQ(##FIELD,##SYM)


  /* ------------------------------------------- */
  /* ADDRESS BASED REGISTER/FIELD ACCESS MACROS  */
  /* ------------------------------------------- */

  #define USIG_RGETA(addr,REG)\
    _PER_RGET16(addr,USIG,##REG)

  #define USIG_RSETA(addr,REG,val)\
    _PER_RSET16(addr,USIG,##REG,val)

  #define USIG_RFSETSA(addr,REG,FIELD,SYM)\
    USIG_RSETA(addr,##REG,_USIG_##REG##_##FIELD##_##SYM##_SV)

  #define USIG_FGETA(addr,REG,FIELD)\
    _PER_FGET16(addr,USIG,##REG,##FIELD)

  #define USIG_FSETA(addr,REG,FIELD,val)\
    _PER_FSET16(addr,USIG,##REG,##FIELD,val)

  #define USIG_FSETSA(addr,REG,FIELD,SYM)\
    _PER_FSETS16(addr,USIG,##REG,##FIELD,##SYM)

  #define USIG_FGETQA(addr,REG,FIELD,val)\
    _PER_FGETQ16(addr,USIG,##REG,##FIELD,val)

  #define USIG_FGETSQA(addr,REG,FIELD,SYM)\
    _PER_FGETSQ16(addr,USIG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* VARIABLE BASED REGISTER/FIELD ACCESS MACROS */
  /* ------------------------------------------- */

  #define USIG_VRGET(var,REG)\
    _PER_VRGET16(var,USIG,##REG)

  #define USIG_VRSET(var,REG,val)\
    _PER_VRSET16(var,USIG,##REG,val)

  #define USIG_VRFSETS(var,REG,FIELD,SYM)\
    USIG_VRSET(var,##REG,_USIG_##REG##_##FIELD##_##SYM##_SV)

  #define USIG_VFGET(var,REG,FIELD)\
    _PER_VFGET16(var,USIG,##REG,##FIELD)

  #define USIG_VFSET(var,REG,FIELD,val)\
    _PER_VFSET16(var,USIG,##REG,##FIELD,val)

  #define USIG_VFSETS(var,REG,FIELD,SYM)\
    _PER_VFSETS16(var,USIG,##REG,##FIELD,##SYM)

  #define USIG_VFGETQ(var,REG,FIELD,val)\
    _PER_VFGETQ16(var,USIG,##REG,##FIELD,val)

  #define USIG_VFGETSQ(var,REG,FIELD,SYM)\
    _PER_VFGETSQ16(var,USIG,##REG,##FIELD,##SYM)


  /* ------------------------------------------- */
  /* Extension of the CSL standard               */
  /* ------------------------------------------- */

  /*
   * _<PER>_<REG>_RECIDX            Index in the array of the recorded registers
   * _<PER>_<REG>_REGOFFS           Offset in bytes from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_REGOFFS16         Offset in 16-bit words from the base address
   *                                of a device of the peripheral
   * _<PER>_<REG>_<FIELD>_<SYM>_SV  Shifted value of a symbol of a field.
   *                                Used by <PER>_RFSETS()-type macros.
   */


/******************************************************************************\
* _________________________
* |                       |
* |  D S P T I N 0        |
* |_______________________|
*
* DSPTIN0 - DSP Tin0 Source
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPTIN0_RECIDX                       No recorded */

  #define _USIG_DSPTIN0_ADDR                         0x6C080024u

  #define _USIG_DSPTIN0_REGOFFS                      0x00000024u
  #define _USIG_DSPTIN0_REGOFFS16                    0x00000012u

  #define _USIG_DSPTIN0_SOURCE_MASK                  0x0007u
  #define _USIG_DSPTIN0_SOURCE_SHIFT                 0
  #define USIG_DSPTIN0_SOURCE_DEFAULT                0x0000u
  #define USIG_DSPTIN0_SOURCE_OF(x)                  _VALUEOF16(x)
  #define USIG_DSPTIN0_SOURCE_SB2                    0x0007u
  #define USIG_DSPTIN0_SOURCE_SYNCBUS2               0x0007u
  #define USIG_DSPTIN0_SOURCE_SB1                    0x0006u
  #define USIG_DSPTIN0_SOURCE_SYNCBUS1               0x0006u
  #define USIG_DSPTIN0_SOURCE_SB0                    0x0005u
  #define USIG_DSPTIN0_SOURCE_SYNCBUS0               0x0005u
  #define USIG_DSPTIN0_SOURCE_PBTIN1                 0x0003u
  #define USIG_DSPTIN0_SOURCE_PBTIN0                 0x0002u
  #define USIG_DSPTIN0_SOURCE_VCC                    0x0001u
  #define USIG_DSPTIN0_SOURCE_GND                    0x0000u
  #define _USIG_DSPTIN0_SOURCE_SB2_SV                0x0007u
  #define _USIG_DSPTIN0_SOURCE_SYNCBUS2_SV           0x0007u
  #define _USIG_DSPTIN0_SOURCE_SB1_SV                0x0006u
  #define _USIG_DSPTIN0_SOURCE_SYNCBUS1_SV           0x0006u
  #define _USIG_DSPTIN0_SOURCE_SB0_SV                0x0005u
  #define _USIG_DSPTIN0_SOURCE_SYNCBUS0_SV           0x0005u
  #define _USIG_DSPTIN0_SOURCE_PBTIN1_SV             0x0003u
  #define _USIG_DSPTIN0_SOURCE_PBTIN0_SV             0x0002u
  #define _USIG_DSPTIN0_SOURCE_VCC_SV                0x0001u
  #define _USIG_DSPTIN0_SOURCE_GND_SV                0x0000u

  #define USIG_DSPTIN0_OF(val)                       _VALUEOF16(val)
  #define USIG_DSPTIN0_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(USIG,DSPTIN0,SOURCE)           \
  )

  #define USIG_DSPTIN0_RMK(source)                   \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPTIN0,SOURCE,source)         \
  )

  #define _USIG_DSPTIN0_FGET(FIELD)                  \
    _PER_FGET16(_USIG_DSPTIN0_ADDR,                  \
      USIG,DSPTIN0,##FIELD)

  #define _USIG_DSPTIN0_FSET(FIELD,field)            \
    _PER_FSET16(_USIG_DSPTIN0_ADDR,                  \
      USIG,DSPTIN0,##FIELD,field)

  #define _USIG_DSPTIN0_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_USIG_DSPTIN0_ADDR,                 \
      USIG,DSPTIN0,##FIELD,##SYM)

  #define _USIG_DSPTIN0_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_USIG_DSPTIN0_ADDR,                 \
      USIG,DSPTIN0,##FIELD,val)

  #define _USIG_DSPTIN0_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_USIG_DSPTIN0_ADDR,                \
      USIG,DSPTIN0,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P T I N 1        |
* |_______________________|
*
* DSPTIN1 - DSP Tin1 Source
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPTIN1_RECIDX                       No recorded */

  #define _USIG_DSPTIN1_ADDR                         0x6C080026u

  #define _USIG_DSPTIN1_REGOFFS                      0x00000026u
  #define _USIG_DSPTIN1_REGOFFS16                    0x00000013u

  #define _USIG_DSPTIN1_SOURCE_MASK                  0x0007u
  #define _USIG_DSPTIN1_SOURCE_SHIFT                 0
  #define USIG_DSPTIN1_SOURCE_DEFAULT                0x0000u
  #define USIG_DSPTIN1_SOURCE_OF(x)                  _VALUEOF16(x)
  #define USIG_DSPTIN1_SOURCE_SB2                    0x0007u
  #define USIG_DSPTIN1_SOURCE_SYNCBUS2               0x0007u
  #define USIG_DSPTIN1_SOURCE_SB1                    0x0006u
  #define USIG_DSPTIN1_SOURCE_SYNCBUS1               0x0006u
  #define USIG_DSPTIN1_SOURCE_SB0                    0x0005u
  #define USIG_DSPTIN1_SOURCE_SYNCBUS0               0x0005u
  #define USIG_DSPTIN1_SOURCE_PBTIN1                 0x0003u
  #define USIG_DSPTIN1_SOURCE_PBTIN0                 0x0002u
  #define USIG_DSPTIN1_SOURCE_VCC                    0x0001u
  #define USIG_DSPTIN1_SOURCE_GND                    0x0000u
  #define _USIG_DSPTIN1_SOURCE_SB2_SV                0x0007u
  #define _USIG_DSPTIN1_SOURCE_SYNCBUS2_SV           0x0007u
  #define _USIG_DSPTIN1_SOURCE_SB1_SV                0x0006u
  #define _USIG_DSPTIN1_SOURCE_SYNCBUS1_SV           0x0006u
  #define _USIG_DSPTIN1_SOURCE_SB0_SV                0x0005u
  #define _USIG_DSPTIN1_SOURCE_SYNCBUS0_SV           0x0005u
  #define _USIG_DSPTIN1_SOURCE_PBTIN1_SV             0x0003u
  #define _USIG_DSPTIN1_SOURCE_PBTIN0_SV             0x0002u
  #define _USIG_DSPTIN1_SOURCE_VCC_SV                0x0001u
  #define _USIG_DSPTIN1_SOURCE_GND_SV                0x0000u

  #define USIG_DSPTIN1_OF(val)                       _VALUEOF16(val)
  #define USIG_DSPTIN1_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(USIG,DSPTIN1,SOURCE)           \
  )

  #define USIG_DSPTIN1_RMK(source)                   \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPTIN1,SOURCE,source)         \
  )

  #define _USIG_DSPTIN1_FGET(FIELD)                  \
    _PER_FGET16(_USIG_DSPTIN1_ADDR,                  \
      USIG,DSPTIN1,##FIELD)

  #define _USIG_DSPTIN1_FSET(FIELD,field)            \
    _PER_FSET16(_USIG_DSPTIN1_ADDR,                  \
      USIG,DSPTIN1,##FIELD,field)

  #define _USIG_DSPTIN1_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_USIG_DSPTIN1_ADDR,                 \
      USIG,DSPTIN1,##FIELD,##SYM)

  #define _USIG_DSPTIN1_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_USIG_DSPTIN1_ADDR,                 \
      USIG,DSPTIN1,##FIELD,val)

  #define _USIG_DSPTIN1_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_USIG_DSPTIN1_ADDR,                \
      USIG,DSPTIN1,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P T I N 2        |
* |_______________________|
*
* DSPTIN2 - DSP Tin2 Source
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPTIN2_RECIDX                       No recorded */

  #define _USIG_DSPTIN2_ADDR                         0x6C080028u

  #define _USIG_DSPTIN2_REGOFFS                      0x00000028u
  #define _USIG_DSPTIN2_REGOFFS16                    0x00000014u

  #define _USIG_DSPTIN2_SOURCE_MASK                  0x0007u
  #define _USIG_DSPTIN2_SOURCE_SHIFT                 0
  #define USIG_DSPTIN2_SOURCE_DEFAULT                0x0000u
  #define USIG_DSPTIN2_SOURCE_OF(x)                  _VALUEOF16(x)
  #define USIG_DSPTIN2_SOURCE_SB2                    0x0007u
  #define USIG_DSPTIN2_SOURCE_SYNCBUS2               0x0007u
  #define USIG_DSPTIN2_SOURCE_SB1                    0x0006u
  #define USIG_DSPTIN2_SOURCE_SYNCBUS1               0x0006u
  #define USIG_DSPTIN2_SOURCE_SB0                    0x0005u
  #define USIG_DSPTIN2_SOURCE_SYNCBUS0               0x0005u
  #define USIG_DSPTIN2_SOURCE_PBTIN1                 0x0003u
  #define USIG_DSPTIN2_SOURCE_PBTIN0                 0x0002u
  #define USIG_DSPTIN2_SOURCE_VCC                    0x0001u
  #define USIG_DSPTIN2_SOURCE_GND                    0x0000u
  #define _USIG_DSPTIN2_SOURCE_SB2_SV                0x0007u
  #define _USIG_DSPTIN2_SOURCE_SYNCBUS2_SV           0x0007u
  #define _USIG_DSPTIN2_SOURCE_SB1_SV                0x0006u
  #define _USIG_DSPTIN2_SOURCE_SYNCBUS1_SV           0x0006u
  #define _USIG_DSPTIN2_SOURCE_SB0_SV                0x0005u
  #define _USIG_DSPTIN2_SOURCE_SYNCBUS0_SV           0x0005u
  #define _USIG_DSPTIN2_SOURCE_PBTIN1_SV             0x0003u
  #define _USIG_DSPTIN2_SOURCE_PBTIN0_SV             0x0002u
  #define _USIG_DSPTIN2_SOURCE_VCC_SV                0x0001u
  #define _USIG_DSPTIN2_SOURCE_GND_SV                0x0000u

  #define USIG_DSPTIN2_OF(val)                       _VALUEOF16(val)
  #define USIG_DSPTIN2_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(USIG,DSPTIN2,SOURCE)           \
  )

  #define USIG_DSPTIN2_RMK(source)                   \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPTIN2,SOURCE,source)         \
  )

  #define _USIG_DSPTIN2_FGET(FIELD)                  \
    _PER_FGET16(_USIG_DSPTIN2_ADDR,                  \
      USIG,DSPTIN2,##FIELD)

  #define _USIG_DSPTIN2_FSET(FIELD,field)            \
    _PER_FSET16(_USIG_DSPTIN2_ADDR,                  \
      USIG,DSPTIN2,##FIELD,field)

  #define _USIG_DSPTIN2_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_USIG_DSPTIN2_ADDR,                 \
      USIG,DSPTIN2,##FIELD,##SYM)

  #define _USIG_DSPTIN2_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_USIG_DSPTIN2_ADDR,                 \
      USIG,DSPTIN2,##FIELD,val)

  #define _USIG_DSPTIN2_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_USIG_DSPTIN2_ADDR,                \
      USIG,DSPTIN2,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P B T O U T 0        |
* |_______________________|
*
* PBTOUT0 - Platform Bus Tout0 Source
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_PBTOUT0_RECIDX                       No recorded */

  #define _USIG_PBTOUT0_ADDR                         0x6C08002Cu

  #define _USIG_PBTOUT0_REGOFFS                      0x0000002Cu
  #define _USIG_PBTOUT0_REGOFFS16                    0x00000016u

  #define _USIG_PBTOUT0_SOURCE_MASK                  0x0007u
  #define _USIG_PBTOUT0_SOURCE_SHIFT                 0
  #define USIG_PBTOUT0_SOURCE_DEFAULT                0x0000u
  #define USIG_PBTOUT0_SOURCE_OF(x)                  _VALUEOF16(x)
  #define USIG_PBTOUT0_SOURCE_SB2                    0x0007u
  #define USIG_PBTOUT0_SOURCE_SYNCBUS2               0x0007u
  #define USIG_PBTOUT0_SOURCE_SB1                    0x0006u
  #define USIG_PBTOUT0_SOURCE_SYNCBUS1               0x0006u
  #define USIG_PBTOUT0_SOURCE_SB0                    0x0005u
  #define USIG_PBTOUT0_SOURCE_SYNCBUS0               0x0005u
  #define USIG_PBTOUT0_SOURCE_DSPTOUT2               0x0004u
  #define USIG_PBTOUT0_SOURCE_DSPTOUT1               0x0003u
  #define USIG_PBTOUT0_SOURCE_DSPTOUT0               0x0002u
  #define USIG_PBTOUT0_SOURCE_VCC                    0x0001u
  #define USIG_PBTOUT0_SOURCE_GND                    0x0000u
  #define _USIG_PBTOUT0_SOURCE_SB2_SV                0x0007u
  #define _USIG_PBTOUT0_SOURCE_SYNCBUS2_SV           0x0007u
  #define _USIG_PBTOUT0_SOURCE_SB1_SV                0x0006u
  #define _USIG_PBTOUT0_SOURCE_SYNCBUS1_SV           0x0006u
  #define _USIG_PBTOUT0_SOURCE_SB0_SV                0x0005u
  #define _USIG_PBTOUT0_SOURCE_SYNCBUS0_SV           0x0005u
  #define _USIG_PBTOUT0_SOURCE_DSPTOUT2_SV           0x0004u
  #define _USIG_PBTOUT0_SOURCE_DSPTOUT1_SV           0x0003u
  #define _USIG_PBTOUT0_SOURCE_DSPTOUT0_SV           0x0002u
  #define _USIG_PBTOUT0_SOURCE_VCC_SV                0x0001u
  #define _USIG_PBTOUT0_SOURCE_GND_SV                0x0000u

  #define USIG_PBTOUT0_OF(val)                       _VALUEOF16(val)
  #define USIG_PBTOUT0_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(USIG,PBTOUT0,SOURCE)           \
  )

  #define USIG_PBTOUT0_RMK(source)                   \
    (Uint16)(                                        \
      _PER_FMK16(USIG,PBTOUT0,SOURCE,source)         \
  )

  #define _USIG_PBTOUT0_FGET(FIELD)                  \
    _PER_FGET16(_USIG_PBTOUT0_ADDR,                  \
      USIG,PBTOUT0,##FIELD)

  #define _USIG_PBTOUT0_FSET(FIELD,field)            \
    _PER_FSET16(_USIG_PBTOUT0_ADDR,                  \
      USIG,PBTOUT0,##FIELD,field)

  #define _USIG_PBTOUT0_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_USIG_PBTOUT0_ADDR,                 \
      USIG,PBTOUT0,##FIELD,##SYM)

  #define _USIG_PBTOUT0_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_USIG_PBTOUT0_ADDR,                 \
      USIG,PBTOUT0,##FIELD,val)

  #define _USIG_PBTOUT0_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_USIG_PBTOUT0_ADDR,                \
      USIG,PBTOUT0,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  P B T O U T 1        |
* |_______________________|
*
* PBTOUT1 - Platform Bus Tout1 Source
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_PBTOUT1_RECIDX                       No recorded */

  #define _USIG_PBTOUT1_ADDR                         0x6C08002Eu

  #define _USIG_PBTOUT1_REGOFFS                      0x0000002Eu
  #define _USIG_PBTOUT1_REGOFFS16                    0x00000017u

  #define _USIG_PBTOUT1_SOURCE_MASK                  0x0007u
  #define _USIG_PBTOUT1_SOURCE_SHIFT                 0
  #define USIG_PBTOUT1_SOURCE_DEFAULT                0x0000u
  #define USIG_PBTOUT1_SOURCE_OF(x)                  _VALUEOF16(x)
  #define USIG_PBTOUT1_SOURCE_SB2                    0x0007u
  #define USIG_PBTOUT1_SOURCE_SYNCBUS2               0x0007u
  #define USIG_PBTOUT1_SOURCE_SB1                    0x0006u
  #define USIG_PBTOUT1_SOURCE_SYNCBUS1               0x0006u
  #define USIG_PBTOUT1_SOURCE_SB0                    0x0005u
  #define USIG_PBTOUT1_SOURCE_SYNCBUS0               0x0005u
  #define USIG_PBTOUT1_SOURCE_DSPTOUT2               0x0004u
  #define USIG_PBTOUT1_SOURCE_DSPTOUT1               0x0003u
  #define USIG_PBTOUT1_SOURCE_DSPTOUT0               0x0002u
  #define USIG_PBTOUT1_SOURCE_VCC                    0x0001u
  #define USIG_PBTOUT1_SOURCE_GND                    0x0000u
  #define _USIG_PBTOUT1_SOURCE_SB2_SV                0x0007u
  #define _USIG_PBTOUT1_SOURCE_SYNCBUS2_SV           0x0007u
  #define _USIG_PBTOUT1_SOURCE_SB1_SV                0x0006u
  #define _USIG_PBTOUT1_SOURCE_SYNCBUS1_SV           0x0006u
  #define _USIG_PBTOUT1_SOURCE_SB0_SV                0x0005u
  #define _USIG_PBTOUT1_SOURCE_SYNCBUS0_SV           0x0005u
  #define _USIG_PBTOUT1_SOURCE_DSPTOUT2_SV           0x0004u
  #define _USIG_PBTOUT1_SOURCE_DSPTOUT1_SV           0x0003u
  #define _USIG_PBTOUT1_SOURCE_DSPTOUT0_SV           0x0002u
  #define _USIG_PBTOUT1_SOURCE_VCC_SV                0x0001u
  #define _USIG_PBTOUT1_SOURCE_GND_SV                0x0000u

  #define USIG_PBTOUT1_OF(val)                       _VALUEOF16(val)
  #define USIG_PBTOUT1_DEFAULT (Uint16)(             \
      _PER_FDEFAULT16(USIG,PBTOUT1,SOURCE)           \
  )

  #define USIG_PBTOUT1_RMK(source)                   \
    (Uint16)(                                        \
      _PER_FMK16(USIG,PBTOUT1,SOURCE,source)         \
  )

  #define _USIG_PBTOUT1_FGET(FIELD)                  \
    _PER_FGET16(_USIG_PBTOUT1_ADDR,                  \
      USIG,PBTOUT1,##FIELD)

  #define _USIG_PBTOUT1_FSET(FIELD,field)            \
    _PER_FSET16(_USIG_PBTOUT1_ADDR,                  \
      USIG,PBTOUT1,##FIELD,field)

  #define _USIG_PBTOUT1_FSETS(FIELD,SYM)             \
    _PER_FSETS16(_USIG_PBTOUT1_ADDR,                 \
      USIG,PBTOUT1,##FIELD,##SYM)

  #define _USIG_PBTOUT1_FGETQ(FIELD,val)             \
    _PER_FGETQ16(_USIG_PBTOUT1_ADDR,                 \
      USIG,PBTOUT1,##FIELD,val)

  #define _USIG_PBTOUT1_FGETSQ(FIELD,SYM)            \
    _PER_FGETSQ16(_USIG_PBTOUT1_ADDR,                \
      USIG,PBTOUT1,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P G P I O 0      |
* |_______________________|
*
* DSPGPIO0 - DSP General Purpose I/O 0 Control
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPGPIO0_RECIDX                      No recorded */

  #define _USIG_DSPGPIO0_ADDR                        0x6C080030u

  #define _USIG_DSPGPIO0_REGOFFS                     0x00000030u
  #define _USIG_DSPGPIO0_REGOFFS16                   0x00000018u

  #define _USIG_DSPGPIO0_SOURCE_MASK                 0x0007u
  #define _USIG_DSPGPIO0_SOURCE_SHIFT                0
  #define USIG_DSPGPIO0_SOURCE_DEFAULT               0x0000u
  #define USIG_DSPGPIO0_SOURCE_OF(x)                 _VALUEOF16(x)
  #define USIG_DSPGPIO0_SOURCE_FIFO3REQ              0x0007u
  #define USIG_DSPGPIO0_SOURCE_FIFO2REQ              0x0006u
  #define USIG_DSPGPIO0_SOURCE_FIFO1REQ              0x0005u
  #define USIG_DSPGPIO0_SOURCE_FIFO0REQ              0x0004u
  #define USIG_DSPGPIO0_SOURCE_VCC                   0x0003u
  #define USIG_DSPGPIO0_SOURCE_GND                   0x0002u
  #define USIG_DSPGPIO0_SOURCE_HIZ                   0x0000u
  #define _USIG_DSPGPIO0_SOURCE_FIFO3REQ_SV          0x0007u
  #define _USIG_DSPGPIO0_SOURCE_FIFO2REQ_SV          0x0006u
  #define _USIG_DSPGPIO0_SOURCE_FIFO1REQ_SV          0x0005u
  #define _USIG_DSPGPIO0_SOURCE_FIFO0REQ_SV          0x0004u
  #define _USIG_DSPGPIO0_SOURCE_VCC_SV               0x0003u
  #define _USIG_DSPGPIO0_SOURCE_GND_SV               0x0002u
  #define _USIG_DSPGPIO0_SOURCE_HIZ_SV               0x0000u

  #define USIG_DSPGPIO0_OF(val)                      _VALUEOF16(val)
  #define USIG_DSPGPIO0_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(USIG,DSPGPIO0,SOURCE)          \
  )

  #define USIG_DSPGPIO0_RMK(source)                  \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPGPIO0,SOURCE,source)        \
  )

  #define _USIG_DSPGPIO0_FGET(FIELD)                 \
    _PER_FGET16(_USIG_DSPGPIO0_ADDR,                 \
      USIG,DSPGPIO0,##FIELD)

  #define _USIG_DSPGPIO0_FSET(FIELD,field)           \
    _PER_FSET16(_USIG_DSPGPIO0_ADDR,                 \
      USIG,DSPGPIO0,##FIELD,field)

  #define _USIG_DSPGPIO0_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_USIG_DSPGPIO0_ADDR,                \
      USIG,DSPGPIO0,##FIELD,##SYM)

  #define _USIG_DSPGPIO0_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_USIG_DSPGPIO0_ADDR,                \
      USIG,DSPGPIO0,##FIELD,val)

  #define _USIG_DSPGPIO0_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_USIG_DSPGPIO0_ADDR,               \
      USIG,DSPGPIO0,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P G P I O 1      |
* |_______________________|
*
* DSPGPIO1 - DSP General Purpose I/O 1 Control
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPGPIO1_RECIDX                      No recorded */

  #define _USIG_DSPGPIO1_ADDR                        0x6C080032u

  #define _USIG_DSPGPIO1_REGOFFS                     0x00000032u
  #define _USIG_DSPGPIO1_REGOFFS16                   0x00000019u

  #define _USIG_DSPGPIO1_SOURCE_MASK                 0x0007u
  #define _USIG_DSPGPIO1_SOURCE_SHIFT                0
  #define USIG_DSPGPIO1_SOURCE_DEFAULT               0x0000u
  #define USIG_DSPGPIO1_SOURCE_OF(x)                 _VALUEOF16(x)
  #define USIG_DSPGPIO1_SOURCE_FIFO3REQ              0x0007u
  #define USIG_DSPGPIO1_SOURCE_FIFO2REQ              0x0006u
  #define USIG_DSPGPIO1_SOURCE_FIFO1REQ              0x0005u
  #define USIG_DSPGPIO1_SOURCE_FIFO0REQ              0x0004u
  #define USIG_DSPGPIO1_SOURCE_VCC                   0x0003u
  #define USIG_DSPGPIO1_SOURCE_GND                   0x0002u
  #define USIG_DSPGPIO1_SOURCE_HIZ                   0x0000u
  #define _USIG_DSPGPIO1_SOURCE_FIFO3REQ_SV          0x0007u
  #define _USIG_DSPGPIO1_SOURCE_FIFO2REQ_SV          0x0006u
  #define _USIG_DSPGPIO1_SOURCE_FIFO1REQ_SV          0x0005u
  #define _USIG_DSPGPIO1_SOURCE_FIFO0REQ_SV          0x0004u
  #define _USIG_DSPGPIO1_SOURCE_VCC_SV               0x0003u
  #define _USIG_DSPGPIO1_SOURCE_GND_SV               0x0002u
  #define _USIG_DSPGPIO1_SOURCE_HIZ_SV               0x0000u

  #define USIG_DSPGPIO1_OF(val)                      _VALUEOF16(val)
  #define USIG_DSPGPIO1_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(USIG,DSPGPIO1,SOURCE)          \
  )

  #define USIG_DSPGPIO1_RMK(source)                  \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPGPIO1,SOURCE,source)        \
  )

  #define _USIG_DSPGPIO1_FGET(FIELD)                 \
    _PER_FGET16(_USIG_DSPGPIO1_ADDR,                 \
      USIG,DSPGPIO1,##FIELD)

  #define _USIG_DSPGPIO1_FSET(FIELD,field)           \
    _PER_FSET16(_USIG_DSPGPIO1_ADDR,                 \
      USIG,DSPGPIO1,##FIELD,field)

  #define _USIG_DSPGPIO1_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_USIG_DSPGPIO1_ADDR,                \
      USIG,DSPGPIO1,##FIELD,##SYM)

  #define _USIG_DSPGPIO1_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_USIG_DSPGPIO1_ADDR,                \
      USIG,DSPGPIO1,##FIELD,val)

  #define _USIG_DSPGPIO1_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_USIG_DSPGPIO1_ADDR,               \
      USIG,DSPGPIO1,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P G P I O 2      |
* |_______________________|
*
* DSPGPIO2 - DSP General Purpose I/O 2 Control
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPGPIO2_RECIDX                      No recorded */

  #define _USIG_DSPGPIO2_ADDR                        0x6C080034u

  #define _USIG_DSPGPIO2_REGOFFS                     0x00000034u
  #define _USIG_DSPGPIO2_REGOFFS16                   0x0000001Au

  #define _USIG_DSPGPIO2_SOURCE_MASK                 0x0007u
  #define _USIG_DSPGPIO2_SOURCE_SHIFT                0
  #define USIG_DSPGPIO2_SOURCE_DEFAULT               0x0000u
  #define USIG_DSPGPIO2_SOURCE_OF(x)                 _VALUEOF16(x)
  #define USIG_DSPGPIO2_SOURCE_FIFO3REQ              0x0007u
  #define USIG_DSPGPIO2_SOURCE_FIFO2REQ              0x0006u
  #define USIG_DSPGPIO2_SOURCE_FIFO1REQ              0x0005u
  #define USIG_DSPGPIO2_SOURCE_FIFO0REQ              0x0004u
  #define USIG_DSPGPIO2_SOURCE_VCC                   0x0003u
  #define USIG_DSPGPIO2_SOURCE_GND                   0x0002u
  #define USIG_DSPGPIO2_SOURCE_HIZ                   0x0000u
  #define _USIG_DSPGPIO2_SOURCE_FIFO3REQ_SV          0x0007u
  #define _USIG_DSPGPIO2_SOURCE_FIFO2REQ_SV          0x0006u
  #define _USIG_DSPGPIO2_SOURCE_FIFO1REQ_SV          0x0005u
  #define _USIG_DSPGPIO2_SOURCE_FIFO0REQ_SV          0x0004u
  #define _USIG_DSPGPIO2_SOURCE_VCC_SV               0x0003u
  #define _USIG_DSPGPIO2_SOURCE_GND_SV               0x0002u
  #define _USIG_DSPGPIO2_SOURCE_HIZ_SV               0x0000u

  #define USIG_DSPGPIO2_OF(val)                      _VALUEOF16(val)
  #define USIG_DSPGPIO2_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(USIG,DSPGPIO2,SOURCE)          \
  )

  #define USIG_DSPGPIO2_RMK(source)                  \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPGPIO2,SOURCE,source)        \
  )

  #define _USIG_DSPGPIO2_FGET(FIELD)                 \
    _PER_FGET16(_USIG_DSPGPIO2_ADDR,                 \
      USIG,DSPGPIO2,##FIELD)

  #define _USIG_DSPGPIO2_FSET(FIELD,field)           \
    _PER_FSET16(_USIG_DSPGPIO2_ADDR,                 \
      USIG,DSPGPIO2,##FIELD,field)

  #define _USIG_DSPGPIO2_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_USIG_DSPGPIO2_ADDR,                \
      USIG,DSPGPIO2,##FIELD,##SYM)

  #define _USIG_DSPGPIO2_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_USIG_DSPGPIO2_ADDR,                \
      USIG,DSPGPIO2,##FIELD,val)

  #define _USIG_DSPGPIO2_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_USIG_DSPGPIO2_ADDR,               \
      USIG,DSPGPIO2,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  D S P G P I O 3      |
* |_______________________|
*
* DSPGPIO3 - DSP General Purpose I/O 3 Control
*
* FIELDS (msb -> lsb)
* (RW)	SOURCE    	[ 2: 0]	 - Source
*
\******************************************************************************/
/*#define _USIG_DSPGPIO3_RECIDX                      No recorded */

  #define _USIG_DSPGPIO3_ADDR                        0x6C080036u

  #define _USIG_DSPGPIO3_REGOFFS                     0x00000036u
  #define _USIG_DSPGPIO3_REGOFFS16                   0x0000001Bu

  #define _USIG_DSPGPIO3_SOURCE_MASK                 0x0007u
  #define _USIG_DSPGPIO3_SOURCE_SHIFT                0
  #define USIG_DSPGPIO3_SOURCE_DEFAULT               0x0000u
  #define USIG_DSPGPIO3_SOURCE_OF(x)                 _VALUEOF16(x)
  #define USIG_DSPGPIO3_SOURCE_FIFO3REQ              0x0007u
  #define USIG_DSPGPIO3_SOURCE_FIFO2REQ              0x0006u
  #define USIG_DSPGPIO3_SOURCE_FIFO1REQ              0x0005u
  #define USIG_DSPGPIO3_SOURCE_FIFO0REQ              0x0004u
  #define USIG_DSPGPIO3_SOURCE_VCC                   0x0003u
  #define USIG_DSPGPIO3_SOURCE_GND                   0x0002u
  #define USIG_DSPGPIO3_SOURCE_HIZ                   0x0000u
  #define _USIG_DSPGPIO3_SOURCE_FIFO3REQ_SV          0x0007u
  #define _USIG_DSPGPIO3_SOURCE_FIFO2REQ_SV          0x0006u
  #define _USIG_DSPGPIO3_SOURCE_FIFO1REQ_SV          0x0005u
  #define _USIG_DSPGPIO3_SOURCE_FIFO0REQ_SV          0x0004u
  #define _USIG_DSPGPIO3_SOURCE_VCC_SV               0x0003u
  #define _USIG_DSPGPIO3_SOURCE_GND_SV               0x0002u
  #define _USIG_DSPGPIO3_SOURCE_HIZ_SV               0x0000u

  #define USIG_DSPGPIO3_OF(val)                      _VALUEOF16(val)
  #define USIG_DSPGPIO3_DEFAULT (Uint16)(            \
      _PER_FDEFAULT16(USIG,DSPGPIO3,SOURCE)          \
  )

  #define USIG_DSPGPIO3_RMK(source)                  \
    (Uint16)(                                        \
      _PER_FMK16(USIG,DSPGPIO3,SOURCE,source)        \
  )

  #define _USIG_DSPGPIO3_FGET(FIELD)                 \
    _PER_FGET16(_USIG_DSPGPIO3_ADDR,                 \
      USIG,DSPGPIO3,##FIELD)

  #define _USIG_DSPGPIO3_FSET(FIELD,field)           \
    _PER_FSET16(_USIG_DSPGPIO3_ADDR,                 \
      USIG,DSPGPIO3,##FIELD,field)

  #define _USIG_DSPGPIO3_FSETS(FIELD,SYM)            \
    _PER_FSETS16(_USIG_DSPGPIO3_ADDR,                \
      USIG,DSPGPIO3,##FIELD,##SYM)

  #define _USIG_DSPGPIO3_FGETQ(FIELD,val)            \
    _PER_FGETQ16(_USIG_DSPGPIO3_ADDR,                \
      USIG,DSPGPIO3,##FIELD,val)

  #define _USIG_DSPGPIO3_FGETSQ(FIELD,SYM)           \
    _PER_FGETSQ16(_USIG_DSPGPIO3_ADDR,               \
      USIG,DSPGPIO3,##FIELD,##SYM)


/******************************************************************************\
* _________________________
* |                       |
* |  S T A T U S          |
* |_______________________|
*
* STATUS - Signal Status (read-only)
*
* FIELDS (msb -> lsb)
* (R.)	DSPGPIO3  	[15:15]	 - DSP GPIO 3 current value
* (R.)	DSPGPIO2  	[14:14]	 - DSP GPIO 2 current value
* (R.)	DSPGPIO1  	[13:13]	 - DSP GPIO 1 current value
* (R.)	DSPGPIO0  	[12:12]	 - DSP GPIO 0 current value
* (R.)	FRDYBUSY  	[11:11]	 - Flash Ready / Busy#
* (R.)	DSPTIN2   	[10:10]	 - DSP Tin2 current value
* (R.)	DSPTIN1   	[ 9: 9]	 - DSP Tin1 current value
* (R.)	DSPTIN0   	[ 8: 8]	 - DSP Tin0 current value
* (R.)	DSPTOUT2  	[ 6: 6]	 - DSP Tout2 current value
* (R.)	DSPTOUT1  	[ 5: 5]	 - DSP Tout1 current value
* (R.)	DSPTOUT0  	[ 4: 4]	 - DSP Tout0 current value
* (R.)	PBTIN1    	[ 3: 3]	 - Platform Bus Tin1 current value
* (R.)	PBTIN0    	[ 2: 2]	 - Platform Bus Tin0 current value
* (R.)	PBTOUT1   	[ 1: 1]	 - Platform Bus Tout1 current value
* (R.)	PBTOUT0   	[ 0: 0]	 - Platform Bus Tout0 current value
*
\******************************************************************************/
/*#define _USIG_STATUS_RECIDX                        No recorded */

  #define _USIG_STATUS_ADDR                          0x6C080080u

  #define _USIG_STATUS_REGOFFS                       0x00000080u
  #define _USIG_STATUS_REGOFFS16                     0x00000040u

  #define _USIG_STATUS_DSPGPIO3_MASK                 0x8000u
  #define _USIG_STATUS_DSPGPIO3_SHIFT                15
  #define USIG_STATUS_DSPGPIO3_DEFAULT               0x0000u
  #define USIG_STATUS_DSPGPIO3_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPGPIO2_MASK                 0x4000u
  #define _USIG_STATUS_DSPGPIO2_SHIFT                14
  #define USIG_STATUS_DSPGPIO2_DEFAULT               0x0000u
  #define USIG_STATUS_DSPGPIO2_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPGPIO1_MASK                 0x2000u
  #define _USIG_STATUS_DSPGPIO1_SHIFT                13
  #define USIG_STATUS_DSPGPIO1_DEFAULT               0x0000u
  #define USIG_STATUS_DSPGPIO1_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPGPIO0_MASK                 0x1000u
  #define _USIG_STATUS_DSPGPIO0_SHIFT                12
  #define USIG_STATUS_DSPGPIO0_DEFAULT               0x0000u
  #define USIG_STATUS_DSPGPIO0_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_FRDYBUSY_MASK                 0x0800u
  #define _USIG_STATUS_FRDYBUSY_SHIFT                11
  #define USIG_STATUS_FRDYBUSY_DEFAULT               0x0000u
  #define USIG_STATUS_FRDYBUSY_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPTIN2_MASK                  0x0400u
  #define _USIG_STATUS_DSPTIN2_SHIFT                 10
  #define USIG_STATUS_DSPTIN2_DEFAULT                0x0000u
  #define USIG_STATUS_DSPTIN2_OF(x)                  _VALUEOF16(x)

  #define _USIG_STATUS_DSPTIN1_MASK                  0x0200u
  #define _USIG_STATUS_DSPTIN1_SHIFT                 9
  #define USIG_STATUS_DSPTIN1_DEFAULT                0x0000u
  #define USIG_STATUS_DSPTIN1_OF(x)                  _VALUEOF16(x)

  #define _USIG_STATUS_DSPTIN0_MASK                  0x0100u
  #define _USIG_STATUS_DSPTIN0_SHIFT                 8
  #define USIG_STATUS_DSPTIN0_DEFAULT                0x0000u
  #define USIG_STATUS_DSPTIN0_OF(x)                  _VALUEOF16(x)

  #define _USIG_STATUS_DSPTOUT2_MASK                 0x0040u
  #define _USIG_STATUS_DSPTOUT2_SHIFT                6
  #define USIG_STATUS_DSPTOUT2_DEFAULT               0x0000u
  #define USIG_STATUS_DSPTOUT2_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPTOUT1_MASK                 0x0020u
  #define _USIG_STATUS_DSPTOUT1_SHIFT                5
  #define USIG_STATUS_DSPTOUT1_DEFAULT               0x0000u
  #define USIG_STATUS_DSPTOUT1_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_DSPTOUT0_MASK                 0x0010u
  #define _USIG_STATUS_DSPTOUT0_SHIFT                4
  #define USIG_STATUS_DSPTOUT0_DEFAULT               0x0000u
  #define USIG_STATUS_DSPTOUT0_OF(x)                 _VALUEOF16(x)

  #define _USIG_STATUS_PBTIN1_MASK                   0x0008u
  #define _USIG_STATUS_PBTIN1_SHIFT                  3
  #define USIG_STATUS_PBTIN1_DEFAULT                 0x0000u
  #define USIG_STATUS_PBTIN1_OF(x)                   _VALUEOF16(x)

  #define _USIG_STATUS_PBTIN0_MASK                   0x0004u
  #define _USIG_STATUS_PBTIN0_SHIFT                  2
  #define USIG_STATUS_PBTIN0_DEFAULT                 0x0000u
  #define USIG_STATUS_PBTIN0_OF(x)                   _VALUEOF16(x)

  #define _USIG_STATUS_PBTOUT1_MASK                  0x0002u
  #define _USIG_STATUS_PBTOUT1_SHIFT                 1
  #define USIG_STATUS_PBTOUT1_DEFAULT                0x0000u
  #define USIG_STATUS_PBTOUT1_OF(x)                  _VALUEOF16(x)

  #define _USIG_STATUS_PBTOUT0_MASK                  0x0001u
  #define _USIG_STATUS_PBTOUT0_SHIFT                 0
  #define USIG_STATUS_PBTOUT0_DEFAULT                0x0000u
  #define USIG_STATUS_PBTOUT0_OF(x)                  _VALUEOF16(x)

  #define USIG_STATUS_OF(val)                        _VALUEOF16(val)
  #define USIG_STATUS_DEFAULT (Uint16)(              \
      _PER_FDEFAULT16(USIG,STATUS,DSPGPIO3)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPGPIO2)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPGPIO1)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPGPIO0)          \
    | _PER_FDEFAULT16(USIG,STATUS,FRDYBUSY)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTIN2)           \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTIN1)           \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTIN0)           \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTOUT2)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTOUT1)          \
    | _PER_FDEFAULT16(USIG,STATUS,DSPTOUT0)          \
    | _PER_FDEFAULT16(USIG,STATUS,PBTIN1)            \
    | _PER_FDEFAULT16(USIG,STATUS,PBTIN0)            \
    | _PER_FDEFAULT16(USIG,STATUS,PBTOUT1)           \
    | _PER_FDEFAULT16(USIG,STATUS,PBTOUT0)           \
  )

  #define _USIG_STATUS_FGET(FIELD)                   \
    _PER_FGET16(_USIG_STATUS_ADDR,                   \
      USIG,STATUS,##FIELD)

  #define _USIG_STATUS_FSET(FIELD,field)             \
    _PER_FSET16(_USIG_STATUS_ADDR,                   \
      USIG,STATUS,##FIELD,field)

  #define _USIG_STATUS_FSETS(FIELD,SYM)              \
    _PER_FSETS16(_USIG_STATUS_ADDR,                  \
      USIG,STATUS,##FIELD,##SYM)

  #define _USIG_STATUS_FGETQ(FIELD,val)              \
    _PER_FGETQ16(_USIG_STATUS_ADDR,                  \
      USIG,STATUS,##FIELD,val)

  #define _USIG_STATUS_FGETSQ(FIELD,SYM)             \
    _PER_FGETSQ16(_USIG_STATUS_ADDR,                 \
      USIG,STATUS,##FIELD,##SYM)

/*----------------------------------------------------------------------------*/

#endif /* (BSL_USIG_SUPPORT) */
#endif /* _BSL_USIGHAL_H_ */
/******************************************************************************\
* End of bsl_usighal.h
\******************************************************************************/
