/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral WATCHDOG
* FILENAME......... bsl_watchdog.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 11:14:29
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. WATCHDOG
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_WATCHDOG_H_
#define _BSL_WATCHDOG_H_

#include <bsl_watchdoghal.h>


#if (BSL_WATCHDOG_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef	__cplusplus
	#define	BSLAPI extern "C" far
#else
	#define	BSLAPI extern far
#endif

#undef	USEDEFS
#undef	IDECL
#undef	IDEF

#ifdef _BSL_WATCHDOG_MOD_
	#define IDECL BSLAPI
	#define USEDEFS
	#define IDEF
#else
	#ifdef	_INLINE
		#define	IDECL static inline
		#define	USEDEFS
		#define	IDEF  static inline
	#else
		#define	IDECL BSLAPI
	#endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

// Timeout identifiers for Watchdog Timer B
// Use them for WATCHDOG_setTimeoutB() function.
#define WATCHDOG_B_TIMEOUT_5S3			0	// 5.3 sec
#define WATCHDOG_B_TIMEOUT_336MS		1	// 336 msec
#define WATCHDOG_B_TIMEOUT_LONG			0	// 5.3 sec
#define WATCHDOG_B_TIMEOUT_SHORT		1	// 336 msec

// Activity identifiers for Watchdog Timer B
// Use them for WATCHDOG_setActivityB() function.
#define WATCHDOG_B_GENERATES_RESET		0
#define WATCHDOG_B_GENERATES_NMI		1


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

/* device configuration structure */
typedef struct {
	Uint16 regCTL;
} WATCHDOG_Config;

/* object structure */
typedef struct {
	Uint32 baseAddr;
} WATCHDOG_Obj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/

BSLAPI WATCHDOG_Obj _WATCHDOG_obj;	/* defined in bsl_watchdog.c */


/******************************************************************************\
* global function declarations
\******************************************************************************/


/******************************************************************************\
* inline function declarations
\******************************************************************************/

//==============================================================================
// Enables the Watchdog Timer A/B. In this case, the selected Watchdog Timer
// must be triggered periodically (according to the set timeout) to avoid DSP
// reset (or NMI).
//==============================================================================
IDECL void WATCHDOG_enableA();
IDECL void WATCHDOG_enableB();

//==============================================================================
// Disables the Watchdog Timer A/B.
//==============================================================================
IDECL void WATCHDOG_disableA();
IDECL void WATCHDOG_disableB();

//==============================================================================
// Returns if the Watchdog Timer A/B is enabled actually.
//==============================================================================
IDECL Uint32 WATCHDOG_isEnabledA();
IDECL Uint32 WATCHDOG_isEnabledB();

//==============================================================================
// Trigger for the Watchdog Timer A/B.
// Clears the internal counter of the Watchdog Timer. If the Watchdog Timer is
// enabled, this function must be called periodically (according to the set
// timeout) to avoid DSP reset (or NMI).
//==============================================================================
IDECL void WATCHDOG_triggerA();
IDECL void WATCHDOG_triggerB();

//==============================================================================
// Sets the timeout of the Watchdog Timer B.
//
// parameters:
//		timeout			Timeout selector
//						Use WATCHDOG_B_TIMEOUT_x constants.
//==============================================================================
IDECL void WATCHDOG_setTimeoutB(Uint32 timeout);

//==============================================================================
// Returns if the timeout of the Watchdog Timer B is set to either long time
// period (5.3 sec) or short time period (336 msec).
//==============================================================================
IDECL Uint32 WATCHDOG_isLongTimeoutB();
IDECL Uint32 WATCHDOG_isShortTimeoutB();

//==============================================================================
// Sets the activity of the Watchdog Timer B.
//
// parameters:
//		gen				Selects which signal will be generated at timeout of the
//						Watchdog Timer B (if it was enabled)
//						Use WATCHDOG_B_GENERATES_x constants.
//==============================================================================
IDECL void WATCHDOG_setActivityB(Uint32 gen);

//==============================================================================
// Returns if the activity of the Watchdog Timer B is set to generate either a
// reset signal or an NMI signal.
//==============================================================================
IDECL Uint32 WATCHDOG_isResetGenB();
IDECL Uint32 WATCHDOG_isNmiGenB();

IDECL void WATCHDOG_config(WATCHDOG_Config *config);
IDECL void WATCHDOG_configArgs(Uint32 ctl);
IDECL void WATCHDOG_getConfig(WATCHDOG_Config *config);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_enableA()
{
	WATCHDOG_FSETS( CTL, WDAEN, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_enableB()
{
	WATCHDOG_FSETS( CTL, WDBEN, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_disableA()
{
	WATCHDOG_FSETS( CTL, WDAEN, DISABLED );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_disableB()
{
	WATCHDOG_FSETS( CTL, WDBEN, DISABLED );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isEnabledA()
{
	return WATCHDOG_FGETSQ( CTL, WDAEN, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isEnabledB()
{
	return WATCHDOG_FGETSQ( CTL, WDBEN, ENABLED );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_setTimeoutB(Uint32 timeout)
{
	WATCHDOG_FSET( CTL, WDBTO, timeout );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isLongTimeoutB()
{
	return WATCHDOG_FGETSQ( CTL, WDBTO, TO5S3 );	// 5.3 sec
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isShortTimeoutB()
{
	return WATCHDOG_FGETSQ( CTL, WDBTO, TO336MS );	// 336 msec
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_setActivityB(Uint32 gen)
{
	WATCHDOG_FSET( CTL, WDBGEN, gen );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isResetGenB()
{
	return WATCHDOG_FGETSQ( CTL, WDBGEN, RESET );
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 WATCHDOG_isNmiGenB()
{
	return WATCHDOG_FGETSQ( CTL, WDBGEN, NMI );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_triggerA()
{
	WATCHDOG_RFSETS( TRIG, WDA, RESET );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_triggerB()
{
	WATCHDOG_RFSETS( TRIG, WDB, RESET );
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_config(WATCHDOG_Config *config)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0;

	base = (volatile Uint16 *)(_WATCHDOG_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = config->regCTL;
	base[_WATCHDOG_CTL_REGOFFS16] = (Uint16)(r0);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_configArgs(Uint32 ctl)
{
	Uint32 gie;
	volatile Uint16 *base;
	register Uint32 r0;

	base = (volatile Uint16 *)(_WATCHDOG_obj.baseAddr);

	gie = IRQ_globalDisable();

	r0 = ctl;
	base[_WATCHDOG_CTL_REGOFFS16] = (Uint16)(r0);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
IDEF void WATCHDOG_getConfig(WATCHDOG_Config *config)
{
	Uint32 gie;
	volatile WATCHDOG_Config *cfg;
	cfg = (volatile WATCHDOG_Config *) config;

	gie = IRQ_globalDisable();

	cfg->regCTL = WATCHDOG_RGET(CTL);

	IRQ_globalRestore(gie);
}

/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */


#endif /* BSL_WATCHDOG_SUPPORT */
#endif /* _BSL_WATCHDOG_H_ */
/******************************************************************************\
* End of bsl_watchdog.h
\******************************************************************************/
