/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... MatMult
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT..........
* FILENAME......... MatMult.c
\******************************************************************************/

#include "MatMultcfg.h"
#include <bsl.h>
#include <bsl_comm.h>
#include "dsp_mat_mul.h"


#define DSPADDRESSMATRIX1 0x80010000
#define DSPADDRESSMATRIX2 0x80020000
#define DSPADDRESSRESULTANTMATRIX  0x80030000

void tskFunctionCalls();

void DoMatrixMult( Uint16 rows, Uint16 cols )
{
    short *Matrix1;
    short *Matrix2;
    short *MatrixResult;

    Matrix1 = (short *) DSPADDRESSMATRIX1;
    Matrix2 = (short *) DSPADDRESSMATRIX2;
    MatrixResult = (short *) DSPADDRESSRESULTANTMATRIX;

    DSP_mat_mul(Matrix1,(int) rows, (int) cols, Matrix2,(int) cols , MatrixResult, 0);
}


//------------------------------------------------------------------------------
// main() function
//------------------------------------------------------------------------------
void main()
{
    //--------------------------------------------------------------------------
    // BSL must be initialized before any BSL function calls
    //--------------------------------------------------------------------------
    BSL_init();
}

//------------------------------------------------------------------------------
// This is the User's Initialization function. It is a TSK. When this function
// starts, the DSP/BIOS has already been started. You can do anything here (it
// is not the main() function). Note that the pre-initialized peripheral
// settings in the CSL - Chip Support Library of the CDB file are initialized
// before this a call of the main() function. That is, before a call of this
// function.
// By default, the tskUserInitialization() function is the highest priority task
// in the application to ensure this TSK runs at first. If you have some PRD
// (Periodic) functions, they can preempt your intialization function
// tskUserInitialization(), which can cause unexpected behave of your program.
// Solution: you have to create a One-Shot PRD function with the highest
// priority to ensure that PRD (SWI) function runs at first. All the
// initialization should be placed in that PRD function. Be careful! Each PRD
// function is called from the PRD_swi PRD scheduler DSP/BIOS function that is
// an SWI, not a TSK. Please, check the availability and behaviour of the called
// DSP/BIOS functions from the your initialization PRD function.
// [DSP/BIOS API Reference Guide (spru403e.pdf), Appendix A.1]
// Note that it could be, your DSP/BIOS version has a bug of starting of the
// One-Shot PRD functions. See TI's SDSsq23340 bug report.
//
// If necessary, modify the stack size of this task. By default, it is set to
// 256 bytes.
//------------------------------------------------------------------------------
void tskUserInitialization()
{

}

//------------------------------------------------------------------------------
// Unique Function Call Identifiers (FCIDs) for each function that can be called
// by a host application. The FCID number of a function to be called must be
// defined in the following naming format: FCID_<function_name>. The FCIDs are
// 24-bit numbers.
//------------------------------------------------------------------------------
#define FCID_DoMatrixMult                   0x000000


//------------------------------------------------------------------------------
// This tskFunctionCalls() function calls the proper functions as TSK functions
// (in a TSK environment) according to the received DSP Function Call Requests
// from a Host application. The tskFunctionCalls() has an infinite loop to serve
// out the requests, to call the functions. Therefore, this task never finishes.
// However, it is waiting for the DSP Function Call Requests in passive mode by
// a semaphore, that is, other TSKs can run until the tskFunctionCalls() is in
// wait state. Note that the tskFunctionCalls() is called by the DSP/BIOS
// scheduler, if there is no higher priority ready-to-run TSK and currently no
// running higher priority TSK. You can set the proper priority level of the
// tskFunctionCalls() for your application in the Configuration Tool.
//------------------------------------------------------------------------------
void tskFunctionCalls()
{
    //--------------------------------------------------------------------------
    // This is an infinite loop to serve out the DSP Function Call requests of
    // a host application.
    // COMM_FUNC_CALL_LOOP_BEGIN macro that must be
    // located at the beginning of the loop.
    // Within the loop, you can define function calls by the following format:
    // COMM_FUNC_CALL_<num_of_params>( <ret_type>, <func_name> [,<param_type>]... );
    // Each COMM_FUNC_CALL_x() macro belongs an FCID_<function_name> constant,
    // which is the unique Function Call Identifier of the selected function.
    //--------------------------------------------------------------------------
    COMM_FUNC_CALL_LOOP_BEGIN

    //
    //
    // The Function Call macros can be placed here.
    //
    //
    COMM_FUNC_CALL_2( void, DoMatrixMult, Uint16  , Uint16 );

    //--------------------------------------------------------------------------
    // The COMM_FUNC_CALL_LOOP_END macro call defines the end of the loop to
    // serve out the DSP Function Call requests of the host application.
    //--------------------------------------------------------------------------
    COMM_FUNC_CALL_LOOP_END;

    //--------------------------------------------------------------------------
    // This code area cannot be reached. The tskFunctionCalls() function never
    // finished.
    //--------------------------------------------------------------------------
}
