/******************************************************************************\
* Copyright (C) 2004 by RTD Embedded Technologies, Inc.   All rights reserved.
* Confidential and Proprietary, Not for Public Release
*------------------------------------------------------------------------------
* PROJECT.......... Board Support Library for SPM6420 and SPM6430
* VERSION.......... (Defined in README.TXT)
*------------------------------------------------------------------------------
* CONTENT.......... Header file for API of peripheral FLASH
* FILENAME......... bsl_flash.h
* GENERATED BY..... Peripheral Generator v1.1
* GENERATED AT..... 02/10/2004 15:27:04
*------------------------------------------------------------------------------
* PERIPHERAL NAME.. FLASH
* PERIPHERAL TYPE.. Single-device peripheral
* ACCESS MODE...... Direct (no handle)
* REGISTER ACCESS.. 16-bit wide
\******************************************************************************/
#ifndef _BSL_FLASH_H_
#define _BSL_FLASH_H_

#include <bsl.h>
#include <std.h>
#include <sem.h>
#include <swi.h>
#include <que.h>


#if (BSL_FLASH_SUPPORT)
/******************************************************************************\
* scope and inline control macros
\******************************************************************************/

#ifdef  __cplusplus
    #define BSLAPI extern "C" far
#else
    #define BSLAPI extern far
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef BSL_FLASH_MOD_
    #define IDECL BSLAPI
    #define USEDEFS
    #define IDEF
#else
    #ifdef  _INLINE
        #define IDECL static inline
        #define USEDEFS
        #define IDEF  static inline
    #else
        #define IDECL BSLAPI
    #endif
#endif


/******************************************************************************\
* global macro declarations
\******************************************************************************/

//------------------------------------------------------------------------------
// bit fields and values in FLASH_AccessReqObj's control member

// state of request
#define _FLASH_SOR_MASK                     (0xF0000000u)
#define FLASH_SOR_COMPLETED                 (0x10000000u)
#define FLASH_SOR_IN_PROCESS                (0x20000000u)
#define FLASH_SOR_IN_QUEUE                  (0x30000000u)
#define FLASH_SOR_INITIAL_ERROR             (0x40000000u)

// operations
#define _FLASH_OP_MASK                      (0x0F000000u)
#define FLASH_OP_TRANSFER_FROM_DSP          (0x00000000u)
#define FLASH_OP_TRANSFER_TO_FLASH          (0x00000000u)
#define FLASH_OP_WRITE_TO_FLASH             (0x00000000u)
#define FLASH_OP_TRANSFER_FROM_FLASH        (0x01000000u)
#define FLASH_OP_TRANSFER_TO_DSP            (0x01000000u)
#define FLASH_OP_READ_FROM_FLASH            (0x01000000u)
#define FLASH_OP_ERASE_SECTORS              (0x02000000u)
#define FLASH_OP_ERASE_CHIP                 (0x03000000u)
#define FLASH_OP_CHECK_BLANK                (0x04000000u)
#define FLASH_OP_COMPARE_BLOCK              (0x05000000u)

// Type of Queue
#define _FLASH_TOQ_MASK                     (0x00F00000u)
#define FLASH_TOQ_LOW_PRIORITY              (0x00000000u)
#define FLASH_TOQ_NORMAL                    (0x00000000u)
#define FLASH_TOQ_HIGH_PRIORITY             (0x00100000u)
#define FLASH_TOQ_EMERGENCY                 (0x00100000u)

// "Type of Signaling" values
#define _FLASH_TOS_MASK                     (0x000F0000u)
#define FLASH_TOS_NONE                      (0x00000000u)
#define FLASH_TOS_SWI                       (0x00010000u)
#define FLASH_TOS_SEM                       (0x00020000u)

// return value of the private function FLASH_checkParams()
#define FLASH_CHKPRM_START_SI               5   // too big sector index for startSI
#define FLASH_CHKPRM_END_SI                 4   // endSI < startSI
#define FLASH_CHKPRM_SIZE                   3
#define FLASH_CHKPRM_FLASH                  2
#define FLASH_CHKPRM_DSP                    1
#define FLASH_CHKPRM_OK                     0

// global flash operation functions' return values
#define FLASH_OK                            0
#define FLASH_ERROR                         2

// error codes in the member errorCode of the FLASH_Return
#define _FLASH_RETERR_MASK                  0x0000FFFF
#define FLASH_RETERR_SUCCESSFUL             0x00000000
#define FLASH_RETERR_OK                     0x00000000
#define FLASH_RETERR_NO_ERROR               0x00000000
#define FLASH_RETERR_BUSY                   0x00000001
#define FLASH_RETERR_STILL_WORK             0x00000001
#define FLASH_RETERR_CHKPRM_START_SI        (FLASH_CHKPRM_START_SI << 4)
#define FLASH_RETERR_CHKPRM_END_SI          (FLASH_CHKPRM_END_SI << 4)
#define FLASH_RETERR_CHKPRM_SIZE            (FLASH_CHKPRM_SIZE << 4)
#define FLASH_RETERR_CHKPRM_FLASH           (FLASH_CHKPRM_FLASH << 4)
#define FLASH_RETERR_CHKPRM_DSP             (FLASH_CHKPRM_DSP << 4)
#define FLASH_RETERR_PROGRAMMING_ERROR      0x00000100  // at programming
#define FLASH_RETERR_ERASE_FAILED           0x00000200  // at chip/sector erasing
#define FLASH_RETERR_CHECK_ERROR            0x00000300  // at blank check and compare
#define FLASH_RETERR_NO_BLANK               0x00000300  // at blank check
#define FLASH_RETERR_DIRTY_SECTOR           0x00000300  // at blank check
#define FLASH_RETERR_COMPARISON_FAILED      0x00000300  // at compare

//------------------------------------------------------------------------------

// starting byte address of the flash device in the DSP's memory address space
#define FLASH_STARTING_ADDRESS              0x67E00000

// Indexes for the FLASH_AccessReqObj's param[] member array
#define FLASH_IOP_flashOffset       0
#define FLASH_IOP_dspAddress        1
#define FLASH_IOP_numOf16bWs        2
#define FLASH_IOP_startSI           0
#define FLASH_IOP_endSI             1
#define FLASH_IOP_currSI            0   // = startSI


/******************************************************************************\
* global typedef declarations
\******************************************************************************/

// data structure for RARO (Resource Access Request Object) of flash device
typedef struct
{
    QUE_Elem    link;           // to put the element into a queue
                                // it must be the first element in the structure
    Uint32      param[3];       // depends on the current flash operation
    Uint32      control;        // operation code, signaling code, return code
    Void *      pSemOrSwiObj;   // SEM or SWI Handler
                                // It will be cast according to Type Of Signaling
} FLASH_AccessReqObj;


/******************************************************************************\
* global variable declarations
\******************************************************************************/


/******************************************************************************\
* global function declarations
\******************************************************************************/

//==============================================================================
// Checking parameters (address ranges) for data transfer
//
// parameters:
//      flashOffset         Starting byte offset within the flash address space
//      dspAddress          Starting byte address within the DSP address space
//                          (must be an 16-bit aligned address)
//      numOf16bWs          Number of 16-bit words to be transferred
//
// return:
//      FLASH_CHKPRM_SIZE   too many 16-bit words should be transferred
//      FLASH_CHKPRM_FLASH  flash offset is too big
//      FLASH_CHKPRM_DSP    DSP address (range) falls into flash memory address region
//      FLASH_CHKPRM_OK     all right
//==============================================================================
BSLAPI Uint32 FLASH_checkTrParams(
    Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs);

//==============================================================================
// Checking parameters (sector indexes) for operations that works on sectors
//
// parameters:
//      startSI     Index of the first sector in the selected sector block
//                  Counter from 0.
//      endSI       Index of the last sector in the selected sector block
//                  Counter from 0.
//
// return:
//      FLASH_CHKPRM_START_SI   Too big sector index.
//      FLASH_CHKPRM_END_SI     endSI less then startSI
//      FLASH_CHKPRM_OK         all right
//==============================================================================
BSLAPI Uint32 FLASH_checkScParams(Uint32 startSI, Uint32 endSI);

//==============================================================================
// Put a previously allocated (by the user) and filled up (by a call of one of
// the FLASH_makeReq_x() functions) FLASH_AccessReqObj into the defined queue to
// request a flash operation in fact.
//
// See the Common considerations description for more details.
//
// parameters:
//      pReqObj             Pointer to the previously allocated and filled up
//                          FLASH_AccessReqObj structure.
//      bResetSEM           If the pReqObj defines a semaphore signaling type
//                          and the parameter bResetSEM is true, the semaphore
//                          will be reset. Can be TRUE, called from TSK!
//
// LOOK OUT! If you call the FLASH_accessReq() function from a context of SWI,
// the parameter bResetSEM MUST BE FALSE; and before the call of the function
// FLASH_accessReq(), you should call the SEM_reset() function from a context of
// TSK for that semaphore, which is pointed by the pReqObj.
//==============================================================================
BSLAPI void FLASH_accessReq(FLASH_AccessReqObj *pReqObj, BOOL bResetSEM);

//==============================================================================
// Returns the flash byte offset of the beginning of the given sector
//
// parameters:
//      sectorIndex         Selects the desired sector. Counted from 0.
//                          The 0-index sector is at the beginning of the flash
//                          memory.
// return:
//      The starting flash byte offset of the given sector.
//==============================================================================
BSLAPI Uint32 FLASH_getSectorStartOffset(Uint32 sectorIndex);

//==============================================================================
// Returns the length of the selected sector in bytes
//
// parameters:
//      sectorIndex         Selects the desired sector. Counted from 0.
//                          The 0-index sector is at the beginning of the flash
//                          memory.
// return:
//      The length of the selected sector in bytes.
//==============================================================================
BSLAPI Uint32 FLASH_getSectorLength(Uint32 sectorIndex);

//==============================================================================
// Returns the last sector index of the flash memory
//
// return:
//      The last sector index of the installed flash device
//==============================================================================
BSLAPI Uint32 FLASH_getLastSectorIndex();

//==============================================================================
// Returns the size of the flash memory in bytes
//
// return:
//      flash memory size in bytes
//==============================================================================
BSLAPI Uint32 FLASH_getFlashSizeInBytes();


/******************************************************************************\
* inline function declarations
\******************************************************************************/

//==============================================================================
// Common considerations to use functions of the FLASH module:
//------------------------------------------------------------------------------
//
// In the name of the "makeReq" functions, the last segment (after the last
// underscore character) determines the signaling type:
//      SWI     After the request has been served out, the proper Software
//              Interrupt will be generated, the given SWI will be posted
//              according to parameter hSWI.
//      SEM     After the request has been served out, the proper Semaphore
//              will be posted according to parameter hSEM.
//      NONE    There is no automatic signaling. You can check (by polling, by
//              calls of the FLASH_isCompleted() function) whether or not the
//              request has already been served out.
//
// DO NOT DELETE the allocated FLASH_AccessReqObj structure until the request is
// served out. It is strongly recommended to use a globally allocated variable
// for the FLASH_AccessReqObj structure. Do not allocate the structure in the
// stack.
//
// After you have created a properly filled up FLASH_AccessReqObj, you can use
// it more times for the same operation without any modification. The return
// error code field and semaphore (if there) is reset at every call of the
// FLASH_accessReq() function.
//
// DO NOT USE the same FLASH_AccessReqObj again until the request is served out
// for a call of the FLASH_accessReq() using the same FLASH_AccessReqObj.
//==============================================================================

//==============================================================================
// This is a slave function of the FLASH_makeReq_blockRead16_x() and
// the FLASH_makeReq_blockProg16_x() and the FLASH_makeReq_blockComp16_x()
// functions.
// Do not call this function directly!
//==============================================================================
IDECL Uint32 FLASH_makeReq_checkTrParams(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj);

//==============================================================================
// This is a slave function of the FLASH_makeReq_sectorErase_x() and
// the FLASH_makeReq_checkSectorBlank_x() functions.
// Do not call this function directly!
//==============================================================================
IDECL Uint32 FLASH_makeReq_checkScParams(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create
// a read operation to transfer a block of data from the flash memory to the
// DSP's memory. The operation is always successful.
//
// See the Common considerations description for more details.
//
// parameters:
//      flashOffset         Starting byte offset within the flash address space.
//                          Must be aligned to 2-byte boundaries.
//      dspAddress          Starting byte address within the DSP address space
//                          excluding address region of the flash memory.
//                          Must be aligned to 2-byte boundaries.
//      numOf16bWs          Number of 16-bit words to be transferred.
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_ERROR         An error occured. To get the exact error code, call
//                          the FLASH_getErrorCode() function with pReqObj as
//                          its parameter.
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//==============================================================================
IDECL Uint32 FLASH_makeReq_blockRead16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_blockRead16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_blockRead16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create
// a write (programming) operation to transfer a block of data from the DSP's
// memory to the flash memory. There is no erase before programming! You should
// always check the Return Error Code in the FLASH_AccessReqObj to get to know
// whether or not the programming was successful.
//
// See the Common considerations description for more details.
//
// parameters:
//      flashOffset         Starting byte offset within the flash address space.
//                          Must be aligned to 2-byte boundaries.
//      dspAddress          Starting byte address within the DSP address space
//                          excluding address region of the flash memory.
//                          Must be aligned to 2-byte boundaries.
//      numOf16bWs          Number of 16-bit words to be transferred.
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_ERROR         An error occured. To get the exact error code, call
//                          the FLASH_getErrorCode() function with pReqObj as
//                          its parameter.
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//==============================================================================
IDECL Uint32 FLASH_makeReq_blockProg16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_blockProg16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_blockProg16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create
// a Chip Erase operation to erase the entire flash memory. All the words of
// the flash memory will be 0xFFFF. There is no check whether the erasing was
// successful or not. The operation is always successful.
//
// See the Common considerations description for more details.
//
// parameters:
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//                          Note that the FLASH_makeReq_chipErase_x() functions
//                          always return FLASH_OK.
//==============================================================================
IDECL Uint32 FLASH_makeReq_chipErase_SWI(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_chipErase_SEM(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_chipErase_NONE(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create
// some Sector Erase operations to erase some sectors in the flash memory. All
// the words of given interval of the sectors will be 0xFFFF. There is no check
// whether the erasing was successful or not. The operation is always
// successful.
//
// See the Common considerations description for more details.
//
// parameters:
//      startSI             Index of the first sector to be erased.
//                          Counted from 0.
//      endSI               Index of the last sector to be erased.
//                          Counted from 0.
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_ERROR         An error occured. To get the exact error code, call
//                          the FLASH_getErrorCode() function with pReqObj as
//                          its parameter.
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//==============================================================================
IDECL Uint32 FLASH_makeReq_sectorErase_SWI(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_sectorErase_SEM(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_sectorErase_NONE(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create a
// checking operation to get to know whether or not the given sectors are blank.
// You should always check the Return Error Code in the FLASH_AccessReqObj to
// get to know the result of the checking.
//
// See the Common considerations description for more details.
//
// parameters:
//      startSI             Index of the first sector to be erased.
//                          Counted from 0.
//      endSI               Index of the last sector to be erased.
//                          Counted from 0.
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_ERROR         An error occured. To get the exact error code, call
//                          the FLASH_getErrorCode() function with pReqObj as
//                          its parameter.
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//==============================================================================
IDECL Uint32 FLASH_makeReq_checkSectorBlank_SWI(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_checkSectorBlank_SEM(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_checkSectorBlank_NONE(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);

//==============================================================================
// Fills up a previously allocated (by the user) FLASH_AccessReqObj to create
// a compare operation to compare a block of the flash memory to a block of the
// DSP's memory. You should always check the Return Error Code in the
// FLASH_AccessReqObj to get to know the result of the comparison.
//
// See the Common considerations description for more details.
//
// parameters:
//      flashOffset         Starting byte offset within the flash address space.
//                          Must be aligned to 2-byte boundaries.
//      dspAddress          Starting byte address within the DSP address space
//                          excluding address region of the flash memory.
//                          Must be aligned to 2-byte boundaries.
//      numOf16bWs          Number of 16-bit words to be transferred.
//      pReqObj             Pointer to the previously allocated (by the user)
//                          FLASH_AccessReqObj structure. This structure will be
//                          filled up accoring to the other given parameters.
//      quePri              Priority of the queue to be used to receive the
//                          request. The FLASH_TOQ_x constants can be used for
//                          this parameter:
//                          FLASH_TOQ_LOW_PRIORITY = FLASH_TOQ_NORMAL,
//                          FLASH_TOQ_HIGH_PRIORITY = FLASH_TOQ_EMERGENCY.
//
//      hSWI                Handle of the SWI object to be posted after the
//                          request has been served out.
//      hSEM                Handle of the initialized (by a call of SEM_new()
//                          function) SEM object to be posted after the request
//                          has been served out.
//
//  return:
//      FLASH_ERROR         An error occured. To get the exact error code, call
//                          the FLASH_getErrorCode() function with pReqObj as
//                          its parameter.
//      FLASH_OK            All right. The access request object has been filled
//                          up properly. Now, you can call the FLASH_accessReq()
//                          function with the pReqObj to put the request into
//                          the selected queue.
//==============================================================================
IDECL Uint32 FLASH_makeReq_blockComp16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI);

IDECL Uint32 FLASH_makeReq_blockComp16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM);

IDECL Uint32 FLASH_makeReq_blockComp16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri);


//==============================================================================
// Returns whether the initialization of the the request defined in the passed
// Access Request Object failed or not after a call of a FLASH_makeReq_x()
// function.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                Making of the request failed. Call the function
//                          FLASH_getErrorCode() to get the error code of the
//                          parameter checking.
//      FALSE               Making of the request was successful.
//==============================================================================
IDECL BOOL FLASH_isInitialError(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns whether the request defined in the passed Access Request Object is
// waiting currently in a queue for service or not.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                The request is being in a queue currently.
//      FALSE               The request is either being in process or it has
//                          been completed or there was an initial error.
//==============================================================================
IDECL BOOL FLASH_isInQueue(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns whether the request defined in the passed Access Request Object is
// being in process currently or not.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                The request is being in process currently.
//      FALSE               The request is either waiting in a queue or it has
//                          been completed or there was an initial error.
//==============================================================================
IDECL BOOL FLASH_isInProcess(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns whether the request defined in the passed Access Request Object has
// been completed or not.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                The request has already been completed.
//      FALSE               The request has not been completed yet.
//==============================================================================
IDECL BOOL FLASH_isCompleted(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns whether the request defined in the passed Access Request Object has
// not been served out yet.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                The request has not been served out yet.
//      FALSE               The request has already been served out, it has been
//                          completed.
//==============================================================================
IDECL BOOL FLASH_isBusy(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns the result of the request defined in the passed Access Request
// Object. This function should be called after the request has already been
// completed.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      TRUE                The requested flash operation was successful.
//      FALSE               The requested flash operation failed.
//==============================================================================
IDECL BOOL FLASH_isSuccessful(FLASH_AccessReqObj *pReqObj);

//==============================================================================
// Returns the error code of the request defined in the passed Access Request
// Object. This function should be called after the request has already been
// completed.
//
// parameters:
//      pReqObj             Pointer to the request object that was given to the
//                          FLASH_accessReq() function.
//
// return:
//      FLASH_RETERR_SUCCESSFUL         The flash operation was successful.
//      FLASH_RETERR_OK                 the same with FLASH_RETERR_SUCCESSFUL
//      FLASH_RETERR_NO_ERROR           the same with FLASH_RETERR_SUCCESSFUL
//
//      FLASH_RETERR_BUSY               The request has not been served out yet.
//      FLASH_RETERR_STILL_WORK         the same with FLASH_RETERR_BUSY
//
//      FLASH_RETERR_CHKPRM_START_SI    Initial error: startSI parameter is bad.
//      FLASH_RETERR_CHKPRM_END_SI      Initial error: endSI parameter is bad.
//      FLASH_RETERR_CHKPRM_SIZE        Initial error: numOf16bWs param. is bad.
//      FLASH_RETERR_CHKPRM_FLASH       Initial error: flashOffset parm. is bad.
//      FLASH_RETERR_CHKPRM_DSP         Initial error: dspAddress param. is bad.
//
//      FLASH_RETERR_PROGRAMMING_ERROR  Flash programming failed.
//
//      FLASH_RETERR_CHECK_ERROR        Sector blank check or block comparison
//                                      failed.
//      FLASH_RETERR_NO_BLANK           the same with FLASH_RETERR_CHECK_ERROR
//      FLASH_RETERR_DIRTY_SECTOR       the same with FLASH_RETERR_CHECK_ERROR
//      FLASH_RETERR_COMPARISON_FAILED  the same with FLASH_RETERR_CHECK_ERROR
//==============================================================================
IDECL Uint32 FLASH_getErrorCode(FLASH_AccessReqObj *pReqObj);


/******************************************************************************\
* inline function definitions
\******************************************************************************/
#ifdef USEDEFS

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_checkTrParams(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj)
{
    Uint32  chkret;

    // check parameters
    chkret = FLASH_checkTrParams(flashOffset, dspAddress, numOf16bWs);
    if( chkret != FLASH_CHKPRM_OK )
    {
        // set "State Of Request" to Initial Error and
        // set the error code to the proper CHKPRM (check parameter) code
        pReqObj->control = FLASH_SOR_INITIAL_ERROR | (chkret << 4);

        // filling up of access request object failed
        return FLASH_ERROR;
    }

    // parameters are good, filling up the access request object
    pReqObj->param[FLASH_IOP_flashOffset]   = flashOffset;
    pReqObj->param[FLASH_IOP_dspAddress]    = dspAddress;
    pReqObj->param[FLASH_IOP_numOf16bWs]    = numOf16bWs;

    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_checkScParams(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj)
{
    Uint32  chkret;

    // check parameters
    chkret = FLASH_checkScParams(startSI, endSI);
    if( chkret != FLASH_CHKPRM_OK )
    {
        // set "State Of Request" to Initial Error and
        // set the error code to the proper CHKPRM (check parameter) code
        pReqObj->control = FLASH_SOR_INITIAL_ERROR | (chkret << 4);

        // filling up of access request object failed
        return FLASH_ERROR;
    }

    // parameters are good, filling up the access request object
    pReqObj->param[FLASH_IOP_startSI]   = startSI;
    pReqObj->param[FLASH_IOP_endSI]     = endSI;

    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockRead16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_READ_FROM_FLASH | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockRead16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_READ_FROM_FLASH | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockRead16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_READ_FROM_FLASH | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockProg16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_WRITE_TO_FLASH | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockProg16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_WRITE_TO_FLASH | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockProg16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_WRITE_TO_FLASH | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_chipErase_SWI(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // set up parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_ERASE_CHIP | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_chipErase_SEM(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // set up parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_ERASE_CHIP | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_chipErase_NONE(
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // set up parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_ERASE_CHIP | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_sectorErase_SWI(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_ERASE_SECTORS | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_sectorErase_SEM(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_ERASE_SECTORS | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_sectorErase_NONE(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_ERASE_SECTORS | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_checkSectorBlank_SWI(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_CHECK_BLANK | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_checkSectorBlank_SEM(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_CHECK_BLANK | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_checkSectorBlank_NONE(
                Uint32 startSI, Uint32 endSI,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkScParams(startSI, endSI, pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_CHECK_BLANK | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockComp16_SWI(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SWI_Handle hSWI)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSWI);
    pReqObj->control = FLASH_OP_COMPARE_BLOCK | FLASH_TOS_SWI
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockComp16_SEM(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri, SEM_Handle hSEM)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    pReqObj->pSemOrSwiObj = (void *)(hSEM);
    pReqObj->control = FLASH_OP_COMPARE_BLOCK | FLASH_TOS_SEM
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_makeReq_blockComp16_NONE(
                Uint32 flashOffset, Uint32 dspAddress, Uint32 numOf16bWs,
                FLASH_AccessReqObj *pReqObj, Uint32 quePri)
{
    // check parameters and fill up the param[] array of the access request object
    if( FLASH_makeReq_checkTrParams(flashOffset, dspAddress, numOf16bWs,
        pReqObj) == FLASH_ERROR )
    {
        return FLASH_ERROR;
    }

    // set up further parameters
    //pReqObj->pSemOrSwiObj = (void *)(NULL);
    // unnecessary, because of FLASH_TOS_NONE
    pReqObj->control = FLASH_OP_COMPARE_BLOCK | FLASH_TOS_NONE
        | (quePri & _FLASH_TOQ_MASK);

    // access request object has been filled up properly
    return FLASH_OK;
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isInitialError(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_SOR_MASK) == FLASH_SOR_INITIAL_ERROR);
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isInQueue(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_SOR_MASK) == FLASH_SOR_IN_QUEUE);
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isInProcess(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_SOR_MASK) == FLASH_SOR_IN_PROCESS);
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isCompleted(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_SOR_MASK) == FLASH_SOR_COMPLETED);
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isBusy(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_SOR_MASK) != FLASH_SOR_COMPLETED);
}

/*----------------------------------------------------------------------------*/
IDEF BOOL FLASH_isSuccessful(FLASH_AccessReqObj *pReqObj)
{
    return (((pReqObj->control) & _FLASH_RETERR_MASK) != FLASH_RETERR_SUCCESSFUL);
}

/*----------------------------------------------------------------------------*/
IDEF Uint32 FLASH_getErrorCode(FLASH_AccessReqObj *pReqObj)
{
    return ((pReqObj->control) & _FLASH_RETERR_MASK);
}

#endif /* USEDEFS */


#endif /* BSL_FLASH_SUPPORT */
#endif /* _BSL_FLASH_H_ */
/******************************************************************************\
* End of bsl_flash.h
\******************************************************************************/
