
//******************************************************************************
//*    Cummins EBU
//*    COPYRIGHT 2009 Cummins EBU, ALL RIGHTS RESERVED
//*    This program may not be reproduced, in whole or in part in any form
//*    or by any means whatsoever without the written permission of
//*        Cummins Inc.
//*        Box 3005,
//*        Columbus, IN 47202 - 3005
//*
//*    File Name:     input_msg_parser_thread.c
//*    Description:   
//*
//*    Project Name:  Inline 6
//*
//*    Platform:      Motorola Coldfire 5329
//*
//*    Creation Date: 10/05/2009
//*
//*    Revision History: 
//*
//*		Authors:	Vani Iyer, Sai Mahesh
//*
//******************************************************************************




#include "Diagnosis_Thread.h"
#include "MCF5253_GPIO.h"
#include <string.h>
#include "wlan.h"
#include "board.h"
#include "spi.h"
#include "hci.h"
#include "netapp.h"
#include "nvmem.h"
#include "socket.h"



//#define HOME		
#define RX_BUFF_LEN 1460

extern uint8_t bEnableUnSolEvent;

char DataSendCC3000Buffer[CC3000_MAXIMAL_RX_SIZE] ;

char DataRecvCC3000Buffer[CC3000_MAXIMAL_RX_SIZE]; 



char aucCC3000_prefix[] = {'T', 'T', 'T'};

volatile extern uint32_t ulSocket, ulSmartConfigFinished;

volatile extern uint8_t  ulCC3000Connected;

volatile extern uint8_t ulCC3000DHCP,ulCC3000DHCP_configured, OkToDoShutDown,ucStopSmartConfig ;

#define ASSERT_CS()			(MCF_GPIO_GPIO_OUT &= ~(0x00000001 << 15))

#define DEASSERT_CS()		(MCF_GPIO_GPIO_OUT |= (0x00000001 << 15))	

unsigned char pucIP_Addr[4];

unsigned char pucIP_DefaultGWAddr[4];

unsigned char pucSubnetMask[4];

unsigned char pucDNS[4];

char mac_status = -1;


int initDriver(unsigned short patch)
{
	long lResult = 0;
	ulCC3000DHCP = 0;
	
	ulCC3000Connected = 0;
	
	
	ulSmartConfigFinished=0;
	
	bEnableUnSolEvent = 0;
	
	
	wlan_init( CC3000_UsynchCallback,NULL, NULL, NULL, ReadWlanInterruptPin, WlanInterruptEnable, WlanInterruptDisable, WriteWlanPin);

	wlan_start(patch);
	
	wlan_smart_config_set_prefix(aucCC3000_prefix);
    
	
	wlan_set_event_mask(HCI_EVNT_WLAN_KEEPALIVE|HCI_EVNT_WLAN_UNSOL_INIT|HCI_EVNT_WLAN_ASYNC_PING_REPORT);
   

	ucStopSmartConfig   = 0;
	
	wlan_ioctl_set_connection_policy(0, 0, 0);	
	
	wlan_ioctl_del_profile(255);
	
	bEnableUnSolEvent = 1;//To Call hci_unsolicited_event_handler() in every 500ms
	
	
}
/*******************************************************************************
 * FUNCTION NAME: th_Diagnosis_Thread
 *
 *        INPUTS: Thread Data-- Unused. This is passed to follow UX API
 *
 *       OUTPUTS: None
 *
 *    PROCESSING: Main Function of Diagnosis thread which is least
 *                Priority function. This function performs House-keeping tasks
 *                such as Toggling LEDs etc. This thread is continous run function.
 *                This is always running. Calculation of Checksum and Validatation
 *                is also done by this thread.               
 ******************************************************************************/
void 		th_Diagnosis_Thread( uint32_t threadData )
{

	uint32_t app_chksum = 0,boot_chksum = 0;
	uint32_t* boot_chksum_addr=0;
	uint32_t* app_chksum_addr=0;
	uint32_t pn_sn_flag = 0, pn_sn_bkp_flag = 0;
	union u_pn_sn pn_sn;
	uint16_t loop_cnt = 0;
	uint8_t		can_channel,status;
	boolean_t bcheck = TRUE;
	unsigned char patchversion[10];
	long lStatus1=0;
	unsigned char ucstatus = 0;
	tNetappIpconfigRetArgs  ipconfig;
	unsigned char cMacFromEeprom1[MAC_ADDR_LEN];
	
	int blinkled = 0 ;
	 
	while( 1 )
	{
		
		if(bcheck)
		{
			bcheck = FALSE;
			
			init_spi();
			
			initDriver(0);
								
			lStatus1 = -1;
			
			lStatus1 = nvmem_read_sp_version(patchversion);
		
			wlan_connect(WLAN_SEC_UNSEC,(char*)"default",7,NULL,NULL,NULL);

			while ((ulCC3000Connected == 0) || (ulCC3000DHCP == 0))
			{				
				hci_unsolicited_event_handler();	
			}
			
			lStatus1 = 0;
		
			while(lStatus1 != 3)
			{
				lStatus1 = wlan_ioctl_statusget();
			}
			
			hci_unsolicited_event_handler();
			
			ipconfig.aucIP[0] = 0x00;
			
			while(ipconfig.aucIP[0] == 0)
			{
				netapp_ipconfig(&ipconfig);
				hci_unsolicited_event_handler();
			}
			
			ServerSendRecv();
			
		}	
			
	}
	wlan_disconnect();
}

void ServerSendRecv()
{
	long sd = 0; 
	sockaddr saddrClient,saddrServer;
	long socketStatus = 0;
	socklen_t tSoclength ;
	int clientDescriptor = -1;
	unsigned short nNumOfBytesRecvd = 0;
	int nNumOfBytesSend = 0;
	int loop  = 0;
	saddrClient.sa_family =  AF_INET;

	saddrServer.sa_family =  AF_INET;
	saddrServer.sa_data[0] = 0x04;saddrServer.sa_data[1] = 0xB4;    saddrServer.sa_data[2] = 0x00; 
	saddrServer.sa_data[3] = 0x00;saddrServer.sa_data[4] = 0x00;	saddrServer.sa_data[5] = 0x00;
	if((sd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) < 0)
		return;

	if((socketStatus = bind(sd,&saddrServer,sizeof(sockaddr))) != 0)
		return;
		
	if((socketStatus = listen(sd,1)) != 0)
		return;
	
	tSoclength = sizeof(saddrClient);


	bEnableUnSolEvent =0;
	
	for(loop = 0 ; loop < CC3000_MAXIMAL_RX_SIZE;loop++)
	{
		DataRecvCC3000Buffer[loop ] = 0x00;
		DataSendCC3000Buffer[loop ] = (char)loop;
	}

	while(1)
	{
		
		while(clientDescriptor < 0)
		{
			clientDescriptor = accept(sd,&saddrClient,&tSoclength);
			
		}		
				
		nNumOfBytesRecvd = 0 ;
		
		
		nNumOfBytesRecvd = recv(clientDescriptor,&DataRecvCC3000Buffer[0], RX_BUFF_LEN  ,0);
			
	
		nNumOfBytesSend = send(clientDescriptor, &DataSendCC3000Buffer[0] , 100 , 0);
			
	}

}

