/*
*******************************************************************************
* Copyright(C) 2011 Renesas Electronics Corporation
* RENESAS ELECTRONICS CONFIDENTIAL AND PROPRIETARY
* This program must be used solely for the purpose for which
* it was furnished by Renesas Electronics Corporation. No part of this
* program may be reproduced or disclosed to others, in any
* form, without the prior written permission of Renesas Electronics
* Corporation. 
*
* This device driver was created by Applilet3 for RL78/G13
* 16-Bit Single-Chip Microcontrollers
* Filename:	CG_int.h
* Abstract:	This file implements device driver for INT module.
* APIlib:	Applilet3 for RL78/G13 E1.00b [14 Jan 2011]
* Device:	R5F100LE
* Compiler:	IAR Systems iccrl78
* Creation date:	15/09/2011
*******************************************************************************
*/

#ifndef _MD_MACROS_H_
#define _MD_MACROS_H_
/*===========================================================================*/
/* Includes                                                                  */
/*===========================================================================*/
/* Application Includes                                                      */


/* --------------------------------------------------------------------------*/
/* Logical Values                                                            */
/* --------------------------------------------------------------------------*/
#define TRUE  1u
#define FALSE 0u

#define uint8_t UCHAR
#define uint16_t USHORT

/* --------------------------------------------------------------------------*/
/* Special Function Register Access                                          */
/* --------------------------------------------------------------------------*/
#define ClrIORBit(Reg, ClrBitMap) ((Reg) &= ~(ClrBitMap))
#define SetIORBit(Reg, SetBitMap) ((Reg) |=  (SetBitMap))

/* --------------------------------------------------------------------------*/
/* LEDs                                                                      */
/* --------------------------------------------------------------------------*/
#define LED02   P7_bit.no7
#define LEDON   FALSE
#define LEDOFF  TRUE

/* --------------------------------------------------------------------------*/
/* SPI PORT                                                                   */
/* --------------------------------------------------------------------------*/
#define SPI_CLK_PIN    P1_bit.no0
#define SPI_MISO_PIN   P1_bit.no1
#define SPI_MOSI_PIN   P1_bit.no2
#define SPI_CS_PIN     P1_bit.no5

#define SPI_IRQ_PIN    P5_bit.no0
#define SPI_EN_PIN     P5_bit.no1

//#define DMA_WINDOW_SIZE         1024
//#define SPI_WINDOW_SIZE         DMA_WINDOW_SIZE
#define SPI_FLAG_TIMEOUT         ((uint32_t)0x1000)
#define SPI_LONG_TIMEOUT         ((uint32_t)(10 * SPI_FLAG_TIMEOUT)) 

#define HI(value)               (((value) & 0xFF00) >> 8)
#define LO(value)               ((value) & 0x00FF) 

#define FWT_DELAY               4000
/*It takes roughly 4 instruction to perform a delay*/
#define FIFTY_US_DELAY			((25*50)/15) // for 25 MHz clk
#define READ                    3
#define WRITE                   1
//#define DMA_WINDOW_SIZE         1024
//#define SPI_WINDOW_SIZE         DMA_WINDOW_SIZE

#define HEADERS_SIZE_EVNT       (SPI_HEADER_SIZE + 5)
#define SPI_TX_BUFFER_SIZE        1700u//1024u//1700u
#define SPI_RX_BUFFER_SIZE        512u//512

/* --------------------------------------------------------------------------*/
/* UART PORT                                                                   */
/* --------------------------------------------------------------------------*/
#define UART_TX_PIN    P0_bit.no2
#define UART_RX_PIN    P0_bit.no3

/* --------------------------------------------------------------------------*/
/* 10ms Timer                                                                */
/* --------------------------------------------------------------------------*/
//#define PERIOD_1SEC  100u

/* Start user code for function. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */
#endif
